/*
 * Decompiled with CFR 0.152.
 */
package org.xbill.DNS;

import java.io.IOException;
import org.xbill.DNS.Compression;
import org.xbill.DNS.DNSInput;
import org.xbill.DNS.DNSOutput;
import org.xbill.DNS.Name;
import org.xbill.DNS.Record;
import org.xbill.DNS.Tokenizer;

public class MINFORecord
extends Record {
    private Name responsibleAddress;
    private Name errorAddress;

    Record getObject() {
        return new MINFORecord();
    }

    void rrFromWire(DNSInput dNSInput) throws IOException {
        this.responsibleAddress = new Name(dNSInput);
        this.errorAddress = new Name(dNSInput);
    }

    void rdataFromString(Tokenizer tokenizer, Name name) throws IOException {
        this.responsibleAddress = tokenizer.getName(name);
        this.errorAddress = tokenizer.getName(name);
    }

    String rrToString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.responsibleAddress);
        stringBuffer.append(" ");
        stringBuffer.append(this.errorAddress);
        return stringBuffer.toString();
    }

    public Name getResponsibleAddress() {
        return this.responsibleAddress;
    }

    public Name getErrorAddress() {
        return this.errorAddress;
    }

    void rrToWire(DNSOutput dNSOutput, Compression compression, boolean bl) {
        this.responsibleAddress.toWire(dNSOutput, null, bl);
        this.errorAddress.toWire(dNSOutput, null, bl);
    }

    MINFORecord() {
    }

    public MINFORecord(Name name, int n, long l, Name name2, Name name3) {
        super(name, 14, n, l);
        this.responsibleAddress = MINFORecord.checkName("responsibleAddress", name2);
        this.errorAddress = MINFORecord.checkName("errorAddress", name3);
    }
}

