/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.StyleContext;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractDocument
implements Document,
Serializable {
    private static final long serialVersionUID = 6842927725919637215L;
    protected static final String BAD_LOCATION = "document location failure";
    public static final String BidiElementName = "bidi level";
    public static final String ContentElementName = "content";
    public static final String ParagraphElementName = "paragraph";
    public static final String SectionElementName = "section";
    public static final String ElementNameAttribute = "$ename";
    Content content;
    AttributeContext context;
    DocumentFilter documentFilter;
    Dictionary properties;
    protected EventListenerList listenerList;
    private Thread currentWriter;
    private int numReaders;
    private int numWritersWaiting;
    Object documentCV;
    static /* synthetic */ Class class$javax$swing$event$DocumentListener;
    static /* synthetic */ Class class$javax$swing$event$UndoableEditListener;

    public abstract Element getParagraphElement(int var1);

    public abstract Element getDefaultRootElement();

    protected Element createBranchElement(Element element, AttributeSet attributeSet) {
        return new BranchElement(element, attributeSet);
    }

    protected Element createLeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
        return new LeafElement(element, attributeSet, n, n2);
    }

    public Position createPosition(int n) throws BadLocationException {
        return this.content.createPosition(n);
    }

    protected void fireChangedUpdate(DocumentEvent documentEvent) {
        DocumentListener[] documentListenerArray = this.getDocumentListeners();
        int n = 0;
        while (n < documentListenerArray.length) {
            documentListenerArray[n].changedUpdate(documentEvent);
            ++n;
        }
    }

    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        DocumentListener[] documentListenerArray = this.getDocumentListeners();
        int n = 0;
        while (n < documentListenerArray.length) {
            documentListenerArray[n].insertUpdate(documentEvent);
            ++n;
        }
    }

    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        DocumentListener[] documentListenerArray = this.getDocumentListeners();
        int n = 0;
        while (n < documentListenerArray.length) {
            documentListenerArray[n].removeUpdate(documentEvent);
            ++n;
        }
    }

    protected void fireUndoableEditUpdate(UndoableEditEvent undoableEditEvent) {
        UndoableEditListener[] undoableEditListenerArray = this.getUndoableEditListeners();
        int n = 0;
        while (n < undoableEditListenerArray.length) {
            undoableEditListenerArray[n].undoableEditHappened(undoableEditEvent);
            ++n;
        }
    }

    public int getAsynchronousLoadPriority() {
        return 0;
    }

    protected AttributeContext getAttributeContext() {
        return this.context;
    }

    public Element getBidiRootElement() {
        return null;
    }

    protected final Content getContent() {
        return this.content;
    }

    protected Thread getCurrentWriter() {
        return this.currentWriter;
    }

    public Dictionary getDocumentProperties() {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        return this.properties;
    }

    public Position getEndPosition() {
        return new Position(){

            public final int getOffset() {
                return AbstractDocument.this.getLength();
            }
        };
    }

    public int getLength() {
        return this.content.length() - 1;
    }

    public EventListener[] getListeners(Class clazz) {
        return this.listenerList.getListeners(clazz);
    }

    public Object getProperty(Object object) {
        Object object2 = null;
        if (this.properties != null) {
            object2 = this.properties.get(object);
        }
        return object2;
    }

    public Element[] getRootElements() {
        Element[] elementArray = new Element[]{this.getDefaultRootElement()};
        return elementArray;
    }

    public Position getStartPosition() {
        return new Position(){

            public final int getOffset() {
                return 0;
            }
        };
    }

    public String getText(int n, int n2) throws BadLocationException {
        return this.content.getString(n, n2);
    }

    public void getText(int n, int n2, Segment segment) throws BadLocationException {
        this.content.getChars(n, n2, segment);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
        if (string == null) return;
        if (string.length() == 0) {
            return;
        }
        DefaultDocumentEvent defaultDocumentEvent = new DefaultDocumentEvent(n, string.length(), DocumentEvent.EventType.INSERT);
        try {
            this.writeLock();
            UndoableEdit undoableEdit = this.content.insertString(n, string);
            if (undoableEdit != null) {
                defaultDocumentEvent.addEdit(undoableEdit);
            }
            this.insertUpdate(defaultDocumentEvent, attributeSet);
            this.fireInsertUpdate(defaultDocumentEvent);
            if (undoableEdit != null) {
                this.fireUndoableEditUpdate(new UndoableEditEvent(this, undoableEdit));
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            this.writeUnlock();
            throw throwable;
        }
        {
            Object var6_8 = null;
            this.writeUnlock();
            return;
        }
    }

    protected void insertUpdate(DefaultDocumentEvent defaultDocumentEvent, AttributeSet attributeSet) {
    }

    protected void postRemoveUpdate(DefaultDocumentEvent defaultDocumentEvent) {
    }

    public void putProperty(Object object, Object object2) {
        if (this.properties == null) {
            this.properties = new Hashtable();
        }
        this.properties.put(object, object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readLock() {
        if (this.currentWriter != null && this.currentWriter.equals(Thread.currentThread())) {
            return;
        }
        Object object = this.documentCV;
        synchronized (object) {
            while (true) {
                if (this.currentWriter == null && this.numWritersWaiting <= 0) {
                    ++this.numReaders;
                    return;
                }
                try {
                    this.documentCV.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new Error("interrupted trying to get a readLock");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readUnlock() {
        if (this.currentWriter == Thread.currentThread()) {
            return;
        }
        if (this.numReaders == 0) {
            throw new IllegalStateException("document lock failure");
        }
        Object object = this.documentCV;
        synchronized (object) {
            if (this.currentWriter == null) {
                --this.numReaders;
                if (this.numReaders == 0 && this.numWritersWaiting != 0) {
                    this.documentCV.notify();
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void remove(int n, int n2) throws BadLocationException {
        DefaultDocumentEvent defaultDocumentEvent = new DefaultDocumentEvent(n, n2, DocumentEvent.EventType.REMOVE);
        try {
            this.writeLock();
            this.removeUpdate(defaultDocumentEvent);
            UndoableEdit undoableEdit = this.content.remove(n, n2);
            this.postRemoveUpdate(defaultDocumentEvent);
            this.fireRemoveUpdate(defaultDocumentEvent);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.writeUnlock();
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.writeUnlock();
            return;
        }
    }

    public void replace(int n, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
        this.remove(n, n2);
        this.insertString(n, string, attributeSet);
    }

    public void addDocumentListener(DocumentListener documentListener) {
        Class clazz = class$javax$swing$event$DocumentListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$DocumentListener = AbstractDocument.class("[Ljavax.swing.event.DocumentListener;", false);
        }
        this.listenerList.add(clazz, documentListener);
    }

    public void removeDocumentListener(DocumentListener documentListener) {
        Class clazz = class$javax$swing$event$DocumentListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$DocumentListener = AbstractDocument.class("[Ljavax.swing.event.DocumentListener;", false);
        }
        this.listenerList.remove(clazz, documentListener);
    }

    public DocumentListener[] getDocumentListeners() {
        Class clazz = class$javax$swing$event$DocumentListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$DocumentListener = AbstractDocument.class("[Ljavax.swing.event.DocumentListener;", false);
        }
        return (DocumentListener[])this.getListeners(clazz);
    }

    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        Class clazz = class$javax$swing$event$UndoableEditListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$UndoableEditListener = AbstractDocument.class("[Ljavax.swing.event.UndoableEditListener;", false);
        }
        this.listenerList.add(clazz, undoableEditListener);
    }

    public void removeUndoableEditListener(UndoableEditListener undoableEditListener) {
        Class clazz = class$javax$swing$event$UndoableEditListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$UndoableEditListener = AbstractDocument.class("[Ljavax.swing.event.UndoableEditListener;", false);
        }
        this.listenerList.remove(clazz, undoableEditListener);
    }

    public UndoableEditListener[] getUndoableEditListeners() {
        Class clazz = class$javax$swing$event$UndoableEditListener;
        if (clazz == null) {
            clazz = class$javax$swing$event$UndoableEditListener = AbstractDocument.class("[Ljavax.swing.event.UndoableEditListener;", false);
        }
        return (UndoableEditListener[])this.getListeners(clazz);
    }

    protected void removeUpdate(DefaultDocumentEvent defaultDocumentEvent) {
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void render(Runnable runnable) {
        this.readLock();
        try {
            runnable.run();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.readUnlock();
            throw throwable;
        }
        {
            Object var3_4 = null;
            this.readUnlock();
            return;
        }
    }

    public void setAsynchronousLoadPriority(int n) {
    }

    public void setDocumentProperties(Dictionary dictionary) {
        this.properties = dictionary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeLock() {
        if (this.currentWriter != null && this.currentWriter.equals(Thread.currentThread())) {
            return;
        }
        Object object = this.documentCV;
        synchronized (object) {
            ++this.numWritersWaiting;
            while (true) {
                if (this.numReaders <= 0) {
                    --this.numWritersWaiting;
                    this.currentWriter = Thread.currentThread();
                    return;
                }
                try {
                    this.documentCV.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new Error("interruped while trying to obtain write lock");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeUnlock() {
        Object object = this.documentCV;
        synchronized (object) {
            if (Thread.currentThread().equals(this.currentWriter)) {
                this.currentWriter = null;
                this.documentCV.notifyAll();
            }
            return;
        }
    }

    public DocumentFilter getDocumentFilter() {
        return this.documentFilter;
    }

    public void setDocumentFilter(DocumentFilter documentFilter) {
        this.documentFilter = documentFilter;
    }

    public void dump(PrintStream printStream) {
        ((AbstractElement)this.getDefaultRootElement()).dump(printStream, 0);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.listenerList = new EventListenerList();
        this.currentWriter = null;
        this.numReaders = 0;
        this.numWritersWaiting = 0;
        this.documentCV = new Object();
    }

    protected AbstractDocument(Content content) {
        this(content, StyleContext.getDefaultStyleContext());
    }

    protected AbstractDocument(Content content, AttributeContext attributeContext) {
        this.this();
        this.content = content;
        this.context = attributeContext;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class BranchElement
    extends AbstractElement {
        private static final long serialVersionUID = -6037216547466333183L;
        private Element[] children;
        private int startOffset;
        private int endOffset;

        public Enumeration children() {
            if (this.children.length == 0) {
                return null;
            }
            Vector vector = new Vector();
            int n = 0;
            while (n < this.children.length) {
                vector.add(this.children[n]);
                ++n;
            }
            return vector.elements();
        }

        public boolean getAllowsChildren() {
            return true;
        }

        public Element getElement(int n) {
            if (n < 0 || n >= this.children.length) {
                return null;
            }
            return this.children[n];
        }

        public int getElementCount() {
            return this.children.length;
        }

        public int getElementIndex(int n) {
            if (n < this.getStartOffset()) {
                return 0;
            }
            int n2 = 0;
            while (n2 < this.children.length - 1) {
                Element element = this.children[n2];
                if (element.getStartOffset() <= n && n < element.getEndOffset()) {
                    return n2;
                }
                if (this.children[n2 + 1].getStartOffset() > n) {
                    if (n - element.getEndOffset() > this.children[n2 + 1].getStartOffset() - n) {
                        return n2 + 1;
                    }
                    return n2;
                }
                ++n2;
            }
            return this.getElementCount() - 1;
        }

        public int getEndOffset() {
            if (this.children.length == 0) {
                if (this.endOffset == -1) {
                    throw new NullPointerException("BranchElement has no children.");
                }
            } else {
                this.endOffset = this.children[this.children.length - 1].getEndOffset();
            }
            return this.endOffset;
        }

        public String getName() {
            return AbstractDocument.ParagraphElementName;
        }

        public int getStartOffset() {
            if (this.children.length == 0) {
                if (this.startOffset == -1) {
                    throw new NullPointerException("BranchElement has no children.");
                }
            } else {
                this.startOffset = this.children[0].getStartOffset();
            }
            return this.startOffset;
        }

        public boolean isLeaf() {
            return false;
        }

        public Element positionToElement(int n) {
            int n2 = 0;
            while (n2 < this.children.length) {
                Element element = this.children[n2];
                if (element.getStartOffset() <= n && n < element.getEndOffset()) {
                    return element;
                }
                ++n2;
            }
            return null;
        }

        public void replace(int n, int n2, Element[] elementArray) {
            Element[] elementArray2 = new Element[this.children.length - n2 + elementArray.length];
            System.arraycopy(this.children, 0, elementArray2, 0, n);
            System.arraycopy(elementArray, 0, elementArray2, n, elementArray.length);
            System.arraycopy(this.children, n + n2, elementArray2, n + elementArray.length, this.children.length - n - n2);
            this.children = elementArray2;
        }

        public String toString() {
            return "BranchElement(" + this.getName() + ") " + this.getStartOffset() + ',' + this.getEndOffset() + '\n';
        }

        private final /* synthetic */ void this() {
            this.children = new Element[0];
        }

        public BranchElement(Element element, AttributeSet attributeSet) {
            super(element, attributeSet);
            this.this();
            this.startOffset = -1;
            this.endOffset = -1;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class LeafElement
    extends AbstractElement {
        private static final long serialVersionUID = -8906306331347768017L;
        private Position startPos;
        private Position endPos;
        private int startDelta;
        private int endDelta;

        public Enumeration children() {
            return null;
        }

        public boolean getAllowsChildren() {
            return false;
        }

        public Element getElement(int n) {
            return null;
        }

        public int getElementCount() {
            return 0;
        }

        public int getElementIndex(int n) {
            return -1;
        }

        public int getEndOffset() {
            return this.endPos.getOffset() + this.endDelta;
        }

        public String getName() {
            String string = super.getName();
            if (string == null) {
                string = AbstractDocument.ContentElementName;
            }
            return string;
        }

        public int getStartOffset() {
            return this.startPos.getOffset() + this.startDelta;
        }

        public boolean isLeaf() {
            return true;
        }

        public String toString() {
            return "LeafElement(" + this.getName() + ") " + this.getStartOffset() + ',' + this.getEndOffset() + '\n';
        }

        public LeafElement(Element element, AttributeSet attributeSet, int n, int n2) {
            super(element, attributeSet);
            int n3 = AbstractDocument.this.content.length();
            this.startDelta = 0;
            if (n > n3) {
                this.startDelta = n - n3;
            }
            this.endDelta = 0;
            if (n2 > n3) {
                this.endDelta = n2 - n3;
            }
            try {
                this.startPos = AbstractDocument.this.createPosition(n - this.startDelta);
                this.endPos = AbstractDocument.this.createPosition(n2 - this.endDelta);
            }
            catch (BadLocationException badLocationException) {
                AssertionError assertionError = new AssertionError((Object)("BadLocationException thrown here. start=" + n + ", end=" + n2 + ", length=" + AbstractDocument.this.getLength()));
                ((Throwable)((Object)assertionError)).initCause(badLocationException);
                throw assertionError;
            }
        }
    }

    public static interface Content {
        public Position createPosition(int var1) throws BadLocationException;

        public int length();

        public UndoableEdit insertString(int var1, String var2) throws BadLocationException;

        public UndoableEdit remove(int var1, int var2) throws BadLocationException;

        public String getString(int var1, int var2) throws BadLocationException;

        public void getChars(int var1, int var2, Segment var3) throws BadLocationException;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class DefaultDocumentEvent
    extends CompoundEdit
    implements DocumentEvent {
        private static final long serialVersionUID = 5230037221564563284L;
        private int offset;
        private int length;
        private DocumentEvent.EventType type;
        Hashtable changes;
        boolean modified;

        public boolean addEdit(UndoableEdit undoableEdit) {
            if (undoableEdit instanceof DocumentEvent.ElementChange) {
                this.modified = true;
                DocumentEvent.ElementChange elementChange = (DocumentEvent.ElementChange)((Object)undoableEdit);
                this.changes.put(elementChange.getElement(), elementChange);
            }
            return super.addEdit(undoableEdit);
        }

        public Document getDocument() {
            return AbstractDocument.this;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public DocumentEvent.EventType getType() {
            return this.type;
        }

        public DocumentEvent.ElementChange getChange(Element element) {
            return (DocumentEvent.ElementChange)this.changes.get(element);
        }

        public String toString() {
            return this.edits.toString();
        }

        public DefaultDocumentEvent(int n, int n2, DocumentEvent.EventType eventType) {
            this.offset = n;
            this.length = n2;
            this.type = eventType;
            this.changes = new Hashtable();
            this.modified = false;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public abstract class AbstractElement
    implements Element,
    MutableAttributeSet,
    TreeNode,
    Serializable {
        private static final long serialVersionUID = 1712240033321461704L;
        int count;
        int offset;
        AttributeSet attributes;
        Element element_parent;
        TreeNode tree_parent;
        Vector tree_children;

        public abstract Enumeration children();

        public abstract boolean getAllowsChildren();

        public TreeNode getChildAt(int n) {
            return (TreeNode)this.tree_children.get(n);
        }

        public int getChildCount() {
            return this.tree_children.size();
        }

        public int getIndex(TreeNode treeNode) {
            return this.tree_children.indexOf(treeNode);
        }

        public TreeNode getParent() {
            return this.tree_parent;
        }

        public abstract boolean isLeaf();

        public void addAttribute(Object object, Object object2) {
            this.attributes = AbstractDocument.this.getAttributeContext().addAttribute(this.attributes, object, object2);
        }

        public void addAttributes(AttributeSet attributeSet) {
            this.attributes = AbstractDocument.this.getAttributeContext().addAttributes(this.attributes, attributeSet);
        }

        public void removeAttribute(Object object) {
            this.attributes = AbstractDocument.this.getAttributeContext().removeAttribute(this.attributes, object);
        }

        public void removeAttributes(AttributeSet attributeSet) {
            this.attributes = AbstractDocument.this.getAttributeContext().removeAttributes(this.attributes, attributeSet);
        }

        public void removeAttributes(Enumeration enumeration) {
            this.attributes = AbstractDocument.this.getAttributeContext().removeAttributes(this.attributes, enumeration);
        }

        public void setResolveParent(AttributeSet attributeSet) {
            this.attributes = AbstractDocument.this.getAttributeContext().addAttribute(this.attributes, ResolveAttribute, attributeSet);
        }

        public boolean containsAttribute(Object object, Object object2) {
            return this.attributes.containsAttribute(object, object2);
        }

        public boolean containsAttributes(AttributeSet attributeSet) {
            return this.attributes.containsAttributes(attributeSet);
        }

        public AttributeSet copyAttributes() {
            return this.attributes.copyAttributes();
        }

        public Object getAttribute(Object object) {
            AttributeSet attributeSet;
            Object object2 = this.attributes.getAttribute(object);
            if (object2 == null && (attributeSet = this.getResolveParent()) != null) {
                object2 = attributeSet.getAttribute(object);
            }
            return object2;
        }

        public int getAttributeCount() {
            return this.attributes.getAttributeCount();
        }

        public Enumeration getAttributeNames() {
            return this.attributes.getAttributeNames();
        }

        public AttributeSet getResolveParent() {
            return this.attributes.getResolveParent();
        }

        public boolean isDefined(Object object) {
            return this.attributes.isDefined(object);
        }

        public boolean isEqual(AttributeSet attributeSet) {
            return this.attributes.isEqual(attributeSet);
        }

        public AttributeSet getAttributes() {
            return this;
        }

        public Document getDocument() {
            return AbstractDocument.this;
        }

        public abstract Element getElement(int var1);

        public String getName() {
            return (String)this.getAttribute(NameAttribute);
        }

        public Element getParentElement() {
            return this.element_parent;
        }

        public abstract int getEndOffset();

        public abstract int getElementCount();

        public abstract int getElementIndex(int var1);

        public abstract int getStartOffset();

        public void dump(PrintStream printStream, int n) {
            Object object;
            StringBuffer stringBuffer = new StringBuffer();
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(' ');
                ++n2;
            }
            stringBuffer.append('<');
            stringBuffer.append(this.getName());
            if (this.getAttributeCount() > 0) {
                stringBuffer.append('\n');
                Enumeration enumeration = this.getAttributeNames();
                while (enumeration.hasMoreElements()) {
                    int n3 = 0;
                    while (n3 < n + 2) {
                        stringBuffer.append(' ');
                        ++n3;
                    }
                    Object object2 = enumeration.nextElement();
                    stringBuffer.append(object2);
                    stringBuffer.append('=');
                    object = this.getAttribute(object2);
                    stringBuffer.append(object);
                    stringBuffer.append('\n');
                }
            }
            stringBuffer.append(">\n");
            if (this.isLeaf()) {
                int n4 = 0;
                while (n4 < n + 2) {
                    stringBuffer.append(' ');
                    ++n4;
                }
                n4 = this.getStartOffset();
                int n5 = this.getEndOffset();
                stringBuffer.append('[');
                stringBuffer.append(n4);
                stringBuffer.append(',');
                stringBuffer.append(n5);
                stringBuffer.append("][");
                try {
                    stringBuffer.append(this.getDocument().getText(n4, n5 - n4));
                }
                catch (BadLocationException badLocationException) {
                    AssertionError assertionError = new AssertionError((Object)"BadLocationException must not be thrown here.");
                    ((Throwable)((Object)assertionError)).initCause(badLocationException);
                    throw assertionError;
                }
                stringBuffer.append("]\n");
            }
            printStream.print(stringBuffer.toString());
            int n6 = this.getElementCount();
            int n7 = 0;
            while (n7 < n6) {
                object = this.getElement(n7);
                if (object instanceof AbstractElement) {
                    ((AbstractElement)object).dump(printStream, n + 2);
                }
                ++n7;
            }
        }

        public AbstractElement(Element element, AttributeSet attributeSet) {
            this.element_parent = element;
            AttributeContext attributeContext = AbstractDocument.this.getAttributeContext();
            this.attributes = attributeContext.getEmptySet();
            if (attributeSet != null) {
                this.attributes = attributeContext.addAttributes(this.attributes, attributeSet);
            }
        }
    }

    public static interface AttributeContext {
        public AttributeSet addAttribute(AttributeSet var1, Object var2, Object var3);

        public AttributeSet addAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet getEmptySet();

        public void reclaim(AttributeSet var1);

        public AttributeSet removeAttribute(AttributeSet var1, Object var2);

        public AttributeSet removeAttributes(AttributeSet var1, AttributeSet var2);

        public AttributeSet removeAttributes(AttributeSet var1, Enumeration var2);
    }

    public static class ElementEdit
    extends AbstractUndoableEdit
    implements DocumentEvent.ElementChange {
        private static final long serialVersionUID = -1216620962142928304L;
        private Element elem;
        private int index;
        private Element[] removed;
        private Element[] added;

        public Element[] getChildrenAdded() {
            return this.added;
        }

        public Element[] getChildrenRemoved() {
            return this.removed;
        }

        public Element getElement() {
            return this.elem;
        }

        public int getIndex() {
            return this.index;
        }

        public ElementEdit(Element element, int n, Element[] elementArray, Element[] elementArray2) {
            this.elem = element;
            this.index = n;
            this.removed = elementArray;
            this.added = elementArray2;
        }
    }
}

