/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.InputMapUIResource;
import javax.swing.plaf.TreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.FixedHeightLayoutCache;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicTreeUI
extends TreeUI {
    static int WAIT_TILL_EDITING = 900;
    static final MouseEvent EDIT = new MouseEvent(new Label(), 7, 7L, 7, 7, 7, 7, false);
    protected transient Icon collapsedIcon;
    protected transient Icon expandedIcon;
    protected int leftChildIndent;
    protected int rightChildIndent;
    protected int totalChildIndent;
    protected int lastSelectedRow;
    protected JTree tree;
    protected transient TreeCellRenderer currentCellRenderer;
    protected boolean createdRenderer;
    protected transient TreeCellEditor cellEditor;
    protected boolean createdCellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected Dimension preferredMinSize;
    protected boolean validCachedPreferredSize;
    protected AbstractLayoutCache treeState;
    protected Hashtable drawingCache;
    protected boolean largeModel;
    protected AbstractLayoutCache.NodeDimensions nodeDimensions;
    protected TreeModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected int depthOffset;
    protected Component editingComponent;
    protected TreePath editingPath;
    protected int editingRow;
    protected boolean editorHasDifferentSize;
    TreeAction action;
    boolean isEditing;
    TreePath currentVisiblePath;
    int gap;
    int maxHeight;
    private PropertyChangeListener propertyChangeListener;
    private FocusListener focusListener;
    private TreeSelectionListener treeSelectionListener;
    private MouseListener mouseListener;
    private KeyListener keyListener;
    private PropertyChangeListener selectionModelPropertyChangeListener;
    private ComponentListener componentListener;
    CellEditorListener cellEditorListener;
    private TreeExpansionListener treeExpansionListener;
    private TreeModelListener treeModelListener;
    Timer startEditTimer;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTreeUI();
    }

    protected Color getHashColor() {
        return UIManager.getColor("Tree.hash");
    }

    protected void setHashColor(Color color) {
        UIManager.put("Tree.hash", color);
    }

    public void setLeftChildIndent(int n) {
        this.leftChildIndent = n;
    }

    public int getLeftChildIndent() {
        return this.leftChildIndent;
    }

    public void setRightChildIndent(int n) {
        this.rightChildIndent = n;
    }

    public int getRightChildIndent() {
        return this.rightChildIndent;
    }

    public void setExpandedIcon(Icon icon) {
        this.expandedIcon = icon;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    public void setCollapsedIcon(Icon icon) {
        this.collapsedIcon = icon;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    protected void setLargeModel(boolean bl) {
        if (bl != this.largeModel) {
            this.tree.removeComponentListener(this.componentListener);
            this.largeModel = bl;
            this.tree.addComponentListener(this.componentListener);
        }
    }

    protected boolean isLargeModel() {
        return this.largeModel;
    }

    protected void setRowHeight(int n) {
        if (n == 0) {
            n = Math.max(this.getMaxHeight(this.tree), 20);
        }
        this.treeState.setRowHeight(n);
    }

    protected int getRowHeight() {
        return this.treeState.getRowHeight();
    }

    protected void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.currentCellRenderer = treeCellRenderer;
        this.updateRenderer();
    }

    protected TreeCellRenderer getCellRenderer() {
        if (this.currentCellRenderer != null) {
            return this.currentCellRenderer;
        }
        return this.createDefaultCellRenderer();
    }

    protected void setModel(TreeModel treeModel) {
        this.tree.setModel(treeModel);
        this.treeModel = this.tree.getModel();
    }

    protected TreeModel getModel() {
        return this.treeModel;
    }

    protected void setRootVisible(boolean bl) {
        this.tree.setRootVisible(bl);
    }

    protected boolean isRootVisible() {
        return this.tree.isRootVisible();
    }

    protected void setShowsRootHandles(boolean bl) {
        this.tree.setShowsRootHandles(bl);
    }

    protected boolean getShowsRootHandles() {
        return this.tree.getShowsRootHandles();
    }

    protected void setCellEditor(TreeCellEditor treeCellEditor) {
        this.cellEditor = treeCellEditor;
        this.createdCellEditor = true;
    }

    protected TreeCellEditor getCellEditor() {
        return this.cellEditor;
    }

    protected void setEditable(boolean bl) {
        this.tree.setEditable(bl);
    }

    protected boolean isEditable() {
        return this.tree.isEditable();
    }

    protected void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        if (treeSelectionModel != null) {
            this.treeSelectionModel = treeSelectionModel;
            this.tree.setSelectionModel(this.treeSelectionModel);
        }
    }

    protected TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    public Rectangle getPathBounds(JTree jTree, TreePath treePath) {
        int n = -1;
        Object object = null;
        if (treePath != null) {
            n = this.getRowForPath(jTree, treePath);
            object = treePath.getLastPathComponent();
        }
        return this.nodeDimensions.getNodeDimensions(object, n, this.getLevel(object), jTree.isExpanded(treePath), new Rectangle());
    }

    private final int getMaxHeight(JTree jTree) {
        if (this.maxHeight != 0) {
            return this.maxHeight;
        }
        Icon icon = UIManager.getIcon("Tree.openIcon");
        Icon icon2 = UIManager.getIcon("Tree.closedIcon");
        Icon icon3 = UIManager.getIcon("Tree.leafIcon");
        int n = this.getRowCount(jTree);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = this.isLeaf(n3) ? icon3.getIconHeight() : (jTree.isExpanded(n3) ? icon.getIconHeight() : icon2.getIconHeight());
            this.maxHeight = Math.max(this.maxHeight, n2 + this.gap);
            ++n3;
        }
        return this.maxHeight;
    }

    public TreePath getPathForRow(JTree jTree, int n) {
        Object[] objectArray;
        if (this.treeModel != null && this.currentVisiblePath != null && n < (objectArray = this.currentVisiblePath.getPath()).length) {
            return new TreePath(this.getPathToRoot(objectArray[n], 0));
        }
        return null;
    }

    public int getRowForPath(JTree jTree, TreePath treePath) {
        int n = 0;
        Object object = treePath.getLastPathComponent();
        int n2 = this.getRowCount(jTree);
        if (this.currentVisiblePath != null) {
            Object[] objectArray = this.currentVisiblePath.getPath();
            while (n < n2) {
                if (object.equals(objectArray[n])) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    public int getRowCount(JTree jTree) {
        if (this.currentVisiblePath != null) {
            return this.currentVisiblePath.getPathCount();
        }
        return 0;
    }

    public TreePath getClosestPathForLocation(JTree jTree, int n, int n2) {
        int n3 = Math.round(n2 / this.getMaxHeight(jTree));
        TreePath treePath = this.getPathForRow(jTree, n3);
        while (n3 > 0 && treePath == null) {
            treePath = this.getPathForRow(jTree, --n3);
        }
        return treePath;
    }

    public boolean isEditing(JTree jTree) {
        return this.isEditing;
    }

    public boolean stopEditing(JTree jTree) {
        if (this.isEditing(jTree)) {
            this.completeEditing(false, false, true);
            this.finish();
        }
        return this.isEditing(jTree) ^ true;
    }

    public void cancelEditing(JTree jTree) {
        this.completeEditing(false, false, false);
        this.finish();
    }

    public void startEditingAtPath(JTree jTree, TreePath treePath) {
        this.startEditing(treePath, null);
    }

    public TreePath getEditingPath(JTree jTree) {
        return this.editingPath;
    }

    protected void prepareForUIInstall() {
    }

    protected void completeUIInstall() {
    }

    protected void completeUIUninstall() {
    }

    protected void installComponents() {
        this.currentCellRenderer = this.createDefaultCellRenderer();
        this.rendererPane = this.createCellRendererPane();
        this.createdRenderer = true;
        this.setCellRenderer(this.currentCellRenderer);
    }

    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new NodeDimensionsHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected PropertyChangeListener createSelectionModelPropertyChangeListener() {
        return new SelectionModelPropertyChangeHandler();
    }

    protected TreeSelectionListener createTreeSelectionListener() {
        return new TreeSelectionHandler();
    }

    protected CellEditorListener createCellEditorListener() {
        return new CellEditorHandler();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return new TreeExpansionHandler();
    }

    protected AbstractLayoutCache createLayoutCache() {
        return new FixedHeightLayoutCache();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected TreeCellEditor createDefaultCellEditor() {
        if (this.currentCellRenderer != null) {
            return new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.currentCellRenderer, this.cellEditor);
        }
        return new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.createDefaultCellRenderer(), this.cellEditor);
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DefaultTreeCellRenderer();
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler();
    }

    protected void uninstallListeners() {
        this.tree.removePropertyChangeListener(this.propertyChangeListener);
        this.tree.removeFocusListener(this.focusListener);
        this.tree.removeTreeSelectionListener(this.treeSelectionListener);
        this.tree.removeMouseListener(this.mouseListener);
        this.tree.removeKeyListener(this.keyListener);
        this.tree.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        this.tree.removeComponentListener(this.componentListener);
        this.tree.removeTreeExpansionListener(this.treeExpansionListener);
        TreeCellEditor treeCellEditor = this.tree.getCellEditor();
        if (treeCellEditor != null) {
            treeCellEditor.removeCellEditorListener(this.cellEditorListener);
        }
        if (this.treeModel != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
    }

    protected void uninstallKeyboardActions() {
        this.action = null;
        this.tree.getInputMap(1).setParent(null);
        this.tree.getActionMap().setParent(null);
    }

    protected void uninstallComponents() {
        this.currentCellRenderer = null;
        this.rendererPane = null;
        this.createdRenderer = false;
        this.setCellRenderer(this.currentCellRenderer);
    }

    protected int getVerticalLegBuffer() {
        return this.getRowHeight() / 2;
    }

    protected int getHorizontalLegBuffer() {
        return this.rightChildIndent / 2;
    }

    protected void updateLayoutCacheExpandedNodes() {
        if (this.treeModel != null) {
            this.updateExpandedDescendants(new TreePath(this.treeModel.getRoot()));
        }
    }

    protected void updateExpandedDescendants(TreePath treePath) {
        Enumeration enumeration = this.tree.getExpandedDescendants(treePath);
        while (enumeration.hasMoreElements()) {
            this.treeState.setExpandedState((TreePath)enumeration.nextElement(), true);
        }
    }

    protected TreePath getLastChildPath(TreePath treePath) {
        return (TreePath)treePath.getLastPathComponent();
    }

    protected void updateDepthOffset() {
        this.depthOffset += this.getVerticalLegBuffer();
    }

    protected void updateCellEditor() {
        if (this.tree.isEditable() && this.cellEditor == null) {
            this.setCellEditor(this.createDefaultCellEditor());
        }
        this.createdCellEditor = true;
    }

    protected void updateRenderer() {
        if (this.tree != null && this.tree.getCellRenderer() == null) {
            if (this.currentCellRenderer == null) {
                this.currentCellRenderer = this.createDefaultCellRenderer();
            }
            this.tree.setCellRenderer(this.currentCellRenderer);
        }
    }

    protected void configureLayoutCache() {
        this.treeState = this.createLayoutCache();
    }

    protected void updateSize() {
        this.preferredSize = null;
        this.updateCachedPreferredSize();
        this.tree.treeDidChange();
    }

    protected void updateCachedPreferredSize() {
        int n = 0;
        this.updateCurrentVisiblePath();
        boolean bl = false;
        if (this.currentVisiblePath != null) {
            Object[] objectArray = this.currentVisiblePath.getPath();
            int n2 = 0;
            while (n2 < objectArray.length) {
                TreePath treePath = new TreePath(this.getPathToRoot(objectArray[n2], 0));
                Rectangle rectangle = this.getPathBounds(this.tree, treePath);
                if (this.treeModel != null) {
                    bl = this.treeModel.isLeaf(objectArray[n2]);
                }
                if (!bl && this.hasControlIcons()) {
                    rectangle.width += this.getCurrentControlIcon(treePath).getIconWidth();
                }
                n = Math.max(n, rectangle.x + rectangle.width);
                ++n2;
            }
            this.maxHeight = 0;
            this.maxHeight = this.getMaxHeight(this.tree);
            this.preferredSize = new Dimension(n, this.maxHeight * objectArray.length);
        } else {
            this.preferredSize = new Dimension(0, 0);
        }
        this.validCachedPreferredSize = true;
    }

    protected void pathWasExpanded(TreePath treePath) {
        this.validCachedPreferredSize = false;
        this.tree.repaint();
    }

    protected void pathWasCollapsed(TreePath treePath) {
        this.validCachedPreferredSize = false;
        this.tree.repaint();
    }

    protected void installDefaults() {
        LookAndFeel.installColorsAndFont(this.tree, "Tree.background", "Tree.foreground", "Tree.font");
        this.tree.setOpaque(true);
        this.rightChildIndent = UIManager.getInt("Tree.rightChildIndent");
        this.leftChildIndent = UIManager.getInt("Tree.leftChildIndent");
        this.setRowHeight(UIManager.getInt("Tree.rowHeight"));
        this.tree.setRowHeight(this.getRowHeight());
        this.tree.setScrollsOnExpand(UIManager.getBoolean("Tree.scrollsOnExpand"));
        this.setExpandedIcon(UIManager.getIcon("Tree.expandedIcon"));
        this.setCollapsedIcon(UIManager.getIcon("Tree.collapsedIcon"));
    }

    protected void installKeyboardActions() {
        InputMap inputMap = (InputMap)UIManager.get("Tree.focusInputMap");
        InputMapUIResource inputMapUIResource = new InputMapUIResource();
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        this.action = new TreeAction();
        KeyStroke[] keyStrokeArray = inputMap.allKeys();
        int n = 0;
        while (n < keyStrokeArray.length) {
            inputMapUIResource.put(KeyStroke.getKeyStroke(keyStrokeArray[n].getKeyCode(), this.convertModifiers(keyStrokeArray[n].getModifiers())), (String)inputMap.get(keyStrokeArray[n]));
            inputMapUIResource.put(KeyStroke.getKeyStroke(keyStrokeArray[n].getKeyCode(), keyStrokeArray[n].getModifiers()), (String)inputMap.get(keyStrokeArray[n]));
            actionMapUIResource.put((String)inputMap.get(keyStrokeArray[n]), new ActionListenerProxy(this.action, (String)inputMap.get(keyStrokeArray[n])));
            ++n;
        }
        inputMapUIResource.setParent(this.tree.getInputMap(1).getParent());
        actionMapUIResource.setParent(this.tree.getActionMap().getParent());
        this.tree.getInputMap(1).setParent(inputMapUIResource);
        this.tree.getActionMap().setParent(actionMapUIResource);
    }

    private final int convertModifiers(int n) {
        if ((n & 0x40) != 0) {
            n |= 1;
            n &= 0xFFFFFFBF;
        }
        if ((n & 0x80) != 0) {
            n |= 2;
            n &= 0xFFFFFF7F;
        }
        if ((n & 0x100) != 0) {
            n |= 4;
            n &= 0xFFFFFEFF;
        }
        if ((n & 0x200) != 0) {
            n |= 8;
            n &= 0xFFFFFDFF;
        }
        if ((n & 0x2000) != 0) {
            n |= 0x20;
            n &= 0xFFFFDFFF;
        }
        return n;
    }

    protected void installListeners() {
        this.tree.addPropertyChangeListener(this.propertyChangeListener);
        this.tree.addFocusListener(this.focusListener);
        this.tree.addTreeSelectionListener(this.treeSelectionListener);
        this.tree.addMouseListener(this.mouseListener);
        this.tree.addKeyListener(this.keyListener);
        this.tree.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
        this.tree.addComponentListener(this.componentListener);
        this.tree.addTreeExpansionListener(this.treeExpansionListener);
        if (this.treeModel != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
    }

    public void installUI(JComponent jComponent) {
        this.tree = (JTree)jComponent;
        this.prepareForUIInstall();
        super.installUI(jComponent);
        this.installDefaults();
        this.installComponents();
        this.installKeyboardActions();
        this.installListeners();
        this.setCellEditor(this.createDefaultCellEditor());
        this.createdCellEditor = true;
        this.isEditing = false;
        this.setModel(this.tree.getModel());
        this.treeSelectionModel = this.tree.getSelectionModel();
        this.completeUIInstall();
    }

    protected void uninstallDefaults() {
        this.tree.setFont(null);
        this.tree.setForeground(null);
        this.tree.setBackground(null);
    }

    public void uninstallUI(JComponent jComponent) {
        this.prepareForUIUninstall();
        this.uninstallDefaults();
        this.uninstallKeyboardActions();
        this.uninstallListeners();
        this.tree = null;
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        JTree jTree = (JTree)jComponent;
        this.updateCurrentVisiblePath();
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = jTree.getInsets();
        if (rectangle != null && this.treeModel != null && this.currentVisiblePath != null) {
            int n = jTree.getClosestRowForLocation(rectangle.x, rectangle.y);
            int n2 = jTree.getClosestRowForLocation(rectangle.x + rectangle.width, rectangle.y + rectangle.height);
            this.paintVerticalPartOfLeg(graphics, rectangle, insets, this.currentVisiblePath);
            int n3 = n;
            while (n3 <= n2) {
                Object object = this.currentVisiblePath.getPathComponent(n3);
                boolean bl = this.treeModel.isLeaf(object);
                TreePath treePath = new TreePath(this.getPathToRoot(object, 0));
                boolean bl2 = jTree.isExpanded(treePath);
                Rectangle rectangle2 = this.getPathBounds(jTree, treePath);
                this.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle2, treePath, n3, bl2, false, bl);
                this.paintRow(graphics, rectangle, insets, rectangle2, treePath, n3, bl2, false, bl);
                ++n3;
            }
        }
    }

    protected void ensureRowsAreVisible(int n, int n2) {
        int n3;
        if (n < n2) {
            n3 = n2;
            n2 = n;
            n = n3;
        }
        n3 = n;
        while (n3 < n2) {
            TreePath treePath = this.getPathForRow(this.tree, n3);
            if (!this.tree.isVisible(treePath)) {
                this.tree.makeVisible(treePath);
            }
            ++n3;
        }
    }

    public void setPreferredMinSize(Dimension dimension) {
        this.preferredMinSize = dimension;
    }

    public Dimension getPreferredMinSize() {
        return this.preferredMinSize;
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent, false);
    }

    public Dimension getPreferredSize(JComponent jComponent, boolean bl) {
        if (!this.validCachedPreferredSize) {
            this.updateCachedPreferredSize();
        }
        return this.preferredSize;
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        Dimension dimension = this.getPreferredMinSize();
        if (dimension == null) {
            return new Dimension();
        }
        return dimension;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (jComponent instanceof JTree) {
            return ((JTree)jComponent).getPreferredSize();
        }
        return new Dimension();
    }

    protected void completeEditing() {
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean bl, boolean bl2, boolean bl3) {
        TreeCellEditor treeCellEditor;
        if (bl) {
            this.getCellEditor().stopCellEditing();
            this.stopEditingInCompleteEditing = true;
        }
        if (bl2) {
            this.getCellEditor().cancelCellEditing();
            this.stopEditingInCompleteEditing = true;
        }
        if (bl3 && (treeCellEditor = this.getCellEditor()) != null) {
            Object object = treeCellEditor.getCellEditorValue();
            this.treeModel.valueForPathChanged(this.tree.getLeadSelectionPath(), object);
        }
    }

    protected boolean startEditing(TreePath treePath, MouseEvent mouseEvent) {
        this.maxHeight = 0;
        this.validCachedPreferredSize = false;
        this.updateCellEditor();
        TreeCellEditor treeCellEditor = this.getCellEditor();
        if (treeCellEditor != null && (mouseEvent == EDIT || treeCellEditor.shouldSelectCell(mouseEvent)) && treeCellEditor.isCellEditable(mouseEvent)) {
            Rectangle rectangle = this.getPathBounds(this.tree, treePath);
            rectangle.width = this.tree.getWidth() - rectangle.x;
            this.editingPath = treePath;
            this.editingRow = this.tree.getRowForPath(this.editingPath);
            Object object = this.editingPath.getLastPathComponent();
            this.stopEditingInCompleteEditing = false;
            boolean bl = this.tree.isExpanded(this.editingPath);
            this.isEditing = true;
            this.editingComponent = treeCellEditor.getTreeCellEditorComponent(this.tree, object, true, bl, this.isLeaf(this.editingRow), this.editingRow);
            this.tree.removeAll();
            Container container = this.editingComponent.getParent();
            container.setBounds(rectangle);
            this.tree.add(container);
            this.editingComponent.requestFocus();
            return true;
        }
        return false;
    }

    protected void checkForClickInExpandControl(TreePath treePath, int n, int n2) {
        if (this.isLocationInExpandControl(treePath, n, n2)) {
            this.toggleExpandState(treePath);
        }
    }

    protected boolean isLocationInExpandControl(TreePath treePath, int n, int n2) {
        boolean bl = false;
        int n3 = this.getRowForPath(this.tree, treePath);
        if (!this.isLeaf(n3)) {
            Rectangle rectangle = this.getPathBounds(this.tree, treePath);
            if (this.hasControlIcons() && n < rectangle.x && n > rectangle.x - this.getCurrentControlIcon(treePath).getIconWidth() - this.gap) {
                bl = true;
            }
        }
        return bl;
    }

    protected void handleExpandControlClick(TreePath treePath, int n, int n2) {
        this.toggleExpandState(treePath);
    }

    protected void toggleExpandState(TreePath treePath) {
        if (this.tree.isExpanded(treePath)) {
            this.tree.collapsePath(treePath);
        } else {
            this.tree.expandPath(treePath);
        }
    }

    protected boolean isToggleSelectionEvent(MouseEvent mouseEvent) {
        boolean bl = false;
        if (this.tree.getSelectionModel().getSelectionMode() == 1) {
            bl = true;
        }
        return bl;
    }

    protected boolean isMultiSelectEvent(MouseEvent mouseEvent) {
        boolean bl = false;
        if (this.tree.getSelectionModel().getSelectionMode() == 2) {
            bl = true;
        }
        return bl;
    }

    protected boolean isToggleEvent(MouseEvent mouseEvent) {
        return true;
    }

    protected void selectPathForEvent(TreePath treePath, MouseEvent mouseEvent) {
        if (this.isToggleSelectionEvent(mouseEvent)) {
            if (this.tree.isPathSelected(treePath)) {
                this.tree.removeSelectionPath(treePath);
            } else {
                this.tree.addSelectionPath(treePath);
                this.tree.setAnchorSelectionPath(treePath);
            }
        } else if (this.isMultiSelectEvent(mouseEvent)) {
            TreePath treePath2 = this.tree.getAnchorSelectionPath();
            if (treePath2 != null) {
                int n = this.getRowForPath(this.tree, treePath2);
                this.tree.addSelectionInterval(n, this.getRowForPath(this.tree, treePath));
            } else {
                this.tree.addSelectionPath(treePath);
            }
        } else {
            this.tree.addSelectionPath(treePath);
        }
    }

    protected boolean isLeaf(int n) {
        TreePath treePath = this.getPathForRow(this.tree, n);
        if (treePath == null) {
            return true;
        }
        Object object = treePath.getLastPathComponent();
        return this.treeModel.isLeaf(object);
    }

    boolean hasControlIcons() {
        return this.expandedIcon != null || this.collapsedIcon != null;
    }

    Icon getCurrentControlIcon(TreePath treePath) {
        if (this.tree.isExpanded(treePath)) {
            return this.expandedIcon;
        }
        return this.collapsedIcon;
    }

    Object getParent(Object object, Object object2) {
        if (object == null || object2 == null || object.equals(object2)) {
            return null;
        }
        if (object2 instanceof TreeNode) {
            return ((TreeNode)object2).getParent();
        }
        return this.findNode(object, object2);
    }

    private final Object findNode(Object object, Object object2) {
        if (!this.treeModel.isLeaf(object) && !object.equals(object2)) {
            int n = this.treeModel.getChildCount(object);
            int n2 = 0;
            while (n2 < n) {
                Object object3 = this.treeModel.getChild(object, n2);
                if (object2.equals(object3)) {
                    return object;
                }
                Object object4 = this.findNode(object3, object2);
                if (object4 != null) {
                    return object4;
                }
                ++n2;
            }
        }
        return null;
    }

    Object getPreviousVisibleNode(Object object) {
        if (this.currentVisiblePath != null) {
            Object[] objectArray = this.currentVisiblePath.getPath();
            int n = 0;
            while (n < objectArray.length && !object.equals(objectArray[n])) {
                ++n;
            }
            if (n - 1 >= 0) {
                return objectArray[n - 1];
            }
        }
        return null;
    }

    Object getNextNode(Object object) {
        if (!this.treeModel.isLeaf(object) && this.treeModel.getChildCount(object) > 0) {
            return this.treeModel.getChild(object, 0);
        }
        Object object2 = object;
        Object object3 = null;
        do {
            object3 = this.getNextSibling(object2);
            object2 = this.getParent(this.treeModel.getRoot(), object2);
        } while (object3 == null && object2 != null);
        return object3;
    }

    Object getPreviousNode(Object object) {
        Object object2 = this.getParent(this.treeModel.getRoot(), object);
        if (object2 == null) {
            return null;
        }
        Object object3 = this.getPreviousSibling(object);
        if (object3 == null) {
            return object2;
        }
        int n = 0;
        if (!this.treeModel.isLeaf(object3)) {
            n = this.treeModel.getChildCount(object3);
        }
        while (n > 0) {
            n = !this.treeModel.isLeaf(object3 = this.treeModel.getChild(object3, n - 1)) ? this.treeModel.getChildCount(object3) : 0;
        }
        return object3;
    }

    Object getNextSibling(Object object) {
        Object object2 = this.getParent(this.treeModel.getRoot(), object);
        if (object2 == null) {
            return null;
        }
        int n = this.treeModel.getIndexOfChild(object2, object) + 1;
        int n2 = 0;
        if (!this.treeModel.isLeaf(object2)) {
            n2 = this.treeModel.getChildCount(object2);
        }
        if (n == 0 || n >= n2) {
            return null;
        }
        return this.treeModel.getChild(object2, n);
    }

    Object getPreviousSibling(Object object) {
        Object object2 = this.getParent(this.treeModel.getRoot(), object);
        if (object2 == null) {
            return null;
        }
        int n = this.treeModel.getIndexOfChild(object2, object) - 1;
        int n2 = 0;
        if (!this.treeModel.isLeaf(object2)) {
            n2 = this.treeModel.getChildCount(object2);
        }
        if (n < 0 || n >= n2) {
            return null;
        }
        return this.treeModel.getChild(object2, n);
    }

    void selectPath(JTree jTree, TreePath treePath) {
        if (treePath != null) {
            if (jTree.getSelectionModel().getSelectionMode() == 1) {
                jTree.getSelectionModel().clearSelection();
                jTree.addSelectionPath(treePath);
                jTree.setLeadSelectionPath(treePath);
            } else if (jTree.getSelectionModel().getSelectionMode() != 2) {
                jTree.addSelectionPath(treePath);
                jTree.setLeadSelectionPath(treePath);
                jTree.getSelectionModel().setSelectionMode(4);
            }
        }
    }

    Object[] getPathToRoot(Object object, int n) {
        if (object == null) {
            if (n == 0) {
                return null;
            }
            return new Object[n];
        }
        Object[] objectArray = this.getPathToRoot(this.getParent(this.treeModel.getRoot(), object), n + 1);
        objectArray[objectArray.length - n - 1] = object;
        return objectArray;
    }

    int getLevel(Object object) {
        int n = -1;
        Object object2 = object;
        if (this.treeModel != null) {
            Object object3 = this.treeModel.getRoot();
            if (!this.tree.isRootVisible() && this.tree.isExpanded(new TreePath(object3))) {
                --n;
            }
            do {
                object2 = this.getParent(object3, object2);
                ++n;
            } while (object2 != null);
        }
        return n;
    }

    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        graphics.setColor(this.getHashColor());
        graphics.drawLine(n, n2, n, n3);
    }

    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        graphics.setColor(this.getHashColor());
        graphics.drawLine(n2, n, n3, n);
    }

    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n, int n2) {
        n2 -= icon.getIconHeight() / 2;
        if ((n -= icon.getIconWidth() / 2) < 0) {
            n = 0;
        }
        if (n2 < 0) {
            n2 = 0;
        }
        icon.paintIcon(component, graphics, n, n2);
    }

    protected void drawDashedHorizontalLine(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(this.getHashColor());
        int n4 = n2;
        while (n4 < n3) {
            graphics.drawLine(n4, n, n4 + 1, n);
            n4 += 2;
        }
    }

    protected void drawDashedVerticalLine(Graphics graphics, int n, int n2, int n3) {
        graphics.setColor(this.getHashColor());
        int n4 = n2;
        while (n4 < n3) {
            graphics.drawLine(n, n4, n, n4 + 1);
            n4 += 2;
        }
    }

    protected void paintExpandControl(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (this.shouldPaintExpandControl(treePath, n, bl, bl2, bl3)) {
            Icon icon = this.getCurrentControlIcon(treePath);
            int n2 = icon.getIconWidth();
            int n3 = rectangle2.x - this.rightChildIndent + n2 / 2;
            if (n3 + n2 > rectangle2.x) {
                n3 = rectangle2.x - this.rightChildIndent - this.gap;
            }
            icon.paintIcon(this.tree, graphics, n3, rectangle2.y + rectangle2.height / 2 - icon.getIconHeight() / 2);
        }
    }

    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (n != 0) {
            this.paintHorizontalLine(graphics, this.tree, rectangle2.y + rectangle2.height / 2, rectangle2.x - this.gap - 2, rectangle2.x);
        }
    }

    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        int n = this.tree.getVisibleRowCount();
        int n2 = 0;
        while (n2 < n) {
            Object object = treePath.getPathComponent(n2);
            TreePath treePath2 = new TreePath(this.getPathToRoot(object, 0));
            int n3 = this.treeModel.getChildCount(object);
            if (n3 > 0 && this.tree.isExpanded(treePath2)) {
                Rectangle rectangle2 = this.getPathBounds(this.tree, treePath2);
                Rectangle rectangle3 = this.getPathBounds(this.tree, new TreePath(this.getPathToRoot(this.treeModel.getChild(object, n3 - 1), 0)));
                this.paintVerticalLine(graphics, this.tree, rectangle2.x + this.gap + 2, rectangle2.y + rectangle2.height - 2, rectangle3.y + rectangle3.height / 2);
            }
            ++n2;
        }
    }

    protected void paintRow(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        boolean bl4 = this.tree.isPathSelected(treePath);
        boolean bl5 = false;
        Object object = treePath.getLastPathComponent();
        if (this.tree.isVisible(treePath)) {
            if (!this.validCachedPreferredSize) {
                this.updateCachedPreferredSize();
            }
            this.paintExpandControl(graphics, rectangle, insets, rectangle2, treePath, n, bl, bl2, bl3);
            if (n != 0) {
                rectangle2.x += this.gap;
            }
            rectangle2.width = this.preferredSize.width + rectangle2.x;
            TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
            if (treeCellRenderer == null) {
                treeCellRenderer = this.createDefaultCellRenderer();
            }
            Component component = treeCellRenderer.getTreeCellRendererComponent(this.tree, object, bl4, bl, bl3, n, this.tree.hasFocus());
            this.rendererPane.paintComponent(graphics, component, component.getParent(), rectangle2);
        }
    }

    protected void prepareForUIUninstall() {
    }

    protected boolean shouldPaintExpandControl(TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        Object object = treePath.getLastPathComponent();
        boolean bl4 = false;
        if (!bl3 && this.getLevel(object) != 0 && this.hasControlIcons()) {
            bl4 = true;
        }
        return bl4;
    }

    void updateCurrentVisiblePath() {
        if (this.treeModel == null) {
            return;
        }
        Object object = this.treeModel.getRoot();
        if (object == null) {
            return;
        }
        TreePath treePath = new TreePath(object);
        Rectangle rectangle = this.getPathBounds(this.tree, treePath);
        if (rectangle.width == 0 && rectangle.height == 0 || !this.isRootVisible() && this.tree.isExpanded(new TreePath(object))) {
            object = this.getNextNode(object);
            treePath = new TreePath(object);
        }
        Object object2 = object;
        TreePath treePath2 = null;
        while (object != null) {
            treePath2 = treePath2 == null ? treePath : treePath2.pathByAddingChild(object);
            do {
                TreePath treePath3;
                if (this.tree.isVisible(treePath3 = new TreePath(this.getPathToRoot(object, 0))) && this.tree.isExpanded(treePath3) || this.treeModel.isLeaf(object)) {
                    object = this.getNextNode(object);
                    continue;
                }
                Object object3 = object;
                if ((object = this.getNextSibling(object3)) != null) continue;
                Object object4 = this.getParent(object2, object3);
                while (object == null && object4 != null) {
                    object = this.getNextSibling(object4);
                    if (object != null) continue;
                    object4 = this.getParent(object2, object4);
                }
            } while (object != null && !this.tree.isVisible(new TreePath(this.getPathToRoot(object, 0))));
        }
        this.currentVisiblePath = treePath2;
        this.tree.setVisibleRowCount(this.getRowCount(this.tree));
        if (this.tree.getSelectionModel() != null && this.tree.getSelectionCount() == 0 && this.currentVisiblePath != null) {
            this.selectPath(this.tree, new TreePath(this.getPathToRoot(this.currentVisiblePath.getPathComponent(0), 0)));
        }
    }

    Object getNextVisibleNode(Object object) {
        if (this.currentVisiblePath != null) {
            Object[] objectArray = this.currentVisiblePath.getPath();
            int n = 0;
            while (n < objectArray.length && !object.equals(objectArray[n])) {
                ++n;
            }
            if (n + 1 < objectArray.length) {
                return objectArray[n + 1];
            }
        }
        return null;
    }

    void finish() {
        this.editingPath = null;
        this.editingRow = -1;
        this.stopEditingInCompleteEditing = false;
        this.isEditing = false;
        this.tree.removeAll();
        this.validCachedPreferredSize = false;
        this.tree.repaint(this.editingComponent.getParent().getBounds());
        this.editingComponent = null;
    }

    private final /* synthetic */ void this() {
        this.gap = 4;
        this.maxHeight = 0;
    }

    public BasicTreeUI() {
        this.this();
        this.validCachedPreferredSize = false;
        this.drawingCache = new Hashtable();
        this.nodeDimensions = this.createNodeDimensions();
        this.configureLayoutCache();
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.focusListener = this.createFocusListener();
        this.treeSelectionListener = this.createTreeSelectionListener();
        this.mouseListener = this.createMouseListener();
        this.keyListener = this.createKeyListener();
        this.selectionModelPropertyChangeListener = this.createSelectionModelPropertyChangeListener();
        this.componentListener = this.createComponentListener();
        this.cellEditorListener = this.createCellEditorListener();
        this.treeExpansionListener = this.createTreeExpansionListener();
        this.treeModelListener = this.createTreeModelListener();
        this.editingRow = -1;
        this.lastSelectedRow = -1;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class NodeDimensionsHandler
    extends AbstractLayoutCache.NodeDimensions {
        public Rectangle getNodeDimensions(Object object, int n, int n2, boolean bl, Rectangle rectangle) {
            if (rectangle == null || object == null) {
                return null;
            }
            String string = object.toString();
            Font font = BasicTreeUI.this.tree.getFont();
            FontMetrics fontMetrics = BasicTreeUI.this.tree.getToolkit().getFontMetrics(font);
            if (string != null) {
                rectangle.x = this.getRowX(n, n2);
                rectangle.width = SwingUtilities.computeStringWidth(fontMetrics, string);
                rectangle.height = BasicTreeUI.this.getMaxHeight(BasicTreeUI.this.tree);
                rectangle.y = rectangle.height * n;
            }
            return rectangle;
        }

        protected int getRowX(int n, int n2) {
            if (n == 0) {
                return 0;
            }
            return n2 * BasicTreeUI.this.rightChildIndent;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("rootVisible")) {
                BasicTreeUI.this.validCachedPreferredSize = false;
                BasicTreeUI.this.tree.repaint();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        public void mousePressed(MouseEvent mouseEvent) {
            if (BasicTreeUI.this.startEditTimer != null) {
                BasicTreeUI.this.startEditTimer.stop();
                BasicTreeUI.this.startEditTimer = null;
            }
            Point point = mouseEvent.getPoint();
            TreePath treePath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, point.x, point.y);
            if (treePath != null) {
                boolean bl;
                Icon icon;
                Rectangle rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treePath);
                int n = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath);
                boolean bl2 = BasicTreeUI.this.isLocationInExpandControl(treePath, point.x, point.y);
                boolean bl3 = BasicTreeUI.this.isLeaf(n);
                TreeCellRenderer treeCellRenderer = BasicTreeUI.this.getCellRenderer();
                Icon icon2 = bl3 ? UIManager.getIcon("Tree.leafIcon") : (BasicTreeUI.this.tree.isExpanded(treePath) ? UIManager.getIcon("Tree.openIcon") : UIManager.getIcon("Tree.closedIcon"));
                if (treeCellRenderer instanceof DefaultTreeCellRenderer && (icon = ((DefaultTreeCellRenderer)treeCellRenderer).getIcon()) != null) {
                    icon2 = icon;
                }
                if (icon2 != null) {
                    rectangle.width += icon2.getIconWidth() + BasicTreeUI.this.gap * 2;
                }
                if (((bl = rectangle.contains(point.x, point.y)) || bl2) && BasicTreeUI.this.tree.isVisible(treePath)) {
                    if (bl) {
                        TreePath treePath2 = BasicTreeUI.this.tree.getLeadSelectionPath();
                        if (treePath2 != null && treePath2.equals(treePath) && mouseEvent.getClickCount() == 1 && BasicTreeUI.this.tree.isEditable()) {
                            final TreePath treePath3 = treePath;
                            if (BasicTreeUI.this.startEditTimer != null) {
                                BasicTreeUI.this.startEditTimer.stop();
                            }
                            BasicTreeUI.this.startEditTimer = new Timer(WAIT_TILL_EDITING, new ActionListener(){

                                public final void actionPerformed(ActionEvent actionEvent) {
                                    BasicTreeUI.this.startEditing(treePath3, EDIT);
                                }
                            });
                            BasicTreeUI.this.startEditTimer.setRepeats(false);
                            BasicTreeUI.this.startEditTimer.start();
                        } else {
                            BasicTreeUI.this.selectPath(BasicTreeUI.this.tree, treePath);
                            if (mouseEvent.getClickCount() == 2 && !BasicTreeUI.this.isLeaf(n)) {
                                BasicTreeUI.this.toggleExpandState(treePath);
                            }
                        }
                    }
                    if (bl2) {
                        BasicTreeUI.this.handleExpandControlClick(treePath, point.x, point.y);
                        if (BasicTreeUI.this.cellEditor != null) {
                            BasicTreeUI.this.cellEditor.cancelCellEditing();
                        }
                        BasicTreeUI.this.tree.scrollPathToVisible(treePath);
                    } else if (BasicTreeUI.this.tree.isEditable()) {
                        BasicTreeUI.this.startEditing(treePath, mouseEvent);
                    }
                }
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
        }

        public void focusLost(FocusEvent focusEvent) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class KeyHandler
    extends KeyAdapter {
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class SelectionModelPropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreeSelectionHandler
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            if (BasicTreeUI.this.tree.isEditing()) {
                BasicTreeUI.this.tree.stopEditing();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class CellEditorHandler
    implements CellEditorListener {
        public void editingStopped(ChangeEvent changeEvent) {
            BasicTreeUI.this.stopEditing(BasicTreeUI.this.tree);
        }

        public void editingCanceled(ChangeEvent changeEvent) {
            BasicTreeUI.this.cancelEditing(BasicTreeUI.this.tree);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer;
        protected JScrollBar scrollBar;

        public void componentMoved(ComponentEvent componentEvent) {
        }

        protected void startTimer() {
        }

        protected JScrollPane getScrollPane() {
            return null;
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreeExpansionHandler
    implements TreeExpansionListener {
        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.tree.repaint();
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.tree.repaint();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreeModelHandler
    implements TreeModelListener {
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.tree.repaint();
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.tree.repaint();
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.tree.repaint();
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            if (treeModelEvent.getPath().length == 1 && !treeModelEvent.getPath()[0].equals(BasicTreeUI.this.treeModel.getRoot())) {
                BasicTreeUI.this.tree.expandPath(new TreePath(BasicTreeUI.this.treeModel.getRoot()));
            }
            BasicTreeUI.this.validCachedPreferredSize = false;
            BasicTreeUI.this.tree.repaint();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class TreeAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
            TreePath treePath = BasicTreeUI.this.tree.getLeadSelectionPath();
            if (actionEvent.getActionCommand().equals("selectPreviousChangeLead") || actionEvent.getActionCommand().equals("selectPreviousExtendSelection") || actionEvent.getActionCommand().equals("selectPrevious") || actionEvent.getActionCommand().equals("selectNext") || actionEvent.getActionCommand().equals("selectNextExtendSelection") || actionEvent.getActionCommand().equals("selectNextChangeLead")) {
                new TreeIncrementAction(0, "").actionPerformed(actionEvent);
            } else if (actionEvent.getActionCommand().equals("selectParent") || actionEvent.getActionCommand().equals("selectChild")) {
                new TreeTraverseAction(0, "").actionPerformed(actionEvent);
            } else if (actionEvent.getActionCommand().equals("selectAll")) {
                TreePath[] treePathArray = new TreePath[BasicTreeUI.this.tree.getVisibleRowCount()];
                Object object = BasicTreeUI.this.getNextVisibleNode(BasicTreeUI.this.treeModel.getRoot());
                int n = 0;
                while (object != null && n < treePathArray.length) {
                    treePathArray[n] = new TreePath(BasicTreeUI.this.getPathToRoot(object, 0));
                    ++n;
                }
                BasicTreeUI.this.tree.addSelectionPaths(treePathArray);
            } else if (actionEvent.getActionCommand().equals("startEditing")) {
                BasicTreeUI.this.tree.startEditingAtPath(treePath);
            } else if (actionEvent.getActionCommand().equals("toggle")) {
                if (BasicTreeUI.this.tree.isEditing()) {
                    BasicTreeUI.this.tree.stopEditing();
                } else {
                    Object object = treePath.getLastPathComponent();
                    TreePath treePath2 = new TreePath(BasicTreeUI.this.getPathToRoot(object, 0));
                    if (!BasicTreeUI.this.treeModel.isLeaf(object)) {
                        BasicTreeUI.this.toggleExpandState(treePath2);
                    }
                }
            } else if (actionEvent.getActionCommand().equals("clearSelection")) {
                BasicTreeUI.this.tree.clearSelection();
            }
            if (BasicTreeUI.this.tree.isEditing() && !actionEvent.getActionCommand().equals("startEditing")) {
                BasicTreeUI.this.tree.stopEditing();
            }
            BasicTreeUI.this.tree.scrollPathToVisible(treePath);
        }

        TreeAction() {
        }
    }

    private static class ActionListenerProxy
    extends AbstractAction {
        ActionListener target;
        String bindingCommandName;

        public void actionPerformed(ActionEvent actionEvent) {
            ActionEvent actionEvent2 = new ActionEvent(actionEvent.getSource(), actionEvent.getID(), this.bindingCommandName, actionEvent.getModifiers());
            this.target.actionPerformed(actionEvent2);
        }

        public ActionListenerProxy(ActionListener actionListener, String string) {
            this.target = actionListener;
            this.bindingCommandName = string;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreeTraverseAction
    extends AbstractAction {
        protected int direction;

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = BasicTreeUI.this.tree.getLeadSelectionPath().getLastPathComponent();
            if (actionEvent.getActionCommand().equals("selectParent")) {
                TreePath treePath = new TreePath(BasicTreeUI.this.getPathToRoot(object, 0));
                Object object2 = BasicTreeUI.this.getParent(BasicTreeUI.this.treeModel.getRoot(), object);
                if (!BasicTreeUI.this.treeModel.isLeaf(object)) {
                    BasicTreeUI.this.toggleExpandState(treePath);
                } else if (object2 != null) {
                    BasicTreeUI.this.selectPath(BasicTreeUI.this.tree, new TreePath(BasicTreeUI.this.getPathToRoot(object2, 0)));
                }
            } else if (actionEvent.getActionCommand().equals("selectChild")) {
                TreePath treePath = new TreePath(BasicTreeUI.this.getPathToRoot(object, 0));
                if (!BasicTreeUI.this.treeModel.isLeaf(object)) {
                    BasicTreeUI.this.toggleExpandState(treePath);
                } else {
                    Object object3 = BasicTreeUI.this.getNextVisibleNode(object);
                    if (object3 != null) {
                        BasicTreeUI.this.selectPath(BasicTreeUI.this.tree, new TreePath(BasicTreeUI.this.getPathToRoot(object3, 0)));
                    }
                }
            }
        }

        public boolean isEnabled() {
            return false;
        }

        public TreeTraverseAction(int n, String string) {
            this.direction = n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreeToggleAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }

        public TreeToggleAction(String string) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreePageAction
    extends AbstractAction {
        protected int direction;

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }

        public TreePageAction(int n, String string) {
            this.direction = n;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreeIncrementAction
    extends AbstractAction {
        protected int direction;

        public void actionPerformed(ActionEvent actionEvent) {
            Object object;
            Object object2 = BasicTreeUI.this.tree.getLeadSelectionPath().getLastPathComponent();
            if (actionEvent.getActionCommand().equals("selectPreviousChangeLead")) {
                Object object3 = BasicTreeUI.this.getPreviousVisibleNode(object2);
                if (object3 != null) {
                    TreePath treePath = new TreePath(BasicTreeUI.this.getPathToRoot(object3, 0));
                    BasicTreeUI.this.selectPath(BasicTreeUI.this.tree, treePath);
                    BasicTreeUI.this.tree.setLeadSelectionPath(treePath);
                }
            } else if (actionEvent.getActionCommand().equals("selectPreviousExtendSelection")) {
                Object object4 = BasicTreeUI.this.getPreviousVisibleNode(object2);
                if (object4 != null) {
                    TreePath treePath = new TreePath(BasicTreeUI.this.getPathToRoot(object4, 0));
                    BasicTreeUI.this.tree.addSelectionPath(treePath);
                    BasicTreeUI.this.tree.setLeadSelectionPath(treePath);
                }
            } else if (actionEvent.getActionCommand().equals("selectPrevious")) {
                Object object5 = BasicTreeUI.this.getPreviousVisibleNode(object2);
                if (object5 != null) {
                    TreePath treePath = new TreePath(BasicTreeUI.this.getPathToRoot(object5, 0));
                    BasicTreeUI.this.selectPath(BasicTreeUI.this.tree, treePath);
                }
            } else if (actionEvent.getActionCommand().equals("selectNext")) {
                Object object6 = BasicTreeUI.this.getNextVisibleNode(object2);
                if (object6 != null) {
                    TreePath treePath = new TreePath(BasicTreeUI.this.getPathToRoot(object6, 0));
                    BasicTreeUI.this.selectPath(BasicTreeUI.this.tree, treePath);
                }
            } else if (actionEvent.getActionCommand().equals("selectNextExtendSelection")) {
                Object object7 = BasicTreeUI.this.getNextVisibleNode(object2);
                if (object7 != null) {
                    TreePath treePath = new TreePath(BasicTreeUI.this.getPathToRoot(object7, 0));
                    BasicTreeUI.this.tree.addSelectionPath(treePath);
                    BasicTreeUI.this.tree.setLeadSelectionPath(treePath);
                }
            } else if (actionEvent.getActionCommand().equals("selectNextChangeLead") && (object = BasicTreeUI.this.getNextVisibleNode(object2)) != null) {
                TreePath treePath = new TreePath(BasicTreeUI.this.getPathToRoot(object, 0));
                BasicTreeUI.this.selectPath(BasicTreeUI.this.tree, treePath);
                BasicTreeUI.this.tree.setLeadSelectionPath(treePath);
            }
        }

        public boolean isEnabled() {
            return false;
        }

        public TreeIncrementAction(int n, String string) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreeHomeAction
    extends AbstractAction {
        protected int direction;

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }

        public TreeHomeAction(int n, String string) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class TreeCancelEditingAction
    extends AbstractAction {
        public void actionPerformed(ActionEvent actionEvent) {
        }

        public boolean isEnabled() {
            return false;
        }

        public TreeCancelEditingAction(String string) {
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public class MouseInputHandler
    implements MouseInputListener {
        protected Component source;
        protected Component destination;

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        protected void removeFromSource() {
        }

        public MouseInputHandler(Component component, Component component2, MouseEvent mouseEvent) {
            this.source = component;
            this.destination = component2;
        }
    }
}

