/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.JFileChooser;
import javax.swing.event.ListDataEvent;
import javax.swing.filechooser.FileSystemView;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class BasicDirectoryModel
extends AbstractListModel
implements PropertyChangeListener {
    private Vector contents;
    private int directories;
    private int listingMode;
    private JFileChooser filechooser;
    private Comparator comparator;

    public boolean contains(Object object) {
        return this.contents.contains(object);
    }

    public void fireContentsChanged() {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public Vector getDirectories() {
        Vector vector = new Vector();
        int n = 0;
        while (n < this.directories) {
            vector.add(this.contents.get(n));
            ++n;
        }
        return vector;
    }

    public Object getElementAt(int n) {
        if (n > this.getSize() - 1) {
            return null;
        }
        if (this.listingMode == 0) {
            return this.contents.get(this.directories + n);
        }
        return this.contents.elementAt(n);
    }

    public Vector getFiles() {
        Vector vector = new Vector();
        int n = this.directories;
        while (n < this.getSize()) {
            vector.add(this.contents.get(n));
            ++n;
        }
        return vector;
    }

    public int getSize() {
        if (this.listingMode == 1) {
            return this.directories;
        }
        if (this.listingMode == 0) {
            return this.contents.size() - this.directories;
        }
        return this.contents.size();
    }

    public int indexOf(Object object) {
        if (this.listingMode == 0) {
            return this.contents.indexOf(object) - this.directories;
        }
        return this.contents.indexOf(object);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
    }

    public void invalidateFileCache() {
    }

    protected boolean lt(File file, File file2) {
        boolean bl;
        boolean bl2 = this.filechooser.isTraversable(file);
        if (bl2 == (bl = this.filechooser.isTraversable(file2))) {
            String string = file.getName().toLowerCase();
            String string2 = file2.getName().toLowerCase();
            boolean bl3 = false;
            if (string.compareTo(string2) < 0) {
                bl3 = true;
            }
            return bl3;
        }
        return bl2;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("fileSelectionChanged")) {
            this.listingMode = this.filechooser.getFileSelectionMode();
        }
    }

    public boolean renameFile(File file, File file2) {
        return false;
    }

    protected void sort(Vector vector) {
        Collections.sort(vector, this.comparator);
        Enumeration enumeration = Collections.enumeration(vector);
        Vector vector2 = new Vector();
        while (enumeration.hasMoreElements()) {
            vector2.add(enumeration.nextElement());
        }
        this.contents = vector2;
    }

    public void validateFileCache() {
        this.contents.clear();
        this.directories = 0;
        FileSystemView fileSystemView = this.filechooser.getFileSystemView();
        File[] fileArray = fileSystemView.getFiles(this.filechooser.getCurrentDirectory(), this.filechooser.isFileHidingEnabled());
        if (fileArray == null) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            if (fileArray[n] != null && this.filechooser.accept(fileArray[n])) {
                this.contents.add(fileArray[n]);
                if (this.filechooser.isTraversable(fileArray[n])) {
                    ++this.directories;
                }
            }
            ++n;
        }
        this.sort(this.contents);
        this.filechooser.revalidate();
        this.filechooser.repaint();
    }

    private final /* synthetic */ void this() {
        this.comparator = new Comparator(){

            public final int compare(Object object, Object object2) {
                if (BasicDirectoryModel.this.lt((File)object, (File)object2)) {
                    return -1;
                }
                return 1;
            }
        };
    }

    public BasicDirectoryModel(JFileChooser jFileChooser) {
        this.this();
        this.filechooser = jFileChooser;
        jFileChooser.addPropertyChangeListener(this);
        this.listingMode = jFileChooser.getFileSelectionMode();
        this.contents = new Vector();
    }
}

