/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.Popup;
import javax.swing.SwingUtilities;

public class PopupFactory {
    private static PopupFactory sharedFactory;

    public static void setSharedInstance(PopupFactory popupFactory) {
        if (popupFactory == null) {
            throw new IllegalArgumentException();
        }
        sharedFactory = popupFactory;
    }

    public static PopupFactory getSharedInstance() {
        if (sharedFactory == null) {
            sharedFactory = new PopupFactory();
        }
        return sharedFactory;
    }

    public Popup getPopup(Component component, Component component2, int n, int n2) {
        JComponent jComponent;
        Popup popup = null;
        boolean bl = true;
        if (component2 instanceof JPopupMenu) {
            jComponent = (JPopupMenu)component2;
            bl = ((JPopupMenu)jComponent).isLightWeightPopupEnabled();
        }
        if ((jComponent = SwingUtilities.getRootPane(component)) != null) {
            Point point = jComponent.getLocationOnScreen();
            Dimension dimension = component2.getSize();
            Dimension dimension2 = jComponent.getSize();
            popup = n >= point.x && n2 > point.y && n - point.x + dimension.width < dimension2.width && n2 - point.y + dimension.height < dimension2.height ? new Popup.LightweightPopup(component, component2, n, n2) : new Popup.JWindowPopup(component, component2, n, n2);
        } else {
            popup = new Popup.JWindowPopup(component, component2, n, n2);
        }
        return popup;
    }
}

