/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.midi;

import java.util.Iterator;
import java.util.Vector;
import javax.sound.midi.InvalidMidiDataException;
import javax.sound.midi.Patch;
import javax.sound.midi.Track;

public class Sequence {
    public static final float PPQ = 0.0f;
    public static final float SMPTE_24 = 24.0f;
    public static final float SMPTE_25 = 25.0f;
    public static final float SMPTE_30 = 30.0f;
    public static final float SMPTE_30DROP = 29.97f;
    protected float divisionType;
    protected int resolution;
    protected Vector tracks;

    private final void init(float f, int n, int n2) throws InvalidMidiDataException {
        if (f != 0.0f && f != 24.0f && f != 25.0f && f != 30.0f && f != 29.97f) {
            throw new InvalidMidiDataException("Invalid division type (" + f + ')');
        }
        this.divisionType = f;
        this.resolution = n;
        this.tracks = new Vector(n2);
        while (n2 > 0) {
            this.tracks.set(--n2, new Track());
        }
    }

    public float getDivisionType() {
        return this.divisionType;
    }

    public int getResolution() {
        return this.resolution;
    }

    public Track createTrack() {
        Track track = new Track();
        this.tracks.add(track);
        return track;
    }

    public boolean deleteTrack(Track track) {
        return this.tracks.remove(track);
    }

    public Track[] getTracks() {
        return (Track[])this.tracks.toArray(new Track[this.tracks.size()]);
    }

    public long getMicrosecondLength() {
        long l = this.getTickLength();
        if (this.divisionType == 0.0f) {
            throw new UnsupportedOperationException("Can't compute PPQ based lengths yet");
        }
        return (long)((float)(l * 1000000L) / (this.divisionType * (float)this.resolution));
    }

    public long getTickLength() {
        long l = 0L;
        Iterator iterator = this.tracks.iterator();
        while (iterator.hasNext()) {
            Track track = (Track)iterator.next();
            long l2 = track.ticks();
            if (l2 <= l) continue;
            l = l2;
        }
        return l;
    }

    public Patch[] getPatchList() {
        throw new UnsupportedOperationException("Can't get patch list yet");
    }

    public Sequence(float f, int n) throws InvalidMidiDataException {
        this.init(f, n, 0);
    }

    public Sequence(float f, int n, int n2) throws InvalidMidiDataException {
        this.init(f, n, 0);
    }
}

