/*
 * Decompiled with CFR 0.152.
 */
package javax.imageio;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageInputStreamSpi;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageTranscoderSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageOutputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class ImageIO {
    private static File cacheDirectory;
    private static boolean useCache;
    static /* synthetic */ Class class$javax$imageio$spi$ImageReaderSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageWriterSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageInputStreamSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageOutputStreamSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageTranscoderSpi;

    private static final Iterator getReadersByFilter(Class clazz, ServiceRegistry.Filter filter, Object object) {
        try {
            Iterator iterator = ImageIO.getRegistry().getServiceProviders(clazz, filter, true);
            return new ImageReaderIterator(iterator, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.EMPTY_SET.iterator();
        }
    }

    private static final Iterator getWritersByFilter(Class clazz, ServiceRegistry.Filter filter, Object object) {
        try {
            Iterator iterator = ImageIO.getRegistry().getServiceProviders(clazz, filter, true);
            return new ImageWriterIterator(iterator, object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return Collections.EMPTY_SET.iterator();
        }
    }

    public static final File getCacheDirectory() {
        return cacheDirectory;
    }

    public static final Iterator getImageReadersByFormatName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("formatName may not be null");
        }
        Class clazz = class$javax$imageio$spi$ImageReaderSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageReaderSpi = ImageIO.class("[Ljavax.imageio.spi.ImageReaderSpi;", false);
        }
        return ImageIO.getReadersByFilter(clazz, new ReaderFormatFilter(string), string);
    }

    public static final Iterator getImageReadersByMIMEType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("MIMEType may not be null");
        }
        Class clazz = class$javax$imageio$spi$ImageReaderSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageReaderSpi = ImageIO.class("[Ljavax.imageio.spi.ImageReaderSpi;", false);
        }
        return ImageIO.getReadersByFilter(clazz, new ReaderMIMETypeFilter(string), string);
    }

    public static final Iterator getImageReadersBySuffix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("formatName may not be null");
        }
        Class clazz = class$javax$imageio$spi$ImageReaderSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageReaderSpi = ImageIO.class("[Ljavax.imageio.spi.ImageReaderSpi;", false);
        }
        return ImageIO.getReadersByFilter(clazz, new ReaderSuffixFilter(string), string);
    }

    public static final Iterator getImageWritersByFormatName(String string) {
        if (string == null) {
            throw new IllegalArgumentException("formatName may not be null");
        }
        Class clazz = class$javax$imageio$spi$ImageWriterSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageWriterSpi = ImageIO.class("[Ljavax.imageio.spi.ImageWriterSpi;", false);
        }
        return ImageIO.getWritersByFilter(clazz, new WriterFormatFilter(string), string);
    }

    public static final Iterator getImageWritersByMIMEType(String string) {
        if (string == null) {
            throw new IllegalArgumentException("MIMEType may not be null");
        }
        Class clazz = class$javax$imageio$spi$ImageWriterSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageWriterSpi = ImageIO.class("[Ljavax.imageio.spi.ImageWriterSpi;", false);
        }
        return ImageIO.getWritersByFilter(clazz, new WriterMIMETypeFilter(string), string);
    }

    public static final Iterator getImageWritersBySuffix(String string) {
        if (string == null) {
            throw new IllegalArgumentException("fileSuffix may not be null");
        }
        Class clazz = class$javax$imageio$spi$ImageWriterSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageWriterSpi = ImageIO.class("[Ljavax.imageio.spi.ImageWriterSpi;", false);
        }
        return ImageIO.getWritersByFilter(clazz, new WriterSuffixFilter(string), string);
    }

    public static final String[] getReaderFormatNames() {
        try {
            IIORegistry iIORegistry = ImageIO.getRegistry();
            Class clazz = class$javax$imageio$spi$ImageReaderSpi;
            if (clazz == null) {
                clazz = class$javax$imageio$spi$ImageReaderSpi = ImageIO.class("[Ljavax.imageio.spi.ImageReaderSpi;", false);
            }
            Iterator iterator = iIORegistry.getServiceProviders(clazz, true);
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                ImageReaderSpi imageReaderSpi = (ImageReaderSpi)iterator.next();
                String[] stringArray = imageReaderSpi.getFormatNames();
                int n = stringArray.length - 1;
                while (n >= 0) {
                    arrayList.add(stringArray[n]);
                    --n;
                }
            }
            return (String[])arrayList.toArray(new String[arrayList.size()]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new String[0];
        }
    }

    public static final String[] getReaderMIMETypes() {
        try {
            IIORegistry iIORegistry = ImageIO.getRegistry();
            Class clazz = class$javax$imageio$spi$ImageReaderSpi;
            if (clazz == null) {
                clazz = class$javax$imageio$spi$ImageReaderSpi = ImageIO.class("[Ljavax.imageio.spi.ImageReaderSpi;", false);
            }
            Iterator iterator = iIORegistry.getServiceProviders(clazz, true);
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                ImageReaderSpi imageReaderSpi = (ImageReaderSpi)iterator.next();
                String[] stringArray = imageReaderSpi.getMIMETypes();
                int n = stringArray.length - 1;
                while (n >= 0) {
                    arrayList.add(stringArray[n]);
                    --n;
                }
            }
            return (String[])arrayList.toArray(new String[arrayList.size()]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new String[0];
        }
    }

    private static final IIORegistry getRegistry() {
        return IIORegistry.getDefaultInstance();
    }

    public static final boolean getUseCache() {
        return useCache;
    }

    public static final String[] getWriterFormatNames() {
        try {
            IIORegistry iIORegistry = ImageIO.getRegistry();
            Class clazz = class$javax$imageio$spi$ImageWriterSpi;
            if (clazz == null) {
                clazz = class$javax$imageio$spi$ImageWriterSpi = ImageIO.class("[Ljavax.imageio.spi.ImageWriterSpi;", false);
            }
            Iterator iterator = iIORegistry.getServiceProviders(clazz, true);
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                ImageWriterSpi imageWriterSpi = (ImageWriterSpi)iterator.next();
                String[] stringArray = imageWriterSpi.getFormatNames();
                int n = stringArray.length - 1;
                while (n >= 0) {
                    arrayList.add(stringArray[n]);
                    --n;
                }
            }
            return (String[])arrayList.toArray(new String[arrayList.size()]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new String[0];
        }
    }

    public static final String[] getWriterMIMETypes() {
        try {
            IIORegistry iIORegistry = ImageIO.getRegistry();
            Class clazz = class$javax$imageio$spi$ImageWriterSpi;
            if (clazz == null) {
                clazz = class$javax$imageio$spi$ImageWriterSpi = ImageIO.class("[Ljavax.imageio.spi.ImageWriterSpi;", false);
            }
            Iterator iterator = iIORegistry.getServiceProviders(clazz, true);
            ArrayList arrayList = new ArrayList();
            while (iterator.hasNext()) {
                ImageWriterSpi imageWriterSpi = (ImageWriterSpi)iterator.next();
                String[] stringArray = imageWriterSpi.getMIMETypes();
                int n = stringArray.length - 1;
                while (n >= 0) {
                    arrayList.add(stringArray[n]);
                    --n;
                }
            }
            return (String[])arrayList.toArray(new String[arrayList.size()]);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return new String[0];
        }
    }

    public static final void scanForPlugins() {
        IIORegistry.getDefaultInstance().registerApplicationClasspathSpis();
    }

    public static final void setCacheDirectory(File file) {
        if (file != null) {
            if (!file.isDirectory()) {
                throw new IllegalArgumentException("cacheDirectory must be a directory");
            }
            file.canWrite();
        }
        cacheDirectory = file;
    }

    public static final void setUseCache(boolean bl) {
        useCache = bl;
    }

    public static final boolean write(RenderedImage renderedImage, String string, File file) throws IOException {
        if (renderedImage == null || string == null || file == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.write(renderedImage, string, new FileOutputStream(file));
    }

    public static final boolean write(RenderedImage renderedImage, String string, OutputStream outputStream) throws IOException {
        if (renderedImage == null || string == null || outputStream == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.write(renderedImage, string, new MemoryCacheImageOutputStream(outputStream));
    }

    public static final boolean write(RenderedImage renderedImage, String string, ImageOutputStream imageOutputStream) throws IOException {
        if (renderedImage == null || string == null || imageOutputStream == null) {
            throw new IllegalArgumentException("null argument");
        }
        Iterator iterator = ImageIO.getImageWritersByFormatName(string);
        IIOImage iIOImage = new IIOImage(renderedImage, null, null);
        while (iterator.hasNext()) {
            ImageWriter imageWriter = (ImageWriter)iterator.next();
            try {
                imageWriter.setOutput(imageOutputStream);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
            imageWriter.write(null, iIOImage, null);
            imageOutputStream.close();
            return true;
        }
        return false;
    }

    public static final BufferedImage read(ImageInputStream imageInputStream) throws IOException {
        if (imageInputStream == null) {
            throw new IllegalArgumentException("null argument");
        }
        IIORegistry iIORegistry = ImageIO.getRegistry();
        Class clazz = class$javax$imageio$spi$ImageReaderSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageReaderSpi = ImageIO.class("[Ljavax.imageio.spi.ImageReaderSpi;", false);
        }
        Iterator iterator = iIORegistry.getServiceProviders(clazz, true);
        while (iterator.hasNext()) {
            ImageReaderSpi imageReaderSpi = (ImageReaderSpi)iterator.next();
            if (!imageReaderSpi.canDecodeInput(imageInputStream)) continue;
            ImageReader imageReader = imageReaderSpi.createReaderInstance();
            imageReader.setInput(imageInputStream);
            return imageReader.read(0, null);
        }
        return null;
    }

    public static final BufferedImage read(URL uRL) throws IOException {
        if (uRL == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.read(uRL.openStream());
    }

    public static final BufferedImage read(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.read(new MemoryCacheImageInputStream(inputStream));
    }

    public static final BufferedImage read(File file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException("null argument");
        }
        return ImageIO.read(new FileInputStream(file));
    }

    public static final ImageInputStream createImageInputStream(Object object) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException("null argument");
        }
        IIORegistry iIORegistry = ImageIO.getRegistry();
        Class clazz = class$javax$imageio$spi$ImageInputStreamSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageInputStreamSpi = ImageIO.class("[Ljavax.imageio.spi.ImageInputStreamSpi;", false);
        }
        Iterator iterator = iIORegistry.getServiceProviders(clazz, true);
        ImageInputStreamSpi imageInputStreamSpi = null;
        while (iterator.hasNext()) {
            ImageInputStreamSpi imageInputStreamSpi2 = (ImageInputStreamSpi)iterator.next();
            if (!object.getClass().equals(imageInputStreamSpi2.getInputClass())) continue;
            imageInputStreamSpi = imageInputStreamSpi2;
            break;
        }
        return imageInputStreamSpi == null ? null : imageInputStreamSpi.createInputStreamInstance(object, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
    }

    public static final ImageOutputStream createImageOutputStream(Object object) throws IOException {
        if (object == null) {
            throw new IllegalArgumentException("null argument");
        }
        IIORegistry iIORegistry = ImageIO.getRegistry();
        Class clazz = class$javax$imageio$spi$ImageOutputStreamSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageOutputStreamSpi = ImageIO.class("[Ljavax.imageio.spi.ImageOutputStreamSpi;", false);
        }
        Iterator iterator = iIORegistry.getServiceProviders(clazz, true);
        ImageOutputStreamSpi imageOutputStreamSpi = null;
        while (iterator.hasNext()) {
            ImageOutputStreamSpi imageOutputStreamSpi2 = (ImageOutputStreamSpi)iterator.next();
            if (!object.getClass().equals(imageOutputStreamSpi2.getOutputClass())) continue;
            imageOutputStreamSpi = imageOutputStreamSpi2;
            break;
        }
        return imageOutputStreamSpi == null ? null : imageOutputStreamSpi.createOutputStreamInstance(object, ImageIO.getUseCache(), ImageIO.getCacheDirectory());
    }

    public static final ImageReader getImageReader(ImageWriter imageWriter) {
        if (imageWriter == null) {
            throw new IllegalArgumentException("null argument");
        }
        ImageWriterSpi imageWriterSpi = (ImageWriterSpi)ImageIO.getRegistry().getServiceProviderByClass(imageWriter.getClass());
        String[] stringArray = imageWriterSpi.getImageReaderSpiNames();
        ImageReader imageReader = null;
        if (stringArray != null) {
            try {
                Class clazz = Class.forName(stringArray[0]);
                imageReader = (ImageReader)clazz.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return imageReader;
    }

    public static final Iterator getImageReaders(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("null argument");
        }
        IIORegistry iIORegistry = ImageIO.getRegistry();
        Class clazz = class$javax$imageio$spi$ImageReaderSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageReaderSpi = ImageIO.class("[Ljavax.imageio.spi.ImageReaderSpi;", false);
        }
        return iIORegistry.getServiceProviders(clazz, new ReaderObjectFilter(object), true);
    }

    public static final Iterator getImageWriters(ImageTypeSpecifier imageTypeSpecifier, String string) {
        if (imageTypeSpecifier == null || string == null) {
            throw new IllegalArgumentException("null argument");
        }
        IIORegistry iIORegistry = ImageIO.getRegistry();
        Class clazz = class$javax$imageio$spi$ImageWriterSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageWriterSpi = ImageIO.class("[Ljavax.imageio.spi.ImageWriterSpi;", false);
        }
        return iIORegistry.getServiceProviders(clazz, new WriterObjectFilter(imageTypeSpecifier, string), true);
    }

    public static final ImageWriter getImageWriter(ImageReader imageReader) {
        if (imageReader == null) {
            throw new IllegalArgumentException("null argument");
        }
        ImageReaderSpi imageReaderSpi = (ImageReaderSpi)ImageIO.getRegistry().getServiceProviderByClass(imageReader.getClass());
        String[] stringArray = imageReaderSpi.getImageWriterSpiNames();
        ImageWriter imageWriter = null;
        if (stringArray != null) {
            try {
                Class clazz = Class.forName(stringArray[0]);
                imageWriter = (ImageWriter)clazz.newInstance();
            }
            catch (Exception exception) {
                return null;
            }
        }
        return imageWriter;
    }

    public static final Iterator getImageTranscoders(ImageReader imageReader, ImageWriter imageWriter) {
        if (imageReader == null || imageWriter == null) {
            throw new IllegalArgumentException("null argument");
        }
        IIORegistry iIORegistry = ImageIO.getRegistry();
        Class clazz = class$javax$imageio$spi$ImageTranscoderSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageTranscoderSpi = ImageIO.class("[Ljavax.imageio.spi.ImageTranscoderSpi;", false);
        }
        return iIORegistry.getServiceProviders(clazz, new TranscoderFilter(imageReader, imageWriter), true);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private ImageIO() {
    }

    static {
        useCache = true;
    }

    private static final class ImageReaderIterator
    implements Iterator {
        Iterator it;
        Object readerExtension;

        public final boolean hasNext() {
            return this.it.hasNext();
        }

        public final Object next() {
            try {
                return ((ImageReaderSpi)this.it.next()).createReaderInstance(this.readerExtension);
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public ImageReaderIterator(Iterator iterator, Object object) {
            this.it = iterator;
            this.readerExtension = object;
        }
    }

    private static final class ImageWriterIterator
    implements Iterator {
        Iterator it;
        Object writerExtension;

        public final boolean hasNext() {
            return this.it.hasNext();
        }

        public final Object next() {
            try {
                return ((ImageWriterSpi)this.it.next()).createWriterInstance(this.writerExtension);
            }
            catch (IOException iOException) {
                return null;
            }
        }

        public final void remove() {
            throw new UnsupportedOperationException();
        }

        public ImageWriterIterator(Iterator iterator, Object object) {
            this.it = iterator;
            this.writerExtension = object;
        }
    }

    private static final class ReaderFormatFilter
    implements ServiceRegistry.Filter {
        private String formatName;

        public final boolean filter(Object object) {
            if (object instanceof ImageReaderSpi) {
                ImageReaderSpi imageReaderSpi = (ImageReaderSpi)object;
                String[] stringArray = imageReaderSpi.getFormatNames();
                int n = stringArray.length - 1;
                while (n >= 0) {
                    if (this.formatName.equals(stringArray[n])) {
                        return true;
                    }
                    --n;
                }
            }
            return false;
        }

        public ReaderFormatFilter(String string) {
            this.formatName = string;
        }
    }

    private static final class ReaderMIMETypeFilter
    implements ServiceRegistry.Filter {
        private String MIMEType;

        public final boolean filter(Object object) {
            if (object instanceof ImageReaderSpi) {
                ImageReaderSpi imageReaderSpi = (ImageReaderSpi)object;
                String[] stringArray = imageReaderSpi.getMIMETypes();
                int n = stringArray.length - 1;
                while (n >= 0) {
                    if (this.MIMEType.equals(stringArray[n])) {
                        return true;
                    }
                    --n;
                }
            }
            return false;
        }

        public ReaderMIMETypeFilter(String string) {
            this.MIMEType = string;
        }
    }

    private static final class ReaderSuffixFilter
    implements ServiceRegistry.Filter {
        private String fileSuffix;

        public final boolean filter(Object object) {
            if (object instanceof ImageReaderSpi) {
                ImageReaderSpi imageReaderSpi = (ImageReaderSpi)object;
                String[] stringArray = imageReaderSpi.getFileSuffixes();
                int n = stringArray.length - 1;
                while (n >= 0) {
                    if (this.fileSuffix.equals(stringArray[n])) {
                        return true;
                    }
                    --n;
                }
            }
            return false;
        }

        public ReaderSuffixFilter(String string) {
            this.fileSuffix = string;
        }
    }

    private static final class WriterFormatFilter
    implements ServiceRegistry.Filter {
        private String formatName;

        public final boolean filter(Object object) {
            if (object instanceof ImageWriterSpi) {
                ImageWriterSpi imageWriterSpi = (ImageWriterSpi)object;
                String[] stringArray = imageWriterSpi.getFormatNames();
                int n = stringArray.length - 1;
                while (n >= 0) {
                    if (this.formatName.equals(stringArray[n])) {
                        return true;
                    }
                    --n;
                }
            }
            return false;
        }

        public WriterFormatFilter(String string) {
            this.formatName = string;
        }
    }

    private static final class WriterMIMETypeFilter
    implements ServiceRegistry.Filter {
        private String MIMEType;

        public final boolean filter(Object object) {
            if (object instanceof ImageWriterSpi) {
                ImageWriterSpi imageWriterSpi = (ImageWriterSpi)object;
                String[] stringArray = imageWriterSpi.getMIMETypes();
                int n = stringArray.length - 1;
                while (n >= 0) {
                    if (this.MIMEType.equals(stringArray[n])) {
                        return true;
                    }
                    --n;
                }
            }
            return false;
        }

        public WriterMIMETypeFilter(String string) {
            this.MIMEType = string;
        }
    }

    private static final class WriterSuffixFilter
    implements ServiceRegistry.Filter {
        private String fileSuffix;

        public final boolean filter(Object object) {
            if (object instanceof ImageWriterSpi) {
                ImageWriterSpi imageWriterSpi = (ImageWriterSpi)object;
                String[] stringArray = imageWriterSpi.getFileSuffixes();
                int n = stringArray.length - 1;
                while (n >= 0) {
                    if (this.fileSuffix.equals(stringArray[n])) {
                        return true;
                    }
                    --n;
                }
            }
            return false;
        }

        public WriterSuffixFilter(String string) {
            this.fileSuffix = string;
        }
    }

    private static final class ReaderObjectFilter
    implements ServiceRegistry.Filter {
        private Object object;

        public final boolean filter(Object object) {
            if (object instanceof ImageReaderSpi) {
                ImageReaderSpi imageReaderSpi = (ImageReaderSpi)object;
                try {
                    if (imageReaderSpi.canDecodeInput(this.object)) {
                        return true;
                    }
                }
                catch (IOException iOException) {}
            }
            return false;
        }

        public ReaderObjectFilter(Object object) {
            this.object = object;
        }
    }

    private static final class WriterObjectFilter
    implements ServiceRegistry.Filter {
        private ImageTypeSpecifier type;
        private String formatName;

        public final boolean filter(Object object) {
            ImageWriterSpi imageWriterSpi;
            if (object instanceof ImageWriterSpi && (imageWriterSpi = (ImageWriterSpi)object).canEncodeImage(this.type)) {
                String[] stringArray = imageWriterSpi.getFormatNames();
                int n = stringArray.length - 1;
                while (n >= 0) {
                    if (this.formatName.equals(stringArray[n])) {
                        return true;
                    }
                    --n;
                }
            }
            return false;
        }

        public WriterObjectFilter(ImageTypeSpecifier imageTypeSpecifier, String string) {
            this.type = imageTypeSpecifier;
            this.formatName = string;
        }
    }

    private static final class TranscoderFilter
    implements ServiceRegistry.Filter {
        private ImageReader reader;
        private ImageWriter writer;

        public final boolean filter(Object object) {
            ImageTranscoderSpi imageTranscoderSpi;
            return object instanceof ImageTranscoderSpi && (imageTranscoderSpi = (ImageTranscoderSpi)object).getReaderServiceProviderName().equals(this.reader.getOriginatingProvider().getClass().getName()) && imageTranscoderSpi.getWriterServiceProviderName().equals(this.writer.getOriginatingProvider().getClass().getName());
        }

        public TranscoderFilter(ImageReader imageReader, ImageWriter imageWriter) {
            this.reader = imageReader;
            this.writer = imageWriter;
        }
    }
}

