/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import gnu.classpath.VMStackWalker;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class ResourceBundle {
    private static Map bundleCache;
    private static Locale lastDefaultLocale;
    private static final Locale emptyLocale;
    private static BundleKey lookupKey;
    private static Object nullEntry;
    protected ResourceBundle parent;
    private Locale locale;
    static /* synthetic */ Class class$java$util$ResourceBundle;

    public final String getString(String string) {
        return (String)this.getObject(string);
    }

    public final String[] getStringArray(String string) {
        return (String[])this.getObject(string);
    }

    public final Object getObject(String string) {
        Object object = this;
        while (object != null) {
            Object object2 = ((ResourceBundle)object).handleGetObject(string);
            if (object2 != null) {
                return object2;
            }
            object = ((ResourceBundle)object).parent;
        }
        object = this.getClass().getName();
        throw new MissingResourceException("Key '" + string + "'not found in Bundle: " + (String)object, (String)object, string);
    }

    public Locale getLocale() {
        return this.locale;
    }

    protected void setParent(ResourceBundle resourceBundle) {
        this.parent = resourceBundle;
    }

    public static ResourceBundle getBundle(String string) {
        ClassLoader classLoader = VMStackWalker.getCallingClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return ResourceBundle.getBundle(string, Locale.getDefault(), classLoader);
    }

    public static ResourceBundle getBundle(String string, Locale locale) {
        ClassLoader classLoader = VMStackWalker.getCallingClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return ResourceBundle.getBundle(string, locale, classLoader);
    }

    public static synchronized ResourceBundle getBundle(String string, Locale locale, ClassLoader classLoader) {
        Locale locale2 = Locale.getDefault();
        if (locale2 != lastDefaultLocale) {
            bundleCache = new HashMap();
            lastDefaultLocale = locale2;
        }
        lookupKey.set(string, locale, classLoader);
        Object object = bundleCache.get(lookupKey);
        Object var5_5 = null;
        if (object instanceof ResourceBundle) {
            return (ResourceBundle)object;
        }
        if (object != nullEntry) {
            boolean bl = locale.equals(locale2);
            ResourceBundle resourceBundle = ResourceBundle.tryBundle(string, locale, classLoader, bl);
            if (resourceBundle == null && !locale.equals(locale2)) {
                resourceBundle = ResourceBundle.tryBundle(string, locale2, classLoader, true);
            }
            BundleKey bundleKey = new BundleKey(string, locale, classLoader);
            if (resourceBundle == null) {
                bundleCache.put(bundleKey, nullEntry);
            } else {
                bundleCache.put(bundleKey, resourceBundle);
                return resourceBundle;
            }
        }
        throw new MissingResourceException("Bundle " + string + " not found for locale " + locale + " by classloader " + classLoader, string, "");
    }

    protected abstract Object handleGetObject(String var1);

    public abstract Enumeration getKeys();

    private static final ResourceBundle tryBundle(String string, ClassLoader classLoader) {
        Object object;
        ResourceBundle resourceBundle = null;
        try {
            object = classLoader == null ? Class.forName(string) : classLoader.loadClass(string);
            Class clazz = class$java$util$ResourceBundle;
            if (clazz == null) {
                clazz = class$java$util$ResourceBundle = ResourceBundle.class("[Ljava.util.ResourceBundle;", false);
            }
            if (clazz.isAssignableFrom((Class)object)) {
                resourceBundle = (ResourceBundle)((Class)object).newInstance();
            }
        }
        catch (Exception exception) {}
        if (resourceBundle == null) {
            try {
                String string2 = string.replace('.', '/') + ".properties";
                object = classLoader == null ? ClassLoader.getSystemResourceAsStream(string2) : classLoader.getResourceAsStream(string2);
                if (object != null) {
                    resourceBundle = new PropertyResourceBundle((InputStream)object);
                }
            }
            catch (IOException iOException) {
                MissingResourceException missingResourceException = new MissingResourceException("Failed to load bundle: " + string, string, "");
                missingResourceException.initCause(iOException);
                throw missingResourceException;
            }
        }
        return resourceBundle;
    }

    private static final ResourceBundle tryBundle(String string, Locale locale, ClassLoader classLoader, boolean bl) {
        String string2 = locale.getLanguage();
        String string3 = locale.getCountry();
        String string4 = locale.getVariant();
        int n = string.length();
        StringBuffer stringBuffer = new StringBuffer(n + string4.length() + 7);
        stringBuffer.append(string);
        if (string2.length() > 0) {
            stringBuffer.append('_');
            stringBuffer.append(string2);
            if (string3.length() > 0) {
                stringBuffer.append('_');
                stringBuffer.append(string3);
                if (string4.length() > 0) {
                    stringBuffer.append('_');
                    stringBuffer.append(string4);
                }
            }
        }
        String string5 = stringBuffer.toString();
        ResourceBundle resourceBundle = null;
        ResourceBundle resourceBundle2 = null;
        while (true) {
            int n2;
            ResourceBundle resourceBundle3;
            if ((resourceBundle3 = ResourceBundle.tryBundle(string5, classLoader)) != null) {
                if (resourceBundle == null) {
                    resourceBundle = resourceBundle3;
                }
                if (resourceBundle2 != null) {
                    resourceBundle2.parent = resourceBundle3;
                }
                resourceBundle3.locale = locale;
                resourceBundle2 = resourceBundle3;
            }
            if ((n2 = string5.lastIndexOf(95)) <= n && (n2 != n || resourceBundle == null && !bl)) break;
            string5 = string5.substring(0, n2);
        }
        return resourceBundle;
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static {
        emptyLocale = new Locale("");
        lookupKey = new BundleKey();
        nullEntry = new Object();
    }

    private static class BundleKey {
        String baseName;
        Locale locale;
        ClassLoader classLoader;
        int hashcode;

        void set(String string, Locale locale, ClassLoader classLoader) {
            this.baseName = string;
            this.locale = locale;
            this.classLoader = classLoader;
            this.hashcode = this.baseName.hashCode() ^ this.locale.hashCode() ^ this.classLoader.hashCode();
        }

        public int hashCode() {
            return this.hashcode;
        }

        public boolean equals(Object object) {
            if (!(object instanceof BundleKey)) {
                return false;
            }
            BundleKey bundleKey = (BundleKey)object;
            boolean bl = false;
            if (this.hashcode == bundleKey.hashcode && this.baseName.equals(bundleKey.baseName) && this.locale.equals(bundleKey.locale) && this.classLoader.equals(bundleKey.classLoader)) {
                bl = true;
            }
            return bl;
        }

        BundleKey() {
        }

        BundleKey(String string, Locale locale, ClassLoader classLoader) {
            this.set(string, locale, classLoader);
        }
    }
}

