/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

public abstract class AbstractList
extends AbstractCollection
implements List {
    protected transient int modCount;

    public abstract Object get(int var1);

    public void add(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public boolean add(Object object) {
        this.add(this.size(), object);
        return true;
    }

    public boolean addAll(int n, Collection collection) {
        int n2;
        Iterator iterator = collection.iterator();
        int n3 = n2 = collection.size();
        while (n3 > 0) {
            this.add(n++, iterator.next());
            --n3;
        }
        boolean bl = false;
        if (n2 > 0) {
            bl = true;
        }
        return bl;
    }

    public void clear() {
        this.removeRange(0, this.size());
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        int n = this.size();
        if (n != ((List)object).size()) {
            return false;
        }
        Iterator iterator = this.iterator();
        Iterator iterator2 = ((List)object).iterator();
        while (--n >= 0) {
            if (AbstractList.equals(iterator.next(), iterator2.next())) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int n = 1;
        Iterator iterator = this.iterator();
        int n2 = this.size();
        while (--n2 >= 0) {
            n = 31 * n + AbstractList.hashCode(iterator.next());
        }
        return n;
    }

    public int indexOf(Object object) {
        ListIterator listIterator = this.listIterator();
        int n = this.size();
        int n2 = 0;
        while (n2 < n) {
            if (AbstractList.equals(object, listIterator.next())) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public Iterator iterator() {
        return new Iterator(){
            private int pos;
            private int size;
            private int last;
            private int knownMod;

            private final void checkMod() {
                if (this.knownMod != AbstractList.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            public final boolean hasNext() {
                this.checkMod();
                boolean bl = false;
                if (this.pos < this.size) {
                    bl = true;
                }
                return bl;
            }

            public final Object next() {
                this.checkMod();
                if (this.pos == this.size) {
                    throw new NoSuchElementException();
                }
                this.last = this.pos;
                return AbstractList.this.get(this.pos++);
            }

            public final void remove() {
                this.checkMod();
                if (this.last < 0) {
                    throw new IllegalStateException();
                }
                AbstractList.this.remove(this.last);
                --this.pos;
                --this.size;
                this.last = -1;
                this.knownMod = AbstractList.this.modCount;
            }

            private final /* synthetic */ void this() {
                this.pos = 0;
                this.size = AbstractList.this.size();
                this.last = -1;
                this.knownMod = AbstractList.this.modCount;
            }
            {
                this.this();
            }
        };
    }

    public int lastIndexOf(Object object) {
        int n = this.size();
        ListIterator listIterator = this.listIterator(n);
        while (--n >= 0) {
            if (!AbstractList.equals(object, listIterator.previous())) continue;
            return n;
        }
        return -1;
    }

    public ListIterator listIterator() {
        return this.listIterator(0);
    }

    public ListIterator listIterator(final int n) {
        if (n < 0 || n > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size());
        }
        return new ListIterator(){
            private int knownMod;
            private int position;
            private int lastReturned;
            private int size;

            private final void checkMod() {
                if (this.knownMod != AbstractList.this.modCount) {
                    throw new ConcurrentModificationException();
                }
            }

            public final boolean hasNext() {
                this.checkMod();
                boolean bl = false;
                if (this.position < this.size) {
                    bl = true;
                }
                return bl;
            }

            public final boolean hasPrevious() {
                this.checkMod();
                boolean bl = false;
                if (this.position > 0) {
                    bl = true;
                }
                return bl;
            }

            public final Object next() {
                this.checkMod();
                if (this.position == this.size) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = this.position;
                return AbstractList.this.get(this.position++);
            }

            public final Object previous() {
                this.checkMod();
                if (this.position == 0) {
                    throw new NoSuchElementException();
                }
                this.lastReturned = --this.position;
                return AbstractList.this.get(this.lastReturned);
            }

            public final int nextIndex() {
                this.checkMod();
                return this.position;
            }

            public final int previousIndex() {
                this.checkMod();
                return this.position - 1;
            }

            public final void remove() {
                this.checkMod();
                if (this.lastReturned < 0) {
                    throw new IllegalStateException();
                }
                AbstractList.this.remove(this.lastReturned);
                --this.size;
                this.position = this.lastReturned;
                this.lastReturned = -1;
                this.knownMod = AbstractList.this.modCount;
            }

            public final void set(Object object) {
                this.checkMod();
                if (this.lastReturned < 0) {
                    throw new IllegalStateException();
                }
                AbstractList.this.set(this.lastReturned, object);
            }

            public final void add(Object object) {
                this.checkMod();
                AbstractList.this.add(this.position++, object);
                ++this.size;
                this.lastReturned = -1;
                this.knownMod = AbstractList.this.modCount;
            }

            private final /* synthetic */ void this() {
                this.knownMod = AbstractList.this.modCount;
                this.position = n;
                this.lastReturned = -1;
                this.size = AbstractList.this.size();
            }
            {
                this.this();
            }
        };
    }

    public Object remove(int n) {
        throw new UnsupportedOperationException();
    }

    protected void removeRange(int n, int n2) {
        ListIterator listIterator = this.listIterator(n);
        int n3 = n;
        while (n3 < n2) {
            listIterator.next();
            listIterator.remove();
            ++n3;
        }
    }

    public Object set(int n, Object object) {
        throw new UnsupportedOperationException();
    }

    public List subList(int n, int n2) {
        if (n > n2) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        if (n < 0 || n2 > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        if (this instanceof RandomAccess) {
            return new RandomAccessSubList(this, n, n2);
        }
        return new SubList(this, n, n2);
    }

    protected AbstractList() {
    }

    private static final class RandomAccessSubList
    extends SubList
    implements RandomAccess {
        RandomAccessSubList(AbstractList abstractList, int n, int n2) {
            super(abstractList, n, n2);
        }
    }

    private static class SubList
    extends AbstractList {
        final AbstractList backingList;
        final int offset;
        int size;

        void checkMod() {
            if (this.modCount != this.backingList.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        private final void checkBoundsInclusive(int n) {
            if (n < 0 || n > this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
            }
        }

        private final void checkBoundsExclusive(int n) {
            if (n < 0 || n >= this.size) {
                throw new IndexOutOfBoundsException("Index: " + n + ", Size:" + this.size);
            }
        }

        public int size() {
            this.checkMod();
            return this.size;
        }

        public Object set(int n, Object object) {
            this.checkMod();
            this.checkBoundsExclusive(n);
            return this.backingList.set(n + this.offset, object);
        }

        public Object get(int n) {
            this.checkMod();
            this.checkBoundsExclusive(n);
            return this.backingList.get(n + this.offset);
        }

        public void add(int n, Object object) {
            this.checkMod();
            this.checkBoundsInclusive(n);
            this.backingList.add(n + this.offset, object);
            ++this.size;
            this.modCount = this.backingList.modCount;
        }

        public Object remove(int n) {
            this.checkMod();
            this.checkBoundsExclusive(n);
            Object object = this.backingList.remove(n + this.offset);
            --this.size;
            this.modCount = this.backingList.modCount;
            return object;
        }

        protected void removeRange(int n, int n2) {
            this.checkMod();
            this.backingList.removeRange(this.offset + n, this.offset + n2);
            this.size -= n2 - n;
            this.modCount = this.backingList.modCount;
        }

        public boolean addAll(int n, Collection collection) {
            this.checkMod();
            this.checkBoundsInclusive(n);
            int n2 = collection.size();
            boolean bl = this.backingList.addAll(this.offset + n, collection);
            this.size += n2;
            this.modCount = this.backingList.modCount;
            return bl;
        }

        public boolean addAll(Collection collection) {
            return this.addAll(this.size, collection);
        }

        public Iterator iterator() {
            return this.listIterator();
        }

        public ListIterator listIterator(final int n) {
            this.checkMod();
            this.checkBoundsInclusive(n);
            return new ListIterator(){
                private final ListIterator i;
                private int position;

                public final boolean hasNext() {
                    SubList.this.checkMod();
                    boolean bl = false;
                    if (this.position < SubList.this.size) {
                        bl = true;
                    }
                    return bl;
                }

                public final boolean hasPrevious() {
                    SubList.this.checkMod();
                    boolean bl = false;
                    if (this.position > 0) {
                        bl = true;
                    }
                    return bl;
                }

                public final Object next() {
                    if (this.position == SubList.this.size) {
                        throw new NoSuchElementException();
                    }
                    ++this.position;
                    return this.i.next();
                }

                public final Object previous() {
                    if (this.position == 0) {
                        throw new NoSuchElementException();
                    }
                    --this.position;
                    return this.i.previous();
                }

                public final int nextIndex() {
                    return this.i.nextIndex() - SubList.this.offset;
                }

                public final int previousIndex() {
                    return this.i.previousIndex() - SubList.this.offset;
                }

                public final void remove() {
                    this.i.remove();
                    --SubList.this.size;
                    this.position = this.nextIndex();
                    SubList.this.modCount = SubList.this.backingList.modCount;
                }

                public final void set(Object object) {
                    this.i.set(object);
                }

                public final void add(Object object) {
                    this.i.add(object);
                    ++SubList.this.size;
                    ++this.position;
                    SubList.this.modCount = SubList.this.backingList.modCount;
                }

                private final /* synthetic */ void this() {
                    this.i = SubList.this.backingList.listIterator(n + SubList.this.offset);
                    this.position = n;
                }
                {
                    this.this();
                }
            };
        }

        SubList(AbstractList abstractList, int n, int n2) {
            this.backingList = abstractList;
            this.modCount = abstractList.modCount;
            this.offset = n;
            this.size = n2 - n;
        }
    }
}

