/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import gnu.java.security.Engine;
import java.lang.reflect.InvocationTargetException;
import java.security.DigestException;
import java.security.DummyMessageDigest;
import java.security.MessageDigestSpi;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.Security;

public abstract class MessageDigest
extends MessageDigestSpi {
    private static final String MESSAGE_DIGEST = "MessageDigest";
    private String algorithm;
    Provider provider;
    private byte[] lastDigest;

    public static MessageDigest getInstance(String string) throws NoSuchAlgorithmException {
        Provider[] providerArray = Security.getProviders();
        int n = 0;
        while (n < providerArray.length) {
            try {
                return MessageDigest.getInstance(string, providerArray[n]);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ++n;
            }
        }
        throw new NoSuchAlgorithmException(string);
    }

    public static MessageDigest getInstance(String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException {
        if (string2 != null) {
            string2 = string2.trim();
        }
        if (string2 == null || string2.length() == 0) {
            throw new IllegalArgumentException("Illegal provider");
        }
        Provider provider = Security.getProvider(string2);
        if (provider == null) {
            throw new NoSuchProviderException(string2);
        }
        return MessageDigest.getInstance(string, provider);
    }

    public static MessageDigest getInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        if (provider == null) {
            throw new IllegalArgumentException("Illegal provider");
        }
        MessageDigest messageDigest = null;
        Object object = null;
        try {
            object = Engine.getInstance(MESSAGE_DIGEST, string, provider);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new NoSuchAlgorithmException(string);
        }
        if (object instanceof MessageDigestSpi) {
            messageDigest = new DummyMessageDigest((MessageDigestSpi)object, string);
        } else if (object instanceof MessageDigest) {
            messageDigest = (MessageDigest)object;
            messageDigest.algorithm = string;
        } else {
            throw new NoSuchAlgorithmException(string);
        }
        messageDigest.provider = provider;
        return messageDigest;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public void update(byte by) {
        this.engineUpdate(by);
    }

    public void update(byte[] byArray, int n, int n2) {
        this.engineUpdate(byArray, n, n2);
    }

    public void update(byte[] byArray) {
        this.engineUpdate(byArray, 0, byArray.length);
    }

    public byte[] digest() {
        this.lastDigest = this.engineDigest();
        return this.lastDigest;
    }

    public int digest(byte[] byArray, int n, int n2) throws DigestException {
        return this.engineDigest(byArray, n, n2);
    }

    public byte[] digest(byte[] byArray) {
        this.update(byArray);
        return this.digest();
    }

    public String toString() {
        return this.getClass().getName() + " Message Digest <" + this.digestToString() + '>';
    }

    public static boolean isEqual(byte[] byArray, byte[] byArray2) {
        if (byArray.length != byArray2.length) {
            return false;
        }
        int n = byArray.length - 1;
        while (n >= 0) {
            if (byArray[n] != byArray2[n]) {
                return false;
            }
            --n;
        }
        return true;
    }

    public void reset() {
        this.engineReset();
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public final int getDigestLength() {
        return this.engineGetDigestLength();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    private final String digestToString() {
        byte[] byArray = this.lastDigest;
        if (byArray == null) {
            return "incomplete";
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray[n2];
            byte by2 = (byte)((by & 0xFF) >>> 4);
            byte by3 = (byte)(by & 0xF);
            stringBuffer.append(by2 > 9 ? 87 + by2 : 48 + by2);
            stringBuffer.append(by3 > 9 ? 87 + by3 : 48 + by3);
            ++n2;
        }
        return stringBuffer.toString();
    }

    protected MessageDigest(String string) {
        this.algorithm = string;
        this.provider = null;
    }
}

