/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import gnu.java.util.WeakIdentityHashMap;
import java.util.Map;

public class Thread
implements Runnable {
    public static final int MIN_PRIORITY = 1;
    public static final int NORM_PRIORITY = 5;
    public static final int MAX_PRIORITY = 10;
    private static int numAnonymousThreadsCreated;
    volatile VMThread vmThread;
    volatile ThreadGroup group;
    final Runnable runnable;
    volatile String name;
    volatile boolean daemon;
    volatile int priority;
    private long stacksize;
    Throwable stillborn;
    private ClassLoader contextClassLoader;
    WeakIdentityHashMap locals;

    public static int activeCount() {
        return Thread.currentThread().group.activeCount();
    }

    public final void checkAccess() {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkAccess(this);
        }
    }

    public int countStackFrames() {
        VMThread vMThread = this.vmThread;
        if (vMThread == null || this.group == null) {
            throw new IllegalThreadStateException();
        }
        return vMThread.countStackFrames();
    }

    public static Thread currentThread() {
        return VMThread.currentThread();
    }

    public void destroy() {
        throw new NoSuchMethodError();
    }

    public static void dumpStack() {
        new Throwable().printStackTrace();
    }

    public static int enumerate(Thread[] threadArray) {
        return Thread.currentThread().group.enumerate(threadArray);
    }

    public final String getName() {
        VMThread vMThread = this.vmThread;
        return vMThread == null ? this.name : vMThread.getName();
    }

    public final synchronized int getPriority() {
        VMThread vMThread = this.vmThread;
        return vMThread == null ? this.priority : vMThread.getPriority();
    }

    public final ThreadGroup getThreadGroup() {
        return this.group;
    }

    public static boolean holdsLock(Object object) {
        return VMThread.holdsLock(object);
    }

    public synchronized void interrupt() {
        this.checkAccess();
        VMThread vMThread = this.vmThread;
        if (vMThread != null) {
            vMThread.interrupt();
        }
    }

    public static boolean interrupted() {
        return VMThread.interrupted();
    }

    public boolean isInterrupted() {
        VMThread vMThread = this.vmThread;
        boolean bl = false;
        if (vMThread != null && vMThread.isInterrupted()) {
            bl = true;
        }
        return bl;
    }

    public final boolean isAlive() {
        boolean bl = false;
        if (this.vmThread != null && this.group != null) {
            bl = true;
        }
        return bl;
    }

    public final boolean isDaemon() {
        VMThread vMThread = this.vmThread;
        return vMThread == null ? this.daemon : vMThread.isDaemon();
    }

    public final void join() throws InterruptedException {
        this.join(0L, 0);
    }

    public final void join(long l) throws InterruptedException {
        this.join(l, 0);
    }

    public final void join(long l, int n) throws InterruptedException {
        if (l < 0L || n < 0 || n > 999999) {
            throw new IllegalArgumentException();
        }
        VMThread vMThread = this.vmThread;
        if (vMThread != null) {
            vMThread.join(l, n);
        }
    }

    public final synchronized void resume() {
        this.checkAccess();
        VMThread vMThread = this.vmThread;
        if (vMThread != null) {
            vMThread.resume();
        }
    }

    public void run() {
        if (this.runnable != null) {
            this.runnable.run();
        }
    }

    public final synchronized void setDaemon(boolean bl) {
        if (this.vmThread != null) {
            throw new IllegalThreadStateException();
        }
        this.checkAccess();
        this.daemon = bl;
    }

    public synchronized ClassLoader getContextClassLoader() {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("getClassLoader"));
        }
        return this.contextClassLoader;
    }

    public synchronized void setContextClassLoader(ClassLoader classLoader) {
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        this.contextClassLoader = classLoader;
    }

    public final synchronized void setName(String string) {
        this.checkAccess();
        if (string == null) {
            throw new NullPointerException();
        }
        VMThread vMThread = this.vmThread;
        if (vMThread != null) {
            vMThread.setName(string);
        } else {
            this.name = string;
        }
    }

    public static void yield() {
        VMThread.yield();
    }

    public static void sleep(long l) throws InterruptedException {
        Thread.sleep(l, 0);
    }

    public static void sleep(long l, int n) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("Negative milliseconds: " + l);
        }
        if (n < 0 || n > 999999) {
            throw new IllegalArgumentException("Nanoseconds ouf of range: " + n);
        }
        VMThread.sleep(l, n);
    }

    public synchronized void start() {
        if (this.vmThread != null || this.group == null) {
            throw new IllegalThreadStateException();
        }
        VMThread.create(this, this.stacksize);
    }

    public final void stop() {
        this.stop(new ThreadDeath());
    }

    public final synchronized void stop(Throwable throwable) {
        VMThread vMThread;
        if (throwable == null) {
            throw new NullPointerException();
        }
        SecurityManager securityManager = SecurityManager.current;
        if (securityManager != null) {
            securityManager.checkAccess(this);
            if (this != Thread.currentThread() || !(throwable instanceof ThreadDeath)) {
                securityManager.checkPermission(new RuntimePermission("stopThread"));
            }
        }
        if ((vMThread = this.vmThread) != null) {
            vMThread.stop(throwable);
        } else {
            this.stillborn = throwable;
        }
    }

    public final synchronized void suspend() {
        this.checkAccess();
        VMThread vMThread = this.vmThread;
        if (vMThread != null) {
            vMThread.suspend();
        }
    }

    public final synchronized void setPriority(int n) {
        this.checkAccess();
        if (n < 1 || n > 10) {
            throw new IllegalArgumentException("Invalid thread priority value " + n + '.');
        }
        n = Math.min(n, this.group.getMaxPriority());
        VMThread vMThread = this.vmThread;
        if (vMThread != null) {
            vMThread.setPriority(n);
        } else {
            this.priority = n;
        }
    }

    public String toString() {
        return "Thread[" + this.name + ',' + this.priority + ',' + (this.group == null ? "" : this.group.getName()) + ']';
    }

    synchronized void die() {
        this.group.removeThread(this);
        this.vmThread = null;
        this.locals = null;
    }

    static Map getThreadLocals() {
        Thread thread = Thread.currentThread();
        WeakIdentityHashMap weakIdentityHashMap = thread.locals;
        if (weakIdentityHashMap == null) {
            weakIdentityHashMap = thread.locals = new WeakIdentityHashMap();
        }
        return weakIdentityHashMap;
    }

    public Thread() {
        this((ThreadGroup)null, (Runnable)null);
    }

    public Thread(Runnable runnable) {
        this(null, runnable);
    }

    public Thread(String string) {
        this(null, null, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable) {
        this(threadGroup, runnable, "Thread-" + ++numAnonymousThreadsCreated, 0L);
    }

    public Thread(ThreadGroup threadGroup, String string) {
        this(threadGroup, null, string, 0L);
    }

    public Thread(Runnable runnable, String string) {
        this(null, runnable, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string) {
        this(threadGroup, runnable, string, 0L);
    }

    public Thread(ThreadGroup threadGroup, Runnable runnable, String string, long l) {
        SecurityManager securityManager = SecurityManager.current;
        Thread thread = Thread.currentThread();
        if (threadGroup == null) {
            if (securityManager != null) {
                threadGroup = securityManager.getThreadGroup();
            }
            if (threadGroup == null) {
                threadGroup = thread.group;
            }
        } else if (securityManager != null) {
            securityManager.checkAccess(threadGroup);
        }
        this.group = threadGroup;
        this.name = string.toString();
        this.runnable = runnable;
        this.stacksize = l;
        this.priority = thread.priority;
        this.daemon = thread.daemon;
        this.contextClassLoader = thread.contextClassLoader;
        threadGroup.addThread(this);
        InheritableThreadLocal.newChildThread(this);
    }

    Thread(VMThread vMThread, String string, int n, boolean bl) {
        this.vmThread = vMThread;
        this.runnable = null;
        if (string == null) {
            string = "Thread-" + ++numAnonymousThreadsCreated;
        }
        this.name = string;
        this.priority = n;
        this.daemon = bl;
        this.contextClassLoader = ClassLoader.getSystemClassLoader();
    }
}

