/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Long
extends Number
implements Comparable {
    private static final long serialVersionUID = 4290774380558885855L;
    public static final long MIN_VALUE = -9223372036854775808L;
    public static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFFL;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('J');
    public static final int SIZE = 64;
    private final long value;

    public static final String toString(long l, int n) {
        if ((long)((int)l) == l) {
            return Integer.toString((int)l, n);
        }
        if (n < 2 || n > 36) {
            n = 10;
        }
        char[] cArray = new char[65];
        int n2 = 65;
        boolean bl = false;
        if (l < 0L) {
            bl = true;
            if ((l = -l) < 0L) {
                cArray[--n2] = digits[(int)(-(l + (long)n) % (long)n)];
                l = -(l / (long)n);
            }
        }
        do {
            cArray[--n2] = digits[(int)(l % (long)n)];
        } while ((l /= (long)n) > 0L);
        if (bl) {
            cArray[--n2] = 45;
        }
        return new String(cArray, n2, 65 - n2, true);
    }

    public static final String toHexString(long l) {
        return Long.toUnsignedString(l, 4);
    }

    public static final String toOctalString(long l) {
        return Long.toUnsignedString(l, 3);
    }

    public static final String toBinaryString(long l) {
        return Long.toUnsignedString(l, 1);
    }

    public static final String toString(long l) {
        return Long.toString(l, 10);
    }

    public static final long parseLong(String string, int n) {
        return Long.parseLong(string, n, false);
    }

    public static final long parseLong(String string) {
        return Long.parseLong(string, 10, false);
    }

    public static final Long valueOf(String string, int n) {
        return new Long(Long.parseLong(string, n, false));
    }

    public static final Long valueOf(String string) {
        return new Long(Long.parseLong(string, 10, false));
    }

    public static final synchronized Long valueOf(long l) {
        return new Long(l);
    }

    public static final Long decode(String string) {
        return new Long(Long.parseLong(string, 10, true));
    }

    public final byte byteValue() {
        return (byte)this.value;
    }

    public final short shortValue() {
        return (short)this.value;
    }

    public final int intValue() {
        return (int)this.value;
    }

    public final long longValue() {
        return this.value;
    }

    public final float floatValue() {
        return this.value;
    }

    public final double doubleValue() {
        return this.value;
    }

    public final String toString() {
        return Long.toString(this.value, 10);
    }

    public final int hashCode() {
        return (int)(this.value ^ this.value >>> 32);
    }

    public final boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof Long && this.value == ((Long)object).value) {
            bl = true;
        }
        return bl;
    }

    public static final Long getLong(String string) {
        return Long.getLong(string, null);
    }

    public static final Long getLong(String string, long l) {
        Long l2 = Long.getLong(string, null);
        return l2 == null ? new Long(l) : l2;
    }

    public static final Long getLong(String string, Long l) {
        if (string == null || "".equals(string)) {
            return l;
        }
        if ((string = System.getProperty(string)) == null) {
            return l;
        }
        try {
            return Long.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            return l;
        }
    }

    public final int compareTo(Long l) {
        if (this.value == l.value) {
            return 0;
        }
        return this.value > l.value ? 1 : -1;
    }

    public final int compareTo(Object object) {
        return this.compareTo((Long)object);
    }

    public static final int bitCount(long l) {
        l = (l >> 1 & 0x5555555555555555L) + (l & 0x5555555555555555L);
        l = (l >> 2 & 0x3333333333333333L) + (l & 0x3333333333333333L);
        int n = (int)((l >>> 32) + l);
        n = (n >> 4 & 0xF0F0F0F) + (n & 0xF0F0F0F);
        n = (n >> 8 & 0xFF00FF) + (n & 0xFF00FF);
        return (n >> 16 & (char)-1) + (n & (char)-1);
    }

    public static final long rotateLeft(long l, int n) {
        return l << n | l >>> -n;
    }

    public static final long rotateRight(long l, int n) {
        return l << -n | l >>> n;
    }

    public static final long highestOneBit(long l) {
        l |= l >>> 1;
        l |= l >>> 2;
        l |= l >>> 4;
        l |= l >>> 8;
        l |= l >>> 16;
        l |= l >>> 32;
        return l ^ l >>> 1;
    }

    public static final int numberOfLeadingZeros(long l) {
        l |= l >>> 1;
        l |= l >>> 2;
        l |= l >>> 4;
        l |= l >>> 8;
        l |= l >>> 16;
        l |= l >>> 32;
        return Long.bitCount(l ^ -1L);
    }

    public static final long lowestOneBit(long l) {
        return l & -l;
    }

    public static final int numberOfTrailingZeros(long l) {
        return Long.bitCount((l & -l) - 1L);
    }

    public static final int signum(long l) {
        int n;
        if (l < 0L) {
            n = -1;
        } else {
            n = 0;
            if (l > 0L) {
                n = 1;
            }
        }
        return n;
    }

    public static final long reverseBytes(long l) {
        int n = Integer.reverseBytes((int)l);
        int n2 = Integer.reverseBytes((int)(l >>> 32));
        return (long)n << 32 | (long)n2;
    }

    public static final long reverse(long l) {
        long l2 = (long)Integer.reverse((int)l) & 0xFFFFFFFFL;
        long l3 = (long)Integer.reverse((int)(l >>> 32)) & 0xFFFFFFFFL;
        return l2 << 32 | l3;
    }

    private static final String toUnsignedString(long l, int n) {
        if (l >= 0L && (long)((int)l) == l) {
            return Integer.toUnsignedString((int)l, n);
        }
        int n2 = (1 << n) - 1;
        char[] cArray = new char[64];
        int n3 = 64;
        do {
            cArray[--n3] = digits[(int)l & n2];
        } while ((l >>>= n) != 0L);
        return new String(cArray, n3, 64 - n3, true);
    }

    private static final long parseLong(String string, int n, boolean bl) {
        if (!bl && string == null) {
            throw new NumberFormatException();
        }
        int n2 = 0;
        int n3 = string.length();
        boolean bl2 = false;
        if (n3 == 0) {
            throw new NumberFormatException();
        }
        int n4 = string.charAt(n2);
        if (n4 == 45) {
            if (n3 == 1) {
                throw new NumberFormatException();
            }
            bl2 = true;
            n4 = string.charAt(++n2);
        }
        if (bl) {
            if (n4 == 48) {
                if (++n2 == n3) {
                    return 0L;
                }
                if ((string.charAt(n2) & 0xFFFFFFDF) == 88) {
                    n = 16;
                    ++n2;
                } else {
                    n = 8;
                }
            } else if (n4 == 35) {
                n = 16;
                ++n2;
            }
        }
        if (n2 == n3) {
            throw new NumberFormatException();
        }
        long l = Long.MAX_VALUE / (long)n;
        if (bl2 && Long.MAX_VALUE % (long)n == (long)(n - 1)) {
            ++l;
        }
        long l2 = 0L;
        while (n2 < n3) {
            if (l2 < 0L || l2 > l) {
                throw new NumberFormatException();
            }
            n4 = Character.digit(string.charAt(n2++), n);
            l2 = l2 * (long)n + (long)n4;
            if (n4 >= 0 && (l2 >= 0L || bl2 && l2 == Long.MIN_VALUE)) continue;
            throw new NumberFormatException();
        }
        return bl2 ? -l2 : l2;
    }

    public Long(long l) {
        this.value = l;
    }

    public Long(String string) {
        this.value = Long.parseLong(string, 10, false);
    }
}

