/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

public class Kernel
implements Cloneable {
    private final int width;
    private final int height;
    private final float[] data;

    public final int getXOrigin() {
        return (this.width - 1) / 2;
    }

    public final int getYOrigin() {
        return (this.height - 1) / 2;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final float[] getKernelData(float[] fArray) throws IllegalArgumentException {
        if (fArray == null) {
            return (float[])this.data.clone();
        }
        if (fArray.length < this.data.length) {
            throw new IllegalArgumentException();
        }
        System.arraycopy(this.data, 0, fArray, 0, this.data.length);
        return fArray;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw (Error)new InternalError().initCause(cloneNotSupportedException);
        }
    }

    public Kernel(int n, int n2, float[] fArray) throws IllegalArgumentException {
        this.width = n;
        this.height = n2;
        if (fArray.length < n * n2 || n < 0 || n2 < 0) {
            throw new IllegalArgumentException();
        }
        this.data = new float[n * n2];
        System.arraycopy(fArray, 0, this.data, 0, n * n2);
    }
}

