/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public class GridLayout
implements LayoutManager,
Serializable {
    static final long serialVersionUID = -7411804673224730901L;
    private int cols;
    private int rows;
    private int hgap;
    private int vgap;

    public void addLayoutComponent(String string, Component component) {
    }

    public int getColumns() {
        return this.cols;
    }

    public int getHgap() {
        return this.hgap;
    }

    public int getRows() {
        return this.rows;
    }

    public int getVgap() {
        return this.vgap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void layoutContainer(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n = container.ncomponents;
            if (n == 0) {
                return;
            }
            Component[] componentArray = container.component;
            int n2 = this.rows;
            int n3 = this.cols;
            if (n2 == 0) {
                n2 = (n + n3 - 1) / n3;
            } else {
                n3 = (n + n2 - 1) / n2;
            }
            if (n < n3) {
                n3 = n;
            }
            Dimension dimension = container.getSize();
            Insets insets = container.getInsets();
            int n4 = dimension.width - insets.left - insets.right;
            n4 = (n4 - (n3 - 1) * this.hgap) / n3;
            int n5 = dimension.height - insets.top - insets.bottom;
            n5 = (n5 - (n2 - 1) * this.vgap) / n2;
            if (n4 < 0) {
                n4 = 1;
            }
            if (n5 < 0) {
                n5 = 1;
            }
            int n6 = insets.left;
            int n7 = insets.top;
            int n8 = 0;
            int n9 = 0;
            while (n8 < n) {
                componentArray[n8].setBounds(n6, n7, n4, n5);
                ++n8;
                if (++n9 == n3) {
                    n9 = 0;
                    n7 += this.vgap + n5;
                    n6 = insets.left;
                    continue;
                }
                n6 += this.hgap + n4;
            }
            return;
        }
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.getSize(container, true);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.getSize(container, false);
    }

    public void removeLayoutComponent(Component component) {
    }

    public void setColumns(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("number of columns cannot be negative");
        }
        if (n == 0 && this.rows == 0) {
            throw new IllegalArgumentException("number of rows is already 0");
        }
        this.cols = n;
    }

    public void setHgap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("horizontal gap must be nonnegative");
        }
        this.hgap = n;
    }

    public void setRows(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("number of rows cannot be negative");
        }
        if (n == 0 && this.cols == 0) {
            throw new IllegalArgumentException("number of columns is already 0");
        }
        this.rows = n;
    }

    public void setVgap(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("vertical gap must be nonnegative");
        }
        this.vgap = n;
    }

    public String toString() {
        return "[" + this.getClass().getName() + ",hgap=" + this.hgap + ",vgap=" + this.vgap + ",rows=" + this.rows + ",cols=" + this.cols + ']';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Dimension getSize(Container container, boolean bl) {
        Object object = container.getTreeLock();
        synchronized (object) {
            int n;
            int n2;
            int n3;
            int n4;
            block5: {
                n4 = 0;
                n3 = 0;
                int n5 = container.ncomponents;
                Component[] componentArray = container.component;
                n2 = 0;
                while (true) {
                    if (n2 >= n5) {
                        n2 = this.rows;
                        n = this.cols;
                        if (n2 != 0) break;
                        n2 = (n5 + n - 1) / n;
                        break block5;
                    }
                    Dimension dimension = bl ? componentArray[n2].getMinimumSize() : componentArray[n2].getPreferredSize();
                    n4 = Math.max(dimension.width, n4);
                    n3 = Math.max(dimension.height, n3);
                    ++n2;
                }
                n = (n5 + n2 - 1) / n2;
            }
            Insets insets = container.getInsets();
            n4 = insets.left + insets.right + n * (n4 + this.hgap) - this.hgap;
            n3 = insets.top + insets.bottom + n2 * (n3 + this.vgap) - this.vgap;
            return new Dimension(n4, n3);
        }
    }

    public GridLayout() {
        this(1, 0, 0, 0);
    }

    public GridLayout(int n, int n2) {
        this(n, n2, 0, 0);
    }

    public GridLayout(int n, int n2, int n3, int n4) {
        if (n < 0) {
            throw new IllegalArgumentException("number of rows cannot be negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("number of columns cannot be negative");
        }
        if (n == 0 && n2 == 0) {
            throw new IllegalArgumentException("both rows and columns cannot be 0");
        }
        if (n3 < 0) {
            throw new IllegalArgumentException("horizontal gap must be nonnegative");
        }
        if (n4 < 0) {
            throw new IllegalArgumentException("vertical gap must be nonnegative");
        }
        this.rows = n;
        this.cols = n2;
        this.hgap = n3;
        this.vgap = n4;
    }
}

