/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class ComponentOrientation
implements Serializable {
    private static final long serialVersionUID = -4113291392143563828L;
    private static final int UNKNOWN_ID = 1;
    private static final int HORIZONTAL_ID = 2;
    private static final int LEFT_TO_RIGHT_ID = 4;
    public static final ComponentOrientation LEFT_TO_RIGHT = new ComponentOrientation(6);
    public static final ComponentOrientation RIGHT_TO_LEFT = new ComponentOrientation(2);
    public static final ComponentOrientation UNKNOWN = new ComponentOrientation(7);
    private final int orientation;

    public final boolean isHorizontal() {
        boolean bl = false;
        if ((this.orientation & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public final boolean isLeftToRight() {
        boolean bl = false;
        if ((this.orientation & 4) != 0) {
            bl = true;
        }
        return bl;
    }

    public static final ComponentOrientation getOrientation(Locale locale) {
        String string = locale.getLanguage();
        if ("ar".equals(string) || "fa".equals(string) || "iw".equals(string) || "ur".equals(string)) {
            return RIGHT_TO_LEFT;
        }
        return LEFT_TO_RIGHT;
    }

    public static final ComponentOrientation getOrientation(ResourceBundle resourceBundle) {
        ComponentOrientation componentOrientation;
        try {
            componentOrientation = (ComponentOrientation)resourceBundle.getObject("Orientation");
            if (componentOrientation != null) {
                return componentOrientation;
            }
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (ClassCastException classCastException) {}
        try {
            componentOrientation = ComponentOrientation.getOrientation(resourceBundle.getLocale());
            if (componentOrientation != null) {
                return componentOrientation;
            }
        }
        catch (Exception exception) {}
        return ComponentOrientation.getOrientation(Locale.getDefault());
    }

    private ComponentOrientation(int n) {
        this.orientation = n;
    }
}

