/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class HexBinaryType
extends AtomicSimpleType {
    static final String HEX = "0123456789ABCDEF";
    static final int[] CONSTRAINING_FACETS = new int[]{1, 2, 3, 4, 5, 6};

    public final int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    public final void checkValid(String string, ValidationContext validationContext) throws DatatypeException {
        super.checkValid(string, validationContext);
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            if (HEX.indexOf(c) == -1) {
                throw new DatatypeException(n2, "invalid hexBinary value");
            }
            ++n2;
        }
    }

    HexBinaryType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "hexBinary"), TypeLibrary.ANY_SIMPLE_TYPE);
    }
}

