/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.libxmlj.transform;

import gnu.xml.libxmlj.dom.GnomeDocument;
import gnu.xml.libxmlj.sax.GnomeXMLReader;
import gnu.xml.libxmlj.transform.ErrorListenerErrorHandler;
import gnu.xml.libxmlj.transform.URIResolverEntityResolver;
import gnu.xml.libxmlj.util.NamedInputStream;
import gnu.xml.libxmlj.util.StandaloneLocator;
import gnu.xml.libxmlj.util.XMLJ;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;

public class GnomeTransformer
extends Transformer
implements Templates {
    private Map parameters;
    private Properties outputProperties;
    private URIResolver resolver;
    private ErrorListener errorListener;
    private Object stylesheet;

    private final native Object newStylesheet() throws TransformerConfigurationException;

    private final native Object newStylesheetFromStream(InputStream var1, byte[] var2, String var3, String var4, String var5, boolean var6, boolean var7) throws TransformerConfigurationException;

    private final native Object newStylesheetFromDoc(GnomeDocument var1) throws TransformerConfigurationException;

    public synchronized void setParameter(String string, Object object) {
        this.parameters.put(string, object);
    }

    public synchronized Object getParameter(String string) {
        return this.parameters.get(string);
    }

    public synchronized void clearParameters() {
        this.parameters.clear();
    }

    public void setErrorListener(ErrorListener errorListener) {
        this.errorListener = errorListener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void setURIResolver(URIResolver uRIResolver) {
        this.resolver = uRIResolver;
    }

    public URIResolver getURIResolver() {
        return this.resolver;
    }

    public void setOutputProperties(Properties properties) {
        this.outputProperties = new Properties(properties);
    }

    public void setOutputProperty(String string, String string2) {
        this.outputProperties.setProperty(string, string2);
    }

    public Properties getOutputProperties() {
        return new Properties(this.outputProperties);
    }

    public String getOutputProperty(String string) {
        return this.outputProperties.getProperty(string);
    }

    public Transformer newTransformer() {
        return new GnomeTransformer(this.stylesheet, this.resolver, this.errorListener, new HashMap(this.parameters), new Properties(this.outputProperties));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void transform(Source source, Result result) throws TransformerException {
        if (source instanceof StreamSource) {
            try {
                StreamSource streamSource = (StreamSource)source;
                NamedInputStream namedInputStream = XMLJ.getInputStream(streamSource);
                String string = streamSource.getPublicId();
                String string2 = streamSource.getSystemId();
                String string3 = XMLJ.getBaseURI(string2);
                byte[] byArray = namedInputStream.getDetectBuffer();
                if (byArray == null) {
                    throw new TransformerException("No document element");
                }
                if (result instanceof StreamResult) {
                    OutputStream outputStream = XMLJ.getOutputStream((StreamResult)result);
                    boolean bl = false;
                    if (this.resolver != null) {
                        bl = true;
                    }
                    boolean bl2 = false;
                    if (this.errorListener != null) {
                        bl2 = true;
                    }
                    this.transformStreamToStream(namedInputStream, byArray, string, string2, string3, bl, bl2, outputStream);
                    return;
                }
                if (result instanceof DOMResult) {
                    DOMResult dOMResult = (DOMResult)result;
                    boolean bl = false;
                    if (this.resolver != null) {
                        bl = true;
                    }
                    boolean bl3 = false;
                    if (this.errorListener != null) {
                        bl3 = true;
                    }
                    GnomeDocument gnomeDocument = this.transformStreamToDoc(namedInputStream, byArray, string, string2, string3, bl, bl3);
                    dOMResult.setNode(gnomeDocument);
                    dOMResult.setSystemId(null);
                    return;
                }
                if (!(result instanceof SAXResult)) {
                    String string4 = "Result type not supported (" + result + ')';
                    throw new TransformerConfigurationException(string4);
                }
                SAXResult sAXResult = (SAXResult)result;
                boolean bl = false;
                if (this.resolver != null) {
                    bl = true;
                }
                boolean bl4 = false;
                if (this.errorListener != null) {
                    bl4 = true;
                }
                this.transformStreamToSAX(namedInputStream, byArray, string, string2, string3, bl, bl4, this.getSAXContext(sAXResult));
                return;
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
        }
        if (!(source instanceof DOMSource)) {
            String string = "Source type not supported";
            throw new TransformerConfigurationException(string);
        }
        DOMSource dOMSource = (DOMSource)source;
        Node node2 = dOMSource.getNode();
        if (!(node2 instanceof GnomeDocument)) {
            String string = "Node is not a GnomeDocument (" + node2 + ')';
            throw new TransformerException(string);
        }
        GnomeDocument gnomeDocument = (GnomeDocument)node2;
        if (result instanceof StreamResult) {
            try {
                OutputStream outputStream = XMLJ.getOutputStream((StreamResult)result);
                this.transformDocToStream(gnomeDocument, outputStream);
                return;
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
        }
        if (result instanceof DOMResult) {
            DOMResult dOMResult = (DOMResult)result;
            GnomeDocument gnomeDocument2 = this.transformDocToDoc(gnomeDocument);
            dOMResult.setNode(gnomeDocument2);
            dOMResult.setSystemId(null);
            return;
        }
        if (result instanceof SAXResult) {
            SAXResult sAXResult = (SAXResult)result;
            this.transformDocToSAX(gnomeDocument, this.getSAXContext(sAXResult));
            return;
        }
        String string = "Result type not supported";
        throw new TransformerConfigurationException(string);
    }

    private final GnomeXMLReader getSAXContext(SAXResult sAXResult) {
        Object object;
        GnomeXMLReader gnomeXMLReader = new GnomeXMLReader();
        gnomeXMLReader.setContentHandler(sAXResult.getHandler());
        gnomeXMLReader.setLexicalHandler(sAXResult.getLexicalHandler());
        if (this.errorListener != null) {
            object = new ErrorListenerErrorHandler(this.errorListener);
            gnomeXMLReader.setErrorHandler((ErrorHandler)object);
        }
        if (this.resolver != null) {
            object = new URIResolverEntityResolver(this.resolver);
            gnomeXMLReader.setEntityResolver((EntityResolver)object);
        }
        return gnomeXMLReader;
    }

    private final native void transformStreamToStream(InputStream var1, byte[] var2, String var3, String var4, String var5, boolean var6, boolean var7, OutputStream var8) throws TransformerException;

    private final native GnomeDocument transformStreamToDoc(InputStream var1, byte[] var2, String var3, String var4, String var5, boolean var6, boolean var7) throws TransformerException;

    private final native void transformStreamToSAX(InputStream var1, byte[] var2, String var3, String var4, String var5, boolean var6, boolean var7, GnomeXMLReader var8) throws TransformerException;

    private final native void transformDocToStream(GnomeDocument var1, OutputStream var2) throws TransformerException;

    private final native GnomeDocument transformDocToDoc(GnomeDocument var1) throws TransformerException;

    private final native void transformDocToSAX(GnomeDocument var1, GnomeXMLReader var2) throws TransformerException;

    private final String[] getParameterArray() {
        String[] stringArray = new String[this.parameters.size() * 2];
        int n = 0;
        Iterator iterator = this.parameters.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)this.parameters.get(string);
            stringArray[n * 2] = string;
            stringArray[n * 2 + 1] = "'" + (string2 != null ? string2 : "") + '\'';
            ++n;
        }
        return stringArray;
    }

    public void finalize() {
        if (this.stylesheet != null) {
            this.free();
            this.stylesheet = null;
        }
    }

    private final native void free();

    private final InputStream resolveEntity(String string, String string2) throws TransformerException {
        if (this.resolver != null) {
            string2 = this.resolver.resolve(null, string2).getSystemId();
        }
        if (string2 == null) {
            return null;
        }
        try {
            URL uRL = new URL(string2);
            return XMLJ.getInputStream(uRL);
        }
        catch (IOException iOException) {
            throw new TransformerException(iOException);
        }
    }

    private final void setDocumentLocator(Object object, Object object2) {
    }

    private final void warning(String string, int n, int n2, String string2, String string3) throws TransformerException {
        if (this.errorListener == null) {
            return;
        }
        StandaloneLocator standaloneLocator = new StandaloneLocator(n, n2, string2, string3);
        this.errorListener.warning(new TransformerException(string, standaloneLocator));
    }

    private final void error(String string, int n, int n2, String string2, String string3) throws TransformerException {
        if (this.errorListener == null) {
            return;
        }
        StandaloneLocator standaloneLocator = new StandaloneLocator(n, n2, string2, string3);
        this.errorListener.error(new TransformerException(string, standaloneLocator));
    }

    private final void fatalError(String string, int n, int n2, String string2, String string3) throws TransformerException {
        if (this.errorListener == null) {
            return;
        }
        StandaloneLocator standaloneLocator = new StandaloneLocator(n, n2, string2, string3);
        this.errorListener.fatalError(new TransformerException(string, standaloneLocator));
    }

    GnomeTransformer(Source source, URIResolver uRIResolver, ErrorListener errorListener) throws TransformerConfigurationException {
        this.resolver = uRIResolver;
        this.errorListener = errorListener;
        this.parameters = new HashMap();
        this.outputProperties = new Properties();
        if (source == null) {
            this.stylesheet = this.newStylesheet();
        } else if (source instanceof StreamSource) {
            try {
                StreamSource streamSource = (StreamSource)source;
                NamedInputStream namedInputStream = XMLJ.getInputStream(streamSource);
                String string = streamSource.getSystemId();
                String string2 = streamSource.getPublicId();
                String string3 = XMLJ.getBaseURI(string);
                byte[] byArray = namedInputStream.getDetectBuffer();
                if (byArray == null) {
                    String string4 = "No document element";
                    throw new TransformerConfigurationException(string4);
                }
                boolean bl = false;
                if (uRIResolver != null) {
                    bl = true;
                }
                boolean bl2 = false;
                if (errorListener != null) {
                    bl2 = true;
                }
                this.stylesheet = this.newStylesheetFromStream(namedInputStream, byArray, string2, string, string3, bl, bl2);
            }
            catch (IOException iOException) {
                throw new TransformerConfigurationException(iOException);
            }
        } else if (source instanceof DOMSource) {
            DOMSource dOMSource = (DOMSource)source;
            Node node2 = dOMSource.getNode();
            if (!(node2 instanceof GnomeDocument)) {
                String string = "Node is not a GnomeDocument";
                throw new TransformerConfigurationException(string);
            }
            GnomeDocument gnomeDocument = (GnomeDocument)node2;
            this.stylesheet = this.newStylesheetFromDoc(gnomeDocument);
        } else {
            String string = "Source type not supported (" + source + ')';
            throw new TransformerConfigurationException(string);
        }
    }

    private GnomeTransformer(Object object, URIResolver uRIResolver, ErrorListener errorListener, Map map, Properties properties) {
        this.stylesheet = object;
        this.resolver = uRIResolver;
        this.errorListener = errorListener;
        this.parameters = map;
        this.outputProperties = properties;
    }
}

