/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.libxmlj.dom;

import gnu.xml.libxmlj.dom.GnomeAttr;
import gnu.xml.libxmlj.dom.GnomeCDATASection;
import gnu.xml.libxmlj.dom.GnomeComment;
import gnu.xml.libxmlj.dom.GnomeDOMException;
import gnu.xml.libxmlj.dom.GnomeDocument;
import gnu.xml.libxmlj.dom.GnomeDocumentFragment;
import gnu.xml.libxmlj.dom.GnomeDocumentType;
import gnu.xml.libxmlj.dom.GnomeElement;
import gnu.xml.libxmlj.dom.GnomeEntity;
import gnu.xml.libxmlj.dom.GnomeEntityReference;
import gnu.xml.libxmlj.dom.GnomeNamedNodeMap;
import gnu.xml.libxmlj.dom.GnomeNodeList;
import gnu.xml.libxmlj.dom.GnomeNotation;
import gnu.xml.libxmlj.dom.GnomeProcessingInstruction;
import gnu.xml.libxmlj.dom.GnomeText;
import gnu.xml.libxmlj.util.StandaloneDocumentType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.UserDataHandler;

class GnomeNode
implements Node,
Comparable {
    static Map instances;
    final Object id;
    Map userData;
    Map userDataHandlers;

    static GnomeNode newInstance(Object object, Object object2, int n) {
        GnomeNode gnomeNode;
        Map map;
        if (object == null) {
            throw new NullPointerException("doc");
        }
        if (object2 == null) {
            throw new NullPointerException("node");
        }
        if (instances == null) {
            instances = new HashMap();
        }
        if ((map = (Map)instances.get(object)) == null) {
            map = new HashMap(1024);
            instances.put(object, map);
        }
        if ((gnomeNode = (GnomeNode)map.get(object2)) != null) {
            return gnomeNode;
        }
        switch (n) {
            case 1: {
                gnomeNode = new GnomeElement(object2);
                break;
            }
            case 2: {
                gnomeNode = new GnomeAttr(object2);
                break;
            }
            case 3: {
                gnomeNode = new GnomeText(object2);
                break;
            }
            case 4: {
                gnomeNode = new GnomeCDATASection(object2);
                break;
            }
            case 5: {
                gnomeNode = new GnomeEntityReference(object2);
                break;
            }
            case 6: {
                gnomeNode = new GnomeEntity(object2);
                break;
            }
            case 7: {
                gnomeNode = new GnomeProcessingInstruction(object2);
                break;
            }
            case 8: {
                gnomeNode = new GnomeComment(object2);
                break;
            }
            case 9: {
                gnomeNode = new GnomeDocument(object2);
                break;
            }
            case 10: {
                gnomeNode = new GnomeDocumentType(object2);
                break;
            }
            case 11: {
                gnomeNode = new GnomeDocumentFragment(object2);
                break;
            }
            case 12: {
                gnomeNode = new GnomeNotation(object2);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown node type: " + n);
            }
        }
        map.put(object2, gnomeNode);
        return gnomeNode;
    }

    static void freeDocument(Object object) {
        if (instances == null || object == null) {
            return;
        }
        instances.remove(object);
    }

    public native String getNodeName();

    public native String getNodeValue() throws DOMException;

    public native void setNodeValue(String var1) throws DOMException;

    public native short getNodeType();

    public native Node getParentNode();

    public NodeList getChildNodes() {
        return new GnomeNodeList(this.id);
    }

    public native Node getFirstChild();

    public native Node getLastChild();

    public native Node getPreviousSibling();

    public native Node getNextSibling();

    public NamedNodeMap getAttributes() {
        return new GnomeNamedNodeMap(this.id, 0);
    }

    public native Document getOwnerDocument();

    public Node insertBefore(Node node2, Node node3) throws DOMException {
        if (node2 instanceof StandaloneDocumentType) {
            DocumentType documentType = (DocumentType)node2;
            node2 = ((GnomeDocument)this.getOwnerDocument()).createDocumentType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        }
        if (node2 == null) {
            throw new GnomeDOMException(8, null);
        }
        if (!(node2 instanceof GnomeNode)) {
            throw new GnomeDOMException(4, null);
        }
        if (node3 == null || !(node3 instanceof GnomeNode)) {
            throw new GnomeDOMException(8, null);
        }
        return this.xmljInsertBefore(node2, node3);
    }

    private final native Node xmljInsertBefore(Node var1, Node var2) throws DOMException;

    public Node replaceChild(Node node2, Node node3) throws DOMException {
        if (node2 instanceof StandaloneDocumentType) {
            DocumentType documentType = (DocumentType)node2;
            node2 = ((GnomeDocument)this.getOwnerDocument()).createDocumentType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        }
        if (node2 == null) {
            throw new GnomeDOMException(8, null);
        }
        if (!(node2 instanceof GnomeNode)) {
            throw new GnomeDOMException(4, node2.toString());
        }
        if (node3 == null || !(node3 instanceof GnomeNode)) {
            throw new GnomeDOMException(8, null);
        }
        return this.xmljReplaceChild(node2, node3);
    }

    private final native Node xmljReplaceChild(Node var1, Node var2) throws DOMException;

    public Node removeChild(Node node2) throws DOMException {
        if (!(node2 instanceof GnomeNode)) {
            throw new GnomeDOMException(4, null);
        }
        return this.xmljRemoveChild(node2);
    }

    private final native Node xmljRemoveChild(Node var1) throws DOMException;

    public Node appendChild(Node node2) throws DOMException {
        if (node2 instanceof StandaloneDocumentType) {
            DocumentType documentType = (DocumentType)node2;
            node2 = ((GnomeDocument)this.getOwnerDocument()).createDocumentType(documentType.getName(), documentType.getPublicId(), documentType.getSystemId());
        }
        if (!(node2 instanceof GnomeNode)) {
            throw new GnomeDOMException(4, null);
        }
        return this.xmljAppendChild(node2);
    }

    private final native Node xmljAppendChild(Node var1) throws DOMException;

    public native boolean hasChildNodes();

    public Node cloneNode(boolean bl) {
        Node node2 = this.xmljCloneNode(bl);
        this.notifyUserDataHandlers((short)1, this, node2);
        return node2;
    }

    private final native Node xmljCloneNode(boolean var1);

    public native void normalize();

    public boolean isSupported(String string, String string2) {
        return this.getOwnerDocument().getImplementation().hasFeature(string, string2);
    }

    public native String getNamespaceURI();

    public native String getPrefix();

    public native void setPrefix(String var1) throws DOMException;

    public native String getLocalName();

    public native boolean hasAttributes();

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        boolean bl = false;
        if (object instanceof GnomeNode && ((GnomeNode)object).id == this.id) {
            bl = true;
        }
        return bl;
    }

    public native String getBaseURI();

    public short compareDocumentPosition(Node node2) throws DOMException {
        return (short)this.compareTo(node2);
    }

    public final int compareTo(Object object) {
        if (object instanceof GnomeNode) {
            return this.xmljCompareTo(object);
        }
        return 0;
    }

    private final native int xmljCompareTo(Object var1);

    public String getTextContent() throws DOMException {
        switch (this.getNodeType()) {
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 11: {
                StringBuffer stringBuffer = new StringBuffer();
                NodeList nodeList = this.getChildNodes();
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    Node node2 = nodeList.item(n2);
                    String string = node2.getTextContent();
                    if (string != null) {
                        stringBuffer.append(string);
                    }
                    ++n2;
                }
                return stringBuffer.toString();
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                return this.getNodeValue();
            }
        }
        return null;
    }

    public void setTextContent(String string) throws DOMException {
        switch (this.getNodeType()) {
            case 5: {
                throw new GnomeDOMException(7, null);
            }
            case 1: 
            case 2: 
            case 6: 
            case 11: {
                NodeList nodeList = this.getChildNodes();
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    Node node2 = nodeList.item(n2);
                    this.removeChild(node2);
                    ++n2;
                }
                if (string == null) break;
                Text text = this.getOwnerDocument().createTextNode(string);
                this.appendChild(text);
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                this.setNodeValue(string);
                break;
            }
        }
    }

    public boolean isSameNode(Node node2) {
        return this.equals(node2);
    }

    public native String lookupPrefix(String var1);

    public native boolean isDefaultNamespace(String var1);

    public native String lookupNamespaceURI(String var1);

    public native boolean isEqualNode(Node var1);

    public Object getFeature(String string, String string2) {
        return this.getOwnerDocument().getImplementation().getFeature(string, string2);
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        if (this.userData == null) {
            this.userData = new HashMap();
        }
        if (userDataHandler != null) {
            if (this.userDataHandlers == null) {
                this.userDataHandlers = new HashMap();
            }
            this.userDataHandlers.put(string, userDataHandler);
        }
        return this.userData.put(string, object);
    }

    public Object getUserData(String string) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(string);
    }

    void notifyUserDataHandlers(short s, Node node2, Node node3) {
        if (this.userDataHandlers != null) {
            Iterator iterator = this.userDataHandlers.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                String string = (String)entry.getKey();
                UserDataHandler userDataHandler = (UserDataHandler)entry.getValue();
                Object object = this.userData.get(string);
                userDataHandler.handle(s, string, object, node2, node3);
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append("[nodeName=");
        stringBuffer.append(this.getNodeName());
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    GnomeNode(Object object) {
        this.id = object;
    }
}

