/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.net.ssl.provider;

import gnu.javax.net.ssl.provider.Constructed;
import gnu.javax.net.ssl.provider.Enumerated;
import gnu.javax.net.ssl.provider.Util;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;

final class Extension
implements Constructed {
    private final Type type;
    private final byte[] value;

    static final Extension read(InputStream inputStream) throws IOException {
        Type type = Type.read(inputStream);
        int n = (inputStream.read() & 0xFF) << 8 | inputStream.read() & 0xFF;
        byte[] byArray = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            int n3 = inputStream.read(byArray, n2, n - n2);
            if (n3 == -1) {
                throw new EOFException("unexpected end of extension");
            }
            n2 += n3;
        }
        return new Extension(type, byArray);
    }

    public final void write(OutputStream outputStream) throws IOException {
        outputStream.write(this.type.getEncoded());
        outputStream.write(this.value.length >>> 8 & 0xFF);
        outputStream.write(this.value.length & 0xFF);
        outputStream.write(this.value);
    }

    final Type getType() {
        return this.type;
    }

    final byte[] getValue() {
        return this.value;
    }

    public final String toString() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println("struct {");
        printWriter.println("  type = " + this.type + ';');
        printWriter.println("  value =");
        printWriter.println(Util.hexDump(this.value, "    "));
        printWriter.println("} Extension;");
        return stringWriter.toString();
    }

    Extension(Type type, byte[] byArray) {
        if (type == null || byArray == null) {
            throw new NullPointerException();
        }
        this.type = type;
        this.value = byArray;
    }

    static final class Type
    implements Enumerated {
        static final Type SERVER_NAME = new Type(0);
        static final Type MAX_FRAGMENT_LENGTH = new Type(1);
        static final Type CLIENT_CERTIFICATE_URL = new Type(2);
        static final Type TRUSTED_CA_KEYS = new Type(3);
        static final Type TRUNCATED_HMAC = new Type(4);
        static final Type STATUS_REQUEST = new Type(5);
        static final Type SRP = new Type(6);
        static final Type CERT_TYPE = new Type(7);
        private final int value;

        static final Type read(InputStream inputStream) throws IOException {
            int n = inputStream.read();
            if (n == -1) {
                throw new EOFException("unexpected end of input stream");
            }
            int n2 = (n & 0xFF) << 8;
            n = inputStream.read();
            if (n == -1) {
                throw new EOFException("unexpected end of input stream");
            }
            switch (n2 |= n & 0xFF) {
                case 0: {
                    return SERVER_NAME;
                }
                case 1: {
                    return MAX_FRAGMENT_LENGTH;
                }
                case 2: {
                    return CLIENT_CERTIFICATE_URL;
                }
                case 3: {
                    return TRUSTED_CA_KEYS;
                }
                case 4: {
                    return TRUNCATED_HMAC;
                }
                case 5: {
                    return STATUS_REQUEST;
                }
                case 6: {
                    return SRP;
                }
                case 7: {
                    return CERT_TYPE;
                }
            }
            return new Type(n2);
        }

        public final byte[] getEncoded() {
            return new byte[]{(byte)(this.value >>> 8 & 0xFF), (byte)(this.value & 0xFF)};
        }

        public final int getValue() {
            return this.value;
        }

        public final String toString() {
            switch (this.value) {
                case 0: {
                    return "server_name";
                }
                case 1: {
                    return "max_fragment_length";
                }
                case 2: {
                    return "client_certificate_url";
                }
                case 3: {
                    return "trusted_ca_keys";
                }
                case 4: {
                    return "truncated_hmac";
                }
                case 5: {
                    return "status_request";
                }
                case 6: {
                    return "srp";
                }
                case 7: {
                    return "cert_type";
                }
            }
            return "unknown(" + this.value + ')';
        }

        private Type(int n) {
            this.value = n;
        }
    }
}

