/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.mac;

import gnu.java.security.util.Util;
import gnu.javax.crypto.cipher.CipherFactory;
import gnu.javax.crypto.cipher.IBlockCipher;
import gnu.javax.crypto.mac.IMac;
import gnu.javax.crypto.mode.IMode;
import java.security.InvalidKeyException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class OMAC
implements IMac {
    private static final boolean DEBUG = false;
    private static final byte C1 = -121;
    private static final byte C2 = 27;
    private static final byte[] KEY0 = Util.toBytesFromString("2b7e151628aed2a6abf7158809cf4f3c");
    private static final byte[] DIGEST0 = Util.toBytesFromString("bb1d6929e95937287fa37d129b756746");
    private static Boolean valid;
    private final IBlockCipher cipher;
    private final String name;
    private IMode mode;
    private int blockSize;
    private int outputSize;
    private byte[] Lu;
    private byte[] Lu2;
    private byte[] M;
    private byte[] Y;
    private boolean init;
    private int index;

    private static final void debug(String string) {
        System.out.print(">>> OMAC: ");
        System.out.println(string);
    }

    public Object clone() {
        return new OMAC(this.cipher);
    }

    public String name() {
        return this.name;
    }

    public int macSize() {
        return this.outputSize;
    }

    public void init(Map map) throws InvalidKeyException {
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.cipher.key.material", map.get("gnu.crypto.mac.key.material"));
        this.cipher.reset();
        this.cipher.init(hashMap);
        this.blockSize = this.cipher.currentBlockSize();
        Integer n = (Integer)map.get("gnu.crypto.mac.truncated.size");
        if (n != null) {
            this.outputSize = n;
            if (this.outputSize < 0 || this.outputSize > this.blockSize) {
                throw new IllegalArgumentException("truncated size out of range");
            }
        } else {
            this.outputSize = this.blockSize;
        }
        byte[] byArray = new byte[this.blockSize];
        this.cipher.encryptBlock(byArray, 0, byArray, 0);
        if (this.Lu != null) {
            Arrays.fill(this.Lu, (byte)0);
            if (this.Lu.length != this.blockSize) {
                this.Lu = new byte[this.blockSize];
            }
        } else {
            this.Lu = new byte[this.blockSize];
        }
        if (this.Lu2 != null) {
            Arrays.fill(this.Lu2, (byte)0);
            if (this.Lu2.length != this.blockSize) {
                this.Lu2 = new byte[this.blockSize];
            }
        } else {
            this.Lu2 = new byte[this.blockSize];
        }
        boolean bl = false;
        if ((byArray[0] & 0x80) != 0) {
            bl = true;
        }
        boolean bl2 = bl;
        int n2 = 0;
        while (n2 < this.blockSize) {
            this.Lu[n2] = (byte)(byArray[n2] << 1 & 0xFF);
            if (n2 + 1 < this.blockSize) {
                int n3 = n2;
                this.Lu[n3] = (byte)(this.Lu[n3] | (byte)((byArray[n2 + 1] & 0x80) >> 7));
            }
            ++n2;
        }
        if (bl2) {
            if (this.blockSize == 16) {
                int n4 = this.Lu.length - 1;
                this.Lu[n4] = (byte)(this.Lu[n4] ^ 0xFFFFFF87);
            } else if (this.blockSize == 8) {
                int n5 = this.Lu.length - 1;
                this.Lu[n5] = (byte)(this.Lu[n5] ^ 0x1B);
            } else {
                throw new IllegalArgumentException("unsupported cipher block size: " + this.blockSize);
            }
        }
        boolean bl3 = false;
        if ((this.Lu[0] & 0x80) != 0) {
            bl3 = true;
        }
        bl2 = bl3;
        n2 = 0;
        while (n2 < this.blockSize) {
            this.Lu2[n2] = (byte)(this.Lu[n2] << 1 & 0xFF);
            if (n2 + 1 < this.blockSize) {
                int n6 = n2;
                this.Lu2[n6] = (byte)(this.Lu2[n6] | (byte)((this.Lu[n2 + 1] & 0x80) >> 7));
            }
            ++n2;
        }
        if (bl2) {
            if (this.blockSize == 16) {
                int n7 = this.Lu2.length - 1;
                this.Lu2[n7] = (byte)(this.Lu2[n7] ^ 0xFFFFFF87);
            } else {
                int n8 = this.Lu2.length - 1;
                this.Lu2[n8] = (byte)(this.Lu2[n8] ^ 0x1B);
            }
        }
        if (this.M != null) {
            Arrays.fill(this.M, (byte)0);
            if (this.M.length != this.blockSize) {
                this.M = new byte[this.blockSize];
            }
        } else {
            this.M = new byte[this.blockSize];
        }
        if (this.Y != null) {
            Arrays.fill(this.Y, (byte)0);
            if (this.Y.length != this.blockSize) {
                this.Y = new byte[this.blockSize];
            }
        } else {
            this.Y = new byte[this.blockSize];
        }
        this.index = 0;
        this.init = true;
    }

    public void update(byte by) {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        if (this.index == this.M.length) {
            this.process();
            this.index = 0;
        }
        this.M[this.index++] = by;
    }

    public void update(byte[] byArray, int n, int n2) {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException("size=" + byArray.length + "; off=" + n + "; len=" + n2);
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.index == this.blockSize) {
                this.process();
                this.index = 0;
            }
            int n4 = Math.min(this.blockSize - this.index, n2 - n3);
            System.arraycopy(byArray, n + n3, this.M, this.index, n4);
            this.index += n4;
            n3 += n4;
        }
    }

    public byte[] digest() {
        byte[] byArray = new byte[this.outputSize];
        this.digest(byArray, 0);
        return byArray;
    }

    public void digest(byte[] byArray, int n) {
        if (!this.init) {
            throw new IllegalStateException("not initialized");
        }
        if (n < 0 || n + this.outputSize > byArray.length) {
            throw new IndexOutOfBoundsException("size=" + byArray.length + "; off=" + n + "; len=" + this.outputSize);
        }
        byte[] byArray2 = new byte[this.blockSize];
        byte[] byArray3 = this.Lu;
        if (this.index < this.blockSize) {
            this.M[this.index++] = -128;
            while (this.index < this.blockSize) {
                this.M[this.index++] = 0;
            }
            byArray3 = this.Lu2;
        }
        int n2 = 0;
        while (n2 < this.blockSize) {
            byArray2[n2] = (byte)(this.M[n2] ^ this.Y[n2] ^ byArray3[n2]);
            ++n2;
        }
        this.cipher.encryptBlock(byArray2, 0, byArray2, 0);
        System.arraycopy(byArray2, 0, byArray, n, this.outputSize);
        this.reset();
    }

    public void reset() {
        this.index = 0;
        if (this.Y != null) {
            Arrays.fill(this.Y, (byte)0);
        }
        if (this.M != null) {
            Arrays.fill(this.M, (byte)0);
        }
    }

    public boolean selfTest() {
        OMAC oMAC = new OMAC(CipherFactory.getInstance("aes"));
        oMAC.reset();
        HashMap hashMap = new HashMap();
        hashMap.put("gnu.crypto.mac.key.material", KEY0);
        byte[] byArray = null;
        try {
            oMAC.init(hashMap);
            byArray = oMAC.digest();
        }
        catch (Exception exception) {
            return false;
        }
        if (byArray == null) {
            return false;
        }
        return Arrays.equals(DIGEST0, byArray);
    }

    private final void process() {
        int n = 0;
        while (n < this.blockSize) {
            this.M[n] = (byte)(this.M[n] ^ this.Y[n]);
            ++n;
        }
        this.cipher.encryptBlock(this.M, 0, this.Y, 0);
    }

    public OMAC(IBlockCipher iBlockCipher) {
        this.cipher = iBlockCipher;
        this.name = "OMAC-" + iBlockCipher.name();
    }
}

