/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.keyring;

import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.key.KeyPairCodecFactory;
import gnu.java.security.key.dss.DSSPublicKey;
import gnu.java.security.key.rsa.GnuRSAPublicKey;
import gnu.javax.crypto.key.dh.GnuDHPublicKey;
import gnu.javax.crypto.keyring.MalformedKeyringException;
import gnu.javax.crypto.keyring.PrimitiveEntry;
import gnu.javax.crypto.keyring.Properties;
import java.io.DataInputStream;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;

public final class PublicKeyEntry
extends PrimitiveEntry {
    public static final int TYPE = 6;
    private PublicKey key;

    public static final PublicKeyEntry decode(DataInputStream dataInputStream) throws IOException {
        PublicKeyEntry publicKeyEntry = new PublicKeyEntry();
        publicKeyEntry.defaultDecode(dataInputStream);
        String string = publicKeyEntry.properties.get("type");
        if (string == null) {
            throw new MalformedKeyringException("no key type");
        }
        if (string.equalsIgnoreCase("RAW-DSS")) {
            IKeyPairCodec iKeyPairCodec = KeyPairCodecFactory.getInstance("dss");
            publicKeyEntry.key = iKeyPairCodec.decodePublicKey(publicKeyEntry.payload);
        } else if (string.equalsIgnoreCase("RAW-RSA")) {
            IKeyPairCodec iKeyPairCodec = KeyPairCodecFactory.getInstance("rsa");
            publicKeyEntry.key = iKeyPairCodec.decodePublicKey(publicKeyEntry.payload);
        } else if (string.equalsIgnoreCase("RAW-DH")) {
            IKeyPairCodec iKeyPairCodec = KeyPairCodecFactory.getInstance("dh");
            publicKeyEntry.key = iKeyPairCodec.decodePublicKey(publicKeyEntry.payload);
        } else if (string.equalsIgnoreCase("X.509")) {
            KeyFactory keyFactory;
            try {
                keyFactory = KeyFactory.getInstance("RSA");
                publicKeyEntry.key = keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyEntry.payload));
            }
            catch (Exception exception) {}
            if (publicKeyEntry.key == null) {
                try {
                    keyFactory = KeyFactory.getInstance("DSA");
                    publicKeyEntry.key = keyFactory.generatePublic(new X509EncodedKeySpec(publicKeyEntry.payload));
                }
                catch (Exception exception) {}
                if (publicKeyEntry.key == null) {
                    throw new MalformedKeyringException("could not decode X.509 key");
                }
            }
        } else {
            throw new MalformedKeyringException("unsupported public key type: " + string);
        }
        return publicKeyEntry;
    }

    public final PublicKey getKey() {
        return this.key;
    }

    protected final void encodePayload() throws IOException {
        if (this.key instanceof DSSPublicKey) {
            this.properties.put("type", "RAW-DSS");
            IKeyPairCodec iKeyPairCodec = KeyPairCodecFactory.getInstance("dss");
            this.payload = iKeyPairCodec.encodePublicKey(this.key);
        } else if (this.key instanceof GnuRSAPublicKey) {
            this.properties.put("type", "RAW-RSA");
            IKeyPairCodec iKeyPairCodec = KeyPairCodecFactory.getInstance("rsa");
            this.payload = iKeyPairCodec.encodePublicKey(this.key);
        } else if (this.key instanceof GnuDHPublicKey) {
            this.properties.put("type", "RAW-DH");
            IKeyPairCodec iKeyPairCodec = KeyPairCodecFactory.getInstance("dh");
            this.payload = iKeyPairCodec.encodePublicKey(this.key);
        } else if (this.key.getFormat() != null && this.key.getFormat().equals("X.509")) {
            this.properties.put("type", "X.509");
            this.payload = this.key.getEncoded();
        } else {
            throw new IllegalArgumentException("cannot encode public key");
        }
    }

    public PublicKeyEntry(PublicKey publicKey, Date date, Properties properties) {
        super(6, date, properties);
        if (publicKey == null) {
            throw new IllegalArgumentException("no key specified");
        }
        this.key = publicKey;
    }

    private PublicKeyEntry() {
        super(6);
    }
}

