/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig.rsa;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.hash.IMessageDigest;
import gnu.java.security.sig.ISignature;
import gnu.java.security.sig.rsa.RSAPKCS1V1_5Signature;
import gnu.java.security.sig.rsa.RSAPSSSignature;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class RSASignatureFactory {
    private static Set names;

    public static final ISignature getInstance(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        if (!(string = string.toLowerCase()).startsWith("rsa-")) {
            return null;
        }
        if ((string = string.substring("rsa-".length()).trim()).startsWith("pss")) {
            return RSASignatureFactory.getPSSSignature(string);
        }
        if (string.startsWith("pkcs1-v1.5")) {
            return RSASignatureFactory.getPKCS1Signature(string);
        }
        return null;
    }

    public static final synchronized Set getNames() {
        if (names == null) {
            Set set = HashFactory.getNames();
            HashSet hashSet = new HashSet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                hashSet.add("rsa-pss-" + string);
            }
            hashSet.add("rsa-pkcs1-v1.5-md2");
            hashSet.add("rsa-pkcs1-v1.5-md5");
            hashSet.add("rsa-pkcs1-v1.5-sha-160");
            hashSet.add("rsa-pkcs1-v1.5-sha-256");
            hashSet.add("rsa-pkcs1-v1.5-sha-384");
            hashSet.add("rsa-pkcs1-v1.5-sha-512");
            names = Collections.unmodifiableSet(hashSet);
        }
        return names;
    }

    private static final ISignature getPSSSignature(String string) {
        IMessageDigest iMessageDigest;
        if ((string = string.substring("pss".length()).trim()).startsWith("-")) {
            string = string.substring(1).trim();
        }
        if (string.length() == 0) {
            iMessageDigest = HashFactory.getInstance("sha-160");
        } else {
            iMessageDigest = HashFactory.getInstance(string);
            if (iMessageDigest == null) {
                return null;
            }
        }
        RSAPSSSignature rSAPSSSignature = new RSAPSSSignature(iMessageDigest, 0);
        return rSAPSSSignature;
    }

    private static final ISignature getPKCS1Signature(String string) {
        IMessageDigest iMessageDigest;
        if ((string = string.substring("pkcs1-v1.5".length()).trim()).startsWith("-")) {
            string = string.substring(1).trim();
        }
        if (string.length() == 0) {
            iMessageDigest = HashFactory.getInstance("sha-160");
        } else {
            iMessageDigest = HashFactory.getInstance(string);
            if (iMessageDigest == null) {
                return null;
            }
        }
        RSAPKCS1V1_5Signature rSAPKCS1V1_5Signature = new RSAPKCS1V1_5Signature(iMessageDigest);
        return rSAPKCS1V1_5Signature;
    }

    private RSASignatureFactory() {
    }
}

