/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.pkcs;

import gnu.java.security.OID;
import gnu.java.security.ber.BER;
import gnu.java.security.ber.BEREncodingException;
import gnu.java.security.ber.BERReader;
import gnu.java.security.ber.BERValue;
import gnu.java.security.der.DERValue;
import java.io.IOException;
import java.math.BigInteger;
import javax.security.auth.x500.X500Principal;

public class SignerInfo {
    private static final boolean DEBUG = false;
    private final BigInteger version;
    private final BigInteger serialNumber;
    private final X500Principal issuer;
    private final OID digestAlgorithmId;
    private final byte[] digestAlgorithmParams;
    private final byte[] authenticatedAttributes;
    private final OID digestEncryptionAlgorithmId;
    private final byte[] digestEncryptionAlgorithmParams;
    private final byte[] encryptedDigest;
    private final byte[] unauthenticatedAttributes;

    private static final void debug(String string) {
        System.err.print("SignerInfo >> ");
        System.err.println(string);
    }

    public BigInteger getVersion() {
        return this.version;
    }

    public BigInteger getSerialNumber() {
        return this.serialNumber;
    }

    public X500Principal getIssuer() {
        return this.issuer;
    }

    public OID getDigestAlgorithmId() {
        return this.digestAlgorithmId;
    }

    public byte[] getDigestAlgorithmParams() {
        return this.digestAlgorithmParams != null ? (byte[])this.digestAlgorithmParams.clone() : null;
    }

    public byte[] getAuthenticatedAttributes() {
        return this.authenticatedAttributes != null ? (byte[])this.authenticatedAttributes.clone() : null;
    }

    public OID getDigestEncryptionAlgorithmId() {
        return this.digestEncryptionAlgorithmId;
    }

    public byte[] getDigestEncryptionAlgorithmParams() {
        return this.digestEncryptionAlgorithmParams != null ? (byte[])this.digestEncryptionAlgorithmParams.clone() : null;
    }

    public byte[] getEncryptedDigest() {
        return this.encryptedDigest != null ? (byte[])this.encryptedDigest.clone() : null;
    }

    public byte[] getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes != null ? (byte[])this.unauthenticatedAttributes.clone() : null;
    }

    public SignerInfo(BERReader bERReader) throws IOException {
        DERValue dERValue = bERReader.read();
        if (!dERValue.isConstructed()) {
            throw new BEREncodingException("malformed SignerInfo");
        }
        dERValue = bERReader.read();
        if (dERValue.getTag() != 2) {
            throw new BEREncodingException("malformed Version");
        }
        this.version = (BigInteger)dERValue.getValue();
        dERValue = bERReader.read();
        if (!dERValue.isConstructed()) {
            throw new BEREncodingException("malformed IssuerAndSerialNumber");
        }
        dERValue = bERReader.read();
        if (!dERValue.isConstructed()) {
            throw new BEREncodingException("malformed Issuer");
        }
        this.issuer = new X500Principal(dERValue.getEncoded());
        bERReader.skip(dERValue.getLength());
        dERValue = bERReader.read();
        if (dERValue.getTag() != 2) {
            throw new BEREncodingException("malformed SerialNumber");
        }
        this.serialNumber = (BigInteger)dERValue.getValue();
        dERValue = bERReader.read();
        if (!dERValue.isConstructed()) {
            throw new BEREncodingException("malformed DigestAlgorithmIdentifier");
        }
        boolean bl = false;
        DERValue dERValue2 = bERReader.read();
        if (dERValue2.getTag() != 6) {
            throw new BEREncodingException("malformed AlgorithmIdentifier");
        }
        this.digestAlgorithmId = (OID)dERValue2.getValue();
        if (BERValue.isIndefinite(dERValue)) {
            dERValue2 = bERReader.read();
            if (dERValue2 != BER.END_OF_SEQUENCE) {
                this.digestAlgorithmParams = dERValue2.getEncoded();
                dERValue2 = bERReader.read();
                if (dERValue2 != BER.END_OF_SEQUENCE) {
                    throw new BEREncodingException("expecting BER end-of-sequence");
                }
            } else {
                this.digestAlgorithmParams = null;
            }
        } else if (dERValue2.getEncodedLength() < dERValue.getLength()) {
            dERValue2 = bERReader.read();
            this.digestAlgorithmParams = dERValue2.getEncoded();
            if (dERValue2.isConstructed()) {
                bERReader.skip(dERValue2.getLength());
            }
        } else {
            this.digestAlgorithmParams = null;
        }
        dERValue = bERReader.read();
        if (dERValue.getTag() == 0) {
            this.authenticatedAttributes = dERValue.getEncoded();
            dERValue = bERReader.read();
            if (dERValue.isConstructed()) {
                bERReader.skip(dERValue.getLength());
            }
            dERValue = bERReader.read();
        } else {
            this.authenticatedAttributes = null;
        }
        if (!dERValue.isConstructed()) {
            throw new BEREncodingException("malformed DigestEncryptionAlgorithmIdentifier");
        }
        bl = false;
        dERValue2 = bERReader.read();
        if (dERValue2.getTag() != 6) {
            throw new BEREncodingException("malformed AlgorithmIdentifier");
        }
        this.digestEncryptionAlgorithmId = (OID)dERValue2.getValue();
        if (BERValue.isIndefinite(dERValue)) {
            dERValue2 = bERReader.read();
            if (dERValue2 != BER.END_OF_SEQUENCE) {
                this.digestEncryptionAlgorithmParams = dERValue2.getEncoded();
                dERValue2 = bERReader.read();
                if (dERValue2 != BER.END_OF_SEQUENCE) {
                    throw new BEREncodingException("expecting BER end-of-sequence");
                }
            } else {
                this.digestEncryptionAlgorithmParams = null;
            }
        } else if (dERValue2.getEncodedLength() < dERValue.getLength()) {
            dERValue2 = bERReader.read();
            this.digestEncryptionAlgorithmParams = dERValue2.getEncoded();
            if (dERValue2.isConstructed()) {
                bERReader.skip(dERValue2.getLength());
            }
        } else {
            this.digestEncryptionAlgorithmParams = null;
        }
        dERValue = bERReader.read();
        if (dERValue.getTag() != 4) {
            throw new BEREncodingException("malformed EncryptedDigest");
        }
        this.encryptedDigest = (byte[])dERValue.getValue();
        this.unauthenticatedAttributes = (byte[])(bERReader.peek() == 1 ? bERReader.read().getEncoded() : null);
        if (bERReader.peek() == 0) {
            bERReader.read();
        }
    }
}

