/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.key.dss;

import gnu.java.security.OID;
import gnu.java.security.der.BitString;
import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.der.DERWriter;
import gnu.java.security.key.IKeyPairCodec;
import gnu.java.security.key.dss.DSSPublicKey;
import gnu.java.security.util.DerUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;

public class DSSKeyPairX509Codec
implements IKeyPairCodec {
    private static final OID DSA_ALG_OID = new OID("1.2.840.10040.4.1");

    public int getFormatID() {
        return 2;
    }

    public byte[] encodePublicKey(PublicKey publicKey) {
        byte[] byArray;
        if (!(publicKey instanceof DSSPublicKey)) {
            throw new InvalidParameterException("key");
        }
        DERValue dERValue = new DERValue(6, DSA_ALG_OID);
        DSSPublicKey dSSPublicKey = (DSSPublicKey)publicKey;
        BigInteger bigInteger = dSSPublicKey.getParams().getP();
        BigInteger bigInteger2 = dSSPublicKey.getParams().getQ();
        BigInteger bigInteger3 = dSSPublicKey.getParams().getG();
        BigInteger bigInteger4 = dSSPublicKey.getY();
        DERValue dERValue2 = new DERValue(2, bigInteger);
        DERValue dERValue3 = new DERValue(2, bigInteger2);
        DERValue dERValue4 = new DERValue(2, bigInteger3);
        ArrayList arrayList = new ArrayList(3);
        arrayList.add(dERValue2);
        arrayList.add(dERValue3);
        arrayList.add(dERValue4);
        DERValue dERValue5 = new DERValue(48, arrayList);
        ArrayList arrayList2 = new ArrayList(2);
        arrayList2.add(dERValue);
        arrayList2.add(dERValue5);
        DERValue dERValue6 = new DERValue(48, arrayList2);
        DERValue dERValue7 = new DERValue(2, bigInteger4);
        byte[] byArray2 = dERValue7.getEncoded();
        DERValue dERValue8 = new DERValue(3, new BitString(byArray2));
        ArrayList arrayList3 = new ArrayList(2);
        arrayList3.add(dERValue6);
        arrayList3.add(dERValue8);
        DERValue dERValue9 = new DERValue(48, arrayList3);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DERWriter.write(byteArrayOutputStream, dERValue9);
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException();
            invalidParameterException.initCause(iOException);
            throw invalidParameterException;
        }
        return byArray;
    }

    public byte[] encodePrivateKey(PrivateKey privateKey) {
        throw new InvalidParameterException("Wrong format for private keys");
    }

    public PublicKey decodePublicKey(byte[] byArray) {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        BigInteger bigInteger3;
        BigInteger bigInteger4;
        if (byArray == null) {
            throw new InvalidParameterException("Input bytes MUST NOT be null");
        }
        DERReader dERReader = new DERReader(byArray);
        try {
            DERValue dERValue = dERReader.read();
            DerUtil.checkIsConstructed(dERValue, "Wrong SubjectPublicKeyInfo field");
            DERValue dERValue2 = dERReader.read();
            DerUtil.checkIsConstructed(dERValue2, "Wrong AlgorithmIdentifier field");
            DERValue dERValue3 = dERReader.read();
            if (!(dERValue3.getValue() instanceof OID)) {
                throw new InvalidParameterException("Wrong Algorithm field");
            }
            OID oID = (OID)dERValue3.getValue();
            if (!oID.equals(DSA_ALG_OID)) {
                throw new InvalidParameterException("Unexpected OID: " + oID);
            }
            DERValue dERValue4 = dERReader.read();
            DerUtil.checkIsConstructed(dERValue4, "Wrong DSS Parameters field");
            DERValue dERValue5 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue5, "Wrong P field");
            bigInteger4 = (BigInteger)dERValue5.getValue();
            dERValue5 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue5, "Wrong Q field");
            bigInteger3 = (BigInteger)dERValue5.getValue();
            dERValue5 = dERReader.read();
            DerUtil.checkIsBigInteger(dERValue5, "Wrong G field");
            bigInteger2 = (BigInteger)dERValue5.getValue();
            dERValue5 = dERReader.read();
            if (!(dERValue5.getValue() instanceof BitString)) {
                throw new InvalidParameterException("Wrong SubjectPublicKey field");
            }
            byte[] byArray2 = ((BitString)dERValue5.getValue()).toByteArray();
            DERReader dERReader2 = new DERReader(byArray2);
            dERValue5 = dERReader2.read();
            DerUtil.checkIsBigInteger(dERValue5, "Wrong Y field");
            bigInteger = (BigInteger)dERValue5.getValue();
        }
        catch (IOException iOException) {
            InvalidParameterException invalidParameterException = new InvalidParameterException();
            invalidParameterException.initCause(iOException);
            throw invalidParameterException;
        }
        return new DSSPublicKey(2, bigInteger4, bigInteger3, bigInteger2, bigInteger);
    }

    public PrivateKey decodePrivateKey(byte[] byArray) {
        throw new InvalidParameterException("Wrong format for private keys");
    }
}

