/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.lang.reflect.TypeSignature;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.lang.reflect.Method;
import java.security.MessageDigest;

public class RMIHashes {
    public static long getMethodHash(Method method) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(method.getName());
            stringBuffer.append('(');
            Class[] classArray = method.getParameterTypes();
            int n = 0;
            while (n < classArray.length) {
                stringBuffer.append(TypeSignature.getEncodingOfClass(classArray[n]));
                ++n;
            }
            stringBuffer.append(')');
            Class clazz = method.getReturnType();
            if (clazz != Void.TYPE) {
                stringBuffer.append(TypeSignature.getEncodingOfClass(clazz));
            } else {
                stringBuffer.append('V');
            }
            dataOutputStream.writeUTF(stringBuffer.toString());
            dataOutputStream.flush();
            dataOutputStream.close();
            messageDigest.update(byteArrayOutputStream.toByteArray());
            byte[] byArray = messageDigest.digest();
            long l = 0L;
            int n2 = byArray.length < 8 ? byArray.length : 8;
            int n3 = 0;
            while (n3 < n2) {
                l += (long)(byArray[n3] & 0xFF) << 8 * n3;
                ++n3;
            }
            return l;
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public static long getInterfaceHash(Class clazz) {
        return clazz.hashCode();
    }
}

