/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.ClasspathToolkit;
import gnu.java.awt.peer.gtk.GdkFontPeer;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;

public class GdkFontMetrics
extends FontMetrics {
    static final int FONT_METRICS_ASCENT = 0;
    static final int FONT_METRICS_MAX_ASCENT = 1;
    static final int FONT_METRICS_DESCENT = 2;
    static final int FONT_METRICS_MAX_DESCENT = 3;
    static final int FONT_METRICS_MAX_ADVANCE = 4;
    static final int TEXT_METRICS_X_BEARING = 0;
    static final int TEXT_METRICS_Y_BEARING = 1;
    static final int TEXT_METRICS_WIDTH = 2;
    static final int TEXT_METRICS_HEIGHT = 3;
    static final int TEXT_METRICS_X_ADVANCE = 4;
    static final int TEXT_METRICS_Y_ADVANCE = 5;
    private int[] font_metrics;
    GdkFontPeer peer;

    private static final Font initFont(Font font) {
        if (font == null) {
            return new Font("Dialog", 0, 12);
        }
        if (font.getPeer() instanceof GdkFontPeer) {
            return font;
        }
        ClasspathToolkit classpathToolkit = (ClasspathToolkit)Toolkit.getDefaultToolkit();
        return classpathToolkit.getFont(font.getName(), font.getAttributes());
    }

    public int stringWidth(String string) {
        double[] dArray = new double[6];
        this.peer.getTextMetrics(string, dArray);
        return (int)dArray[2];
    }

    public int charWidth(char c) {
        return this.stringWidth(new String(new char[]{c}));
    }

    public int charsWidth(char[] cArray, int n, int n2) {
        return this.stringWidth(new String(cArray, n, n2));
    }

    public int getLeading() {
        return 0;
    }

    public int getAscent() {
        return this.font_metrics[0];
    }

    public int getMaxAscent() {
        return this.font_metrics[1];
    }

    public int getDescent() {
        return this.font_metrics[2];
    }

    public int getMaxDescent() {
        return this.font_metrics[3];
    }

    public int getMaxAdvance() {
        return this.font_metrics[4];
    }

    public GdkFontMetrics(Font font) {
        super(GdkFontMetrics.initFont(font));
        this.peer = (GdkFontPeer)this.font.getPeer();
        this.font_metrics = new int[5];
        double[] dArray = new double[5];
        this.peer.getFontMetrics(dArray);
        int n = 0;
        while (n < 5) {
            this.font_metrics[n] = (int)dArray[n];
            ++n;
        }
    }
}

