/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.imap;

import gnu.inet.imap.IMAPConstants;
import gnu.inet.imap.IMAPException;
import gnu.inet.imap.IMAPResponse;
import gnu.inet.imap.IMAPResponseTokenizer;
import gnu.inet.imap.ListEntry;
import gnu.inet.imap.MailboxStatus;
import gnu.inet.imap.MessageSetTokenizer;
import gnu.inet.imap.MessageStatus;
import gnu.inet.imap.Namespaces;
import gnu.inet.imap.Quota;
import gnu.inet.imap.UIDPlusHandler;
import gnu.inet.imap.UTF7imap;
import gnu.inet.util.BASE64;
import gnu.inet.util.CRLFOutputStream;
import gnu.inet.util.EmptyX509TrustManager;
import gnu.inet.util.SaslCallbackHandler;
import gnu.inet.util.SaslCramMD5;
import gnu.inet.util.SaslInputStream;
import gnu.inet.util.SaslLogin;
import gnu.inet.util.SaslOutputStream;
import gnu.inet.util.SaslPlain;
import gnu.inet.util.TraceLevel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class IMAPConnection
implements IMAPConstants {
    public static final Logger logger = Logger.getLogger("gnu.inet.imap");
    public static final Level IMAP_TRACE = new TraceLevel("imap");
    protected static final String TAG_PREFIX = "A";
    protected static final String US_ASCII = "US-ASCII";
    protected static final int DEFAULT_PORT = 143;
    protected static final int DEFAULT_SSL_PORT = 993;
    protected Socket socket;
    protected IMAPResponseTokenizer in;
    protected CRLFOutputStream out;
    protected List asyncResponses;
    private List alerts;
    private int tagIndex;
    private boolean ansiDebug;

    public void setAnsiDebug(boolean bl) {
        this.ansiDebug = bl;
    }

    protected String newTag() {
        return TAG_PREFIX + ++this.tagIndex;
    }

    protected void sendCommand(String string, String string2) throws IOException {
        logger.log(IMAP_TRACE, "> " + string + ' ' + string2);
        this.out.write(string + ' ' + string2);
        this.out.writeln();
        this.out.flush();
    }

    protected boolean invokeSimpleCommand(String string) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        String string3 = this.newTag();
        this.sendCommand(string3, string);
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (string3.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string2 == "OK") {
                    return true;
                }
                if (string2 == "NO") {
                    return false;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    protected IMAPResponse readResponse() throws IOException {
        IMAPResponse iMAPResponse = this.in.next();
        if (iMAPResponse == null) {
            logger.log(IMAP_TRACE, "<EOF");
            throw new EOFException();
        }
        if (this.ansiDebug) {
            logger.log(IMAP_TRACE, "< " + iMAPResponse.toANSIString());
        } else {
            logger.log(IMAP_TRACE, "< " + iMAPResponse.toString());
        }
        return iMAPResponse;
    }

    private final void processAlerts(IMAPResponse iMAPResponse) {
        List list2 = iMAPResponse.getResponseCode();
        if (list2 != null && list2.contains("ALERT")) {
            this.alerts.add(iMAPResponse.getText());
        }
    }

    public boolean alertsPending() {
        boolean bl = false;
        if (this.alerts.size() > 0) {
            bl = true;
        }
        return bl;
    }

    public String[] getAlerts() {
        Object[] objectArray = new String[this.alerts.size()];
        this.alerts.toArray(objectArray);
        this.alerts.clear();
        return objectArray;
    }

    public List capability() throws IOException {
        String string;
        IMAPResponse iMAPResponse;
        String string2 = this.newTag();
        this.sendCommand(string2, "CAPABILITY");
        ArrayList arrayList = new ArrayList();
        block0: while (true) {
            iMAPResponse = this.readResponse();
            string = iMAPResponse.getID();
            if (string2.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string == "OK") {
                    if (arrayList.size() == 0) {
                        this.addTokens(arrayList, iMAPResponse.getText());
                    }
                    return arrayList;
                }
                throw new IMAPException(string, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            if (string == "CAPABILITY") {
                this.addTokens(arrayList, iMAPResponse.getText());
                continue;
            }
            if (string == "OK") {
                int n;
                List list2 = iMAPResponse.getResponseCode();
                int n2 = 0;
                if (list2 != null) {
                    n2 = list2.size();
                }
                if ((n = n2) > 0 && "CAPABILITY".equals(list2.get(0))) {
                    int n3 = 1;
                    while (true) {
                        if (n3 >= n) continue block0;
                        String string3 = (String)list2.get(n3);
                        if (!arrayList.contains(string3)) {
                            arrayList.add(string3);
                        }
                        ++n3;
                    }
                }
                this.asyncResponses.add(iMAPResponse);
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string, iMAPResponse.getText());
    }

    private final void addTokens(List list2, String string) {
        String string2;
        int n = 0;
        int n2 = string.indexOf(32);
        while (n2 != -1) {
            string2 = string.substring(n, n2);
            if (!list2.contains(string2)) {
                list2.add(string2);
            }
            n = n2 + 1;
            n2 = string.indexOf(32, n);
        }
        string2 = string.substring(n);
        if (string2.length() > 0 && !list2.contains(string2)) {
            list2.add(string2);
        }
    }

    public MailboxStatus noop() throws IOException {
        String string;
        IMAPResponse iMAPResponse;
        String string2 = this.newTag();
        this.sendCommand(string2, "NOOP");
        boolean bl = false;
        MailboxStatus mailboxStatus = new MailboxStatus();
        Iterator iterator = this.asyncResponses.iterator();
        while (true) {
            if (iterator.hasNext()) {
                iMAPResponse = (IMAPResponse)iterator.next();
                iterator.remove();
            } else {
                iMAPResponse = this.readResponse();
            }
            string = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            boolean bl2 = false;
            if (bl || this.updateMailboxStatus(mailboxStatus, string, iMAPResponse)) {
                bl2 = true;
            }
            bl = bl2;
        }
        if (string2.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string == "OK") {
                return bl ? mailboxStatus : null;
            }
            throw new IMAPException(string, iMAPResponse.getText());
        }
        throw new IMAPException(string, iMAPResponse.getText());
    }

    protected SSLSocketFactory getSSLSocketFactory(TrustManager trustManager) throws GeneralSecurityException {
        if (trustManager == null) {
            trustManager = new EmptyX509TrustManager();
        }
        SSLContext sSLContext = SSLContext.getInstance("TLS");
        TrustManager[] trustManagerArray = new TrustManager[]{trustManager};
        sSLContext.init(null, trustManagerArray, null);
        return sSLContext.getSocketFactory();
    }

    public boolean starttls() throws IOException {
        return this.starttls(new EmptyX509TrustManager());
    }

    /*
     * Exception decompiling
     */
    public boolean starttls(TrustManager var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[UNCONDITIONALDOLOOP]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean login(String string, String string2) throws IOException {
        return this.invokeSimpleCommand("LOGIN " + IMAPConnection.quote(string) + ' ' + IMAPConnection.quote(string2));
    }

    public boolean authenticate(String string, String string2, String string3) throws IOException {
        try {
            String[] stringArray = new String[]{string};
            SaslCallbackHandler saslCallbackHandler = new SaslCallbackHandler(string2, string3);
            HashMap hashMap = new HashMap();
            hashMap.put("gnu.crypto.sasl.username", string2);
            hashMap.put("gnu.crypto.sasl.password", string3);
            SaslClient saslClient = Sasl.createSaslClient(stringArray, null, "imap", this.socket.getInetAddress().getHostName(), hashMap, saslCallbackHandler);
            if (saslClient == null) {
                if ("LOGIN".equalsIgnoreCase(string)) {
                    saslClient = new SaslLogin(string2, string3);
                } else if ("PLAIN".equalsIgnoreCase(string)) {
                    saslClient = new SaslPlain(string2, string3);
                } else if ("CRAM-MD5".equalsIgnoreCase(string)) {
                    saslClient = new SaslCramMD5(string2, string3);
                } else {
                    logger.log(IMAP_TRACE, string + " not available");
                    return false;
                }
            }
            StringBuffer stringBuffer = new StringBuffer("AUTHENTICATE");
            stringBuffer.append(' ');
            stringBuffer.append(string);
            String string4 = this.newTag();
            this.sendCommand(string4, stringBuffer.toString());
            while (true) {
                Object object;
                Object object2;
                Object object3;
                Object object4;
                IMAPResponse iMAPResponse;
                if (string4.equals((iMAPResponse = this.readResponse()).getTag())) {
                    this.processAlerts(iMAPResponse);
                    object4 = iMAPResponse.getID();
                    if (object4 == "OK") {
                        object3 = (String)saslClient.getNegotiatedProperty("javax.security.sasl.qop");
                        if ("auth-int".equalsIgnoreCase((String)object3) || "auth-conf".equalsIgnoreCase((String)object3)) {
                            object2 = this.socket.getInputStream();
                            object2 = new BufferedInputStream((InputStream)object2);
                            object2 = new SaslInputStream(saslClient, (InputStream)object2);
                            this.in = new IMAPResponseTokenizer((InputStream)object2);
                            object = this.socket.getOutputStream();
                            object = new BufferedOutputStream((OutputStream)object);
                            object = new SaslOutputStream(saslClient, (OutputStream)object);
                            this.out = new CRLFOutputStream((OutputStream)object);
                        }
                        return true;
                    }
                    if (object4 == "NO") {
                        return false;
                    }
                    if (object4 != "BAD") continue;
                    throw new IMAPException((String)object4, iMAPResponse.getText());
                }
                if (iMAPResponse.isContinuation()) {
                    try {
                        object4 = iMAPResponse.getText().getBytes(US_ASCII);
                        object3 = BASE64.decode((byte[])object4);
                        object2 = saslClient.evaluateChallenge((byte[])object3);
                        object = BASE64.encode(object2);
                        this.out.write((byte[])object);
                        this.out.writeln();
                        this.out.flush();
                        logger.log(IMAP_TRACE, "> " + new String((byte[])object, US_ASCII));
                    }
                    catch (SaslException saslException) {
                        this.out.write(42);
                        this.out.writeln();
                        this.out.flush();
                        logger.log(IMAP_TRACE, "> *");
                    }
                    continue;
                }
                this.asyncResponses.add(iMAPResponse);
            }
        }
        catch (SaslException saslException) {
            logger.log(IMAP_TRACE, saslException.getMessage(), saslException);
            return false;
        }
        catch (RuntimeException runtimeException) {
            logger.log(IMAP_TRACE, runtimeException.getMessage(), runtimeException);
            return false;
        }
    }

    public void logout() throws IOException {
        String string = this.newTag();
        this.sendCommand(string, "LOGOUT");
        while (true) {
            IMAPResponse iMAPResponse;
            if ((iMAPResponse = this.readResponse()).isTagged() && string.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                String string2 = iMAPResponse.getID();
                if (string2 == "OK") {
                    this.socket.close();
                    return;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            this.asyncResponses.add(iMAPResponse);
        }
    }

    public MailboxStatus select(String string) throws IOException {
        return this.selectImpl(string, "SELECT");
    }

    public MailboxStatus examine(String string) throws IOException {
        return this.selectImpl(string, "EXAMINE");
    }

    protected MailboxStatus selectImpl(String string, String string2) throws IOException {
        String string3;
        IMAPResponse iMAPResponse;
        String string4 = this.newTag();
        this.sendCommand(string4, string2 + ' ' + IMAPConnection.quote(UTF7imap.encode(string)));
        MailboxStatus mailboxStatus = new MailboxStatus();
        while (true) {
            iMAPResponse = this.readResponse();
            string3 = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            if (this.updateMailboxStatus(mailboxStatus, string3, iMAPResponse)) continue;
            this.asyncResponses.add(iMAPResponse);
        }
        if (string4.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string3 == "OK") {
                List list2 = iMAPResponse.getResponseCode();
                if (list2 != null && list2.size() > 0 && list2.get(0) == "READ-WRITE") {
                    mailboxStatus.readWrite = true;
                }
                return mailboxStatus;
            }
            throw new IMAPException(string3, iMAPResponse.getText());
        }
        throw new IMAPException(string3, iMAPResponse.getText());
    }

    /*
     * Unable to fully structure code
     */
    protected boolean updateMailboxStatus(MailboxStatus var1_1, String var2_2, IMAPResponse var3_3) throws IOException {
        if (var2_2 == "OK") {
            var4_4 = false;
            var5_5 = var3_3.getResponseCode();
            v0 = 0;
            if (var5_5 != null) {
                v0 = var5_5.size();
            }
            var6_6 = v0;
            var7_7 = 0;
            while (var7_7 < var6_6) {
                var8_8 = var5_5.get(var7_7);
                if (var8_8 instanceof String) {
                    var9_9 = (String)var8_8;
                    if (var7_7 + 1 < var6_6) {
                        var10_10 = var5_5.get(var7_7 + 1);
                        if (var10_10 instanceof String) {
                            var11_11 = (String)var10_10;
                            try {
                                if (var9_9 == "UNSEEN") {
                                    var1_1.firstUnreadMessage = Integer.parseInt(var11_11);
                                    ++var7_7;
                                    var4_4 = true;
                                }
                                if (var9_9 != "UIDVALIDITY") ** GOTO lbl34
                                var1_1.uidValidity = Integer.parseInt(var11_11);
                                ++var7_7;
                                var4_4 = true;
                            }
                            catch (NumberFormatException var12_12) {
                                throw new ProtocolException("Illegal " + var9_9 + " value: " + var11_11);
                            }
                        } else if (var10_10 instanceof List && var9_9 == "PERMANENTFLAGS") {
                            var1_1.permanentFlags = (List)var10_10;
                            ++var7_7;
                            var4_4 = true;
                        }
                    }
                }
lbl34:
                // 10 sources

                ++var7_7;
            }
            return var4_4;
        }
        if (var2_2 == "EXISTS") {
            var1_1.messageCount = var3_3.getCount();
            return true;
        }
        if (var2_2 == "RECENT") {
            var1_1.newMessageCount = var3_3.getCount();
            return true;
        }
        if (var2_2 == "FLAGS") {
            var1_1.flags = var3_3.getResponseCode();
            return true;
        }
        return false;
    }

    public boolean create(String string) throws IOException {
        return this.invokeSimpleCommand("CREATE " + IMAPConnection.quote(UTF7imap.encode(string)));
    }

    public boolean delete(String string) throws IOException {
        return this.invokeSimpleCommand("DELETE " + IMAPConnection.quote(UTF7imap.encode(string)));
    }

    public boolean rename(String string, String string2) throws IOException {
        return this.invokeSimpleCommand("RENAME " + IMAPConnection.quote(UTF7imap.encode(string)) + ' ' + IMAPConnection.quote(UTF7imap.encode(string2)));
    }

    public boolean subscribe(String string) throws IOException {
        return this.invokeSimpleCommand("SUBSCRIBE " + IMAPConnection.quote(UTF7imap.encode(string)));
    }

    public boolean unsubscribe(String string) throws IOException {
        return this.invokeSimpleCommand("UNSUBSCRIBE " + IMAPConnection.quote(UTF7imap.encode(string)));
    }

    public ListEntry[] list(String string, String string2) throws IOException {
        return this.listImpl("LIST", string, string2);
    }

    public ListEntry[] lsub(String string, String string2) throws IOException {
        return this.listImpl("LSUB", string, string2);
    }

    protected ListEntry[] listImpl(String string, String string2, String string3) throws IOException {
        Object[] objectArray;
        String string4;
        IMAPResponse iMAPResponse;
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null) {
            string3 = "";
        }
        String string5 = this.newTag();
        this.sendCommand(string5, string + ' ' + IMAPConnection.quote(UTF7imap.encode(string2)) + ' ' + IMAPConnection.quote(UTF7imap.encode(string3)));
        ArrayList arrayList = new ArrayList();
        while (true) {
            iMAPResponse = this.readResponse();
            string4 = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            if (string4.equals(string)) {
                objectArray = iMAPResponse.getResponseCode();
                String string6 = iMAPResponse.getText();
                int n = 0;
                if (objectArray != null) {
                    n = objectArray.size();
                }
                int n2 = n;
                boolean bl = false;
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                int n3 = 0;
                while (n3 < n2) {
                    String string7 = (String)objectArray.get(n3);
                    if (string7.equalsIgnoreCase("\\Noinferiors")) {
                        bl = true;
                    } else if (string7.equalsIgnoreCase("\\Noselect")) {
                        bl2 = true;
                    } else if (string7.equalsIgnoreCase("\\Marked")) {
                        bl3 = true;
                    } else if (string7.equalsIgnoreCase("\\Unmarked")) {
                        bl4 = true;
                    }
                    ++n3;
                }
                n3 = string6.indexOf(32);
                char c = '\u0000';
                String string8 = string6.substring(0, n3);
                if (!string8.equalsIgnoreCase("NIL")) {
                    c = IMAPConnection.stripQuotes(string8).charAt(0);
                }
                String string9 = IMAPConnection.stripQuotes(string6.substring(n3 + 1));
                string9 = UTF7imap.decode(string9);
                ListEntry listEntry = new ListEntry(string9, c, bl, bl2, bl3, bl4);
                arrayList.add(listEntry);
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        if (string5.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string4 == "OK") {
                objectArray = new ListEntry[arrayList.size()];
                arrayList.toArray(objectArray);
                return objectArray;
            }
            throw new IMAPException(string4, iMAPResponse.getText());
        }
        throw new IMAPException(string4, iMAPResponse.getText());
    }

    public MailboxStatus status(String string, String[] stringArray) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        String string3 = this.newTag();
        StringBuffer stringBuffer = new StringBuffer("STATUS").append(' ').append(IMAPConnection.quote(UTF7imap.encode(string))).append(' ').append('(');
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        stringBuffer.append(')');
        this.sendCommand(string3, stringBuffer.toString());
        MailboxStatus mailboxStatus = new MailboxStatus();
        block3: while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            if (string2 == "STATUS") {
                List list2 = iMAPResponse.getResponseCode();
                int n2 = 0;
                if (list2 != null) {
                    n2 = list2.size() - 1;
                }
                int n3 = n2;
                int n4 = 0;
                while (true) {
                    if (n4 >= n3) continue block3;
                    try {
                        String string4 = ((String)list2.get(n4)).intern();
                        int n5 = Integer.parseInt((String)list2.get(n4 + 1));
                        if (string4 == "MESSAGES") {
                            mailboxStatus.messageCount = n5;
                        } else if (string4 == "RECENT") {
                            mailboxStatus.newMessageCount = n5;
                        } else if (string4 == "UIDNEXT") {
                            mailboxStatus.uidNext = n5;
                        } else if (string4 == "UIDVALIDITY") {
                            mailboxStatus.uidValidity = n5;
                        } else if (string4 == "UNSEEN") {
                            mailboxStatus.firstUnreadMessage = n5;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IMAPException(string2, "Invalid code: " + list2);
                    }
                    n4 += 2;
                }
            }
            this.asyncResponses.add(iMAPResponse);
        }
        if (string3.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string2 == "OK") {
                return mailboxStatus;
            }
            throw new IMAPException(string2, iMAPResponse.getText());
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    public boolean append(String string, String[] stringArray, byte[] byArray) throws IOException {
        return this.append(string, stringArray, byArray, null);
    }

    public boolean append(String string, String[] stringArray, byte[] byArray, UIDPlusHandler uIDPlusHandler) throws IOException {
        String string2;
        String string3 = this.newTag();
        StringBuffer stringBuffer = new StringBuffer("APPEND").append(' ').append(IMAPConnection.quote(UTF7imap.encode(string))).append(' ');
        if (stringArray != null) {
            stringBuffer.append('(');
            int n = 0;
            while (n < stringArray.length) {
                if (n > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(stringArray[n]);
                ++n;
            }
            stringBuffer.append(')');
            stringBuffer.append(' ');
        }
        stringBuffer.append('{');
        stringBuffer.append(byArray.length);
        stringBuffer.append('}');
        this.sendCommand(string3, stringBuffer.toString());
        IMAPResponse iMAPResponse = this.readResponse();
        if (!iMAPResponse.isContinuation()) {
            throw new IMAPException(iMAPResponse.getID(), iMAPResponse.getText());
        }
        this.out.write(byArray);
        this.out.writeln();
        this.out.flush();
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (string3.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string2 == "OK") {
                    if (uIDPlusHandler != null) {
                        this.processUIDPlus(iMAPResponse.getResponseCode(), uIDPlusHandler);
                    }
                    return true;
                }
                if (string2 == "NO") {
                    return false;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    void processUIDPlus(List list2, UIDPlusHandler uIDPlusHandler) {
        int n = list2.size();
        int n2 = 0;
        while (n2 < n) {
            Object object = list2.get(n2);
            if (object instanceof String) {
                long l;
                if ("APPENDUID".equals(object) && n2 < n - 2) {
                    l = Long.parseLong((String)list2.get(n2 + 1));
                    long l2 = Long.parseLong((String)list2.get(n2 + 2));
                    uIDPlusHandler.appenduid(l, l2);
                } else if ("COPYUID".equals(object) && n2 < n - 3) {
                    l = Long.parseLong((String)list2.get(n2 + 1));
                    MessageSetTokenizer messageSetTokenizer = new MessageSetTokenizer((String)list2.get(n2 + 2));
                    MessageSetTokenizer messageSetTokenizer2 = new MessageSetTokenizer((String)list2.get(n2 + 3));
                    while (messageSetTokenizer.hasNext()) {
                        long l3 = (Long)messageSetTokenizer.next();
                        long l4 = (Long)messageSetTokenizer2.next();
                        uIDPlusHandler.copyuid(l, l3, l4);
                    }
                }
            } else {
                this.processUIDPlus((List)object, uIDPlusHandler);
            }
            ++n2;
        }
    }

    public void check() throws IOException {
        this.invokeSimpleCommand("CHECK");
    }

    public boolean close() throws IOException {
        return this.invokeSimpleCommand("CLOSE");
    }

    public int[] expunge() throws IOException {
        String string;
        IMAPResponse iMAPResponse;
        String string2 = this.newTag();
        this.sendCommand(string2, "EXPUNGE");
        ArrayList arrayList = new ArrayList();
        while (true) {
            iMAPResponse = this.readResponse();
            string = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            if (string == "EXPUNGE") {
                arrayList.add(new Integer(iMAPResponse.getCount()));
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        if (string2.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string == "OK") {
                int n = arrayList.size();
                int[] nArray = new int[n];
                int n2 = 0;
                while (n2 < n) {
                    nArray[n2] = (Integer)arrayList.get(n2);
                    ++n2;
                }
                return nArray;
            }
            throw new IMAPException(string, iMAPResponse.getText());
        }
        throw new IMAPException(string, iMAPResponse.getText());
    }

    public int[] search(String string, String[] stringArray) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        String string3 = this.newTag();
        StringBuffer stringBuffer = new StringBuffer("SEARCH");
        stringBuffer.append(' ');
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append(' ');
        }
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        this.sendCommand(string3, stringBuffer.toString());
        ArrayList arrayList = new ArrayList();
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            if (string2 == "SEARCH") {
                String string4 = iMAPResponse.getText();
                if (string4 == null) continue;
                try {
                    int n2 = string4.indexOf(32);
                    while (n2 != -1) {
                        arrayList.add(new Integer(string4.substring(0, n2)));
                        string4 = string4.substring(n2 + 1);
                        n2 = string4.indexOf(32);
                    }
                    arrayList.add(new Integer(string4));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IMAPException(string2, "Expecting number: " + string4);
                }
            }
            this.asyncResponses.add(iMAPResponse);
        }
        if (string3.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string2 == "OK") {
                int n3 = arrayList.size();
                int[] nArray = new int[n3];
                int n4 = 0;
                while (n4 < n3) {
                    nArray[n4] = (Integer)arrayList.get(n4);
                    ++n4;
                }
                return nArray;
            }
            throw new IMAPException(string2, iMAPResponse.getText());
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    public MessageStatus fetch(int n, String[] stringArray) throws IOException {
        String string = n == -1 ? "*" : Integer.toString(n);
        return this.fetchImpl("FETCH", string, stringArray)[0];
    }

    public MessageStatus[] fetch(int n, int n2, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n == -1 ? 42 : n);
        stringBuffer.append(':');
        stringBuffer.append(n2 == -1 ? 42 : n2);
        return this.fetchImpl("FETCH", stringBuffer.toString(), stringArray);
    }

    public MessageStatus[] fetch(int[] nArray, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(nArray[n]);
            ++n;
        }
        return this.fetchImpl("FETCH", stringBuffer.toString(), stringArray);
    }

    public MessageStatus uidFetch(long l, String[] stringArray) throws IOException {
        String string = l == (long)-1 ? "*" : Long.toString(l);
        return this.fetchImpl("UID FETCH", string, stringArray)[0];
    }

    public MessageStatus[] uidFetch(long l, long l2, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(l == (long)-1 ? 42L : l);
        stringBuffer.append(':');
        stringBuffer.append(l2 == (long)-1 ? 42L : l2);
        return this.fetchImpl("UID FETCH", stringBuffer.toString(), stringArray);
    }

    public MessageStatus[] uidFetch(long[] lArray, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < lArray.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(lArray[n]);
            ++n;
        }
        return this.fetchImpl("UID FETCH", stringBuffer.toString(), stringArray);
    }

    private final MessageStatus[] fetchImpl(String string, String string2, String[] stringArray) throws IOException {
        String string3;
        IMAPResponse iMAPResponse;
        String string4 = this.newTag();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        stringBuffer.append(string2);
        stringBuffer.append(' ');
        stringBuffer.append('(');
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        stringBuffer.append(')');
        this.sendCommand(string4, stringBuffer.toString());
        ArrayList arrayList = new ArrayList();
        while (true) {
            iMAPResponse = this.readResponse();
            string3 = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            if (string3 == "FETCH") {
                int n2 = iMAPResponse.getCount();
                List list2 = iMAPResponse.getResponseCode();
                MessageStatus messageStatus = new MessageStatus(n2, list2);
                arrayList.add(messageStatus);
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        if (string4.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string3 == "OK") {
                Object[] objectArray = new MessageStatus[arrayList.size()];
                arrayList.toArray(objectArray);
                return objectArray;
            }
            throw new IMAPException(string3, iMAPResponse.getText());
        }
        throw new IMAPException(string3, iMAPResponse.getText());
    }

    public MessageStatus store(int n, String string, String[] stringArray) throws IOException {
        String string2 = n == -1 ? "*" : Integer.toString(n);
        return this.storeImpl("STORE", string2, string, stringArray)[0];
    }

    public MessageStatus[] store(int n, int n2, String string, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(n == -1 ? 42 : n);
        stringBuffer.append(':');
        stringBuffer.append(n2 == -1 ? 42 : n2);
        return this.storeImpl("STORE", stringBuffer.toString(), string, stringArray);
    }

    public MessageStatus[] store(int[] nArray, String string, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(nArray[n]);
            ++n;
        }
        return this.storeImpl("STORE", stringBuffer.toString(), string, stringArray);
    }

    public MessageStatus uidStore(long l, String string, String[] stringArray) throws IOException {
        String string2 = l == (long)-1 ? "*" : Long.toString(l);
        return this.storeImpl("UID STORE", string2, string, stringArray)[0];
    }

    public MessageStatus[] uidStore(long l, long l2, String string, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(l == (long)-1 ? 42L : l);
        stringBuffer.append(':');
        stringBuffer.append(l2 == (long)-1 ? 42L : l2);
        return this.storeImpl("UID STORE", stringBuffer.toString(), string, stringArray);
    }

    public MessageStatus[] uidStore(long[] lArray, String string, String[] stringArray) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < lArray.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(lArray[n]);
            ++n;
        }
        return this.storeImpl("UID STORE", stringBuffer.toString(), string, stringArray);
    }

    private final MessageStatus[] storeImpl(String string, String string2, String string3, String[] stringArray) throws IOException {
        String string4;
        IMAPResponse iMAPResponse;
        String string5 = this.newTag();
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(' ');
        stringBuffer.append(string2);
        stringBuffer.append(' ');
        stringBuffer.append(string3);
        stringBuffer.append(' ');
        stringBuffer.append('(');
        int n = 0;
        while (n < stringArray.length) {
            if (n > 0) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(stringArray[n]);
            ++n;
        }
        stringBuffer.append(')');
        this.sendCommand(string5, stringBuffer.toString());
        ArrayList arrayList = new ArrayList();
        while (true) {
            Object object;
            iMAPResponse = this.readResponse();
            string4 = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            int n2 = iMAPResponse.getCount();
            List list2 = iMAPResponse.getResponseCode();
            if (string4 == "FETCH") {
                object = new MessageStatus(n2, list2);
                arrayList.add(object);
                continue;
            }
            if (string4 == "FETCH FLAGS") {
                object = new ArrayList();
                object.add("FLAGS");
                object.add(list2);
                MessageStatus messageStatus = new MessageStatus(n2, (List)object);
                arrayList.add(messageStatus);
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        if (string5.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string4 == "OK") {
                Object[] objectArray = new MessageStatus[arrayList.size()];
                arrayList.toArray(objectArray);
                return objectArray;
            }
            throw new IMAPException(string4, iMAPResponse.getText());
        }
        throw new IMAPException(string4, iMAPResponse.getText());
    }

    public boolean copy(int[] nArray, String string) throws IOException {
        return this.copy(nArray, string, null);
    }

    public boolean copy(int[] nArray, String string, UIDPlusHandler uIDPlusHandler) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        if (nArray == null || nArray.length < 1) {
            return true;
        }
        StringBuffer stringBuffer = new StringBuffer("COPY").append(' ');
        int n = 0;
        while (n < nArray.length) {
            if (n > 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(nArray[n]);
            ++n;
        }
        stringBuffer.append(' ').append(IMAPConnection.quote(UTF7imap.encode(string)));
        String string3 = this.newTag();
        this.sendCommand(string3, stringBuffer.toString());
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (string3.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string2 == "OK") {
                    if (uIDPlusHandler != null) {
                        this.processUIDPlus(iMAPResponse.getResponseCode(), uIDPlusHandler);
                    }
                    return true;
                }
                if (string2 == "NO") {
                    return false;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    public Namespaces namespace() throws IOException {
        String string;
        IMAPResponse iMAPResponse;
        String string2 = this.newTag();
        this.sendCommand(string2, "NAMESPACE");
        Namespaces namespaces = null;
        while (true) {
            iMAPResponse = this.readResponse();
            string = iMAPResponse.getID();
            if (string2.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string == "OK") {
                    return namespaces;
                }
                throw new IMAPException(string, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            if ("NAMESPACE".equals(iMAPResponse.getID())) {
                namespaces = new Namespaces(iMAPResponse.getText());
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string, iMAPResponse.getText());
    }

    public boolean setacl(String string, String string2, int n) throws IOException {
        String string3 = "SETACL " + IMAPConnection.quote(UTF7imap.encode(string)) + ' ' + UTF7imap.encode(string2) + ' ' + this.rightsToString(n);
        return this.invokeSimpleCommand(string3);
    }

    public boolean deleteacl(String string, String string2) throws IOException {
        String string3 = "DELETEACL " + IMAPConnection.quote(UTF7imap.encode(string)) + ' ' + UTF7imap.encode(string2);
        return this.invokeSimpleCommand(string3);
    }

    public Map getacl(String string) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        String string3 = this.newTag();
        this.sendCommand(string3, "GETACL " + IMAPConnection.quote(UTF7imap.encode(string)));
        TreeMap treeMap = new TreeMap();
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (string3.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string2 == "OK") {
                    return treeMap;
                }
                if (string2 == "NO") {
                    return null;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            if ("ACL".equals(iMAPResponse.getID())) {
                String string4 = iMAPResponse.getText();
                List list2 = this.parseACL(string4, 1);
                String string5 = (String)list2.get(2);
                treeMap.put(list2.get(1), new Integer(this.stringToRights(string5)));
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    public int listrights(String string, String string2) throws IOException {
        String string3;
        IMAPResponse iMAPResponse;
        String string4 = this.newTag();
        String string5 = "LISTRIGHTS " + IMAPConnection.quote(UTF7imap.encode(string)) + ' ' + UTF7imap.encode(string2);
        this.sendCommand(string4, string5);
        int n = -1;
        while (true) {
            iMAPResponse = this.readResponse();
            string3 = iMAPResponse.getID();
            if (string4.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string3 == "OK") {
                    return n;
                }
                if (string3 == "NO") {
                    return -1;
                }
                throw new IMAPException(string3, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            if ("LISTRIGHTS".equals(iMAPResponse.getID())) {
                String string6 = iMAPResponse.getText();
                List list2 = this.parseACL(string6, 1);
                n = this.stringToRights((String)list2.get(2));
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string3, iMAPResponse.getText());
    }

    public int myrights(String string) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        String string3 = this.newTag();
        String string4 = "MYRIGHTS " + IMAPConnection.quote(UTF7imap.encode(string));
        this.sendCommand(string3, string4);
        int n = -1;
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (string3.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string2 == "OK") {
                    return n;
                }
                if (string2 == "NO") {
                    return -1;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            if ("MYRIGHTS".equals(iMAPResponse.getID())) {
                String string5 = iMAPResponse.getText();
                List list2 = this.parseACL(string5, 0);
                n = this.stringToRights((String)list2.get(2));
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    private final String rightsToString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        if ((n & 1) != 0) {
            stringBuffer.append('l');
        }
        if ((n & 2) != 0) {
            stringBuffer.append('r');
        }
        if ((n & 4) != 0) {
            stringBuffer.append('s');
        }
        if ((n & 8) != 0) {
            stringBuffer.append('w');
        }
        if ((n & 0x10) != 0) {
            stringBuffer.append('i');
        }
        if ((n & 0x20) != 0) {
            stringBuffer.append('p');
        }
        if ((n & 0x40) != 0) {
            stringBuffer.append('c');
        }
        if ((n & 0x80) != 0) {
            stringBuffer.append('d');
        }
        if ((n & 0x100) != 0) {
            stringBuffer.append('a');
        }
        return stringBuffer.toString();
    }

    private final int stringToRights(String string) {
        int n = 0;
        int n2 = string.length();
        int n3 = 0;
        while (n3 < n2) {
            switch (string.charAt(n3)) {
                case 'l': {
                    n |= 1;
                    break;
                }
                case 'r': {
                    n |= 2;
                    break;
                }
                case 's': {
                    n |= 4;
                    break;
                }
                case 'w': {
                    n |= 8;
                    break;
                }
                case 'i': {
                    n |= 0x10;
                    break;
                }
                case 'p': {
                    n |= 0x20;
                    break;
                }
                case 'c': {
                    n |= 0x40;
                    break;
                }
                case 'd': {
                    n |= 0x80;
                    break;
                }
                case 'a': {
                    n |= 0x100;
                    break;
                }
            }
            ++n3;
        }
        return n;
    }

    private final List parseACL(String string, int n) {
        int n2 = string.length();
        boolean bl = false;
        ArrayList arrayList = new ArrayList();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (n3 < n2) {
            char c = string.charAt(n3);
            switch (c) {
                case '\"': {
                    bl ^= true;
                    break;
                }
                case ' ': {
                    if (bl || arrayList.size() > n) {
                        stringBuffer.append(c);
                        break;
                    }
                    arrayList.add(UTF7imap.decode(stringBuffer.toString()));
                    stringBuffer.setLength(0);
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n3;
        }
        arrayList.add(stringBuffer.toString());
        return arrayList;
    }

    public Quota setquota(String string, Quota.Resource[] resourceArray) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        StringBuffer stringBuffer = new StringBuffer();
        if (resourceArray != null) {
            int n = 0;
            while (n < resourceArray.length) {
                if (n > 0) {
                    stringBuffer.append(' ');
                }
                stringBuffer.append(resourceArray[n].toString());
                ++n;
            }
        }
        String string3 = this.newTag();
        String string4 = "SETQUOTA " + IMAPConnection.quote(UTF7imap.encode(string)) + ' ' + stringBuffer.toString();
        this.sendCommand(string3, string4);
        Quota quota = null;
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (string3.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string2 == "OK") {
                    return quota;
                }
                if (string2 == "NO") {
                    return null;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            if ("QUOTA".equals(iMAPResponse.getID())) {
                quota = new Quota(iMAPResponse.getText());
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    public Quota getquota(String string) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        String string3 = this.newTag();
        String string4 = "GETQUOTA " + IMAPConnection.quote(UTF7imap.encode(string));
        this.sendCommand(string3, string4);
        Quota quota = null;
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (string3.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string2 == "OK") {
                    return quota;
                }
                if (string2 == "NO") {
                    return null;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            if ("QUOTA".equals(iMAPResponse.getID())) {
                quota = new Quota(iMAPResponse.getText());
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    public Quota[] getquotaroot(String string) throws IOException {
        String string2;
        IMAPResponse iMAPResponse;
        String string3 = this.newTag();
        String string4 = "GETQUOTAROOT " + IMAPConnection.quote(UTF7imap.encode(string));
        this.sendCommand(string3, string4);
        ArrayList arrayList = new ArrayList();
        while (true) {
            iMAPResponse = this.readResponse();
            string2 = iMAPResponse.getID();
            if (string3.equals(iMAPResponse.getTag())) {
                this.processAlerts(iMAPResponse);
                if (string2 == "OK") {
                    Object[] objectArray = new Quota[arrayList.size()];
                    arrayList.toArray(objectArray);
                    return objectArray;
                }
                if (string2 == "NO") {
                    return null;
                }
                throw new IMAPException(string2, iMAPResponse.getText());
            }
            if (!iMAPResponse.isUntagged()) break;
            if ("QUOTA".equals(iMAPResponse.getID())) {
                arrayList.add(new Quota(iMAPResponse.getText()));
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        throw new IMAPException(string2, iMAPResponse.getText());
    }

    public int[] uidExpunge(long l, long l2) throws IOException {
        String string;
        IMAPResponse iMAPResponse;
        String string2 = this.newTag();
        StringBuffer stringBuffer = new StringBuffer("UID EXPUNGE");
        stringBuffer.append(' ');
        stringBuffer.append(l);
        stringBuffer.append(':');
        stringBuffer.append(l2);
        this.sendCommand(string2, stringBuffer.toString());
        ArrayList arrayList = new ArrayList();
        while (true) {
            iMAPResponse = this.readResponse();
            string = iMAPResponse.getID();
            if (!iMAPResponse.isUntagged()) break;
            if (string == "EXPUNGE") {
                arrayList.add(new Integer(iMAPResponse.getCount()));
                continue;
            }
            this.asyncResponses.add(iMAPResponse);
        }
        if (string2.equals(iMAPResponse.getTag())) {
            this.processAlerts(iMAPResponse);
            if (string == "OK") {
                int n = arrayList.size();
                int[] nArray = new int[n];
                int n2 = 0;
                while (n2 < n) {
                    nArray[n2] = (Integer)arrayList.get(n2);
                    ++n2;
                }
                return nArray;
            }
            throw new IMAPException(string, iMAPResponse.getText());
        }
        throw new IMAPException(string, iMAPResponse.getText());
    }

    static String stripQuotes(String string) {
        int n;
        if (string.charAt(0) == '\"' && string.charAt((n = string.length()) - 1) == '\"') {
            return string.substring(1, n - 1);
        }
        return string;
    }

    static String quote(String string) {
        if (string.length() == 0 || string.indexOf(32) != -1) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append('\"');
            stringBuffer.append(string);
            stringBuffer.append('\"');
            return stringBuffer.toString();
        }
        return string;
    }

    private final /* synthetic */ void this() {
        this.tagIndex = 0;
        this.ansiDebug = false;
    }

    public IMAPConnection(String string) throws UnknownHostException, IOException {
        this(string, -1, 0, 0, false, null);
    }

    public IMAPConnection(String string, int n) throws UnknownHostException, IOException {
        this(string, n, 0, 0, false, null);
    }

    public IMAPConnection(String string, int n, int n2, int n3) throws UnknownHostException, IOException {
        this(string, n, n2, n3, false, null);
    }

    public IMAPConnection(String string, int n, TrustManager trustManager) throws UnknownHostException, IOException {
        this(string, n, 0, 0, true, trustManager);
    }

    public IMAPConnection(String string, int n, int n2, int n3, boolean bl, TrustManager trustManager) throws UnknownHostException, IOException {
        Object object;
        Object object2;
        this.this();
        if (n < 0) {
            n = bl ? 993 : 143;
        }
        try {
            this.socket = new Socket();
            object2 = new InetSocketAddress(string, n);
            if (n2 > 0) {
                this.socket.connect((SocketAddress)object2, n2);
            } else {
                this.socket.connect((SocketAddress)object2);
            }
            if (n3 > 0) {
                this.socket.setSoTimeout(n3);
            }
            if (bl) {
                object = this.getSSLSocketFactory(trustManager);
                SSLSocket sSLSocket = (SSLSocket)((SSLSocketFactory)object).createSocket(this.socket, string, n, true);
                String[] stringArray = new String[]{"TLSv1", "SSLv3"};
                sSLSocket.setEnabledProtocols(stringArray);
                sSLSocket.setUseClientMode(true);
                sSLSocket.startHandshake();
                this.socket = sSLSocket;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            IOException iOException = new IOException();
            iOException.initCause(generalSecurityException);
            throw iOException;
        }
        object2 = this.socket.getInputStream();
        object2 = new BufferedInputStream((InputStream)object2);
        this.in = new IMAPResponseTokenizer((InputStream)object2);
        object = this.socket.getOutputStream();
        object = new BufferedOutputStream((OutputStream)object);
        this.out = new CRLFOutputStream((OutputStream)object);
        this.asyncResponses = new ArrayList();
        this.alerts = new ArrayList();
    }
}

