/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMFrame;
import gnu.classpath.jdwp.VMVirtualMachine;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ThreadId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.JdwpString;
import gnu.classpath.jdwp.util.Location;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;

public class ThreadReferenceCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer byteBuffer, DataOutputStream dataOutputStream, byte by) throws JdwpException {
        try {
            switch (by) {
                case 1: {
                    this.executeName(byteBuffer, dataOutputStream);
                    break;
                }
                case 2: {
                    this.executeSuspend(byteBuffer, dataOutputStream);
                    break;
                }
                case 3: {
                    this.executeResume(byteBuffer, dataOutputStream);
                    break;
                }
                case 4: {
                    this.executeStatus(byteBuffer, dataOutputStream);
                    break;
                }
                case 5: {
                    this.executeThreadGroup(byteBuffer, dataOutputStream);
                    break;
                }
                case 6: {
                    this.executeFrames(byteBuffer, dataOutputStream);
                    break;
                }
                case 7: {
                    this.executeFrameCount(byteBuffer, dataOutputStream);
                    break;
                }
                case 8: {
                    this.executeOwnedMonitors(byteBuffer, dataOutputStream);
                    break;
                }
                case 9: {
                    this.executeCurrentContendedMonitor(byteBuffer, dataOutputStream);
                    break;
                }
                case 10: {
                    this.executeStop(byteBuffer, dataOutputStream);
                    break;
                }
                case 11: {
                    this.executeInterrupt(byteBuffer, dataOutputStream);
                    break;
                }
                case 12: {
                    this.executeSuspendCount(byteBuffer, dataOutputStream);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + by + " not found in Thread Reference Command Set.");
                }
            }
        }
        catch (IOException iOException) {
            throw new JdwpInternalErrorException(iOException);
        }
        return false;
    }

    private final void executeName(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ThreadId threadId = (ThreadId)this.idMan.readObjectId(byteBuffer);
        Thread thread = threadId.getThread();
        JdwpString.writeString(dataOutputStream, thread.getName());
    }

    private final void executeSuspend(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ThreadId threadId = (ThreadId)this.idMan.readObjectId(byteBuffer);
        Thread thread = threadId.getThread();
        VMVirtualMachine.suspendThread(thread);
    }

    private final void executeResume(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ThreadId threadId = (ThreadId)this.idMan.readObjectId(byteBuffer);
        Thread thread = threadId.getThread();
        VMVirtualMachine.suspendThread(thread);
    }

    private final void executeStatus(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ThreadId threadId = (ThreadId)this.idMan.readObjectId(byteBuffer);
        Thread thread = threadId.getThread();
        int n = VMVirtualMachine.getThreadStatus(thread);
        int n2 = 1;
        dataOutputStream.writeInt(n);
        dataOutputStream.writeInt(n2);
    }

    private final void executeThreadGroup(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ThreadId threadId = (ThreadId)this.idMan.readObjectId(byteBuffer);
        Thread thread = threadId.getThread();
        ThreadGroup threadGroup = thread.getThreadGroup();
        ObjectId objectId = this.idMan.getObjectId(threadGroup);
        objectId.write(dataOutputStream);
    }

    private final void executeFrames(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ThreadId threadId = (ThreadId)this.idMan.readObjectId(byteBuffer);
        Thread thread = threadId.getThread();
        int n = byteBuffer.getInt();
        int n2 = byteBuffer.getInt();
        ArrayList arrayList = VMVirtualMachine.getFrames(thread, n, n2);
        dataOutputStream.writeInt(arrayList.size());
        int n3 = 0;
        while (n3 < arrayList.size()) {
            VMFrame vMFrame = (VMFrame)arrayList.get(n3);
            dataOutputStream.writeLong(vMFrame.getId());
            Location location = vMFrame.getLocation();
            location.write(dataOutputStream);
            ++n3;
        }
    }

    private final void executeFrameCount(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ThreadId threadId = (ThreadId)this.idMan.readObjectId(byteBuffer);
        Thread thread = threadId.getThread();
        int n = VMVirtualMachine.getFrameCount(thread);
        dataOutputStream.writeInt(n);
    }

    private final void executeOwnedMonitors(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException {
        throw new NotImplementedException("Command OwnedMonitors not implemented.");
    }

    private final void executeCurrentContendedMonitor(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException {
        throw new NotImplementedException("Command CurrentContentedMonitors not implemented.");
    }

    private final void executeStop(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ThreadId threadId = (ThreadId)this.idMan.readObjectId(byteBuffer);
        Thread thread = threadId.getThread();
        ObjectId objectId = this.idMan.readObjectId(byteBuffer);
        Throwable throwable = (Throwable)objectId.getObject();
        thread.stop(throwable);
    }

    private final void executeInterrupt(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ThreadId threadId = (ThreadId)this.idMan.readObjectId(byteBuffer);
        Thread thread = threadId.getThread();
        thread.interrupt();
    }

    private final void executeSuspendCount(ByteBuffer byteBuffer, DataOutputStream dataOutputStream) throws JdwpException, IOException {
        ThreadId threadId = (ThreadId)this.idMan.readObjectId(byteBuffer);
        Thread thread = threadId.getThread();
        int n = VMVirtualMachine.getSuspendCount(thread);
        dataOutputStream.writeInt(n);
    }
}

