/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp;

import gnu.classpath.jdwp.exception.InvalidClassException;
import gnu.classpath.jdwp.exception.InvalidObjectException;
import gnu.classpath.jdwp.id.ArrayId;
import gnu.classpath.jdwp.id.ArrayReferenceTypeId;
import gnu.classpath.jdwp.id.ClassLoaderId;
import gnu.classpath.jdwp.id.ClassObjectId;
import gnu.classpath.jdwp.id.ClassReferenceTypeId;
import gnu.classpath.jdwp.id.InterfaceReferenceTypeId;
import gnu.classpath.jdwp.id.ObjectId;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.id.StringId;
import gnu.classpath.jdwp.id.ThreadGroupId;
import gnu.classpath.jdwp.id.ThreadId;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Hashtable;

public class VMIdManager {
    private static VMIdManager _idm = new VMIdManager();
    private ReferenceQueue _refQueue = new ReferenceQueue();
    private Hashtable _oidTable = new Hashtable(50);
    private Hashtable _idTable = new Hashtable(50);
    private Hashtable _classTable = new Hashtable(20);
    private Hashtable _ridTable = new Hashtable(20);

    public static VMIdManager getDefault() {
        return _idm;
    }

    private final void _update() {
        Reference reference;
        while ((reference = this._refQueue.poll()) != null) {
            ObjectId objectId = (ObjectId)this._oidTable.get(reference);
            this._oidTable.remove(reference);
            this._idTable.remove(new Long(objectId.getId()));
        }
    }

    public ObjectId getObjectId(Object object) {
        ReferenceKey referenceKey = new ReferenceKey(object, this._refQueue);
        ObjectId objectId = (ObjectId)this._oidTable.get(referenceKey);
        if (objectId == null) {
            this._update();
            objectId = IdFactory.newObjectId(referenceKey);
            this._oidTable.put(referenceKey, objectId);
            this._idTable.put(new Long(objectId.getId()), objectId);
        }
        return objectId;
    }

    public ObjectId get(long l) throws InvalidObjectException {
        ObjectId objectId = (ObjectId)this._idTable.get(new Long(l));
        if (objectId == null) {
            throw new InvalidObjectException(l);
        }
        return objectId;
    }

    public ObjectId readObjectId(ByteBuffer byteBuffer) throws InvalidObjectException {
        long l = byteBuffer.getLong();
        return this.get(l);
    }

    public ReferenceTypeId getReferenceTypeId(Class clazz) {
        ReferenceKey referenceKey = new ReferenceKey(clazz);
        ReferenceTypeId referenceTypeId = (ReferenceTypeId)this._classTable.get(referenceKey);
        if (referenceTypeId == null) {
            referenceTypeId = IdFactory.newReferenceTypeId(referenceKey);
            this._classTable.put(referenceKey, referenceTypeId);
            this._ridTable.put(new Long(referenceTypeId.getId()), referenceTypeId);
        }
        return referenceTypeId;
    }

    public ReferenceTypeId getReferenceType(long l) throws InvalidClassException {
        ReferenceTypeId referenceTypeId = (ReferenceTypeId)this._ridTable.get(new Long(l));
        if (referenceTypeId == null) {
            throw new InvalidClassException(l);
        }
        return referenceTypeId;
    }

    public ReferenceTypeId readReferenceTypeId(ByteBuffer byteBuffer) throws InvalidClassException {
        long l = byteBuffer.getLong();
        return this.getReferenceType(l);
    }

    private VMIdManager() {
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    class ReferenceKey
    extends SoftReference {
        private int _hash;

        public int hashCode() {
            return this._hash;
        }

        public boolean equals(Object object) {
            if (object instanceof ReferenceKey) {
                ReferenceKey referenceKey = (ReferenceKey)object;
                if (this == object) {
                    return true;
                }
                boolean bl = false;
                if (referenceKey.get() == this.get()) {
                    bl = true;
                }
                return bl;
            }
            return false;
        }

        public ReferenceKey(Object object) {
            super(object);
            this._hash = object.hashCode();
        }

        public ReferenceKey(Object object, ReferenceQueue referenceQueue) {
            super(object, referenceQueue);
            this._hash = object.hashCode();
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private static class IdFactory {
        private static Object _idLock = new Object();
        private static Object _ridLock = new Object();
        private static long _lastId = 0L;
        private static long _lastRid = 0L;
        private static HashMap _idList = new HashMap();
        static /* synthetic */ Class class$gnu$classpath$jdwp$id$ClassLoaderId;
        static /* synthetic */ Class class$gnu$classpath$jdwp$id$ClassObjectId;
        static /* synthetic */ Class class$gnu$classpath$jdwp$id$StringId;
        static /* synthetic */ Class class$gnu$classpath$jdwp$id$ThreadId;
        static /* synthetic */ Class class$gnu$classpath$jdwp$id$ThreadGroupId;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static ObjectId newObjectId(SoftReference softReference) {
            Object object;
            ObjectId objectId = null;
            Object object2 = softReference.get();
            if (object2.getClass().isArray()) {
                objectId = new ArrayId();
            } else {
                object = object2.getClass();
                while (object != null) {
                    Class clazz = (Class)_idList.get(object);
                    if (clazz != null) {
                        try {
                            objectId = (ObjectId)clazz.newInstance();
                            Object object3 = _idLock;
                            synchronized (object3) {
                                objectId.setId(++_lastId);
                            }
                            objectId.setReference(softReference);
                            return objectId;
                        }
                        catch (InstantiationException instantiationException) {
                            throw new RuntimeException("cannot create new ID", instantiationException);
                        }
                        catch (IllegalAccessException illegalAccessException) {
                            throw new RuntimeException("illegal access of ID", illegalAccessException);
                        }
                    }
                    object = ((Class)object).getSuperclass();
                }
                objectId = new ObjectId();
            }
            object = _idLock;
            synchronized (object) {
                objectId.setId(++_lastId);
            }
            objectId.setReference(softReference);
            return objectId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public static ReferenceTypeId newReferenceTypeId(SoftReference softReference) {
            Class clazz = (Class)softReference.get();
            if (clazz == null) {
                return null;
            }
            ReferenceTypeId referenceTypeId = clazz.isArray() ? new ArrayReferenceTypeId() : (clazz.isInterface() ? new InterfaceReferenceTypeId() : new ClassReferenceTypeId());
            Object object = _ridLock;
            synchronized (object) {
                referenceTypeId.setId(++_lastRid);
                return referenceTypeId;
            }
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError().initCause(classNotFoundException);
            }
        }

        private IdFactory() {
        }

        static {
            Class clazz = class$gnu$classpath$jdwp$id$ClassLoaderId;
            if (clazz == null) {
                clazz = class$gnu$classpath$jdwp$id$ClassLoaderId = IdFactory.class("[Lgnu.classpath.jdwp.id.ClassLoaderId;", false);
            }
            _idList.put(ClassLoaderId.typeClass, clazz);
            Class clazz2 = class$gnu$classpath$jdwp$id$ClassObjectId;
            if (clazz2 == null) {
                clazz2 = class$gnu$classpath$jdwp$id$ClassObjectId = IdFactory.class("[Lgnu.classpath.jdwp.id.ClassObjectId;", false);
            }
            _idList.put(ClassObjectId.typeClass, clazz2);
            Class clazz3 = class$gnu$classpath$jdwp$id$StringId;
            if (clazz3 == null) {
                clazz3 = class$gnu$classpath$jdwp$id$StringId = IdFactory.class("[Lgnu.classpath.jdwp.id.StringId;", false);
            }
            _idList.put(StringId.typeClass, clazz3);
            Class clazz4 = class$gnu$classpath$jdwp$id$ThreadId;
            if (clazz4 == null) {
                clazz4 = class$gnu$classpath$jdwp$id$ThreadId = IdFactory.class("[Lgnu.classpath.jdwp.id.ThreadId;", false);
            }
            _idList.put(ThreadId.typeClass, clazz4);
            Class clazz5 = class$gnu$classpath$jdwp$id$ThreadGroupId;
            if (clazz5 == null) {
                clazz5 = class$gnu$classpath$jdwp$id$ThreadGroupId = IdFactory.class("[Lgnu.classpath.jdwp.id.ThreadGroupId;", false);
            }
            _idList.put(ThreadGroupId.typeClass, clazz5);
        }
    }
}

