/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecodecvssnap;

import gnu.bytecodecvssnap.CodeAttr;
import gnu.bytecodecvssnap.Label;
import gnu.bytecodecvssnap.Location;
import gnu.bytecodecvssnap.Scope;
import gnu.bytecodecvssnap.Type;
import java.util.Enumeration;
import java.util.NoSuchElementException;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Variable
extends Location
implements Enumeration {
    private static final int SIMPLE_FLAG = 1;
    private static final int PARAMETER_FLAG = 2;
    private static final int LIVE_FLAG = 4;
    static final int UNASSIGNED = -1;
    Variable next;
    private int flags;
    int offset;
    Scope scope;

    public final Variable nextVar() {
        return this.next;
    }

    public final boolean hasMoreElements() {
        boolean bl = false;
        if (this.next != null) {
            bl = true;
        }
        return bl;
    }

    public Object nextElement() {
        if (this.next == null) {
            throw new NoSuchElementException("Variable enumeration");
        }
        return this.next;
    }

    public final boolean isAssigned() {
        boolean bl = false;
        if (this.offset != -1) {
            bl = true;
        }
        return bl;
    }

    final boolean dead() {
        boolean bl = false;
        if ((this.flags & 4) == 0) {
            bl = true;
        }
        return bl;
    }

    private final void setFlag(boolean bl, int n) {
        this.flags = bl ? (this.flags |= n) : (this.flags &= ~n);
    }

    public final boolean isSimple() {
        boolean bl = false;
        if ((this.flags & 1) != 0) {
            bl = true;
        }
        return bl;
    }

    public final void setSimple(boolean bl) {
        this.setFlag(bl, 1);
    }

    public final boolean isParameter() {
        boolean bl = false;
        if ((this.flags & 2) != 0) {
            bl = true;
        }
        return bl;
    }

    public final void setParameter(boolean bl) {
        this.setFlag(bl, 2);
    }

    public boolean reserveLocal(int n, CodeAttr codeAttr) {
        int n2 = 0;
        if (this.getType().size > 4) {
            n2 = 1;
        }
        int n3 = n2 + 1;
        if (codeAttr.locals.used == null) {
            codeAttr.locals.used = new Variable[20 + n3];
        } else if (codeAttr.getMaxLocals() + n3 >= codeAttr.locals.used.length) {
            Variable[] variableArray = new Variable[2 * codeAttr.locals.used.length + n3];
            System.arraycopy(codeAttr.locals.used, 0, variableArray, 0, codeAttr.getMaxLocals());
            codeAttr.locals.used = variableArray;
        }
        int n4 = 0;
        while (n4 < n3) {
            if (codeAttr.locals.used[n + n4] != null) {
                return false;
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n3) {
            codeAttr.locals.used[n + n4] = this;
            ++n4;
        }
        if (n + n3 > codeAttr.getMaxLocals()) {
            codeAttr.setMaxLocals(n + n3);
        }
        this.offset = n;
        this.flags |= 4;
        return true;
    }

    public void allocateLocal(CodeAttr codeAttr) {
        if (this.offset != -1) {
            return;
        }
        int n = 0;
        while (!this.reserveLocal(n, codeAttr)) {
            ++n;
        }
        return;
    }

    public void freeLocal(CodeAttr codeAttr) {
        this.flags &= 0xFFFFFFFB;
        int n = 0;
        if (this.getType().size > 4) {
            n = 1;
        }
        int n2 = n + 1;
        while (--n2 >= 0) {
            codeAttr.locals.used[this.offset + n2] = null;
        }
    }

    boolean shouldEmit() {
        Label label;
        int n;
        Label label2;
        Scope scope = this.scope;
        boolean bl = false;
        if (this.isSimple() && this.name != null && scope != null && (label2 = scope.start) != null && (n = label2.position) >= 0 && (label = scope.end) != null && label.position > n) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        return "Variable[" + this.getName() + " offset:" + this.offset + ']';
    }

    private final /* synthetic */ void this() {
        this.flags = 1;
        this.offset = -1;
    }

    public Variable() {
        this.this();
    }

    public Variable(String string) {
        this.this();
        this.setName(string);
    }

    public Variable(String string, Type type) {
        this.this();
        this.setName(string);
        this.setType(type);
    }
}

