/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecodecvssnap;

import gnu.bytecodecvssnap.Attribute;
import gnu.bytecodecvssnap.ClassType;
import gnu.bytecodecvssnap.ClassTypeWriter;
import gnu.bytecodecvssnap.ConstantPool;
import gnu.bytecodecvssnap.CpoolClass;
import gnu.bytecodecvssnap.Method;
import gnu.bytecodecvssnap.ObjectType;
import java.io.DataOutputStream;
import java.io.IOException;

public class ExceptionsAttr
extends Attribute {
    ClassType[] exceptions;
    short[] exception_table;

    public void setExceptions(short[] sArray, ClassType classType) {
        this.exception_table = sArray;
        this.exceptions = new ClassType[sArray.length];
        ConstantPool constantPool = classType.getConstants();
        int n = sArray.length - 1;
        while (n >= 0) {
            this.exceptions[n] = (ClassType)((CpoolClass)constantPool.getPoolEntry(sArray[n])).getClassType();
            --n;
        }
    }

    public void setExceptions(ClassType[] classTypeArray) {
        this.exceptions = classTypeArray;
    }

    public void assignConstants(ClassType classType) {
        super.assignConstants(classType);
        ConstantPool constantPool = classType.getConstants();
        int n = this.exceptions.length;
        this.exception_table = new short[n];
        int n2 = n - 1;
        while (n2 >= 0) {
            this.exception_table[n2] = (short)constantPool.addClass((ObjectType)this.exceptions[n2]).index;
            --n2;
        }
    }

    public final int getLength() {
        int n = 0;
        if (this.exceptions != null) {
            n = this.exceptions.length;
        }
        return 2 + 2 * n;
    }

    public final ClassType[] getExceptions() {
        return this.exceptions;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n = this.exceptions.length;
        dataOutputStream.writeShort(n);
        int n2 = 0;
        while (n2 < n) {
            dataOutputStream.writeShort(this.exception_table[n2]);
            ++n2;
        }
    }

    public void print(ClassTypeWriter classTypeWriter) {
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.print(this.getLength());
        classTypeWriter.print(", count: ");
        int n = this.exceptions.length;
        classTypeWriter.println(n);
        int n2 = 0;
        while (n2 < n) {
            int n3 = this.exception_table[n2] & (char)-1;
            classTypeWriter.print("  ");
            classTypeWriter.printOptionalIndex(n3);
            classTypeWriter.printConstantTersely(n3, 7);
            classTypeWriter.println();
            ++n2;
        }
    }

    public ExceptionsAttr(Method method) {
        super("Exceptions");
        this.addToFrontOf(method);
    }
}

