/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecodecvssnap;

import gnu.bytecodecvssnap.AttrContainer;
import gnu.bytecodecvssnap.ClassType;
import gnu.bytecodecvssnap.ClassTypeWriter;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class Attribute {
    AttrContainer container;
    Attribute next;
    String name;
    int name_index;

    public final AttrContainer getContainer() {
        return this.container;
    }

    public final void setContainer(AttrContainer attrContainer) {
        this.container = attrContainer;
    }

    public final Attribute getNext() {
        return this.next;
    }

    public final void setNext(Attribute attribute) {
        this.next = attribute;
    }

    public void addToFrontOf(AttrContainer attrContainer) {
        this.setContainer(attrContainer);
        this.setNext(attrContainer.getAttributes());
        attrContainer.setAttributes(this);
    }

    public final boolean isSkipped() {
        boolean bl = false;
        if (this.name_index < 0) {
            bl = true;
        }
        return bl;
    }

    public final void setSkipped(boolean bl) {
        this.name_index = 0 - bl;
    }

    public final void setSkipped() {
        this.name_index = -1;
    }

    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.name = string.intern();
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final void setNameIndex(int n) {
        this.name_index = n;
    }

    public static Attribute get(AttrContainer attrContainer, String string) {
        Attribute attribute = attrContainer.getAttributes();
        while (attribute != null) {
            if (attribute.getName() == string) {
                return attribute;
            }
            attribute = attribute.next;
        }
        return null;
    }

    public void assignConstants(ClassType classType) {
        if (this.name_index == 0) {
            this.name_index = classType.getConstants().addUtf8(this.name).getIndex();
        }
    }

    public static void assignConstants(AttrContainer attrContainer, ClassType classType) {
        Attribute attribute = attrContainer.getAttributes();
        while (attribute != null) {
            if (!attribute.isSkipped()) {
                attribute.assignConstants(classType);
            }
            attribute = attribute.next;
        }
    }

    public abstract int getLength();

    public static int getLengthAll(AttrContainer attrContainer) {
        int n = 0;
        Attribute attribute = attrContainer.getAttributes();
        while (attribute != null) {
            if (!attribute.isSkipped()) {
                n += 6 + attribute.getLength();
            }
            attribute = attribute.next;
        }
        return n;
    }

    public abstract void write(DataOutputStream var1) throws IOException;

    public static int count(AttrContainer attrContainer) {
        int n = 0;
        Attribute attribute = attrContainer.getAttributes();
        while (attribute != null) {
            if (!attribute.isSkipped()) {
                ++n;
            }
            attribute = attribute.next;
        }
        return n;
    }

    public static void writeAll(AttrContainer attrContainer, DataOutputStream dataOutputStream) throws IOException {
        int n = Attribute.count(attrContainer);
        dataOutputStream.writeShort(n);
        Attribute attribute = attrContainer.getAttributes();
        while (attribute != null) {
            if (!attribute.isSkipped()) {
                if (attribute.name_index == 0) {
                    throw new Error("Attribute.writeAll called without assignConstants");
                }
                dataOutputStream.writeShort(attribute.name_index);
                dataOutputStream.writeInt(attribute.getLength());
                attribute.write(dataOutputStream);
            }
            attribute = attribute.next;
        }
    }

    public void print(ClassTypeWriter classTypeWriter) {
        classTypeWriter.print("Attribute \"");
        classTypeWriter.print(this.getName());
        classTypeWriter.print("\", length:");
        classTypeWriter.println(this.getLength());
    }

    public Attribute(String string) {
        this.name = string;
    }
}

