/* ethos-ui-manager-widget.h
 *
 * Copyright (C) 2009 Christian Hergert <chris@dronelabs.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 
 * 02110-1301 USA
 */

#ifndef __ETHOS_UI_MANAGER_WIDGET_H__
#define __ETHOS_UI_MANAGER_WIDGET_H__

#include <glib-object.h>
#include <gtk/gtk.h>
#include <ethos/ethos.h>

G_BEGIN_DECLS

#define ETHOS_UI_TYPE_MANAGER_WIDGET		(ethos_ui_manager_widget_get_type ())
#define ETHOS_UI_MANAGER_WIDGET(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), ETHOS_UI_TYPE_MANAGER_WIDGET, EthosUIManagerWidget))
#define ETHOS_UI_MANAGER_WIDGET_CONST(obj)	(G_TYPE_CHECK_INSTANCE_CAST ((obj), ETHOS_UI_TYPE_MANAGER_WIDGET, EthosUIManagerWidget const))
#define ETHOS_UI_MANAGER_WIDGET_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass),  ETHOS_UI_TYPE_MANAGER_WIDGET, EthosUIManagerWidgetClass))
#define ETHOS_UI_IS_MANAGER_WIDGET(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), ETHOS_UI_TYPE_MANAGER_WIDGET))
#define ETHOS_UI_IS_MANAGER_WIDGET_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass),  ETHOS_UI_TYPE_MANAGER_WIDGET))
#define ETHOS_UI_MANAGER_WIDGET_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj),  ETHOS_UI_TYPE_MANAGER_WIDGET, EthosUIManagerWidgetClass))

typedef struct _EthosUIManagerWidget		EthosUIManagerWidget;
typedef struct _EthosUIManagerWidgetClass	EthosUIManagerWidgetClass;
typedef struct _EthosUIManagerWidgetPrivate	EthosUIManagerWidgetPrivate;

struct _EthosUIManagerWidget
{
	GtkVBox parent;

	/*< private >*/
	EthosUIManagerWidgetPrivate *priv;
};

struct _EthosUIManagerWidgetClass
{
	GtkVBoxClass parent_class;
};

GType      ethos_ui_manager_widget_get_type    (void) G_GNUC_CONST;
GtkWidget* ethos_ui_manager_widget_new         (void);
void       ethos_ui_manager_widget_set_manager (EthosUIManagerWidget *widget,
                                                EthosManager         *manager);

G_END_DECLS

#endif /* __ETHOS_UI_MANAGER_WIDGET_H__ */
