# -*- coding: utf-8 -*-
#
# papyon - a python client library for Msn
#
# Copyright (C) 2007 Johann Prieur <johann.prieur@gmail.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

__all__ = ['annotations_to_dict', 'get_detailled_error']

def annotations_to_dict(annotations):
    if annotations is None:
        return {}

    result = {}
    for annotation in annotations:
        key = annotation.findtext("./ab:Name")
        value = annotation.findtext("./ab:Value")
        result[key] = value
    return result

def get_detailled_error(fault):
    if fault.detail is not None:
        errorcode = fault.detail.findtext("./ab:errorcode")
        errorstring = fault.detail.findtext("./ab:errorstring")
    else:
        errorcode = fault.faultcode
        errorstring = fault.faultstring
    return errorcode, errorstring
