INCLUDE(Platform/NetBSD)

IF($ENV{LOCALBASE})
  SET(OPENBSD_LOCALBASE $ENV{LOCALBASE})
ELSE($ENV{LOCALBASE})
  SET(OPENBSD_LOCALBASE /usr/local)
ENDIF($ENV{LOCALBASE})

IF($ENV{X11BASE})
  SET(OPENBSD_X11BASE $ENV{X11BASE})
ELSE($ENV{X11BASE})
  SET(OPENBSD_X11BASE /usr/X11R6)
ENDIF($ENV{X11BASE})

SET(CMAKE_SYSTEM_INCLUDE_PATH ${CMAKE_SYSTEM_INCLUDE_PATH} /usr/include
  ${OPENBSD_LOCALBASE}/include ${OPENBSD_X11BASE}/include)
SET(CMAKE_SYSTEM_LIBRARY_PATH ${CMAKE_SYSTEM_LIBRARY_PATH} /usr/lib
  ${OPENBSD_LOCALBASE}/lib ${OPENBSD_X11BASE}/lib)
SET(CMAKE_SYSTEM_PROGRAM_PATH ${CMAKE_SYSTEM_PROGRAM_PATH} /bin /usr/bin
  ${OPENBSD_LOCALBASE}/bin /sbin /usr/sbin ${OPENBSD_LOCALBASE}/sbin)

# On OpenBSD, the compile time linker does not share it's configuration with
# the runtime linker.  This will extract the library search paths from the
# system's ld.so.hints file which will allow CMake to set the appropriate
# -rpath-link flags
IF(NOT CMAKE_PLATFORM_RUNTIME_PATH)
  EXECUTE_PROCESS(COMMAND /sbin/ldconfig -r
                  OUTPUT_VARIABLE LDCONFIG_HINTS
                  ERROR_QUIET)
  STRING(REGEX REPLACE ".*search\\ directories:\\ ([^\n]*).*" "\\1"
         LDCONFIG_HINTS "${LDCONFIG_HINTS}")
  STRING(REGEX REPLACE ":" ";"
         CMAKE_PLATFORM_RUNTIME_PATH
         "${LDCONFIG_HINTS}")
ENDIF()

SET_PROPERTY(GLOBAL PROPERTY FIND_LIBRARY_USE_OPENBSD_VERSIONING 1)
SET(CMAKE_INSTALL_SO_NO_EXE 1)
