# -*- encoding: utf-8 -*-

Gem::Specification.new do |s|
  s.name = %q{facets}
  s.version = "2.7.0"

  s.required_rubygems_version = Gem::Requirement.new(">= 0") if s.respond_to? :required_rubygems_version=
  s.authors = ["facets-universal@rubyforge.org", "Thomas Sawyer <transfire@gmail.com>"]
  s.date = %q{2009-08-21}
  s.description = %q{Ruby Facets is the single largest collection of general purpose method extensions and system additions for the Ruby programming language.  The CORE extensions is a large collection of methods which extend the core capabilities of Ruby's built-in classes and modules. This collection of extension methods are unique by virtue of their atomicity. The methods are generally stored in individual files so that each can be required independently. This gives developers the potential for much finer control over which extra methods to bring into their code.  The MORE additions are a collection of classes, modules and lightweight systems which constitute an ever improving source of reusable components. This set of libraries is kept light and focused on useful to a wide variety of usecases.}
  s.email = %q{facets-universal@rubyforge.org}
  s.extra_rdoc_files = ["Rakefile", "HISTORY.rdoc", "MANIFEST", "NOTES", "TODO", "README.rdoc", "AUTHORS", "COPYING"]
  s.files = ["demo/hook.rd", "demo/scenario_require.rd", "doc/README.core", "doc/README.more", "doc/manual/about.rb", "doc/manual/annotations.rdoc", "doc/manual/associations.rdoc", "doc/manual/blockups.rdoc", "doc/manual/capsule.rdoc", "doc/manual/command.rdoc", "doc/manual/core.rdoc", "doc/manual/faq.rdoc", "doc/manual/typecast.html", "lib/core/facets/array/combination.rb", "lib/core/facets/array/conjoin.rb", "lib/core/facets/array/delete.rb", "lib/core/facets/array/delete_unless.rb", "lib/core/facets/array/delete_values.rb", "lib/core/facets/array/index.rb", "lib/core/facets/array/indexable.rb", "lib/core/facets/array/merge.rb", "lib/core/facets/array/not_empty.rb", "lib/core/facets/array/only.rb", "lib/core/facets/array/pad.rb", "lib/core/facets/array/permutation.rb", "lib/core/facets/array/product.rb", "lib/core/facets/array/recursively.rb", "lib/core/facets/array/rotate.rb", "lib/core/facets/array/select.rb", "lib/core/facets/array/splice.rb", "lib/core/facets/array/stackable.rb", "lib/core/facets/array/traverse.rb", "lib/core/facets/array.rb", "lib/core/facets/binding/caller.rb", "lib/core/facets/binding/callstack.rb", "lib/core/facets/binding/defined.rb", "lib/core/facets/binding/eval.rb", "lib/core/facets/binding/local_variables.rb", "lib/core/facets/binding/opvars.rb", "lib/core/facets/binding/self.rb", "lib/core/facets/binding.rb", "lib/core/facets/bitmask.rb", "lib/core/facets/blank.rb", "lib/core/facets/boolean.rb", "lib/core/facets/cattr.rb", "lib/core/facets/class/cattr.rb", "lib/core/facets/class/cattr_accessor.rb", "lib/core/facets/class/cattr_reader.rb", "lib/core/facets/class/cattr_writer.rb", "lib/core/facets/class/descendents.rb", "lib/core/facets/class/methodize.rb", "lib/core/facets/class/pathize.rb", "lib/core/facets/class/prepend.rb", "lib/core/facets/class/subclasses.rb", "lib/core/facets/class/to_proc.rb", "lib/core/facets/class.rb", "lib/core/facets/comparable/at_least.rb", "lib/core/facets/comparable/at_most.rb", "lib/core/facets/comparable/bound.rb", "lib/core/facets/comparable/cap.rb", "lib/core/facets/comparable/clip.rb", "lib/core/facets/comparable/cmp.rb", "lib/core/facets/comparable/comparable.rb", "lib/core/facets/comparable.rb", "lib/core/facets/denumerable.rb", "lib/core/facets/dir/ascend.rb", "lib/core/facets/dir/descend.rb", "lib/core/facets/dir/multiglob.rb", "lib/core/facets/dir/parent.rb", "lib/core/facets/dir/recurse.rb", "lib/core/facets/dir.rb", "lib/core/facets/duplicable.rb", "lib/core/facets/enumerable/accumulate.rb", "lib/core/facets/enumerable/cluster_by.rb", "lib/core/facets/enumerable/collect.rb", "lib/core/facets/enumerable/commonality.rb", "lib/core/facets/enumerable/compact_map.rb", "lib/core/facets/enumerable/count.rb", "lib/core/facets/enumerable/defer.rb", "lib/core/facets/enumerable/divide.rb", "lib/core/facets/enumerable/duplicates.rb", "lib/core/facets/enumerable/each_by.rb", "lib/core/facets/enumerable/entropy.rb", "lib/core/facets/enumerable/every.rb", "lib/core/facets/enumerable/ewise.rb", "lib/core/facets/enumerable/filter.rb", "lib/core/facets/enumerable/frequency.rb", "lib/core/facets/enumerable/graph.rb", "lib/core/facets/enumerable/group_by.rb", "lib/core/facets/enumerable/inject.rb", "lib/core/facets/enumerable/map_send.rb", "lib/core/facets/enumerable/map_with_index.rb", "lib/core/facets/enumerable/mash.rb", "lib/core/facets/enumerable/mode.rb", "lib/core/facets/enumerable/modulate.rb", "lib/core/facets/enumerable/none.rb", "lib/core/facets/enumerable/occur.rb", "lib/core/facets/enumerable/one.rb", "lib/core/facets/enumerable/per.rb", "lib/core/facets/enumerable/probability.rb", "lib/core/facets/enumerable/split.rb", "lib/core/facets/enumerable/sum.rb", "lib/core/facets/enumerable/take.rb", "lib/core/facets/enumerable/uniq_by.rb", "lib/core/facets/enumerable.rb", "lib/core/facets/exception/detail.rb", "lib/core/facets/exception/raised.rb", "lib/core/facets/exception/suppress.rb", "lib/core/facets/exception.rb", "lib/core/facets/file/append.rb", "lib/core/facets/file/create.rb", "lib/core/facets/file/null.rb", "lib/core/facets/file/read.rb", "lib/core/facets/file/rewrite.rb", "lib/core/facets/file/rootname.rb", "lib/core/facets/file/split_all.rb", "lib/core/facets/file/split_root.rb", "lib/core/facets/file/write.rb", "lib/core/facets/file/writelines.rb", "lib/core/facets/file.rb", "lib/core/facets/filetest/root.rb", "lib/core/facets/filetest.rb", "lib/core/facets/float/round.rb", "lib/core/facets/float.rb", "lib/core/facets/functor.rb", "lib/core/facets/hash/alias.rb", "lib/core/facets/hash/argumentize.rb", "lib/core/facets/hash/at.rb", "lib/core/facets/hash/autonew.rb", "lib/core/facets/hash/collate.rb", "lib/core/facets/hash/dearray_values.rb", "lib/core/facets/hash/delete.rb", "lib/core/facets/hash/diff.rb", "lib/core/facets/hash/except.rb", "lib/core/facets/hash/group_by_value.rb", "lib/core/facets/hash/insert.rb", "lib/core/facets/hash/inverse.rb", "lib/core/facets/hash/join.rb", "lib/core/facets/hash/keys.rb", "lib/core/facets/hash/mash.rb", "lib/core/facets/hash/merge.rb", "lib/core/facets/hash/new_with.rb", "lib/core/facets/hash/op.rb", "lib/core/facets/hash/op_add.rb", "lib/core/facets/hash/op_and.rb", "lib/core/facets/hash/op_mul.rb", "lib/core/facets/hash/op_or.rb", "lib/core/facets/hash/op_push.rb", "lib/core/facets/hash/op_sub.rb", "lib/core/facets/hash/recursive_merge.rb", "lib/core/facets/hash/recursively.rb", "lib/core/facets/hash/rekey.rb", "lib/core/facets/hash/replace_each.rb", "lib/core/facets/hash/select.rb", "lib/core/facets/hash/slice.rb", "lib/core/facets/hash/stringify_keys.rb", "lib/core/facets/hash/swap.rb", "lib/core/facets/hash/symbolize_keys.rb", "lib/core/facets/hash/to_h.rb", "lib/core/facets/hash/to_options.rb", "lib/core/facets/hash/to_proc.rb", "lib/core/facets/hash/to_struct.rb", "lib/core/facets/hash/traverse.rb", "lib/core/facets/hash/update.rb", "lib/core/facets/hash/update_each.rb", "lib/core/facets/hash/update_keys.rb", "lib/core/facets/hash/update_values.rb", "lib/core/facets/hash/weave.rb", "lib/core/facets/hash/zipnew.rb", "lib/core/facets/hash.rb", "lib/core/facets/indexable.rb", "lib/core/facets/integer/even.rb", "lib/core/facets/integer/factorial.rb", "lib/core/facets/integer/length.rb", "lib/core/facets/integer/multiple.rb", "lib/core/facets/integer/odd.rb", "lib/core/facets/integer/of.rb", "lib/core/facets/integer/ordinal.rb", "lib/core/facets/integer.rb", "lib/core/facets/kernel/__callee__.rb", "lib/core/facets/kernel/__class__.rb", "lib/core/facets/kernel/__dir__.rb", "lib/core/facets/kernel/__get__.rb", "lib/core/facets/kernel/__here__.rb", "lib/core/facets/kernel/__method__.rb", "lib/core/facets/kernel/__set__.rb", "lib/core/facets/kernel/as.rb", "lib/core/facets/kernel/ask.rb", "lib/core/facets/kernel/attr_singleton.rb", "lib/core/facets/kernel/callstack.rb", "lib/core/facets/kernel/complete.rb", "lib/core/facets/kernel/constant.rb", "lib/core/facets/kernel/d.rb", "lib/core/facets/kernel/deep_copy.rb", "lib/core/facets/kernel/demo.rb", "lib/core/facets/kernel/equate.rb", "lib/core/facets/kernel/ergo.rb", "lib/core/facets/kernel/extension.rb", "lib/core/facets/kernel/here.rb", "lib/core/facets/kernel/identical.rb", "lib/core/facets/kernel/in.rb", "lib/core/facets/kernel/instance_assign.rb", "lib/core/facets/kernel/instance_class.rb", "lib/core/facets/kernel/instance_exec.rb", "lib/core/facets/kernel/instance_send.rb", "lib/core/facets/kernel/instance_variables.rb", "lib/core/facets/kernel/maybe.rb", "lib/core/facets/kernel/method.rb", "lib/core/facets/kernel/not_nil.rb", "lib/core/facets/kernel/object_class.rb", "lib/core/facets/kernel/object_hexid.rb", "lib/core/facets/kernel/object_send.rb", "lib/core/facets/kernel/object_state.rb", "lib/core/facets/kernel/p.rb", "lib/core/facets/kernel/populate.rb", "lib/core/facets/kernel/qua_class.rb", "lib/core/facets/kernel/require_all.rb", "lib/core/facets/kernel/require_local.rb", "lib/core/facets/kernel/require_relative.rb", "lib/core/facets/kernel/resc.rb", "lib/core/facets/kernel/respond.rb", "lib/core/facets/kernel/returning.rb", "lib/core/facets/kernel/silence.rb", "lib/core/facets/kernel/singleton_class.rb", "lib/core/facets/kernel/source_location.rb", "lib/core/facets/kernel/tap.rb", "lib/core/facets/kernel/try.rb", "lib/core/facets/kernel/val.rb", "lib/core/facets/kernel/with.rb", "lib/core/facets/kernel.rb", "lib/core/facets/lazy.rb", "lib/core/facets/matchdata/match.rb", "lib/core/facets/matchdata/matchset.rb", "lib/core/facets/matchdata.rb", "lib/core/facets/metaid.rb", "lib/core/facets/module/abstract.rb", "lib/core/facets/module/alias_accessor.rb", "lib/core/facets/module/alias_method_chain.rb", "lib/core/facets/module/alias_module_function.rb", "lib/core/facets/module/ancestor.rb", "lib/core/facets/module/attr_setter.rb", "lib/core/facets/module/basename.rb", "lib/core/facets/module/can.rb", "lib/core/facets/module/class.rb", "lib/core/facets/module/conflict.rb", "lib/core/facets/module/extend.rb", "lib/core/facets/module/include_function_module.rb", "lib/core/facets/module/instance_method.rb", "lib/core/facets/module/instance_methods.rb", "lib/core/facets/module/integrate.rb", "lib/core/facets/module/is.rb", "lib/core/facets/module/methodize.rb", "lib/core/facets/module/modspace.rb", "lib/core/facets/module/module_load.rb", "lib/core/facets/module/module_require.rb", "lib/core/facets/module/nesting.rb", "lib/core/facets/module/op.rb", "lib/core/facets/module/pathize.rb", "lib/core/facets/module/prepend.rb", "lib/core/facets/module/redefine_method.rb", "lib/core/facets/module/redirect_method.rb", "lib/core/facets/module/rename_method.rb", "lib/core/facets/module/revise.rb", "lib/core/facets/module/spacename.rb", "lib/core/facets/module/wrap_method.rb", "lib/core/facets/module.rb", "lib/core/facets/nilclass/ergo.rb", "lib/core/facets/nilclass/to_f.rb", "lib/core/facets/nilclass.rb", "lib/core/facets/numeric/approx.rb", "lib/core/facets/numeric/distance.rb", "lib/core/facets/numeric/round.rb", "lib/core/facets/numeric.rb", "lib/core/facets/objectspace/classes.rb", "lib/core/facets/objectspace/op_fetch.rb", "lib/core/facets/objectspace.rb", "lib/core/facets/proc/bind.rb", "lib/core/facets/proc/compose.rb", "lib/core/facets/proc/curry.rb", "lib/core/facets/proc/to_method.rb", "lib/core/facets/proc/update.rb", "lib/core/facets/proc.rb", "lib/core/facets/range/combine.rb", "lib/core/facets/range/overlap.rb", "lib/core/facets/range/to_r.rb", "lib/core/facets/range/umbrella.rb", "lib/core/facets/range/within.rb", "lib/core/facets/range.rb", "lib/core/facets/regexp/arity.rb", "lib/core/facets/regexp/to_re.rb", "lib/core/facets/regexp.rb", "lib/core/facets/stackable.rb", "lib/core/facets/string/align.rb", "lib/core/facets/string/bracket.rb", "lib/core/facets/string/bytes.rb", "lib/core/facets/string/camelcase.rb", "lib/core/facets/string/capitalized.rb", "lib/core/facets/string/chars.rb", "lib/core/facets/string/chomp.rb", "lib/core/facets/string/cleave.rb", "lib/core/facets/string/compress_lines.rb", "lib/core/facets/string/contains.rb", "lib/core/facets/string/divide.rb", "lib/core/facets/string/each_char.rb", "lib/core/facets/string/each_word.rb", "lib/core/facets/string/end_with.rb", "lib/core/facets/string/expand_tab.rb", "lib/core/facets/string/file.rb", "lib/core/facets/string/fold.rb", "lib/core/facets/string/indent.rb", "lib/core/facets/string/interpolate.rb", "lib/core/facets/string/line_wrap.rb", "lib/core/facets/string/lines.rb", "lib/core/facets/string/lowercase.rb", "lib/core/facets/string/margin.rb", "lib/core/facets/string/methodize.rb", "lib/core/facets/string/modulize.rb", "lib/core/facets/string/mscan.rb", "lib/core/facets/string/natcmp.rb", "lib/core/facets/string/nchar.rb", "lib/core/facets/string/op_sub.rb", "lib/core/facets/string/outdent.rb", "lib/core/facets/string/pathize.rb", "lib/core/facets/string/range.rb", "lib/core/facets/string/rewrite.rb", "lib/core/facets/string/shatter.rb", "lib/core/facets/string/snakecase.rb", "lib/core/facets/string/splice.rb", "lib/core/facets/string/start_with.rb", "lib/core/facets/string/subtract.rb", "lib/core/facets/string/tab.rb", "lib/core/facets/string/tabto.rb", "lib/core/facets/string/titlecase.rb", "lib/core/facets/string/to_re.rb", "lib/core/facets/string/underscore.rb", "lib/core/facets/string/unfold.rb", "lib/core/facets/string/uppercase.rb", "lib/core/facets/string/variablize.rb", "lib/core/facets/string/word_wrap.rb", "lib/core/facets/string/words.rb", "lib/core/facets/string/xor.rb", "lib/core/facets/string.rb", "lib/core/facets/struct/attributes.rb", "lib/core/facets/struct.rb", "lib/core/facets/symbol/chomp.rb", "lib/core/facets/symbol/generate.rb", "lib/core/facets/symbol/not.rb", "lib/core/facets/symbol/plain.rb", "lib/core/facets/symbol/query.rb", "lib/core/facets/symbol/re_s.rb", "lib/core/facets/symbol/setter.rb", "lib/core/facets/symbol/succ.rb", "lib/core/facets/symbol/thrown.rb", "lib/core/facets/symbol/to_proc.rb", "lib/core/facets/symbol/variablize.rb", "lib/core/facets/symbol.rb", "lib/core/facets/time/advance.rb", "lib/core/facets/time/ago.rb", "lib/core/facets/time/change.rb", "lib/core/facets/time/elapse.rb", "lib/core/facets/time/hence.rb", "lib/core/facets/time/round.rb", "lib/core/facets/time/set.rb", "lib/core/facets/time/stamp.rb", "lib/core/facets/time/to_time.rb", "lib/core/facets/time/trunc.rb", "lib/core/facets/time.rb", "lib/core/facets/to_hash.rb", "lib/core/facets/unboundmethod/arguments.rb", "lib/core/facets/unboundmethod/name.rb", "lib/core/facets/unboundmethod.rb", "lib/core/facets-live.rb", "lib/core/facets-load.rb", "lib/core/facets.rb", "lib/more/facets/ansicode.rb", "lib/more/facets/argvector.rb", "lib/more/facets/autoarray.rb", "lib/more/facets/autoreload.rb", "lib/more/facets/basicobject.rb", "lib/more/facets/blankslate.rb", "lib/more/facets/capsule.rb", "lib/more/facets/cgi.rb", "lib/more/facets/class_extend.rb", "lib/more/facets/cloneable.rb", "lib/more/facets/continuation.rb", "lib/more/facets/coroutine.rb", "lib/more/facets/daemonize.rb", "lib/more/facets/date.rb", "lib/more/facets/dictionary.rb", "lib/more/facets/duration.rb", "lib/more/facets/enumargs.rb", "lib/more/facets/enumerablepass.rb", "lib/more/facets/enumerator.rb", "lib/more/facets/equitable.rb", "lib/more/facets/expirable.rb", "lib/more/facets/fileable.rb", "lib/more/facets/filelist.rb", "lib/more/facets/fileutils/head.rb", "lib/more/facets/fileutils/safe_ln.rb", "lib/more/facets/fileutils/slice.rb", "lib/more/facets/fileutils/tail.rb", "lib/more/facets/fileutils/wc.rb", "lib/more/facets/fileutils/whereis.rb", "lib/more/facets/fileutils/which.rb", "lib/more/facets/fileutils.rb", "lib/more/facets/getoptlong.rb", "lib/more/facets/hook.rb", "lib/more/facets/inheritor.rb", "lib/more/facets/instance_eval.rb", "lib/more/facets/instance_function.rb", "lib/more/facets/instantiable.rb", "lib/more/facets/ioredirect.rb", "lib/more/facets/main.rb", "lib/more/facets/memoize.rb", "lib/more/facets/methodspace.rb", "lib/more/facets/module/attr.rb", "lib/more/facets/module/attr_tester.rb", "lib/more/facets/module/attr_toggler.rb", "lib/more/facets/module/attr_validator.rb", "lib/more/facets/module/class_extend.rb", "lib/more/facets/multipliers.rb", "lib/more/facets/multiton.rb", "lib/more/facets/nullclass.rb", "lib/more/facets/once.rb", "lib/more/facets/opencascade.rb", "lib/more/facets/opencollection.rb", "lib/more/facets/openhash.rb", "lib/more/facets/openmodule.rb", "lib/more/facets/openobject.rb", "lib/more/facets/opesc.rb", "lib/more/facets/orderedhash.rb", "lib/more/facets/ostruct.rb", "lib/more/facets/ostructable.rb", "lib/more/facets/partial.rb", "lib/more/facets/pathlist.rb", "lib/more/facets/pathname.rb", "lib/more/facets/platform.rb", "lib/more/facets/preinitialize.rb", "lib/more/facets/progressbar.rb", "lib/more/facets/random.rb", "lib/more/facets/rbconfig.rb", "lib/more/facets/rbsystem.rb", "lib/more/facets/recorder.rb", "lib/more/facets/reference.rb", "lib/more/facets/registerable.rb", "lib/more/facets/set.rb", "lib/more/facets/shellwords.rb", "lib/more/facets/stash.rb", "lib/more/facets/succ.rb", "lib/more/facets/thread.rb", "lib/more/facets/timer.rb", "lib/more/facets/tracepoint.rb", "lib/more/facets/tuple.rb", "lib/more/facets/uri.rb", "lib/more/facets/version.rb", "lib/more/facets/yaml.rb", "lib/more/facets/zlib.rb", "meta/abstract", "meta/authors", "meta/contact", "meta/contributors", "meta/created", "meta/homepage", "meta/license", "meta/loadpath", "meta/modified", "meta/package", "meta/releases", "meta/sitemap", "meta/slogan", "meta/summary", "meta/version", "test/core/array/test_combination.rb", "test/core/array/test_delete.rb", "test/core/array/test_index.rb", "test/core/array/test_indexable.rb", "test/core/array/test_merge.rb", "test/core/array/test_only.rb", "test/core/array/test_pad.rb", "test/core/array/test_permutation.rb", "test/core/array/test_product.rb", "test/core/array/test_rotate.rb", "test/core/array/test_select.rb", "test/core/array/test_stackable.rb", "test/core/binding/test_caller.rb", "test/core/binding/test_defined.rb", "test/core/binding/test_eval.rb", "test/core/binding/test_local_variables.rb", "test/core/binding/test_opvars.rb", "test/core/binding/test_self.rb", "test/core/class/test_cattr.rb", "test/core/class/test_cattr_accessor.rb", "test/core/class/test_cattr_reader.rb", "test/core/class/test_cattr_writer.rb", "test/core/class/test_descendents.rb", "test/core/class/test_to_proc.rb", "test/core/comparable/test_cap.rb", "test/core/comparable/test_clip.rb", "test/core/comparable/test_cmp.rb", "test/core/comparable/test_comparable.rb", "test/core/dir/test_ascend.rb", "test/core/dir/test_descend.rb", "test/core/dir/test_multiglob.rb", "test/core/dir/test_parent.rb", "test/core/dir/test_recurse.rb", "test/core/enumerable/test_cluster_by.rb", "test/core/enumerable/test_collect.rb", "test/core/enumerable/test_commonality.rb", "test/core/enumerable/test_count.rb", "test/core/enumerable/test_defer.rb", "test/core/enumerable/test_each_by.rb", "test/core/enumerable/test_entropy.rb", "test/core/enumerable/test_every.rb", "test/core/enumerable/test_ewise.rb", "test/core/enumerable/test_frequency.rb", "test/core/enumerable/test_group_by.rb", "test/core/enumerable/test_inject.rb", "test/core/enumerable/test_mash.rb", "test/core/enumerable/test_modulate.rb", "test/core/enumerable/test_none.rb", "test/core/enumerable/test_occur.rb", "test/core/enumerable/test_one.rb", "test/core/enumerable/test_per.rb", "test/core/enumerable/test_probability.rb", "test/core/enumerable/test_split.rb", "test/core/enumerable/test_take.rb", "test/core/enumerable/test_uniq_by.rb", "test/core/exception/test_exception.rb", "test/core/file/test_create.rb", "test/core/file/test_file.rb", "test/core/file/test_null.rb", "test/core/file/test_rewrite.rb", "test/core/file/test_split_all.rb", "test/core/file/test_write.rb", "test/core/file/test_writelines.rb", "test/core/filetest/test_filetest.rb", "test/core/hash/test_alias.rb", "test/core/hash/test_at.rb", "test/core/hash/test_autonew.rb", "test/core/hash/test_collate.rb", "test/core/hash/test_dearray_values.rb", "test/core/hash/test_delete.rb", "test/core/hash/test_insert.rb", "test/core/hash/test_inverse.rb", "test/core/hash/test_keys.rb", "test/core/hash/test_mash.rb", "test/core/hash/test_merge.rb", "test/core/hash/test_op.rb", "test/core/hash/test_op_add.rb", "test/core/hash/test_op_and.rb", "test/core/hash/test_op_mul.rb", "test/core/hash/test_op_or.rb", "test/core/hash/test_op_push.rb", "test/core/hash/test_op_sub.rb", "test/core/hash/test_rekey.rb", "test/core/hash/test_replace_each.rb", "test/core/hash/test_select.rb", "test/core/hash/test_slice.rb", "test/core/hash/test_stringify_keys.rb", "test/core/hash/test_swap.rb", "test/core/hash/test_symbolize_keys.rb", "test/core/hash/test_traverse.rb", "test/core/hash/test_update_each.rb", "test/core/hash/test_update_keys.rb", "test/core/hash/test_update_values.rb", "test/core/hash/test_weave.rb", "test/core/hash/test_zipnew.rb", "test/core/integer/test_bitmask.rb", "test/core/integer/test_even.rb", "test/core/integer/test_factorial.rb", "test/core/integer/test_length.rb", "test/core/integer/test_multiple.rb", "test/core/integer/test_odd.rb", "test/core/integer/test_of.rb", "test/core/integer/test_ordinal.rb", "test/core/kernel/test_as.rb", "test/core/kernel/test_attr_singleton.rb", "test/core/kernel/test_callstack.rb", "test/core/kernel/test_constant.rb", "test/core/kernel/test_deepcopy.rb", "test/core/kernel/test_here.rb", "test/core/kernel/test_in.rb", "test/core/kernel/test_instance_assign.rb", "test/core/kernel/test_instance_class.rb", "test/core/kernel/test_method.rb", "test/core/kernel/test_not_nil.rb", "test/core/kernel/test_object_class.rb", "test/core/kernel/test_object_hexid.rb", "test/core/kernel/test_populate.rb", "test/core/kernel/test_resc.rb", "test/core/kernel/test_returning.rb", "test/core/kernel/test_silence.rb", "test/core/kernel/test_tap.rb", "test/core/kernel/test_val.rb", "test/core/matchdata/test_match.rb", "test/core/matchdata/test_matchset.rb", "test/core/module/test_abstract.rb", "test/core/module/test_alias_accessor.rb", "test/core/module/test_alias_method_chain.rb", "test/core/module/test_alias_module_function.rb", "test/core/module/test_ancestor.rb", "test/core/module/test_basename.rb", "test/core/module/test_can.rb", "test/core/module/test_class.rb", "test/core/module/test_conflict.rb", "test/core/module/test_integrate.rb", "test/core/module/test_is.rb", "test/core/module/test_methodize.rb", "test/core/module/test_modspace.rb", "test/core/module/test_nesting.rb", "test/core/module/test_op.rb", "test/core/module/test_pathize.rb", "test/core/module/test_prepend.rb", "test/core/module/test_redefine_method.rb", "test/core/module/test_redirect_method.rb", "test/core/module/test_rename_method.rb", "test/core/module/test_revise.rb", "test/core/module/test_spacename.rb", "test/core/module/test_wrap_method.rb", "test/core/nilclass/test_to_f.rb", "test/core/numeric/test_approx.rb", "test/core/numeric/test_distance.rb", "test/core/numeric/test_round.rb", "test/core/proc/test_bind.rb", "test/core/proc/test_compose.rb", "test/core/proc/test_curry.rb", "test/core/proc/test_to_method.rb", "test/core/range/test_combine.rb", "test/core/range/test_overlap.rb", "test/core/range/test_to_r.rb", "test/core/range/test_within.rb", "test/core/regexp/test_arity.rb", "test/core/regexp/test_to_re.rb", "test/core/string/test_align.rb", "test/core/string/test_bracket.rb", "test/core/string/test_bytes.rb", "test/core/string/test_camelcase.rb", "test/core/string/test_capitalized.rb", "test/core/string/test_chars.rb", "test/core/string/test_cleave.rb", "test/core/string/test_divide.rb", "test/core/string/test_each_char.rb", "test/core/string/test_each_word.rb", "test/core/string/test_end_with.rb", "test/core/string/test_fold.rb", "test/core/string/test_indent.rb", "test/core/string/test_interpolate.rb", "test/core/string/test_lchomp.rb", "test/core/string/test_line_wrap.rb", "test/core/string/test_lines.rb", "test/core/string/test_margin.rb", "test/core/string/test_methodize.rb", "test/core/string/test_modulize.rb", "test/core/string/test_mscan.rb", "test/core/string/test_natcmp.rb", "test/core/string/test_nchar.rb", "test/core/string/test_op_sub.rb", "test/core/string/test_outdent.rb", "test/core/string/test_pathize.rb", "test/core/string/test_range.rb", "test/core/string/test_rewrite.rb", "test/core/string/test_shatter.rb", "test/core/string/test_snakecase.rb", "test/core/string/test_splice.rb", "test/core/string/test_start_with.rb", "test/core/string/test_subtract.rb", "test/core/string/test_tab.rb", "test/core/string/test_tabto.rb", "test/core/string/test_titlecase.rb", "test/core/string/test_to_re.rb", "test/core/string/test_unfold.rb", "test/core/string/test_variablize.rb", "test/core/string/test_word_wrap.rb", "test/core/string/test_words.rb", "test/core/string/test_xor.rb", "test/core/symbol/test_chomp.rb", "test/core/symbol/test_generate.rb", "test/core/symbol/test_not.rb", "test/core/symbol/test_plain.rb", "test/core/symbol/test_query.rb", "test/core/symbol/test_setter.rb", "test/core/symbol/test_succ.rb", "test/core/symbol/test_to_proc.rb", "test/core/test_blank.rb", "test/core/test_boolean.rb", "test/core/test_functor.rb", "test/core/test_metaid.rb", "test/core/test_to_hash.rb", "test/core/time/test_change.rb", "test/core/time/test_elapse.rb", "test/core/time/test_hence.rb", "test/core/time/test_round.rb", "test/core/time/test_stamp.rb", "test/core/time/test_to_time.rb", "test/core/time/test_trunc.rb", "test/core/unboundmethod/test_arguments.rb", "test/core/unboundmethod/test_name.rb", "test/more/test_ansicode.rb", "test/more/test_argvector.rb", "test/more/test_autoarray.rb", "test/more/test_basicobject.rb", "test/more/test_class_extend.rb", "test/more/test_cloneable.rb", "test/more/test_continuation.rb", "test/more/test_coroutine.rb", "test/more/test_date.rb", "test/more/test_dictionary.rb", "test/more/test_enumargs.rb", "test/more/test_equitable.rb", "test/more/test_getoptlong.rb", "test/more/test_inheritor.rb", "test/more/test_instance_function.rb", "test/more/test_instantiable.rb", "test/more/test_memoize.rb", "test/more/test_methodspace.rb", "test/more/test_multipliers.rb", "test/more/test_multiton.rb", "test/more/test_opencascade.rb", "test/more/test_openobject.rb", "test/more/test_ostruct.rb", "test/more/test_partial.rb", "test/more/test_random.rb", "test/more/test_recorder.rb", "test/more/test_succ.rb", "test/more/test_thread.rb", "test/more/test_timer.rb", "test/more/test_tuple.rb", "test/more/test_uri.rb", "Rakefile", "HISTORY.rdoc", "NOTES", "TODO", "README.rdoc", "AUTHORS", "COPYING", "MANIFEST"]
  s.homepage = %q{http://facets.rubyforge.org}
  s.rdoc_options = ["--inline-source", "--title", "facets api"]
  s.require_paths = ["lib/core", "lib/more"]
  s.rubyforge_project = %q{facets}
  s.rubygems_version = %q{1.3.5}
  s.summary = %q{Premium Core Extensions and Standard Additions}
  s.test_files = ["lib/core/facets/filetest.rb", "lib/more/facets/module/attr_tester.rb", "test/core/array/test_combination.rb", "test/core/array/test_delete.rb", "test/core/array/test_index.rb", "test/core/array/test_indexable.rb", "test/core/array/test_merge.rb", "test/core/array/test_only.rb", "test/core/array/test_pad.rb", "test/core/array/test_permutation.rb", "test/core/array/test_product.rb", "test/core/array/test_rotate.rb", "test/core/array/test_select.rb", "test/core/array/test_stackable.rb", "test/core/binding/test_caller.rb", "test/core/binding/test_defined.rb", "test/core/binding/test_eval.rb", "test/core/binding/test_local_variables.rb", "test/core/binding/test_opvars.rb", "test/core/binding/test_self.rb", "test/core/class/test_cattr.rb", "test/core/class/test_cattr_accessor.rb", "test/core/class/test_cattr_reader.rb", "test/core/class/test_cattr_writer.rb", "test/core/class/test_descendents.rb", "test/core/class/test_to_proc.rb", "test/core/comparable/test_cap.rb", "test/core/comparable/test_clip.rb", "test/core/comparable/test_cmp.rb", "test/core/comparable/test_comparable.rb", "test/core/dir/test_ascend.rb", "test/core/dir/test_descend.rb", "test/core/dir/test_multiglob.rb", "test/core/dir/test_parent.rb", "test/core/dir/test_recurse.rb", "test/core/enumerable/test_cluster_by.rb", "test/core/enumerable/test_collect.rb", "test/core/enumerable/test_commonality.rb", "test/core/enumerable/test_count.rb", "test/core/enumerable/test_defer.rb", "test/core/enumerable/test_each_by.rb", "test/core/enumerable/test_entropy.rb", "test/core/enumerable/test_every.rb", "test/core/enumerable/test_ewise.rb", "test/core/enumerable/test_frequency.rb", "test/core/enumerable/test_group_by.rb", "test/core/enumerable/test_inject.rb", "test/core/enumerable/test_mash.rb", "test/core/enumerable/test_modulate.rb", "test/core/enumerable/test_none.rb", "test/core/enumerable/test_occur.rb", "test/core/enumerable/test_one.rb", "test/core/enumerable/test_per.rb", "test/core/enumerable/test_probability.rb", "test/core/enumerable/test_split.rb", "test/core/enumerable/test_take.rb", "test/core/enumerable/test_uniq_by.rb", "test/core/exception/test_exception.rb", "test/core/file/test_create.rb", "test/core/file/test_file.rb", "test/core/file/test_null.rb", "test/core/file/test_rewrite.rb", "test/core/file/test_split_all.rb", "test/core/file/test_write.rb", "test/core/file/test_writelines.rb", "test/core/filetest/test_filetest.rb", "test/core/hash/test_alias.rb", "test/core/hash/test_at.rb", "test/core/hash/test_autonew.rb", "test/core/hash/test_collate.rb", "test/core/hash/test_dearray_values.rb", "test/core/hash/test_delete.rb", "test/core/hash/test_insert.rb", "test/core/hash/test_inverse.rb", "test/core/hash/test_keys.rb", "test/core/hash/test_mash.rb", "test/core/hash/test_merge.rb", "test/core/hash/test_op.rb", "test/core/hash/test_op_add.rb", "test/core/hash/test_op_and.rb", "test/core/hash/test_op_mul.rb", "test/core/hash/test_op_or.rb", "test/core/hash/test_op_push.rb", "test/core/hash/test_op_sub.rb", "test/core/hash/test_rekey.rb", "test/core/hash/test_replace_each.rb", "test/core/hash/test_select.rb", "test/core/hash/test_slice.rb", "test/core/hash/test_stringify_keys.rb", "test/core/hash/test_swap.rb", "test/core/hash/test_symbolize_keys.rb", "test/core/hash/test_traverse.rb", "test/core/hash/test_update_each.rb", "test/core/hash/test_update_keys.rb", "test/core/hash/test_update_values.rb", "test/core/hash/test_weave.rb", "test/core/hash/test_zipnew.rb", "test/core/integer/test_bitmask.rb", "test/core/integer/test_even.rb", "test/core/integer/test_factorial.rb", "test/core/integer/test_length.rb", "test/core/integer/test_multiple.rb", "test/core/integer/test_odd.rb", "test/core/integer/test_of.rb", "test/core/integer/test_ordinal.rb", "test/core/kernel/test_as.rb", "test/core/kernel/test_attr_singleton.rb", "test/core/kernel/test_callstack.rb", "test/core/kernel/test_constant.rb", "test/core/kernel/test_deepcopy.rb", "test/core/kernel/test_here.rb", "test/core/kernel/test_in.rb", "test/core/kernel/test_instance_assign.rb", "test/core/kernel/test_instance_class.rb", "test/core/kernel/test_method.rb", "test/core/kernel/test_not_nil.rb", "test/core/kernel/test_object_class.rb", "test/core/kernel/test_object_hexid.rb", "test/core/kernel/test_populate.rb", "test/core/kernel/test_resc.rb", "test/core/kernel/test_returning.rb", "test/core/kernel/test_silence.rb", "test/core/kernel/test_tap.rb", "test/core/kernel/test_val.rb", "test/core/matchdata/test_match.rb", "test/core/matchdata/test_matchset.rb", "test/core/module/test_abstract.rb", "test/core/module/test_alias_accessor.rb", "test/core/module/test_alias_method_chain.rb", "test/core/module/test_alias_module_function.rb", "test/core/module/test_ancestor.rb", "test/core/module/test_basename.rb", "test/core/module/test_can.rb", "test/core/module/test_class.rb", "test/core/module/test_conflict.rb", "test/core/module/test_integrate.rb", "test/core/module/test_is.rb", "test/core/module/test_methodize.rb", "test/core/module/test_modspace.rb", "test/core/module/test_nesting.rb", "test/core/module/test_op.rb", "test/core/module/test_pathize.rb", "test/core/module/test_prepend.rb", "test/core/module/test_redefine_method.rb", "test/core/module/test_redirect_method.rb", "test/core/module/test_rename_method.rb", "test/core/module/test_revise.rb", "test/core/module/test_spacename.rb", "test/core/module/test_wrap_method.rb", "test/core/nilclass/test_to_f.rb", "test/core/numeric/test_approx.rb", "test/core/numeric/test_distance.rb", "test/core/numeric/test_round.rb", "test/core/proc/test_bind.rb", "test/core/proc/test_compose.rb", "test/core/proc/test_curry.rb", "test/core/proc/test_to_method.rb", "test/core/range/test_combine.rb", "test/core/range/test_overlap.rb", "test/core/range/test_to_r.rb", "test/core/range/test_within.rb", "test/core/regexp/test_arity.rb", "test/core/regexp/test_to_re.rb", "test/core/string/test_align.rb", "test/core/string/test_bracket.rb", "test/core/string/test_bytes.rb", "test/core/string/test_camelcase.rb", "test/core/string/test_capitalized.rb", "test/core/string/test_chars.rb", "test/core/string/test_cleave.rb", "test/core/string/test_divide.rb", "test/core/string/test_each_char.rb", "test/core/string/test_each_word.rb", "test/core/string/test_end_with.rb", "test/core/string/test_fold.rb", "test/core/string/test_indent.rb", "test/core/string/test_interpolate.rb", "test/core/string/test_lchomp.rb", "test/core/string/test_line_wrap.rb", "test/core/string/test_lines.rb", "test/core/string/test_margin.rb", "test/core/string/test_methodize.rb", "test/core/string/test_modulize.rb", "test/core/string/test_mscan.rb", "test/core/string/test_natcmp.rb", "test/core/string/test_nchar.rb", "test/core/string/test_op_sub.rb", "test/core/string/test_outdent.rb", "test/core/string/test_pathize.rb", "test/core/string/test_range.rb", "test/core/string/test_rewrite.rb", "test/core/string/test_shatter.rb", "test/core/string/test_snakecase.rb", "test/core/string/test_splice.rb", "test/core/string/test_start_with.rb", "test/core/string/test_subtract.rb", "test/core/string/test_tab.rb", "test/core/string/test_tabto.rb", "test/core/string/test_titlecase.rb", "test/core/string/test_to_re.rb", "test/core/string/test_unfold.rb", "test/core/string/test_variablize.rb", "test/core/string/test_word_wrap.rb", "test/core/string/test_words.rb", "test/core/string/test_xor.rb", "test/core/symbol/test_chomp.rb", "test/core/symbol/test_generate.rb", "test/core/symbol/test_not.rb", "test/core/symbol/test_plain.rb", "test/core/symbol/test_query.rb", "test/core/symbol/test_setter.rb", "test/core/symbol/test_succ.rb", "test/core/symbol/test_to_proc.rb", "test/core/test_blank.rb", "test/core/test_boolean.rb", "test/core/test_functor.rb", "test/core/test_metaid.rb", "test/core/test_to_hash.rb", "test/core/time/test_change.rb", "test/core/time/test_elapse.rb", "test/core/time/test_hence.rb", "test/core/time/test_round.rb", "test/core/time/test_stamp.rb", "test/core/time/test_to_time.rb", "test/core/time/test_trunc.rb", "test/core/unboundmethod/test_arguments.rb", "test/core/unboundmethod/test_name.rb", "test/more/test_ansicode.rb", "test/more/test_argvector.rb", "test/more/test_autoarray.rb", "test/more/test_basicobject.rb", "test/more/test_class_extend.rb", "test/more/test_cloneable.rb", "test/more/test_continuation.rb", "test/more/test_coroutine.rb", "test/more/test_date.rb", "test/more/test_dictionary.rb", "test/more/test_enumargs.rb", "test/more/test_equitable.rb", "test/more/test_getoptlong.rb", "test/more/test_inheritor.rb", "test/more/test_instance_function.rb", "test/more/test_instantiable.rb", "test/more/test_memoize.rb", "test/more/test_methodspace.rb", "test/more/test_multipliers.rb", "test/more/test_multiton.rb", "test/more/test_opencascade.rb", "test/more/test_openobject.rb", "test/more/test_ostruct.rb", "test/more/test_partial.rb", "test/more/test_random.rb", "test/more/test_recorder.rb", "test/more/test_succ.rb", "test/more/test_thread.rb", "test/more/test_timer.rb", "test/more/test_tuple.rb", "test/more/test_uri.rb"]

  if s.respond_to? :specification_version then
    current_version = Gem::Specification::CURRENT_SPECIFICATION_VERSION
    s.specification_version = 3

    if Gem::Version.new(Gem::RubyGemsVersion) >= Gem::Version.new('1.2.0') then
    else
    end
  else
  end
end
