/*
  libuta - a C++ widget library based on SDL (Simple Direct Layer)
  Copyright (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/
// written by Karsten Laux, August 1999

#ifndef _MUTEX_H_
#define _MUTEX_H_

#include <SDL/SDL_mutex.h>

namespace uta {

class DirectSurface;
class ScreenSurface;

///Mutex class.
class Mutex
{
 public:
  
  /* this is ugly implementation ...
     these classes need for their implementation access to SDL_mutex ...
  */
  friend class uta::DirectSurface;
  friend class uta::ScreenSurface;
  
  ///
  Mutex() { mutex = SDL_CreateMutex();}
  ///
  ~Mutex() { SDL_DestroyMutex(mutex); }

  ///
  void release() { SDL_mutexV(mutex);}
  ///
  void grab() { SDL_mutexP(mutex);}

 protected:
  ///
  SDL_mutex* mutex;

};



}



#endif
  
