/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.catalina.Context;
import org.apache.catalina.util.Enumerator;
import org.apache.catalina.util.RequestUtil;
import org.apache.catalina.util.StringManager;

class ApplicationHttpRequest
extends HttpServletRequestWrapper {
    protected static final String[] specials = new String[]{"javax.servlet.include.request_uri", "javax.servlet.include.context_path", "javax.servlet.include.servlet_path", "javax.servlet.include.path_info", "javax.servlet.include.query_string"};
    protected Context context;
    protected HashMap attributes = new HashMap();
    protected String contextPath = null;
    protected static final String info = "org.apache.catalina.core.ApplicationHttpRequest/1.0";
    protected Map parameters = new HashMap();
    protected String pathInfo = null;
    protected String queryString = null;
    protected String requestURI = null;
    protected String servletPath = null;
    protected static StringManager sm = StringManager.getManager("org.apache.catalina.core");

    public ApplicationHttpRequest(HttpServletRequest request, Context context) {
        super(request);
        this.setRequest(request);
        this.context = context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAttribute(String name) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return this.attributes.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getAttributeNames() {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            return new Enumerator(this.attributes.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAttribute(String name) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.remove(name);
            if (!this.isSpecial(name)) {
                this.getRequest().removeAttribute(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAttribute(String name, Object value) {
        HashMap hashMap = this.attributes;
        synchronized (hashMap) {
            this.attributes.put(name, value);
            if (!this.isSpecial(name)) {
                this.getRequest().setAttribute(name, value);
            }
        }
    }

    public String getContextPath() {
        return this.contextPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getParameter(String name) {
        Map map = this.parameters;
        synchronized (map) {
            Object value = this.parameters.get(name);
            if (value == null) {
                return null;
            }
            if (value instanceof String[]) {
                return ((String[])value)[0];
            }
            if (value instanceof String) {
                return (String)value;
            }
            return value.toString();
        }
    }

    public Map getParameterMap() {
        return this.parameters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration getParameterNames() {
        Map map = this.parameters;
        synchronized (map) {
            return new Enumerator(this.parameters.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getParameterValues(String name) {
        Map map = this.parameters;
        synchronized (map) {
            Object value = this.parameters.get(name);
            if (value == null) {
                return null;
            }
            if (value instanceof String[]) {
                return (String[])value;
            }
            if (value instanceof String) {
                String[] values = new String[]{(String)value};
                return values;
            }
            String[] values = new String[]{value.toString()};
            return values;
        }
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getInfo() {
        return info;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.context == null) {
            return null;
        }
        if (path == null) {
            return null;
        }
        if (path.startsWith("/")) {
            return this.context.getServletContext().getRequestDispatcher(path);
        }
        String servletPath = (String)this.getAttribute("javax.servlet.include.servlet_path");
        if (servletPath == null) {
            servletPath = this.getServletPath();
        }
        int pos = servletPath.lastIndexOf(47);
        String relative = null;
        relative = pos >= 0 ? servletPath.substring(0, pos + 1) + path : servletPath + path;
        return this.context.getServletContext().getRequestDispatcher(relative);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map copyMap(Map orig) {
        if (orig == null) {
            return new HashMap();
        }
        HashMap dest = new HashMap();
        Map map = orig;
        synchronized (map) {
            Iterator keys = orig.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                dest.put(key, orig.get(key));
            }
        }
        return dest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeParameters(String queryString) {
        if (queryString == null || queryString.length() < 1) {
            return;
        }
        HashMap<String, Object> queryParameters = new HashMap<String, Object>();
        String encoding = this.getCharacterEncoding();
        if (encoding == null) {
            encoding = "ISO-8859-1";
        }
        try {
            RequestUtil.parseParameters(queryParameters, queryString, encoding);
        }
        catch (Exception e) {
            // empty catch block
        }
        Map map = this.parameters;
        synchronized (map) {
            Iterator keys = this.parameters.keySet().iterator();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                Object value = queryParameters.get(key);
                if (value == null) {
                    queryParameters.put(key, this.parameters.get(key));
                    continue;
                }
                queryParameters.put(key, this.mergeValues(value, this.parameters.get(key)));
            }
            this.parameters = queryParameters;
        }
    }

    void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    void setPathInfo(String pathInfo) {
        this.pathInfo = pathInfo;
    }

    void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setRequest(HttpServletRequest request) {
        super.setRequest((ServletRequest)request);
        Map map = this.attributes;
        synchronized (map) {
            this.attributes.clear();
            Enumeration names = request.getAttributeNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                if ("javax.servlet.include.request_uri".equals(name) || "javax.servlet.include.servlet_path".equals(name)) continue;
                Object value = request.getAttribute(name);
                this.attributes.put(name, value);
            }
        }
        map = this.parameters;
        synchronized (map) {
            this.parameters = this.copyMap(request.getParameterMap());
        }
        this.contextPath = request.getContextPath();
        this.pathInfo = request.getPathInfo();
        this.queryString = request.getQueryString();
        this.requestURI = request.getRequestURI();
        this.servletPath = request.getServletPath();
    }

    void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    protected boolean isSpecial(String name) {
        for (int i = 0; i < specials.length; ++i) {
            if (!specials[i].equals(name)) continue;
            return true;
        }
        return false;
    }

    protected String[] mergeValues(Object values1, Object values2) {
        int i;
        String[] values;
        ArrayList<Object> results = new ArrayList<Object>();
        if (values1 != null) {
            if (values1 instanceof String) {
                results.add(values1);
            } else if (values1 instanceof String[]) {
                values = (String[])values1;
                for (i = 0; i < values.length; ++i) {
                    results.add(values[i]);
                }
            } else {
                results.add(values1.toString());
            }
        }
        if (values2 != null) {
            if (values2 instanceof String) {
                results.add(values2);
            } else if (values2 instanceof String[]) {
                values = (String[])values2;
                for (i = 0; i < values.length; ++i) {
                    results.add(values[i]);
                }
            } else {
                results.add(values2.toString());
            }
        }
        values = new String[results.size()];
        return results.toArray(values);
    }
}

