/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.browser;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import java.util.StringTokenizer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.DownloadFactory;
import org.eclipse.swt.browser.FilePickerFactory;
import org.eclipse.swt.browser.HelperAppLauncherDialogFactory;
import org.eclipse.swt.browser.InputStream;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.PromptServiceFactory;
import org.eclipse.swt.browser.StatusTextEvent;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowCreator;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.Library;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.LONG;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.XPCOMObject;
import org.eclipse.swt.internal.mozilla.nsEmbedString;
import org.eclipse.swt.internal.mozilla.nsIAppShell;
import org.eclipse.swt.internal.mozilla.nsIBaseWindow;
import org.eclipse.swt.internal.mozilla.nsICategoryManager;
import org.eclipse.swt.internal.mozilla.nsIComponentManager;
import org.eclipse.swt.internal.mozilla.nsIComponentRegistrar;
import org.eclipse.swt.internal.mozilla.nsIContextMenuListener;
import org.eclipse.swt.internal.mozilla.nsICookie;
import org.eclipse.swt.internal.mozilla.nsICookieManager;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIDOMEvent;
import org.eclipse.swt.internal.mozilla.nsIDOMMouseEvent;
import org.eclipse.swt.internal.mozilla.nsIDOMWindow;
import org.eclipse.swt.internal.mozilla.nsIDirectoryService;
import org.eclipse.swt.internal.mozilla.nsIDocShell;
import org.eclipse.swt.internal.mozilla.nsIEmbeddingSiteWindow;
import org.eclipse.swt.internal.mozilla.nsIFile;
import org.eclipse.swt.internal.mozilla.nsIIOService;
import org.eclipse.swt.internal.mozilla.nsIInterfaceRequestor;
import org.eclipse.swt.internal.mozilla.nsILocalFile;
import org.eclipse.swt.internal.mozilla.nsIPrefBranch;
import org.eclipse.swt.internal.mozilla.nsIPrefLocalizedString;
import org.eclipse.swt.internal.mozilla.nsIPrefService;
import org.eclipse.swt.internal.mozilla.nsIProperties;
import org.eclipse.swt.internal.mozilla.nsIRequest;
import org.eclipse.swt.internal.mozilla.nsIServiceManager;
import org.eclipse.swt.internal.mozilla.nsISimpleEnumerator;
import org.eclipse.swt.internal.mozilla.nsISupports;
import org.eclipse.swt.internal.mozilla.nsISupportsWeakReference;
import org.eclipse.swt.internal.mozilla.nsITooltipListener;
import org.eclipse.swt.internal.mozilla.nsIURI;
import org.eclipse.swt.internal.mozilla.nsIURIContentListener;
import org.eclipse.swt.internal.mozilla.nsIWeakReference;
import org.eclipse.swt.internal.mozilla.nsIWebBrowser;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserChrome;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserChromeFocus;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserFocus;
import org.eclipse.swt.internal.mozilla.nsIWebBrowserStream;
import org.eclipse.swt.internal.mozilla.nsIWebNavigation;
import org.eclipse.swt.internal.mozilla.nsIWebProgress;
import org.eclipse.swt.internal.mozilla.nsIWebProgressListener;
import org.eclipse.swt.internal.mozilla.nsIWindowWatcher;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Browser
extends Composite {
    int embedHandle;
    int mozillaHandle;
    nsIWebBrowser webBrowser;
    XPCOMObject supports;
    XPCOMObject weakReference;
    XPCOMObject webProgressListener;
    XPCOMObject webBrowserChrome;
    XPCOMObject webBrowserChromeFocus;
    XPCOMObject embeddingSiteWindow;
    XPCOMObject interfaceRequestor;
    XPCOMObject supportsWeakReference;
    XPCOMObject contextMenuListener;
    XPCOMObject uriContentListener;
    XPCOMObject tooltipListener;
    int chromeFlags = 1;
    int refCount = 0;
    int request;
    Point location;
    Point size;
    boolean addressBar;
    boolean menuBar;
    boolean statusBar;
    boolean toolBar;
    boolean visible;
    Shell tip = null;
    CloseWindowListener[] closeWindowListeners = new CloseWindowListener[0];
    LocationListener[] locationListeners = new LocationListener[0];
    OpenWindowListener[] openWindowListeners = new OpenWindowListener[0];
    ProgressListener[] progressListeners = new ProgressListener[0];
    StatusTextListener[] statusTextListeners = new StatusTextListener[0];
    TitleListener[] titleListeners = new TitleListener[0];
    VisibilityWindowListener[] visibilityWindowListeners = new VisibilityWindowListener[0];
    static nsIAppShell AppShell;
    static WindowCreator WindowCreator;
    static int BrowserCount;
    static boolean mozilla;
    static boolean ignoreDispose;
    static boolean usingProfile;
    static Callback eventCallback;
    static int eventProc;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.browser.";
    static final String ADD_WIDGET_KEY = "org.eclipse.swt.internal.addWidget";
    static final String NO_INPUT_METHOD = "org.eclipse.swt.internal.gtk.noInputMethod";
    static final String URI_FROMMEMORY = "file:///";
    static final String ABOUT_BLANK = "about:blank";
    static final String PREFERENCE_LANGUAGES = "intl.accept_languages";
    static final String PREFERENCE_CHARSET = "intl.charset.default";
    static final String SEPARATOR_LOCALE = "-";
    static final String TOKENIZER_LOCALE = ",";
    static final String PROFILE_DIR = "/eclipse";
    static final int STOP_PROPOGATE = 1;

    public Browser(Composite parent, int style) {
        super(Browser.fixIM(parent), style);
        int list;
        Display display = parent.getDisplay();
        display.setData(NO_INPUT_METHOD, null);
        int[] result = new int[1];
        if (!mozilla) {
            int length;
            File file;
            String mozillaPath = null;
            int ptr = OS.getenv(Converter.wcsToMbcs(null, "MOZILLA_FIVE_HOME", true));
            if (ptr != 0) {
                int length2 = OS.strlen(ptr);
                byte[] buffer = new byte[length2];
                OS.memmove(buffer, ptr, length2);
                mozillaPath = new String(Converter.mbcsToWcs(null, buffer));
            }
            if (mozillaPath == null) {
                this.dispose();
                SWT.error(2, null, " [Unknown Mozilla path (MOZILLA_FIVE_HOME not set)]");
            }
            if ((file = new File(mozillaPath, "components/libwidget_gtk.so")).exists()) {
                this.dispose();
                SWT.error(2, null, " [Mozilla GTK2 required (GTK1.2 detected)]");
            }
            try {
                Library.loadLibrary("swt-mozilla");
            }
            catch (UnsatisfiedLinkError e) {
                try {
                    Library.loadLibrary("swt-mozilla-gcc3");
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    this.dispose();
                    SWT.error(2, e);
                }
            }
            usingProfile = true;
            int[] retVal = new int[1];
            nsEmbedString pathString = new nsEmbedString(mozillaPath);
            int rc = XPCOM.NS_NewLocalFile(pathString.getAddress(), true, retVal);
            pathString.dispose();
            if (rc != 0) {
                Browser.error(rc);
            }
            if (retVal[0] == 0) {
                Browser.error(-2147467261);
            }
            nsILocalFile localFile = new nsILocalFile(retVal[0]);
            rc = XPCOM.NS_InitXPCOM2(0, localFile.getAddress(), 0);
            localFile.Release();
            if (rc != 0) {
                this.dispose();
                SWT.error(2, null, " [NS_InitXPCOM2 " + mozillaPath + " error " + rc + "]");
            }
            if ((rc = XPCOM.NS_GetComponentManager(result)) != 0) {
                Browser.error(rc);
            }
            if (result[0] == 0) {
                Browser.error(-2147467262);
            }
            nsIComponentManager componentManager = new nsIComponentManager(result[0]);
            result[0] = 0;
            rc = componentManager.CreateInstance(XPCOM.NS_APPSHELL_CID, 0, nsIAppShell.NS_IAPPSHELL_IID, result);
            if (rc != 0) {
                Browser.error(rc);
            }
            if (result[0] == 0) {
                Browser.error(-2147467262);
            }
            if ((rc = (AppShell = new nsIAppShell(result[0])).Create(0, null)) != 0) {
                Browser.error(rc);
            }
            if ((rc = AppShell.Spinup()) != 0) {
                Browser.error(rc);
            }
            WindowCreator = new WindowCreator();
            WindowCreator.AddRef();
            rc = XPCOM.NS_GetServiceManager(result);
            if (rc != 0) {
                Browser.error(rc);
            }
            if (result[0] == 0) {
                Browser.error(-2147467262);
            }
            nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
            result[0] = 0;
            byte[] buffer = "@mozilla.org/embedcomp/window-watcher;1".getBytes();
            byte[] aContractID = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
            rc = serviceManager.GetServiceByContractID(aContractID, nsIWindowWatcher.NS_IWINDOWWATCHER_IID, result);
            if (rc != 0) {
                Browser.error(rc);
            }
            if (result[0] == 0) {
                Browser.error(-2147467262);
            }
            nsIWindowWatcher windowWatcher = new nsIWindowWatcher(result[0]);
            result[0] = 0;
            rc = windowWatcher.SetWindowCreator(WindowCreator.getAddress());
            if (rc != 0) {
                Browser.error(rc);
            }
            windowWatcher.Release();
            if (usingProfile) {
                buffer = Converter.wcsToMbcs(null, "@mozilla.org/file/directory_service;1", true);
                rc = serviceManager.GetServiceByContractID(buffer, nsIDirectoryService.NS_IDIRECTORYSERVICE_IID, result);
                if (rc != 0) {
                    Browser.error(rc);
                }
                if (result[0] == 0) {
                    Browser.error(-2147467262);
                }
                nsIDirectoryService directoryService = new nsIDirectoryService(result[0]);
                result[0] = 0;
                rc = directoryService.QueryInterface(nsIProperties.NS_IPROPERTIES_IID, result);
                if (rc != 0) {
                    Browser.error(rc);
                }
                if (result[0] == 0) {
                    Browser.error(-2147467262);
                }
                directoryService.Release();
                nsIProperties properties = new nsIProperties(result[0]);
                result[0] = 0;
                buffer = Converter.wcsToMbcs(null, "AppRegD", true);
                rc = properties.Get(buffer, nsIFile.NS_IFILE_IID, result);
                if (rc != 0) {
                    Browser.error(rc);
                }
                if (result[0] == 0) {
                    Browser.error(-2147467262);
                }
                nsIFile profileDir = new nsIFile(result[0]);
                result[0] = 0;
                int path = XPCOM.nsEmbedCString_new();
                rc = profileDir.GetNativePath(path);
                if (rc != 0) {
                    Browser.error(rc);
                }
                profileDir.Release();
                length = XPCOM.nsEmbedCString_Length(path);
                ptr = XPCOM.nsEmbedCString_get(path);
                buffer = new byte[length];
                XPCOM.memmove(buffer, ptr, length);
                XPCOM.nsEmbedCString_delete(path);
                String string = String.valueOf(new String(Converter.mbcsToWcs(null, buffer))) + PROFILE_DIR;
                pathString = new nsEmbedString(string);
                rc = XPCOM.NS_NewLocalFile(pathString.getAddress(), true, result);
                if (rc != 0) {
                    Browser.error(rc);
                }
                if (result[0] == 0) {
                    Browser.error(-2147467261);
                }
                pathString.dispose();
                profileDir = new nsIFile(result[0]);
                buffer = Converter.wcsToMbcs(null, "ProfD", true);
                rc = properties.Set(buffer, profileDir.getAddress());
                if (rc != 0) {
                    Browser.error(rc);
                }
                properties.Release();
                result[0] = 0;
            }
            buffer = "@mozilla.org/preferences-service;1".getBytes();
            aContractID = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
            rc = serviceManager.GetServiceByContractID(aContractID, nsIPrefService.NS_IPREFSERVICE_IID, result);
            serviceManager.Release();
            if (rc != 0) {
                Browser.error(rc);
            }
            if (result[0] == 0) {
                Browser.error(-2147467262);
            }
            nsIPrefService prefService = new nsIPrefService(result[0]);
            result[0] = 0;
            buffer = new byte[1];
            rc = prefService.GetBranch(buffer, result);
            prefService.Release();
            if (rc != 0) {
                Browser.error(rc);
            }
            if (result[0] == 0) {
                Browser.error(-2147467262);
            }
            nsIPrefBranch prefBranch = new nsIPrefBranch(result[0]);
            result[0] = 0;
            String prefLocales = null;
            nsIPrefLocalizedString localizedString = null;
            buffer = Converter.wcsToMbcs(null, PREFERENCE_LANGUAGES, true);
            rc = prefBranch.GetComplexValue(buffer, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, result);
            if (rc != 0) {
                prefLocales = "en-us,en,";
            } else {
                if (result[0] == 0) {
                    Browser.error(-2147467262);
                }
                localizedString = new nsIPrefLocalizedString(result[0]);
                result[0] = 0;
                rc = localizedString.ToString(result);
                if (rc != 0) {
                    Browser.error(rc);
                }
                if (result[0] == 0) {
                    Browser.error(-2147467262);
                }
                length = XPCOM.strlen_PRUnichar(result[0]);
                char[] dest = new char[length];
                XPCOM.memmove(dest, result[0], length * 2);
                prefLocales = String.valueOf(new String(dest)) + TOKENIZER_LOCALE;
            }
            result[0] = 0;
            Locale locale = Locale.getDefault();
            String language = locale.getLanguage();
            String country = locale.getCountry();
            StringBuffer stringBuffer = new StringBuffer(language);
            stringBuffer.append(SEPARATOR_LOCALE);
            stringBuffer.append(country.toLowerCase());
            stringBuffer.append(TOKENIZER_LOCALE);
            stringBuffer.append(language);
            stringBuffer.append(TOKENIZER_LOCALE);
            String newLocales = stringBuffer.toString();
            StringTokenizer tokenzier = new StringTokenizer(prefLocales, TOKENIZER_LOCALE);
            while (tokenzier.hasMoreTokens()) {
                String token = (String.valueOf(tokenzier.nextToken()) + TOKENIZER_LOCALE).trim();
                if (newLocales.indexOf(token) != -1) continue;
                stringBuffer.append(token);
            }
            newLocales = stringBuffer.toString();
            if (!newLocales.equals(prefLocales)) {
                newLocales = newLocales.substring(0, newLocales.length() - TOKENIZER_LOCALE.length());
                int length3 = newLocales.length();
                char[] charBuffer = new char[length3 + 1];
                newLocales.getChars(0, length3, charBuffer, 0);
                if (localizedString == null) {
                    byte[] contractID = Converter.wcsToMbcs(null, "@mozilla.org/pref-localizedstring;1", true);
                    rc = componentManager.CreateInstanceByContractID(contractID, 0, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, result);
                    if (rc != 0) {
                        Browser.error(rc);
                    }
                    if (result[0] == 0) {
                        Browser.error(-2147467262);
                    }
                    localizedString = new nsIPrefLocalizedString(result[0]);
                    result[0] = 0;
                }
                localizedString.SetDataWithLength(length3, charBuffer);
                rc = prefBranch.SetComplexValue(buffer, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, localizedString.getAddress());
            }
            if (localizedString != null) {
                localizedString.Release();
                localizedString = null;
            }
            String prefCharset = null;
            buffer = Converter.wcsToMbcs(null, PREFERENCE_CHARSET, true);
            rc = prefBranch.GetComplexValue(buffer, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, result);
            if (rc != 0) {
                prefCharset = "ISO-8859-1";
            } else {
                if (result[0] == 0) {
                    Browser.error(-2147467262);
                }
                localizedString = new nsIPrefLocalizedString(result[0]);
                result[0] = 0;
                rc = localizedString.ToString(result);
                if (rc != 0) {
                    Browser.error(rc);
                }
                if (result[0] == 0) {
                    Browser.error(-2147467262);
                }
                int length4 = XPCOM.strlen_PRUnichar(result[0]);
                char[] dest = new char[length4];
                XPCOM.memmove(dest, result[0], length4 * 2);
                prefCharset = new String(dest);
            }
            result[0] = 0;
            String newCharset = System.getProperty("file.encoding");
            if (!newCharset.equals(prefCharset)) {
                int length5 = newCharset.length();
                char[] charBuffer = new char[length5 + 1];
                newCharset.getChars(0, length5, charBuffer, 0);
                if (localizedString == null) {
                    byte[] contractID = Converter.wcsToMbcs(null, "@mozilla.org/pref-localizedstring;1", true);
                    rc = componentManager.CreateInstanceByContractID(contractID, 0, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, result);
                    if (rc != 0) {
                        Browser.error(rc);
                    }
                    if (result[0] == 0) {
                        Browser.error(-2147467262);
                    }
                    localizedString = new nsIPrefLocalizedString(result[0]);
                    result[0] = 0;
                }
                localizedString.SetDataWithLength(length5, charBuffer);
                rc = prefBranch.SetComplexValue(buffer, nsIPrefLocalizedString.NS_IPREFLOCALIZEDSTRING_IID, localizedString.getAddress());
            }
            if (localizedString != null) {
                localizedString.Release();
            }
            prefBranch.Release();
            PromptServiceFactory factory = new PromptServiceFactory();
            factory.AddRef();
            rc = componentManager.QueryInterface(nsIComponentRegistrar.NS_ICOMPONENTREGISTRAR_IID, result);
            if (rc != 0) {
                Browser.error(rc);
            }
            if (result[0] == 0) {
                Browser.error(-2147467262);
            }
            nsIComponentRegistrar componentRegistrar = new nsIComponentRegistrar(result[0]);
            result[0] = 0;
            buffer = "@mozilla.org/embedcomp/prompt-service;1".getBytes();
            aContractID = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
            buffer = "Prompt Service".getBytes();
            byte[] aClassName = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aClassName, 0, buffer.length);
            rc = componentRegistrar.RegisterFactory(XPCOM.NS_PROMPTSERVICE_CID, aClassName, aContractID, factory.getAddress());
            if (rc != 0) {
                Browser.error(rc);
            }
            factory.Release();
            HelperAppLauncherDialogFactory dialogFactory = new HelperAppLauncherDialogFactory();
            dialogFactory.AddRef();
            buffer = "@mozilla.org/helperapplauncherdialog;1".getBytes();
            aContractID = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
            buffer = "Helper App Launcher Dialog".getBytes();
            aClassName = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aClassName, 0, buffer.length);
            rc = componentRegistrar.RegisterFactory(XPCOM.NS_HELPERAPPLAUNCHERDIALOG_CID, aClassName, aContractID, dialogFactory.getAddress());
            if (rc != 0) {
                Browser.error(rc);
            }
            dialogFactory.Release();
            DownloadFactory downloadFactory = new DownloadFactory();
            downloadFactory.AddRef();
            buffer = "@mozilla.org/download;1".getBytes();
            aContractID = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
            buffer = "Download".getBytes();
            aClassName = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aClassName, 0, buffer.length);
            rc = componentRegistrar.RegisterFactory(XPCOM.NS_DOWNLOAD_CID, aClassName, aContractID, downloadFactory.getAddress());
            if (rc != 0) {
                Browser.error(rc);
            }
            downloadFactory.Release();
            FilePickerFactory pickerFactory = new FilePickerFactory();
            pickerFactory.AddRef();
            buffer = "@mozilla.org/filepicker;1".getBytes();
            aContractID = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
            buffer = "FilePicker".getBytes();
            aClassName = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, aClassName, 0, buffer.length);
            rc = componentRegistrar.RegisterFactory(XPCOM.NS_FILEPICKER_CID, aClassName, aContractID, pickerFactory.getAddress());
            if (rc != 0) {
                Browser.error(rc);
            }
            pickerFactory.Release();
            componentRegistrar.Release();
            componentManager.Release();
            mozilla = true;
        }
        ++BrowserCount;
        int rc = XPCOM.NS_GetComponentManager(result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        nsIComponentManager componentManager = new nsIComponentManager(result[0]);
        result[0] = 0;
        nsID NS_IWEBBROWSER_CID = new nsID("F1EAC761-87E9-11d3-AF80-00A024FFC08C");
        rc = componentManager.CreateInstance(NS_IWEBBROWSER_CID, 0, nsIWebBrowser.NS_IWEBBROWSER_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        componentManager.Release();
        this.webBrowser = new nsIWebBrowser(result[0]);
        this.createCOMInterfaces();
        this.AddRef();
        rc = this.webBrowser.SetContainerWindow(this.webBrowserChrome.getAddress());
        if (rc != 0) {
            Browser.error(rc);
        }
        if ((rc = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result)) != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        nsIBaseWindow baseWindow = new nsIBaseWindow(result[0]);
        Rectangle rect = this.getClientArea();
        if (rect.isEmpty()) {
            rect.width = 1;
            rect.height = 1;
        }
        this.embedHandle = OS.gtk_hbox_new(false, 0);
        OS.gtk_container_add(this.handle, this.embedHandle);
        OS.gtk_widget_show(this.embedHandle);
        rc = baseWindow.InitWindow(this.embedHandle, 0, 0, 0, rect.width, rect.height);
        if (rc != 0) {
            Browser.error(-2147467259);
        }
        if ((rc = baseWindow.Create()) != 0) {
            Browser.error(-2147467259);
        }
        if ((rc = baseWindow.SetVisibility(true)) != 0) {
            Browser.error(-2147467259);
        }
        baseWindow.Release();
        rc = this.webBrowser.AddWebBrowserListener(this.weakReference.getAddress(), nsIWebProgressListener.NS_IWEBPROGRESSLISTENER_IID);
        if (rc != 0) {
            Browser.error(rc);
        }
        if ((rc = this.webBrowser.SetParentURIContentListener(this.uriContentListener.getAddress())) != 0) {
            Browser.error(rc);
        }
        if (eventCallback == null && (eventProc = (eventCallback = new Callback(Browser.class, "eventProc", 3)).getAddress()) == 0) {
            Browser.error(3);
        }
        if ((list = OS.gtk_container_get_children(this.embedHandle)) != 0) {
            this.mozillaHandle = OS.g_list_data(list);
            OS.g_list_free(list);
            if (this.mozillaHandle != 0) {
                this.getDisplay().setData(ADD_WIDGET_KEY, new Object[]{new LONG(this.mozillaHandle), this});
                OS.g_signal_connect(this.mozillaHandle, OS.event, eventProc, 0);
                OS.g_signal_connect(this.mozillaHandle, OS.key_press_event, eventProc, 1);
                OS.g_signal_connect(this.mozillaHandle, OS.key_release_event, eventProc, 1);
            }
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 12: {
                        if (ignoreDispose) {
                            ignoreDispose = false;
                            break;
                        }
                        ignoreDispose = true;
                        Browser.this.notifyListeners(event.type, event);
                        event.type = 0;
                        Browser.this.onDispose(event.display);
                        break;
                    }
                    case 11: {
                        Browser.this.onResize();
                        break;
                    }
                    case 15: {
                        Browser.this.Activate();
                        break;
                    }
                    case 27: {
                        Display display = event.display;
                        if (Browser.this != display.getFocusControl()) break;
                        Browser.this.Deactivate();
                        break;
                    }
                    case 22: {
                        Display display = event.display;
                        display.asyncExec(new Runnable(){

                            public void run() {
                                if (Browser.this.isDisposed()) {
                                    return;
                                }
                                Browser.this.onResize();
                            }
                        });
                    }
                }
            }
        };
        int[] folderEvents = new int[]{12, 11, 15, 27, 22};
        int i = 0;
        while (i < folderEvents.length) {
            this.addListener(folderEvents[i], listener);
            ++i;
        }
    }

    public static void clearSessions() {
        if (!mozilla) {
            return;
        }
        int[] result = new int[1];
        int rc = XPCOM.NS_GetServiceManager(result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
        result[0] = 0;
        byte[] buffer = "@mozilla.org/cookiemanager;1".getBytes();
        byte[] aContractID = new byte[buffer.length + 1];
        System.arraycopy(buffer, 0, aContractID, 0, buffer.length);
        rc = serviceManager.GetServiceByContractID(aContractID, nsICookieManager.NS_ICOOKIEMANAGER_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        serviceManager.Release();
        nsICookieManager manager = new nsICookieManager(result[0]);
        result[0] = 0;
        rc = manager.GetEnumerator(result);
        if (rc != 0) {
            Browser.error(rc);
        }
        manager.Release();
        nsISimpleEnumerator enumerator = new nsISimpleEnumerator(result[0]);
        boolean[] moreElements = new boolean[1];
        rc = enumerator.HasMoreElements(moreElements);
        if (rc != 0) {
            Browser.error(rc);
        }
        while (moreElements[0]) {
            result[0] = 0;
            rc = enumerator.GetNext(result);
            if (rc != 0) {
                Browser.error(rc);
            }
            nsICookie cookie = new nsICookie(result[0]);
            long[] expires = new long[1];
            rc = cookie.GetExpires(expires);
            if (expires[0] == 0L) {
                int domain = XPCOM.nsEmbedCString_new();
                int name = XPCOM.nsEmbedCString_new();
                int path = XPCOM.nsEmbedCString_new();
                cookie.GetHost(domain);
                cookie.GetName(name);
                cookie.GetPath(path);
                rc = manager.Remove(domain, name, path, false);
                XPCOM.nsEmbedCString_delete(domain);
                XPCOM.nsEmbedCString_delete(name);
                XPCOM.nsEmbedCString_delete(path);
                if (rc != 0) {
                    Browser.error(rc);
                }
            }
            cookie.Release();
            rc = enumerator.HasMoreElements(moreElements);
            if (rc == 0) continue;
            Browser.error(rc);
        }
        enumerator.Release();
    }

    static int eventProc(int handle, int gdkEvent, int pointer) {
        Widget widget = Display.getCurrent().findWidget(handle);
        if (widget != null && widget instanceof Browser) {
            return ((Browser)widget).gtk_event(handle, gdkEvent, pointer);
        }
        return 0;
    }

    static Composite fixIM(Composite parent) {
        Display display;
        if (parent != null && !parent.isDisposed() && (display = parent.getDisplay()) != null && display.getThread() == Thread.currentThread()) {
            display.setData(NO_INPUT_METHOD, "true");
        }
        return parent;
    }

    int gtk_event(int handle, int gdkEvent, int pointer) {
        if (pointer == 1) {
            return 1;
        }
        GdkEvent event = new GdkEvent();
        OS.memmove(event, gdkEvent, GdkEvent.sizeof);
        switch (event.type) {
            case 4: 
            case 7: 
            case 8: 
            case 9: {
                OS.gtk_widget_event(this.handle, gdkEvent);
            }
        }
        return 0;
    }

    public void addCloseWindowListener(CloseWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        CloseWindowListener[] newCloseWindowListeners = new CloseWindowListener[this.closeWindowListeners.length + 1];
        System.arraycopy(this.closeWindowListeners, 0, newCloseWindowListeners, 0, this.closeWindowListeners.length);
        this.closeWindowListeners = newCloseWindowListeners;
        this.closeWindowListeners[this.closeWindowListeners.length - 1] = listener;
    }

    public void addLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        LocationListener[] newLocationListeners = new LocationListener[this.locationListeners.length + 1];
        System.arraycopy(this.locationListeners, 0, newLocationListeners, 0, this.locationListeners.length);
        this.locationListeners = newLocationListeners;
        this.locationListeners[this.locationListeners.length - 1] = listener;
    }

    public void addOpenWindowListener(OpenWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[this.openWindowListeners.length + 1];
        System.arraycopy(this.openWindowListeners, 0, newOpenWindowListeners, 0, this.openWindowListeners.length);
        this.openWindowListeners = newOpenWindowListeners;
        this.openWindowListeners[this.openWindowListeners.length - 1] = listener;
    }

    public void addProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        ProgressListener[] newProgressListeners = new ProgressListener[this.progressListeners.length + 1];
        System.arraycopy(this.progressListeners, 0, newProgressListeners, 0, this.progressListeners.length);
        this.progressListeners = newProgressListeners;
        this.progressListeners[this.progressListeners.length - 1] = listener;
    }

    public void addStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        StatusTextListener[] newStatusTextListeners = new StatusTextListener[this.statusTextListeners.length + 1];
        System.arraycopy(this.statusTextListeners, 0, newStatusTextListeners, 0, this.statusTextListeners.length);
        this.statusTextListeners = newStatusTextListeners;
        this.statusTextListeners[this.statusTextListeners.length - 1] = listener;
    }

    public void addTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        TitleListener[] newTitleListeners = new TitleListener[this.titleListeners.length + 1];
        System.arraycopy(this.titleListeners, 0, newTitleListeners, 0, this.titleListeners.length);
        this.titleListeners = newTitleListeners;
        this.titleListeners[this.titleListeners.length - 1] = listener;
    }

    public void addVisibilityWindowListener(VisibilityWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        VisibilityWindowListener[] newVisibilityWindowListeners = new VisibilityWindowListener[this.visibilityWindowListeners.length + 1];
        System.arraycopy(this.visibilityWindowListeners, 0, newVisibilityWindowListeners, 0, this.visibilityWindowListeners.length);
        this.visibilityWindowListeners = newVisibilityWindowListeners;
        this.visibilityWindowListeners[this.visibilityWindowListeners.length - 1] = listener;
    }

    public boolean back() {
        this.checkWidget();
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        rc = webNavigation.GoBack();
        webNavigation.Release();
        return rc == 0;
    }

    protected void checkSubclass() {
        int index;
        String name = this.getClass().getName();
        if (!name.substring(0, (index = name.lastIndexOf(46)) + 1).equals(PACKAGE_PREFIX)) {
            SWT.error(43);
        }
    }

    void createCOMInterfaces() {
        int[] nArray = new int[3];
        nArray[0] = 2;
        this.supports = new XPCOMObject(nArray){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }
        };
        int[] nArray2 = new int[4];
        nArray2[0] = 2;
        nArray2[3] = 2;
        this.weakReference = new XPCOMObject(nArray2){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.QueryReferent(args[0], args[1]);
            }
        };
        int[] nArray3 = new int[8];
        nArray3[0] = 2;
        nArray3[3] = 4;
        nArray3[4] = 6;
        nArray3[5] = 3;
        nArray3[6] = 4;
        nArray3[7] = 3;
        this.webProgressListener = new XPCOMObject(nArray3){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.OnStateChange(args[0], args[1], args[2], args[3]);
            }

            public int method4(int[] args) {
                return Browser.this.OnProgressChange(args[0], args[1], args[2], args[3], args[4], args[5]);
            }

            public int method5(int[] args) {
                return Browser.this.OnLocationChange(args[0], args[1], args[2]);
            }

            public int method6(int[] args) {
                return Browser.this.OnStatusChange(args[0], args[1], args[2], args[3]);
            }

            public int method7(int[] args) {
                return Browser.this.OnSecurityChange(args[0], args[1], args[2]);
            }
        };
        int[] nArray4 = new int[13];
        nArray4[0] = 2;
        nArray4[3] = 2;
        nArray4[4] = 1;
        nArray4[5] = 1;
        nArray4[6] = 1;
        nArray4[7] = 1;
        nArray4[9] = 2;
        nArray4[11] = 1;
        nArray4[12] = 1;
        this.webBrowserChrome = new XPCOMObject(nArray4){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.SetStatus(args[0], args[1]);
            }

            public int method4(int[] args) {
                return Browser.this.GetWebBrowser(args[0]);
            }

            public int method5(int[] args) {
                return Browser.this.SetWebBrowser(args[0]);
            }

            public int method6(int[] args) {
                return Browser.this.GetChromeFlags(args[0]);
            }

            public int method7(int[] args) {
                return Browser.this.SetChromeFlags(args[0]);
            }

            public int method8(int[] args) {
                return Browser.this.DestroyBrowserWindow();
            }

            public int method9(int[] args) {
                return Browser.this.SizeBrowserTo(args[0], args[1]);
            }

            public int method10(int[] args) {
                return Browser.this.ShowAsModal();
            }

            public int method11(int[] args) {
                return Browser.this.IsWindowModal(args[0]);
            }

            public int method12(int[] args) {
                return Browser.this.ExitModalEventLoop(args[0]);
            }
        };
        int[] nArray5 = new int[5];
        nArray5[0] = 2;
        this.webBrowserChromeFocus = new XPCOMObject(nArray5){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.FocusNextElement();
            }

            public int method4(int[] args) {
                return Browser.this.FocusPrevElement();
            }
        };
        int[] nArray6 = new int[11];
        nArray6[0] = 2;
        nArray6[3] = 5;
        nArray6[4] = 5;
        nArray6[6] = 1;
        nArray6[7] = 1;
        nArray6[8] = 1;
        nArray6[9] = 1;
        nArray6[10] = 1;
        this.embeddingSiteWindow = new XPCOMObject(nArray6){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.SetDimensions(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method4(int[] args) {
                return Browser.this.GetDimensions(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method5(int[] args) {
                return Browser.this.SetFocus();
            }

            public int method6(int[] args) {
                return Browser.this.GetVisibility(args[0]);
            }

            public int method7(int[] args) {
                return Browser.this.SetVisibility(args[0]);
            }

            public int method8(int[] args) {
                return Browser.this.GetTitle(args[0]);
            }

            public int method9(int[] args) {
                return Browser.this.SetTitle(args[0]);
            }

            public int method10(int[] args) {
                return Browser.this.GetSiteWindow(args[0]);
            }
        };
        int[] nArray7 = new int[4];
        nArray7[0] = 2;
        nArray7[3] = 2;
        this.interfaceRequestor = new XPCOMObject(nArray7){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.GetInterface(args[0], args[1]);
            }
        };
        int[] nArray8 = new int[4];
        nArray8[0] = 2;
        nArray8[3] = 1;
        this.supportsWeakReference = new XPCOMObject(nArray8){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.GetWeakReference(args[0]);
            }
        };
        int[] nArray9 = new int[4];
        nArray9[0] = 2;
        nArray9[3] = 3;
        this.contextMenuListener = new XPCOMObject(nArray9){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.OnShowContextMenu(args[0], args[1], args[2]);
            }
        };
        int[] nArray10 = new int[11];
        nArray10[0] = 2;
        nArray10[3] = 2;
        nArray10[4] = 5;
        nArray10[5] = 3;
        nArray10[6] = 4;
        nArray10[7] = 1;
        nArray10[8] = 1;
        nArray10[9] = 1;
        nArray10[10] = 1;
        this.uriContentListener = new XPCOMObject(nArray10){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.OnStartURIOpen(args[0], args[1]);
            }

            public int method4(int[] args) {
                return Browser.this.DoContent(args[0], args[1], args[2], args[3], args[4]);
            }

            public int method5(int[] args) {
                return Browser.this.IsPreferred(args[0], args[1], args[2]);
            }

            public int method6(int[] args) {
                return Browser.this.CanHandleContent(args[0], args[1], args[2], args[3]);
            }

            public int method7(int[] args) {
                return Browser.this.GetLoadCookie(args[0]);
            }

            public int method8(int[] args) {
                return Browser.this.SetLoadCookie(args[0]);
            }

            public int method9(int[] args) {
                return Browser.this.GetParentContentListener(args[0]);
            }

            public int method10(int[] args) {
                return Browser.this.SetParentContentListener(args[0]);
            }
        };
        int[] nArray11 = new int[5];
        nArray11[0] = 2;
        nArray11[3] = 3;
        this.tooltipListener = new XPCOMObject(nArray11){

            public int method0(int[] args) {
                return Browser.this.QueryInterface(args[0], args[1]);
            }

            public int method1(int[] args) {
                return Browser.this.AddRef();
            }

            public int method2(int[] args) {
                return Browser.this.Release();
            }

            public int method3(int[] args) {
                return Browser.this.OnShowTooltip(args[0], args[1], args[2]);
            }

            public int method4(int[] args) {
                return Browser.this.OnHideTooltip();
            }
        };
    }

    void disposeCOMInterfaces() {
        if (this.supports != null) {
            this.supports.dispose();
            this.supports = null;
        }
        if (this.weakReference != null) {
            this.weakReference.dispose();
            this.weakReference = null;
        }
        if (this.webProgressListener != null) {
            this.webProgressListener.dispose();
            this.webProgressListener = null;
        }
        if (this.webBrowserChrome != null) {
            this.webBrowserChrome.dispose();
            this.webBrowserChrome = null;
        }
        if (this.webBrowserChromeFocus != null) {
            this.webBrowserChromeFocus.dispose();
            this.webBrowserChromeFocus = null;
        }
        if (this.embeddingSiteWindow != null) {
            this.embeddingSiteWindow.dispose();
            this.embeddingSiteWindow = null;
        }
        if (this.interfaceRequestor != null) {
            this.interfaceRequestor.dispose();
            this.interfaceRequestor = null;
        }
        if (this.supportsWeakReference != null) {
            this.supportsWeakReference.dispose();
            this.supportsWeakReference = null;
        }
        if (this.contextMenuListener != null) {
            this.contextMenuListener.dispose();
            this.contextMenuListener = null;
        }
        if (this.uriContentListener != null) {
            this.uriContentListener.dispose();
            this.uriContentListener = null;
        }
        if (this.tooltipListener != null) {
            this.tooltipListener.dispose();
            this.tooltipListener = null;
        }
    }

    public boolean execute(String script) {
        this.checkWidget();
        if (script == null) {
            SWT.error(4);
        }
        String url = "javascript:" + script + ";void(0);";
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        char[] arg = url.toCharArray();
        char[] c = new char[arg.length + 1];
        System.arraycopy(arg, 0, c, 0, arg.length);
        rc = webNavigation.LoadURI(c, 0, 0, 0, 0);
        webNavigation.Release();
        return rc == 0;
    }

    static Browser findBrowser(int handle) {
        int parent = OS.gtk_widget_get_parent(handle);
        Display display = Display.getCurrent();
        return (Browser)display.findWidget(parent);
    }

    public boolean forward() {
        this.checkWidget();
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        rc = webNavigation.GoForward();
        webNavigation.Release();
        return rc == 0;
    }

    public String getUrl() {
        int[] aCurrentURI;
        nsIWebNavigation webNavigation;
        this.checkWidget();
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        if ((rc = (webNavigation = new nsIWebNavigation(result[0])).GetCurrentURI(aCurrentURI = new int[1])) != 0) {
            Browser.error(rc);
        }
        webNavigation.Release();
        byte[] dest = null;
        if (aCurrentURI[0] != 0) {
            nsIURI uri = new nsIURI(aCurrentURI[0]);
            int aSpec = XPCOM.nsEmbedCString_new();
            rc = uri.GetSpec(aSpec);
            if (rc != 0) {
                Browser.error(rc);
            }
            int length = XPCOM.nsEmbedCString_Length(aSpec);
            int buffer = XPCOM.nsEmbedCString_get(aSpec);
            dest = new byte[length];
            XPCOM.memmove(dest, buffer, length);
            XPCOM.nsEmbedCString_delete(aSpec);
            uri.Release();
        }
        if (dest == null) {
            return "";
        }
        String location = new String(dest);
        if (location.equals(URI_FROMMEMORY)) {
            location = ABOUT_BLANK;
        }
        return location;
    }

    public boolean isBackEnabled() {
        this.checkWidget();
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        boolean[] aCanGoBack = new boolean[1];
        rc = webNavigation.GetCanGoBack(aCanGoBack);
        webNavigation.Release();
        return aCanGoBack[0];
    }

    public boolean isForwardEnabled() {
        this.checkWidget();
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        boolean[] aCanGoForward = new boolean[1];
        rc = webNavigation.GetCanGoForward(aCanGoForward);
        webNavigation.Release();
        return aCanGoForward[0];
    }

    static String error(int code) {
        throw new SWTError("XPCOM error " + code);
    }

    void onDispose(Display display) {
        nsIBaseWindow baseWindow;
        int[] result;
        Object[] objectArray = new Object[2];
        objectArray[0] = new LONG(this.mozillaHandle);
        display.setData(ADD_WIDGET_KEY, objectArray);
        int rc = this.webBrowser.RemoveWebBrowserListener(this.weakReference.getAddress(), nsIWebProgressListener.NS_IWEBPROGRESSLISTENER_IID);
        if (rc != 0) {
            Browser.error(rc);
        }
        if ((rc = this.webBrowser.SetParentURIContentListener(0)) != 0) {
            Browser.error(rc);
        }
        if ((rc = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result = new int[1])) != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        if ((rc = (baseWindow = new nsIBaseWindow(result[0])).Destroy()) != 0) {
            Browser.error(rc);
        }
        baseWindow.Release();
        this.Release();
        this.webBrowser.Release();
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        this.tip = null;
        --BrowserCount;
    }

    void Activate() {
        nsIWebBrowserFocus webBrowserFocus;
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebBrowserFocus.NS_IWEBBROWSERFOCUS_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        if ((rc = (webBrowserFocus = new nsIWebBrowserFocus(result[0])).Activate()) != 0) {
            Browser.error(rc);
        }
        webBrowserFocus.Release();
    }

    void Deactivate() {
        nsIWebBrowserFocus webBrowserFocus;
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebBrowserFocus.NS_IWEBBROWSERFOCUS_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        if ((rc = (webBrowserFocus = new nsIWebBrowserFocus(result[0])).Deactivate()) != 0) {
            Browser.error(rc);
        }
        webBrowserFocus.Release();
    }

    void SetFocusAtFirstElement() {
        nsIWebBrowserFocus webBrowserFocus;
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebBrowserFocus.NS_IWEBBROWSERFOCUS_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        if ((rc = (webBrowserFocus = new nsIWebBrowserFocus(result[0])).SetFocusAtFirstElement()) != 0) {
            Browser.error(rc);
        }
        webBrowserFocus.Release();
    }

    void onResize() {
        Rectangle rect = this.getClientArea();
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        OS.gtk_widget_set_size_request(this.embedHandle, rect.width, rect.height);
        nsIBaseWindow baseWindow = new nsIBaseWindow(result[0]);
        rc = baseWindow.SetPositionAndSize(rect.x, rect.y, rect.width, rect.height, true);
        if (rc != 0) {
            Browser.error(rc);
        }
        baseWindow.Release();
    }

    public void refresh() {
        this.checkWidget();
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        rc = webNavigation.Reload(0);
        webNavigation.Release();
        if (rc == 0) {
            return;
        }
        if (rc != -2147467261 && rc != -2142109678) {
            Browser.error(rc);
        }
    }

    public void removeCloseWindowListener(CloseWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.closeWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.closeWindowListeners.length) {
            if (listener == this.closeWindowListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.closeWindowListeners.length == 1) {
            this.closeWindowListeners = new CloseWindowListener[0];
            return;
        }
        CloseWindowListener[] newCloseWindowListeners = new CloseWindowListener[this.closeWindowListeners.length - 1];
        System.arraycopy(this.closeWindowListeners, 0, newCloseWindowListeners, 0, index);
        System.arraycopy(this.closeWindowListeners, index + 1, newCloseWindowListeners, index, this.closeWindowListeners.length - index - 1);
        this.closeWindowListeners = newCloseWindowListeners;
    }

    public void removeLocationListener(LocationListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.locationListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.locationListeners.length) {
            if (listener == this.locationListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.locationListeners.length == 1) {
            this.locationListeners = new LocationListener[0];
            return;
        }
        LocationListener[] newLocationListeners = new LocationListener[this.locationListeners.length - 1];
        System.arraycopy(this.locationListeners, 0, newLocationListeners, 0, index);
        System.arraycopy(this.locationListeners, index + 1, newLocationListeners, index, this.locationListeners.length - index - 1);
        this.locationListeners = newLocationListeners;
    }

    public void removeOpenWindowListener(OpenWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.openWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.openWindowListeners.length) {
            if (listener == this.openWindowListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.openWindowListeners.length == 1) {
            this.openWindowListeners = new OpenWindowListener[0];
            return;
        }
        OpenWindowListener[] newOpenWindowListeners = new OpenWindowListener[this.openWindowListeners.length - 1];
        System.arraycopy(this.openWindowListeners, 0, newOpenWindowListeners, 0, index);
        System.arraycopy(this.openWindowListeners, index + 1, newOpenWindowListeners, index, this.openWindowListeners.length - index - 1);
        this.openWindowListeners = newOpenWindowListeners;
    }

    public void removeProgressListener(ProgressListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.progressListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.progressListeners.length) {
            if (listener == this.progressListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.progressListeners.length == 1) {
            this.progressListeners = new ProgressListener[0];
            return;
        }
        ProgressListener[] newProgressListeners = new ProgressListener[this.progressListeners.length - 1];
        System.arraycopy(this.progressListeners, 0, newProgressListeners, 0, index);
        System.arraycopy(this.progressListeners, index + 1, newProgressListeners, index, this.progressListeners.length - index - 1);
        this.progressListeners = newProgressListeners;
    }

    public void removeStatusTextListener(StatusTextListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.statusTextListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.statusTextListeners.length) {
            if (listener == this.statusTextListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.statusTextListeners.length == 1) {
            this.statusTextListeners = new StatusTextListener[0];
            return;
        }
        StatusTextListener[] newStatusTextListeners = new StatusTextListener[this.statusTextListeners.length - 1];
        System.arraycopy(this.statusTextListeners, 0, newStatusTextListeners, 0, index);
        System.arraycopy(this.statusTextListeners, index + 1, newStatusTextListeners, index, this.statusTextListeners.length - index - 1);
        this.statusTextListeners = newStatusTextListeners;
    }

    public void removeTitleListener(TitleListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.titleListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.titleListeners.length) {
            if (listener == this.titleListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.titleListeners.length == 1) {
            this.titleListeners = new TitleListener[0];
            return;
        }
        TitleListener[] newTitleListeners = new TitleListener[this.titleListeners.length - 1];
        System.arraycopy(this.titleListeners, 0, newTitleListeners, 0, index);
        System.arraycopy(this.titleListeners, index + 1, newTitleListeners, index, this.titleListeners.length - index - 1);
        this.titleListeners = newTitleListeners;
    }

    public void removeVisibilityWindowListener(VisibilityWindowListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error(4);
        }
        if (this.visibilityWindowListeners.length == 0) {
            return;
        }
        int index = -1;
        int i = 0;
        while (i < this.visibilityWindowListeners.length) {
            if (listener == this.visibilityWindowListeners[i]) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        if (this.visibilityWindowListeners.length == 1) {
            this.visibilityWindowListeners = new VisibilityWindowListener[0];
            return;
        }
        VisibilityWindowListener[] newVisibilityWindowListeners = new VisibilityWindowListener[this.visibilityWindowListeners.length - 1];
        System.arraycopy(this.visibilityWindowListeners, 0, newVisibilityWindowListeners, 0, index);
        System.arraycopy(this.visibilityWindowListeners, index + 1, newVisibilityWindowListeners, index, this.visibilityWindowListeners.length - index - 1);
        this.visibilityWindowListeners = newVisibilityWindowListeners;
    }

    public boolean setText(String html) {
        this.checkWidget();
        if (html == null) {
            SWT.error(4);
        }
        if (this != this.getDisplay().getFocusControl()) {
            this.Deactivate();
        }
        byte[] data = null;
        try {
            data = html.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        int[] result = new int[1];
        int rc = XPCOM.NS_GetServiceManager(result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
        result[0] = 0;
        rc = serviceManager.GetService(XPCOM.NS_IOSERVICE_CID, nsIIOService.NS_IIOSERVICE_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        serviceManager.Release();
        nsIIOService ioService = new nsIIOService(result[0]);
        result[0] = 0;
        byte[] aString = URI_FROMMEMORY.getBytes();
        int aSpec = XPCOM.nsEmbedCString_new(aString, aString.length);
        rc = ioService.NewURI(aSpec, null, 0, result);
        XPCOM.nsEmbedCString_delete(aSpec);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        ioService.Release();
        nsIURI uri = new nsIURI(result[0]);
        result[0] = 0;
        byte[] buffer = "text/html".getBytes();
        byte[] contentTypeBuffer = new byte[buffer.length + 1];
        System.arraycopy(buffer, 0, contentTypeBuffer, 0, buffer.length);
        int aContentType = XPCOM.nsEmbedCString_new(contentTypeBuffer, contentTypeBuffer.length);
        result[0] = 0;
        rc = this.webBrowser.QueryInterface(nsIWebBrowserStream.NS_IWEBBROWSERSTREAM_IID, result);
        if (rc == 0) {
            nsIWebBrowserStream stream;
            if (result[0] == 0) {
                Browser.error(-2147467262);
            }
            if ((rc = (stream = new nsIWebBrowserStream(result[0])).OpenStream(uri.getAddress(), aContentType)) != 0) {
                Browser.error(rc);
            }
            int ptr = XPCOM.PR_Malloc(data.length);
            XPCOM.memmove(ptr, data, data.length);
            int pageSize = 8192;
            int pageCount = data.length / pageSize + 1;
            int current = ptr;
            int i = 0;
            while (i < pageCount) {
                int length;
                int n = length = i == pageCount - 1 ? data.length % pageSize : pageSize;
                if (length > 0 && (rc = stream.AppendToStream(current, length)) != 0) {
                    Browser.error(rc);
                }
                current += pageSize;
                ++i;
            }
            rc = stream.CloseStream();
            if (rc != 0) {
                Browser.error(rc);
            }
            XPCOM.PR_Free(ptr);
            stream.Release();
        } else {
            rc = this.webBrowser.QueryInterface(nsIInterfaceRequestor.NS_IINTERFACEREQUESTOR_IID, result);
            if (rc != 0) {
                Browser.error(rc);
            }
            if (result[0] == 0) {
                Browser.error(-2147467262);
            }
            nsIInterfaceRequestor interfaceRequestor = new nsIInterfaceRequestor(result[0]);
            result[0] = 0;
            rc = interfaceRequestor.GetInterface(nsIDocShell.NS_IDOCSHELL_IID, result);
            interfaceRequestor.Release();
            nsIDocShell docShell = new nsIDocShell(result[0]);
            result[0] = 0;
            buffer = "UTF-8".getBytes();
            byte[] contentCharsetBuffer = new byte[buffer.length + 1];
            System.arraycopy(buffer, 0, contentCharsetBuffer, 0, buffer.length);
            int aContentCharset = XPCOM.nsEmbedCString_new(contentCharsetBuffer, contentCharsetBuffer.length);
            InputStream inputStream = new InputStream(data);
            inputStream.AddRef();
            rc = docShell.LoadStream(inputStream.getAddress(), uri.getAddress(), aContentType, aContentCharset, 0);
            if (rc != 0) {
                Browser.error(rc);
            }
            XPCOM.nsEmbedCString_delete(aContentCharset);
            inputStream.Release();
            docShell.Release();
        }
        XPCOM.nsEmbedCString_delete(aContentType);
        uri.Release();
        return true;
    }

    public boolean setUrl(String url) {
        int[] result;
        int rc;
        this.checkWidget();
        if (url == null) {
            SWT.error(4);
        }
        if ((rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result = new int[1])) != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        nsIWebNavigation webNavigation = new nsIWebNavigation(result[0]);
        char[] arg = url.toCharArray();
        char[] c = new char[arg.length + 1];
        System.arraycopy(arg, 0, c, 0, arg.length);
        rc = webNavigation.LoadURI(c, 0, 0, 0, 0);
        webNavigation.Release();
        return rc == 0;
    }

    public void stop() {
        nsIWebNavigation webNavigation;
        this.checkWidget();
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIWebNavigation.NS_IWEBNAVIGATION_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        if ((rc = (webNavigation = new nsIWebNavigation(result[0])).Stop(3)) != 0) {
            Browser.error(rc);
        }
        webNavigation.Release();
    }

    int QueryInterface(int riid, int ppvObject) {
        if (riid == 0 || ppvObject == 0) {
            return -2147467262;
        }
        nsID guid = new nsID();
        XPCOM.memmove(guid, riid, 16);
        if (guid.Equals(nsISupports.NS_ISUPPORTS_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.supports.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIWeakReference.NS_IWEAKREFERENCE_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.weakReference.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIWebProgressListener.NS_IWEBPROGRESSLISTENER_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.webProgressListener.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIWebBrowserChrome.NS_IWEBBROWSERCHROME_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.webBrowserChrome.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIWebBrowserChromeFocus.NS_IWEBBROWSERCHROMEFOCUS_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.webBrowserChromeFocus.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIEmbeddingSiteWindow.NS_IEMBEDDINGSITEWINDOW_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.embeddingSiteWindow.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIInterfaceRequestor.NS_IINTERFACEREQUESTOR_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.interfaceRequestor.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsISupportsWeakReference.NS_ISUPPORTSWEAKREFERENCE_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.supportsWeakReference.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIContextMenuListener.NS_ICONTEXTMENULISTENER_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.contextMenuListener.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsIURIContentListener.NS_IURICONTENTLISTENER_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.uriContentListener.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        if (guid.Equals(nsITooltipListener.NS_ITOOLTIPLISTENER_IID)) {
            XPCOM.memmove(ppvObject, new int[]{this.tooltipListener.getAddress()}, OS.PTR_SIZEOF);
            this.AddRef();
            return 0;
        }
        XPCOM.memmove(ppvObject, new int[1], OS.PTR_SIZEOF);
        return -2147467262;
    }

    int AddRef() {
        ++this.refCount;
        return this.refCount;
    }

    int Release() {
        --this.refCount;
        if (this.refCount == 0) {
            this.disposeCOMInterfaces();
        }
        return this.refCount;
    }

    int QueryReferent(int riid, int ppvObject) {
        return this.QueryInterface(riid, ppvObject);
    }

    int GetInterface(int riid, int ppvObject) {
        if (riid == 0 || ppvObject == 0) {
            return -2147467262;
        }
        nsID guid = new nsID();
        XPCOM.memmove(guid, riid, 16);
        if (guid.Equals(nsIDOMWindow.NS_IDOMWINDOW_IID)) {
            int[] aContentDOMWindow = new int[1];
            int rc = this.webBrowser.GetContentDOMWindow(aContentDOMWindow);
            if (rc != 0) {
                Browser.error(rc);
            }
            if (aContentDOMWindow[0] == 0) {
                Browser.error(-2147467262);
            }
            XPCOM.memmove(ppvObject, aContentDOMWindow, OS.PTR_SIZEOF);
            return rc;
        }
        return this.QueryInterface(riid, ppvObject);
    }

    int GetWeakReference(int ppvObject) {
        XPCOM.memmove(ppvObject, new int[]{this.weakReference.getAddress()}, OS.PTR_SIZEOF);
        this.AddRef();
        return 0;
    }

    int OnStateChange(int aWebProgress, int aRequest, int aStateFlags, int aStatus) {
        if ((aStateFlags & 0x20000) == 0) {
            return 0;
        }
        if ((aStateFlags & 1) != 0) {
            if (this.request == 0) {
                this.request = aRequest;
            }
        } else if ((aStateFlags & 2) != 0) {
            if (this.request == aRequest) {
                this.request = 0;
            }
        } else if ((aStateFlags & 0x10) != 0 && (this.request == aRequest || this.request == 0)) {
            this.request = 0;
            StatusTextEvent event = new StatusTextEvent(this);
            event.display = this.getDisplay();
            event.widget = this;
            event.text = "";
            int i = 0;
            while (i < this.statusTextListeners.length) {
                this.statusTextListeners[i].changed(event);
                ++i;
            }
            ProgressEvent event2 = new ProgressEvent(this);
            event2.display = this.getDisplay();
            event2.widget = this;
            int i2 = 0;
            while (i2 < this.progressListeners.length) {
                this.progressListeners[i2].completed(event2);
                ++i2;
            }
        }
        return 0;
    }

    int OnProgressChange(int aWebProgress, int aRequest, int aCurSelfProgress, int aMaxSelfProgress, int aCurTotalProgress, int aMaxTotalProgress) {
        if (this.progressListeners.length == 0) {
            return 0;
        }
        int total = aMaxTotalProgress;
        if (total <= 0) {
            total = Integer.MAX_VALUE;
        }
        ProgressEvent event = new ProgressEvent(this);
        event.display = this.getDisplay();
        event.widget = this;
        event.current = aCurTotalProgress;
        event.total = aMaxTotalProgress;
        int i = 0;
        while (i < this.progressListeners.length) {
            this.progressListeners[i].changed(event);
            ++i;
        }
        return 0;
    }

    int OnLocationChange(int aWebProgress, int aRequest, int aLocation) {
        int[] aTop;
        nsIDOMWindow domWindow;
        if (this.request != 0 && this.request != aRequest) {
            this.request = aRequest;
        }
        if (this.locationListeners.length == 0) {
            return 0;
        }
        nsIWebProgress webProgress = new nsIWebProgress(aWebProgress);
        int[] aDOMWindow = new int[1];
        int rc = webProgress.GetDOMWindow(aDOMWindow);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (aDOMWindow[0] == 0) {
            Browser.error(-2147467262);
        }
        if ((rc = (domWindow = new nsIDOMWindow(aDOMWindow[0])).GetTop(aTop = new int[1])) != 0) {
            Browser.error(rc);
        }
        if (aTop[0] == 0) {
            Browser.error(-2147467262);
        }
        domWindow.Release();
        nsIDOMWindow topWindow = new nsIDOMWindow(aTop[0]);
        topWindow.Release();
        nsIURI location = new nsIURI(aLocation);
        int aSpec = XPCOM.nsEmbedCString_new();
        location.GetSpec(aSpec);
        int length = XPCOM.nsEmbedCString_Length(aSpec);
        int buffer = XPCOM.nsEmbedCString_get(aSpec);
        byte[] dest = new byte[length];
        XPCOM.memmove(dest, buffer, length);
        XPCOM.nsEmbedCString_delete(aSpec);
        LocationEvent event = new LocationEvent(this);
        event.display = this.getDisplay();
        event.widget = this;
        event.location = new String(dest);
        if (event.location.equals(URI_FROMMEMORY)) {
            event.location = ABOUT_BLANK;
        }
        event.top = aTop[0] == aDOMWindow[0];
        int i = 0;
        while (i < this.locationListeners.length) {
            this.locationListeners[i].changed(event);
            ++i;
        }
        return 0;
    }

    int OnStatusChange(int aWebProgress, int aRequest, int aStatus, int aMessage) {
        nsIRequest request = new nsIRequest(aRequest);
        int aName = XPCOM.nsEmbedCString_new();
        request.GetName(aName);
        int length = XPCOM.nsEmbedCString_Length(aName);
        int buffer = XPCOM.nsEmbedCString_get(aName);
        byte[] bytes = new byte[length];
        XPCOM.memmove(bytes, buffer, length);
        XPCOM.nsEmbedCString_delete(aName);
        String value = new String(bytes);
        if (!usingProfile && value.startsWith("https:")) {
            request.Cancel(2);
            return 0;
        }
        if (this.statusTextListeners.length == 0) {
            return 0;
        }
        StatusTextEvent event = new StatusTextEvent(this);
        event.display = this.getDisplay();
        event.widget = this;
        length = XPCOM.strlen_PRUnichar(aMessage);
        char[] dest = new char[length];
        XPCOM.memmove(dest, aMessage, length * 2);
        event.text = new String(dest);
        int i = 0;
        while (i < this.statusTextListeners.length) {
            this.statusTextListeners[i].changed(event);
            ++i;
        }
        return 0;
    }

    int OnSecurityChange(int aWebProgress, int aRequest, int state) {
        return 0;
    }

    int SetStatus(int statusType, int status) {
        StatusTextEvent event = new StatusTextEvent(this);
        event.display = this.getDisplay();
        event.widget = this;
        int length = XPCOM.strlen_PRUnichar(status);
        char[] dest = new char[length];
        XPCOM.memmove(dest, status, length * 2);
        String string = new String(dest);
        if (string == null) {
            string = "";
        }
        event.text = string;
        int i = 0;
        while (i < this.statusTextListeners.length) {
            this.statusTextListeners[i].changed(event);
            ++i;
        }
        return 0;
    }

    int GetWebBrowser(int aWebBrowser) {
        int[] ret = new int[1];
        if (this.webBrowser != null) {
            this.webBrowser.AddRef();
            ret[0] = this.webBrowser.getAddress();
        }
        XPCOM.memmove(aWebBrowser, ret, OS.PTR_SIZEOF);
        return 0;
    }

    int SetWebBrowser(int aWebBrowser) {
        if (this.webBrowser != null) {
            this.webBrowser.Release();
        }
        this.webBrowser = aWebBrowser != 0 ? new nsIWebBrowser(aWebBrowser) : null;
        return 0;
    }

    int GetChromeFlags(int aChromeFlags) {
        int[] ret = new int[]{this.chromeFlags};
        XPCOM.memmove(aChromeFlags, ret, 4);
        return 0;
    }

    int SetChromeFlags(int aChromeFlags) {
        this.chromeFlags = aChromeFlags;
        return 0;
    }

    int DestroyBrowserWindow() {
        WindowEvent newEvent = new WindowEvent(this);
        newEvent.display = this.getDisplay();
        newEvent.widget = this;
        int i = 0;
        while (i < this.closeWindowListeners.length) {
            this.closeWindowListeners[i].close(newEvent);
            ++i;
        }
        this.dispose();
        return 0;
    }

    int SizeBrowserTo(int aCX, int aCY) {
        this.size = new Point(aCX, aCY);
        return 0;
    }

    int ShowAsModal() {
        return -2147467263;
    }

    int IsWindowModal(int retval) {
        XPCOM.memmove(retval, new int[1], 4);
        return 0;
    }

    int ExitModalEventLoop(int aStatus) {
        return 0;
    }

    int SetDimensions(int flags, int x, int y, int cx, int cy) {
        if (flags == 1) {
            this.location = new Point(x, y);
        }
        return 0;
    }

    int GetDimensions(int flags, int x, int y, int cx, int cy) {
        return 0;
    }

    int SetFocus() {
        nsIBaseWindow baseWindow;
        int[] result = new int[1];
        int rc = this.webBrowser.QueryInterface(nsIBaseWindow.NS_IBASEWINDOW_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        if ((rc = (baseWindow = new nsIBaseWindow(result[0])).SetFocus()) != 0) {
            Browser.error(rc);
        }
        baseWindow.Release();
        return 0;
    }

    int GetVisibility(int aVisibility) {
        XPCOM.memmove(aVisibility, new int[]{this.isVisible() ? 1 : 0}, 4);
        return 0;
    }

    int SetVisibility(int aVisibility) {
        WindowEvent event = new WindowEvent(this);
        event.display = this.getDisplay();
        event.widget = this;
        if (aVisibility == 1) {
            if (!this.visible) {
                this.visible = true;
                event.location = this.location;
                event.size = this.size;
                event.addressBar = this.addressBar;
                event.menuBar = this.menuBar;
                event.statusBar = this.statusBar;
                event.toolBar = this.toolBar;
                int i = 0;
                while (i < this.visibilityWindowListeners.length) {
                    this.visibilityWindowListeners[i].show(event);
                    ++i;
                }
                this.location = null;
                this.size = null;
            }
        } else {
            this.visible = false;
            int i = 0;
            while (i < this.visibilityWindowListeners.length) {
                this.visibilityWindowListeners[i].hide(event);
                ++i;
            }
        }
        return 0;
    }

    int GetTitle(int aTitle) {
        return 0;
    }

    int SetTitle(int aTitle) {
        if (this.titleListeners.length == 0) {
            return 0;
        }
        TitleEvent event = new TitleEvent(this);
        event.display = this.getDisplay();
        event.widget = this;
        int length = XPCOM.strlen_PRUnichar(aTitle);
        char[] dest = new char[length];
        XPCOM.memmove(dest, aTitle, length * 2);
        event.title = new String(dest);
        int i = 0;
        while (i < this.titleListeners.length) {
            this.titleListeners[i].changed(event);
            ++i;
        }
        return 0;
    }

    int GetSiteWindow(int aSiteWindow) {
        XPCOM.memmove(aSiteWindow, new int[]{this.embedHandle}, OS.PTR_SIZEOF);
        return 0;
    }

    int FocusNextElement() {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Browser.this.traverse(16);
            }
        });
        return 0;
    }

    int FocusPrevElement() {
        this.getDisplay().asyncExec(new Runnable(){

            public void run() {
                Browser.this.traverse(8);
            }
        });
        return 0;
    }

    int OnShowContextMenu(int aContextFlags, int aEvent, int aNode) {
        nsIDOMEvent domEvent = new nsIDOMEvent(aEvent);
        int[] result = new int[1];
        int rc = domEvent.QueryInterface(nsIDOMMouseEvent.NS_IDOMMOUSEEVENT_IID, result);
        if (rc != 0) {
            Browser.error(rc);
        }
        if (result[0] == 0) {
            Browser.error(-2147467262);
        }
        nsIDOMMouseEvent domMouseEvent = new nsIDOMMouseEvent(result[0]);
        int[] aScreenX = new int[1];
        int[] aScreenY = new int[1];
        rc = domMouseEvent.GetScreenX(aScreenX);
        if (rc != 0) {
            Browser.error(rc);
        }
        if ((rc = domMouseEvent.GetScreenY(aScreenY)) != 0) {
            Browser.error(rc);
        }
        domMouseEvent.Release();
        Event event = new Event();
        event.x = aScreenX[0];
        event.y = aScreenY[0];
        this.notifyListeners(35, event);
        if (!event.doit) {
            return 0;
        }
        Menu menu = this.getMenu();
        if (menu != null && !menu.isDisposed()) {
            if (aScreenX[0] != event.x || aScreenY[0] != event.y) {
                menu.setLocation(event.x, event.y);
            }
            menu.setVisible(true);
        }
        return 0;
    }

    int OnStartURIOpen(int aURI, int retval) {
        boolean doit;
        nsIURI location = new nsIURI(aURI);
        int aSpec = XPCOM.nsEmbedCString_new();
        location.GetSpec(aSpec);
        int length = XPCOM.nsEmbedCString_Length(aSpec);
        int buffer = XPCOM.nsEmbedCString_get(aSpec);
        buffer = XPCOM.nsEmbedCString_get(aSpec);
        byte[] dest = new byte[length];
        XPCOM.memmove(dest, buffer, length);
        XPCOM.nsEmbedCString_delete(aSpec);
        String value = new String(dest);
        boolean isHttps = value.startsWith("https:");
        if (this.locationListeners.length == 0) {
            XPCOM.memmove(retval, new int[]{isHttps && !usingProfile ? 1 : 0}, 4);
            return 0;
        }
        boolean bl = doit = !isHttps || usingProfile;
        if (this.request == 0) {
            LocationEvent event = new LocationEvent(this);
            event.display = this.getDisplay();
            event.widget = this;
            event.location = value;
            if (event.location.equals(URI_FROMMEMORY)) {
                event.location = ABOUT_BLANK;
            }
            event.doit = doit;
            int i = 0;
            while (i < this.locationListeners.length) {
                this.locationListeners[i].changing(event);
                ++i;
            }
            if (!isHttps || usingProfile) {
                doit = event.doit;
            }
        }
        XPCOM.memmove(retval, new int[]{doit ? 0 : 1}, 4);
        return 0;
    }

    int DoContent(int aContentType, int aIsContentPreferred, int aRequest, int aContentHandler, int retval) {
        return -2147467263;
    }

    int IsPreferred(int aContentType, int aDesiredContentType, int retval) {
        boolean preferred = false;
        int size = XPCOM.strlen(aContentType);
        if (size > 0) {
            byte[] typeBytes = new byte[size + 1];
            XPCOM.memmove(typeBytes, aContentType, size);
            String contentType = new String(typeBytes);
            if (!contentType.equals("application/x-vnd.mozilla.maybe-text") && !contentType.equals("multipart/x-mixed-replace")) {
                int[] result = new int[1];
                int rc = XPCOM.NS_GetServiceManager(result);
                if (rc != 0) {
                    Browser.error(rc);
                }
                if (result[0] == 0) {
                    Browser.error(-2147467262);
                }
                nsIServiceManager serviceManager = new nsIServiceManager(result[0]);
                result[0] = 0;
                rc = serviceManager.GetService(XPCOM.NS_CATEGORYMANAGER_CID, nsICategoryManager.NS_ICATEGORYMANAGER_IID, result);
                serviceManager.Release();
                if (rc != 0) {
                    Browser.error(rc);
                }
                if (result[0] == 0) {
                    Browser.error(-2147467262);
                }
                nsICategoryManager categoryManager = new nsICategoryManager(result[0]);
                result[0] = 0;
                byte[] categoryBytes = Converter.wcsToMbcs(null, "Gecko-Content-Viewers", true);
                rc = categoryManager.GetCategoryEntry(categoryBytes, typeBytes, result);
                categoryManager.Release();
                preferred = rc == 0;
            }
        }
        XPCOM.memmove(retval, new int[]{preferred ? 1 : 0}, 4);
        return 0;
    }

    int CanHandleContent(int aContentType, int aIsContentPreferred, int aDesiredContentType, int retval) {
        return -2147467263;
    }

    int GetLoadCookie(int aLoadCookie) {
        return -2147467263;
    }

    int SetLoadCookie(int aLoadCookie) {
        return -2147467263;
    }

    int GetParentContentListener(int aParentContentListener) {
        return -2147467263;
    }

    int SetParentContentListener(int aParentContentListener) {
        return -2147467263;
    }

    int OnShowTooltip(int aXCoords, int aYCoords, int aTipText) {
        int length = XPCOM.strlen_PRUnichar(aTipText);
        char[] dest = new char[length];
        XPCOM.memmove(dest, aTipText, length * 2);
        String text = new String(dest);
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        Display display = this.getDisplay();
        Shell parent = this.getShell();
        this.tip = new Shell(parent, 16384);
        this.tip.setLayout(new FillLayout());
        Label label = new Label(this.tip, 0x1000000);
        label.setForeground(display.getSystemColor(28));
        label.setBackground(display.getSystemColor(29));
        label.setText(text);
        Point point = display.getCursorLocation();
        point.y += 21;
        this.tip.setLocation(point);
        this.tip.pack();
        this.tip.setVisible(true);
        return 0;
    }

    int OnHideTooltip() {
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        this.tip = null;
        return 0;
    }
}

