/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model;

import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.model.FileScope;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.OccurencesSupport;
import org.netbeans.modules.php.editor.model.ParameterInfoSupport;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.ModelVisitor;
import org.netbeans.modules.php.editor.parser.api.Utils;

public final class Model {
    private ModelVisitor modelVisitor;
    private final ParserResult info;
    private OccurencesSupport occurencesSupport;

    Model(ParserResult info) {
        this.info = info;
    }

    public Model getExtendedModel() {
        this.getModelVisitor().extendModel();
        return this;
    }

    public FileScope getFileScope() {
        ModelVisitor visitor = this.getModelVisitor();
        return visitor.getFileScope();
    }

    public IndexScope getIndexScope() {
        return ModelVisitor.getIndexScope(this.info);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OccurencesSupport getOccurencesSupport(OffsetRange range) {
        ModelVisitor visitor = this.getModelVisitor();
        Model model = this;
        synchronized (model) {
            if (this.occurencesSupport == null || !range.containsInclusive(this.occurencesSupport.offset)) {
                this.occurencesSupport = new OccurencesSupport(visitor, range.getStart() + 1);
            }
        }
        return this.occurencesSupport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OccurencesSupport getOccurencesSupport(int offset) {
        ModelVisitor visitor = this.getModelVisitor();
        Model model = this;
        synchronized (model) {
            if (this.occurencesSupport == null || this.occurencesSupport.offset != offset) {
                this.occurencesSupport = new OccurencesSupport(visitor, offset);
            }
        }
        return this.occurencesSupport;
    }

    public ParameterInfoSupport getParameterInfoSupport(int offset) {
        ModelVisitor visitor = this.getModelVisitor();
        return new ParameterInfoSupport(visitor, offset);
    }

    public VariableScope getVariableScope(int offset) {
        ModelVisitor visitor = this.getModelVisitor();
        return visitor.getVariableScope(offset);
    }

    public ModelElement findDeclaration(PhpElement element) {
        ModelVisitor visitor = this.getModelVisitor();
        return visitor.findDeclaration(element);
    }

    synchronized ModelVisitor getModelVisitor() {
        if (this.modelVisitor == null) {
            this.modelVisitor = new ModelVisitor(this.info);
            this.modelVisitor.scan(Utils.getRoot(this.info));
        }
        return this.modelVisitor;
    }
}

