/*
 * Decompiled with CFR 0.152.
 */
package jmunit.framework.cldc11;

import jmunit.framework.cldc11.Assertion;
import jmunit.framework.cldc11.PerformanceMeasurement;

public class MemoryMeasurement
implements PerformanceMeasurement {
    private long maxMemory;
    private long initFreeMemory;
    private boolean runGc;

    public MemoryMeasurement(long l) {
        this(l, true);
    }

    public MemoryMeasurement(long l, boolean bl) {
        this.runGc = bl;
        this.maxMemory = l;
        this.startMeasurement();
    }

    public void startMeasurement() {
        if (this.runGc) {
            System.gc();
        }
        this.initFreeMemory = Runtime.getRuntime().freeMemory();
    }

    public void endMeasurement() {
        if (this.runGc) {
            System.gc();
        }
        long l = this.initFreeMemory - Runtime.getRuntime().freeMemory();
        Assertion.assertTrue("Test used too much memory: " + l + " bytes.", l < this.maxMemory);
    }
}

