/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdump;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import org.netbeans.modules.cnd.dwarfdump.Magic;
import org.netbeans.modules.cnd.dwarfdump.exception.WrongFileFormatException;

public class FileMagic {
    private MyRandomAccessFile reader;
    private Magic magic;

    public FileMagic(String objFileName) throws WrongFileFormatException, IOException {
        this.reader = new MyRandomAccessFile(objFileName);
        try {
            this.readMagic();
        }
        catch (WrongFileFormatException ex) {
            throw new WrongFileFormatException(ex.getMessage() + ":" + objFileName);
        }
    }

    public RandomAccessFile getReader() {
        return this.reader;
    }

    public Magic getMagic() {
        return this.magic;
    }

    private void readMagic() throws WrongFileFormatException {
        byte[] bytes = new byte[8];
        try {
            this.reader.readFully(bytes);
        }
        catch (IOException ex) {
            this.dispose();
            throw new WrongFileFormatException("Not an ELF/PE/COFF/MACH-O file");
        }
        if (FileMagic.isElfMagic(bytes)) {
            this.magic = Magic.Elf;
        } else if (FileMagic.isCoffMagic(bytes)) {
            this.magic = Magic.Coff;
        } else if (FileMagic.isExeMagic(bytes)) {
            this.magic = Magic.Exe;
        } else if (FileMagic.isPeMagic(bytes)) {
            this.magic = Magic.Pe;
        } else if (FileMagic.isMachoMagic(bytes)) {
            this.magic = Magic.Macho;
        } else if (FileMagic.isArchiveMagic(bytes)) {
            this.magic = Magic.Arch;
        } else {
            this.dispose();
            throw new WrongFileFormatException("Not an ELF/PE/COFF/MACH-O file");
        }
    }

    public void dispose() {
        if (this.reader != null) {
            this.reader.dispose();
            this.reader = null;
        }
    }

    public static boolean isExeMagic(byte[] bytes) {
        return bytes[0] == 77 && bytes[1] == 90;
    }

    public static boolean isPeMagic(byte[] bytes) {
        return bytes[0] == 80 && bytes[1] == 69 && bytes[2] == 0 && bytes[3] == 0;
    }

    public static boolean isCoffMagic(byte[] bytes) {
        return bytes[0] == 76 && bytes[1] == 1;
    }

    public static boolean isElfMagic(byte[] bytes) {
        return bytes[0] == 127 && bytes[1] == 69 && bytes[2] == 76 && bytes[3] == 70;
    }

    public static boolean isMachoMagic(byte[] bytes) {
        return (bytes[0] == -50 || bytes[0] == -49) && bytes[1] == -6 && bytes[2] == -19 && bytes[3] == -2;
    }

    public static boolean isArchiveMagic(byte[] bytes) {
        return bytes[0] == 33 && bytes[1] == 60 && bytes[2] == 97 && bytes[3] == 114 && bytes[4] == 99 && bytes[5] == 104 && bytes[6] == 62 && bytes[7] == 10;
    }

    private static final class MyRandomAccessFile
    extends RandomAccessFile {
        private static final int BUF_SIZE = Integer.getInteger("cnd.dwarfdump.random_access_file_buffer_size", 8192);
        private static final int BUF_ALIGNMENT = 1024;
        private static final int BUF_CACHE_SIZE = 4;
        private String fileName;
        private BufferCache currentCache;
        private LinkedList<BufferCache> bufferList = new LinkedList();
        private static final boolean TRACE_STATISTIC = false;
        private long countOfReads = 0L;
        private long countOfBufferReads = 0L;

        private MyRandomAccessFile(String fileName) throws IOException {
            super(fileName, "r");
            this.fileName = fileName;
            this.currentCache = new BufferCache(0L);
            this.invalidate();
        }

        private void invalidate() throws IOException {
            this.currentCache.buf_end = 0;
            this.currentCache.buf_pos = 0;
            this.currentCache.real_pos = super.getFilePointer();
        }

        private int fillBuffer() throws IOException {
            int shift = (int)(this.currentCache.real_pos % 1024L);
            if (this.currentCache.real_pos - (long)shift >= 1024L) {
                shift += 1024;
            }
            super.seek(this.currentCache.real_pos - (long)shift);
            int n = super.read(this.currentCache.buffer, 0, BUF_SIZE);
            if (n >= 0) {
                this.currentCache.real_pos += n - shift;
                this.currentCache.buf_end = n;
                this.currentCache.buf_pos = shift;
            }
            return n;
        }

        public int read() throws IOException {
            if (this.currentCache.buf_pos >= this.currentCache.buf_end && this.fillBuffer() < 0) {
                return -1;
            }
            if (this.currentCache.buf_end == 0) {
                return -1;
            }
            return 0xFF & this.currentCache.buffer[this.currentCache.buf_pos++];
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int leftover = this.currentCache.buf_end - this.currentCache.buf_pos;
            if (len <= leftover) {
                System.arraycopy(this.currentCache.buffer, this.currentCache.buf_pos, b, off, len);
                this.currentCache.buf_pos += len;
                return len;
            }
            for (int i = 0; i < len; ++i) {
                int c = this.read();
                if (c == -1) {
                    if (i == 0) {
                        return -1;
                    }
                    return i;
                }
                b[off + i] = (byte)c;
            }
            return len;
        }

        public long getFilePointer() throws IOException {
            long l = this.currentCache.real_pos;
            return l - (long)this.currentCache.buf_end + (long)this.currentCache.buf_pos;
        }

        public void seek(long pos) throws IOException {
            int n = (int)(this.currentCache.real_pos - pos);
            if (n >= 0 && n <= this.currentCache.buf_end) {
                this.currentCache.buf_pos = this.currentCache.buf_end - n;
                return;
            }
            boolean currentInList = false;
            for (BufferCache cache : this.bufferList) {
                n = (int)(cache.real_pos - pos);
                if (n >= 0 && n <= cache.buf_end) {
                    cache.buf_pos = cache.buf_end - n;
                    this.currentCache = cache;
                    return;
                }
                if (this.currentCache != cache) continue;
                currentInList = true;
            }
            if (currentInList) {
                this.bufferList.remove(this.currentCache);
            }
            BufferCache oldest = null;
            if (this.bufferList.size() >= 4) {
                oldest = this.bufferList.removeFirst();
            }
            if (oldest != null) {
                this.currentCache = oldest;
            } else {
                this.bufferList.addLast(this.currentCache);
                this.currentCache = new BufferCache(pos);
            }
            this.bufferList.addLast(this.currentCache);
            super.seek(pos);
            this.invalidate();
        }

        public void dispose() {
            try {
                this.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            BufferCache.access$502(this.currentCache, null);
        }

        static /* synthetic */ int access$600() {
            return BUF_SIZE;
        }

        private static final class BufferCache {
            private byte[] buffer = new byte[MyRandomAccessFile.access$600()];
            private int buf_end = 0;
            private int buf_pos = 0;
            private long real_pos = 0L;

            private BufferCache(long realFilePointer) {
                this.real_pos = realFilePointer;
            }

            public String toString() {
                return "Buffer length " + this.buf_end + " Current buffer position " + this.buf_pos + " File position [" + (this.real_pos - (long)this.buf_end) + "," + this.real_pos + "]";
            }

            static /* synthetic */ byte[] access$502(BufferCache x0, byte[] x1) {
                x0.buffer = x1;
                return x1;
            }
        }
    }
}

