/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.add;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import org.netbeans.lib.cvsclient.command.Command;
import org.netbeans.lib.cvsclient.command.GlobalOptions;
import org.netbeans.lib.cvsclient.command.add.AddCommand;
import org.netbeans.lib.cvsclient.command.add.AddInformation;
import org.netbeans.modules.versioning.system.cvss.ClientRuntime;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ExecutorSupport;
import org.netbeans.modules.versioning.system.cvss.FileStatusCache;
import org.openide.ErrorManager;
import org.openide.util.NbBundle;

public class AddExecutor
extends ExecutorSupport {
    private static final Comparator byLengthComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            File a = (File)o1;
            File b = (File)o2;
            return a.getAbsolutePath().length() - b.getAbsolutePath().length();
        }
    };

    public static AddExecutor[] splitCommand(AddCommand cmd, CvsVersioningSystem cvs, GlobalOptions options) {
        int i;
        File[][] sets;
        ArrayList<Object> fileSets = new ArrayList<Object>();
        File[] files = AddExecutor.getNewDirectories(cmd.getFiles());
        if (files.length > 0) {
            try {
                sets = AddExecutor.splitFiles(files);
                for (i = 0; i < sets.length; ++i) {
                    File[] set = sets[i];
                    Arrays.sort(set, byLengthComparator);
                    fileSets.add(set);
                }
            }
            catch (IOException e) {
                ErrorManager.getDefault().notify((Throwable)e);
                return null;
            }
        }
        try {
            sets = AddExecutor.splitFiles(cmd.getFiles());
            fileSets.addAll(Arrays.asList(sets));
        }
        catch (IOException e) {
            ErrorManager.getDefault().notify((Throwable)e);
            return null;
        }
        AddCommand[] commands = new AddCommand[fileSets.size()];
        for (i = 0; i < commands.length; ++i) {
            commands[i] = (AddCommand)cmd.clone();
            commands[i].setFiles((File[])fileSets.get(i));
        }
        AddExecutor[] executors = new AddExecutor[commands.length];
        for (int i2 = 0; i2 < commands.length; ++i2) {
            AddCommand command = commands[i2];
            int len = command.getFiles().length;
            String param = len == 1 ? command.getFiles()[0].getName() : NbBundle.getMessage(AddExecutor.class, (String)"MSG_AddExecutor_CmdDisplayXfiles", (Object)Integer.toString(len));
            command.setDisplayName(NbBundle.getMessage(AddExecutor.class, (String)"MSG_AddExecutor_CmdDisplayName", (Object)param));
            executors[i2] = new AddExecutor(cvs, command, options);
        }
        return executors;
    }

    private static File[] getNewDirectories(File[] files) {
        FileStatusCache cache = CvsVersioningSystem.getInstance().getStatusCache();
        HashSet<File> newDirs = new HashSet<File>();
        for (int i = 0; i < files.length; ++i) {
            File parent = files[i].getParentFile();
            while (cache.getStatus(parent).getStatus() == 4) {
                newDirs.add(parent);
                if ((parent = parent.getParentFile()) != null) continue;
            }
        }
        ArrayList dirs = new ArrayList(newDirs);
        return dirs.toArray(new File[dirs.size()]);
    }

    private AddExecutor(CvsVersioningSystem cvs, AddCommand cmd, GlobalOptions options) {
        super(cvs, (Command)cmd, options);
    }

    @Override
    protected void commandFinished(ClientRuntime.Result result) {
        HashSet<File> parents = new HashSet<File>();
        for (AddInformation addInformation : this.toRefresh) {
            File file = addInformation.getFile();
            this.cache.refreshCached(file, addInformation.getType().charAt(0));
            parents.add(file.getParentFile());
        }
        this.toRefresh.clear();
        for (File dir : parents) {
            this.cache.refreshCached(dir, 0);
        }
    }
}

