/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.ui.customizer;

import java.awt.Image;
import java.io.File;
import java.net.URI;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;

public final class VisualClassPathItem {
    public static final int TYPE_JAR = 0;
    public static final int TYPE_LIBRARY = 1;
    public static final int TYPE_ARTIFACT = 2;
    public static final int TYPE_CLASSPATH = 3;
    public static final int TYPE_FOLDER = 4;
    private final String RESOURCE_ICON_JAR = "org/netbeans/modules/project/support/customizer/resources/jar.gif";
    private final String RESOURCE_ICON_FOLDER = "org/netbeans/modules/project/support/customizer/resources/folder.gif";
    private final String RESOURCE_ICON_LIBRARY = "org/netbeans/modules/project/support/customizer/resources/libraries.gif";
    private final String RESOURCE_ICON_ARTIFACT = "org/netbeans/modules/project/support/customizer/resources/projectDependencies.gif";
    private final String RESOURCE_ICON_CLASSPATH = "org/netbeans/modules/project/support/customizer/resources/project.gif";
    private final String RESOURCE_ICON_BROKEN = "org/netbeans/modules/project/support/customizer/resources/brokenProjectBadge.gif";
    private Icon ICON_JAR;
    private Icon ICON_LIBRARY;
    private Icon ICON_ARTIFACT;
    private Icon ICON_CLASSPATH;
    private Icon ICON_FOLDER;
    private Icon ICON_BROKEN_JAR;
    private Icon ICON_BROKEN_LIBRARY;
    private Icon ICON_BROKEN_ARTIFACT;
    private Icon ICON_BROKEN_CLASSPATH;
    private Icon ICON_BROKEN_FOLDER;
    private Image IMAGE_JAR;
    private Image IMAGE_LIBRARY;
    private Image IMAGE_ARTIFACT;
    private Image IMAGE_CLASSPATH;
    private Image IMAGE_FOLDER;
    private Image IMAGE_BROKEN_JAR;
    private Image IMAGE_BROKEN_LIBRARY;
    private Image IMAGE_BROKEN_ARTIFACT;
    private Image IMAGE_BROKEN_CLASSPATH;
    private Image IMAGE_BROKEN_FOLDER;
    private int type;
    private Object cpElement;
    private String display;
    private String rawText;
    private URI uri;
    private boolean extra;

    public static VisualClassPathItem create(Library library) {
        if (library == null) {
            throw new IllegalArgumentException("library must not be null");
        }
        String libraryName = library.getName();
        return new VisualClassPathItem(library, 1, "${libs." + libraryName + ".classpath}", library.getDisplayName());
    }

    public static VisualClassPathItem create(AntArtifact artifact, URI artifactURI) {
        String location;
        if (artifactURI == null) {
            throw new IllegalArgumentException("artifactURI must not be null");
        }
        if (artifact == null) {
            throw new IllegalArgumentException("artifact must not be null");
        }
        try {
            location = FileUtil.normalizeFile((File)new File(artifact.getScriptLocation().getParentFile().toURI().resolve(artifactURI))).getPath();
        }
        catch (Exception e) {
            location = artifactURI.getPath();
        }
        return new VisualClassPathItem(artifact, artifactURI, 2, null, location);
    }

    public static VisualClassPathItem create(File file) {
        if (file == null) {
            throw new IllegalArgumentException("file must not be null");
        }
        return new VisualClassPathItem(file, VisualClassPathItem.isJar(file.getName()) ? 0 : 4, null, file.getPath());
    }

    private static boolean isJar(String s) {
        if (s == null) {
            return false;
        }
        return (s = s.toLowerCase()).endsWith(".jar") || s.endsWith(".zip");
    }

    public void setExtra(boolean extra) {
        this.extra = extra;
    }

    public boolean isExtra() {
        return this.extra;
    }

    public VisualClassPathItem(AntArtifact cpElement, URI uri, int type, String rawText, String display) {
        this(cpElement, type, rawText, display);
        this.uri = uri;
    }

    public VisualClassPathItem(Object cpElement, int type, String rawText, String display) {
        Image broken = ImageUtilities.loadImage((String)"org/netbeans/modules/project/support/customizer/resources/brokenProjectBadge.gif");
        this.IMAGE_JAR = ImageUtilities.loadImage((String)"org/netbeans/modules/project/support/customizer/resources/jar.gif");
        this.ICON_JAR = new ImageIcon(this.IMAGE_JAR);
        this.IMAGE_BROKEN_JAR = ImageUtilities.mergeImages((Image)this.IMAGE_JAR, (Image)broken, (int)8, (int)0);
        this.ICON_BROKEN_JAR = new ImageIcon(this.IMAGE_BROKEN_JAR);
        this.IMAGE_LIBRARY = ImageUtilities.loadImage((String)"org/netbeans/modules/project/support/customizer/resources/libraries.gif");
        this.ICON_LIBRARY = new ImageIcon(this.IMAGE_LIBRARY);
        this.IMAGE_BROKEN_LIBRARY = ImageUtilities.mergeImages((Image)this.IMAGE_LIBRARY, (Image)broken, (int)8, (int)0);
        this.ICON_BROKEN_LIBRARY = new ImageIcon(this.IMAGE_BROKEN_LIBRARY);
        this.IMAGE_ARTIFACT = ImageUtilities.loadImage((String)"org/netbeans/modules/project/support/customizer/resources/projectDependencies.gif");
        this.ICON_ARTIFACT = new ImageIcon(this.IMAGE_ARTIFACT);
        this.IMAGE_BROKEN_ARTIFACT = ImageUtilities.mergeImages((Image)this.IMAGE_ARTIFACT, (Image)broken, (int)8, (int)0);
        this.ICON_BROKEN_ARTIFACT = new ImageIcon(this.IMAGE_BROKEN_ARTIFACT);
        this.IMAGE_CLASSPATH = ImageUtilities.loadImage((String)"org/netbeans/modules/project/support/customizer/resources/project.gif");
        this.ICON_CLASSPATH = new ImageIcon(this.IMAGE_CLASSPATH);
        this.IMAGE_BROKEN_CLASSPATH = ImageUtilities.mergeImages((Image)this.IMAGE_CLASSPATH, (Image)broken, (int)8, (int)0);
        this.ICON_BROKEN_CLASSPATH = new ImageIcon(this.IMAGE_BROKEN_CLASSPATH);
        this.IMAGE_FOLDER = ImageUtilities.loadImage((String)"org/netbeans/modules/project/support/customizer/resources/folder.gif");
        this.ICON_FOLDER = new ImageIcon(this.IMAGE_FOLDER);
        this.IMAGE_BROKEN_FOLDER = ImageUtilities.mergeImages((Image)this.IMAGE_FOLDER, (Image)broken, (int)8, (int)0);
        this.ICON_BROKEN_FOLDER = new ImageIcon(this.IMAGE_BROKEN_FOLDER);
        this.extra = false;
        this.cpElement = cpElement;
        this.type = type;
        this.display = display;
        this.rawText = rawText;
    }

    public Object getElement() {
        return this.cpElement;
    }

    public URI getURI() {
        return this.uri;
    }

    public int getType() {
        return this.type;
    }

    public String getDisplayName() {
        return this.display;
    }

    public String getRawText() {
        return this.rawText;
    }

    public boolean canDelete() {
        return this.getType() != 3;
    }

    public Icon getIcon() {
        switch (this.getType()) {
            case 0: {
                return this.getElement() != null ? this.ICON_JAR : this.ICON_BROKEN_JAR;
            }
            case 4: {
                return this.getElement() != null ? this.ICON_FOLDER : this.ICON_BROKEN_FOLDER;
            }
            case 1: {
                return this.getElement() != null ? this.ICON_LIBRARY : this.ICON_BROKEN_LIBRARY;
            }
            case 2: {
                return this.getElement() != null ? this.ICON_ARTIFACT : this.ICON_BROKEN_ARTIFACT;
            }
            case 3: {
                return this.getElement() != null ? this.ICON_CLASSPATH : this.ICON_BROKEN_CLASSPATH;
            }
        }
        return null;
    }

    public Image getImage() {
        switch (this.getType()) {
            case 0: {
                return this.getElement() != null ? this.IMAGE_JAR : this.IMAGE_BROKEN_JAR;
            }
            case 4: {
                return this.getElement() != null ? this.IMAGE_FOLDER : this.IMAGE_BROKEN_FOLDER;
            }
            case 1: {
                return this.getElement() != null ? this.IMAGE_LIBRARY : this.IMAGE_BROKEN_LIBRARY;
            }
            case 2: {
                return this.getElement() != null ? this.IMAGE_ARTIFACT : this.IMAGE_BROKEN_ARTIFACT;
            }
            case 3: {
                return this.getElement() != null ? this.IMAGE_CLASSPATH : this.IMAGE_BROKEN_CLASSPATH;
            }
        }
        return null;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public int hashCode() {
        int hash = this.getType();
        switch (this.getType()) {
            case 2: {
                AntArtifact aa = (AntArtifact)this.getElement();
                if (aa == null) {
                    if (this.rawText == null) break;
                    hash += this.rawText.hashCode();
                    break;
                }
                hash += aa.getType().hashCode();
                hash += aa.getScriptLocation().hashCode();
                hash += this.uri.hashCode();
                break;
            }
            default: {
                Object element = this.getElement();
                if (element == null) break;
                hash += element.hashCode();
            }
        }
        return hash;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof VisualClassPathItem)) {
            return false;
        }
        VisualClassPathItem vcpi = (VisualClassPathItem)object;
        if (this.getType() != vcpi.getType()) {
            return false;
        }
        switch (this.getType()) {
            case 2: {
                AntArtifact aa1 = (AntArtifact)this.getElement();
                AntArtifact aa2 = (AntArtifact)vcpi.getElement();
                if (aa1 == null || aa2 == null) {
                    return this.getRawText() != null && vcpi.getRawText() != null && this.getRawText().equals(vcpi.getRawText());
                }
                if (aa1.getType() != aa2.getType()) {
                    return false;
                }
                if (!aa1.getScriptLocation().equals(aa2.getScriptLocation())) {
                    return false;
                }
                return this.getURI().equals(vcpi.getURI());
            }
        }
        Object element = this.getElement();
        Object cElement = vcpi.getElement();
        if (cElement == null && element == null && vcpi.getRawText().equals(this.getRawText())) {
            return true;
        }
        if (element == null && cElement instanceof Library && this.toString().equals(vcpi.toString()) && vcpi.getRawText().equals(this.getRawText())) {
            return true;
        }
        if (element == null) {
            return false;
        }
        return element.equals(vcpi.getElement());
    }
}

