/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.project.deployment;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.spi.mobility.deployment.DeploymentPlugin;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class MobilityDeploymentProperties
extends HashMap<String, Object>
implements Runnable {
    public static final String DEPLOYMENT_PREFIX = "deployments.";
    final RequestProcessor.Task task;
    private final RequestProcessor requestProcessor;

    @Deprecated
    public MobilityDeploymentProperties() {
        this(new RequestProcessor());
    }

    public MobilityDeploymentProperties(RequestProcessor requestProcessor) {
        this.requestProcessor = requestProcessor;
        this.task = requestProcessor.create((Runnable)this);
        EditableProperties ep = PropertyUtils.getGlobalProperties();
        for (Map.Entry en : ep.entrySet()) {
            String key = (String)en.getKey();
            if (!key.startsWith(DEPLOYMENT_PREFIX)) continue;
            super.put(key, en.getValue());
        }
    }

    public Collection<String> getInstanceList(String deploymentTypeName) {
        String pref = DEPLOYMENT_PREFIX + deploymentTypeName + '.';
        int i = pref.length();
        HashSet<String> instances = new HashSet<String>();
        for (String key : this.keySet()) {
            int j;
            if (!key.startsWith(pref) || (j = key.indexOf(46, i + 1)) <= i) continue;
            instances.add(key.substring(i, j));
        }
        return instances;
    }

    public void removeInstance(String deploymentTypeName, String instanceName) {
        String pref = DEPLOYMENT_PREFIX + deploymentTypeName + '.' + instanceName + '.';
        for (String key : this.keySet().toArray(new String[0])) {
            if (!key.startsWith(pref)) continue;
            this.remove(key);
        }
        this.task.schedule(200);
    }

    public void createInstance(String deploymentTypeName, String instanceName) {
        for (DeploymentPlugin dp : Lookup.getDefault().lookupAll(DeploymentPlugin.class)) {
            if (!deploymentTypeName.equalsIgnoreCase(dp.getDeploymentMethodName())) continue;
            String pref = DEPLOYMENT_PREFIX + deploymentTypeName + '.' + instanceName + '.';
            Map def = dp.getGlobalPropertyDefaultValues();
            if (def == null) continue;
            for (Map.Entry en : def.entrySet()) {
                if (en.getValue() == null) continue;
                super.put(pref + (String)en.getKey(), en.getValue().toString());
            }
            this.task.schedule(200);
            return;
        }
    }

    @Override
    public void run() {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                EditableProperties ep = PropertyUtils.getGlobalProperties();
                for (String key : ep.keySet().toArray(new String[0])) {
                    if (!key.startsWith(MobilityDeploymentProperties.DEPLOYMENT_PREFIX)) continue;
                    ep.remove((Object)key);
                }
                for (Map.Entry en : MobilityDeploymentProperties.this.entrySet()) {
                    ep.put((String)en.getKey(), en.getValue().toString());
                }
                try {
                    PropertyUtils.putGlobalProperties((EditableProperties)ep);
                }
                catch (IOException ioe) {
                    ErrorManager.getDefault().notify((Throwable)ioe);
                }
            }
        });
    }

    @Override
    public Object put(String key, Object value) {
        Object retValue = super.put(key, value);
        this.task.schedule(200);
        return retValue;
    }
}

