/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.keyring;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.keyring.Utils;
import org.netbeans.spi.keyring.KeyringProvider;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public class Keyring {
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.keyring");
    private static KeyringProvider PROVIDER;

    private Keyring() {
    }

    private static synchronized KeyringProvider provider() {
        if (PROVIDER == null) {
            for (KeyringProvider p : Lookup.getDefault().lookupAll(KeyringProvider.class)) {
                if (!p.enabled()) continue;
                PROVIDER = p;
                break;
            }
            if (PROVIDER == null) {
                PROVIDER = new DummyKeyringProvider();
            }
            LOG.log(Level.FINE, "Using provider: {0}", PROVIDER);
        }
        return PROVIDER;
    }

    public static synchronized char[] read(String key) {
        Parameters.notNull((CharSequence)"key", (Object)key);
        LOG.log(Level.FINEST, "reading: {0}", key);
        return Keyring.provider().read(key);
    }

    public static synchronized void save(String key, char[] password, String description) {
        Parameters.notNull((CharSequence)"key", (Object)key);
        Parameters.notNull((CharSequence)"password", (Object)password);
        LOG.log(Level.FINEST, "saving: {0}", key);
        Keyring.provider().save(key, password, description);
        Arrays.fill(password, '\u0000');
    }

    public static synchronized void delete(String key) {
        Parameters.notNull((CharSequence)"key", (Object)key);
        LOG.log(Level.FINEST, "deleting: {0}", key);
        Keyring.provider().delete(key);
    }

    private static class DummyKeyringProvider
    implements KeyringProvider {
        private final Map<String, byte[]> passwords = new HashMap<String, byte[]>();

        private DummyKeyringProvider() {
        }

        @Override
        public boolean enabled() {
            return true;
        }

        @Override
        public char[] read(String key) {
            byte[] pwd = this.passwords.get(key);
            return pwd != null ? Utils.bytes2Chars(pwd) : null;
        }

        @Override
        public void save(String key, char[] password, String description) {
            this.passwords.put(key, Utils.chars2Bytes(password));
        }

        @Override
        public void delete(String key) {
            this.passwords.remove(key);
        }
    }
}

