/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.nodes;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.embedder.MavenSettingsSingleton;
import org.netbeans.modules.maven.nodes.AnnotatedAbstractNode;
import org.netbeans.modules.maven.nodes.OthersRootNode;
import org.netbeans.modules.maven.spi.nodes.NodeUtils;
import org.openide.cookies.EditCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class ProjectFilesNode
extends AnnotatedAbstractNode {
    private NbMavenProjectImpl project;

    public ProjectFilesNode(NbMavenProjectImpl project) {
        super((Children)new ProjectFilesChildren(project), Lookups.fixed((Object[])new Object[]{project.getProjectDirectory(), new OthersRootNode.ChildDelegateFind()}));
        this.setName("projectfiles");
        this.setDisplayName(NbBundle.getMessage(ProjectFilesNode.class, (String)"LBL_Project_Files"));
        this.project = project;
        this.setMyFiles();
    }

    public Action[] getActions(boolean context) {
        ArrayList<AbstractAction> col = new ArrayList<AbstractAction>();
        if (this.project.getProjectDirectory().getFileObject("profiles.xml") == null) {
            col.add(new AddProfileXmlAction());
        }
        if (!new File(MavenSettingsSingleton.getInstance().getM2UserDir(), "settings.xml").exists()) {
            col.add(new AddSettingsXmlAction());
        }
        return col.toArray(new Action[col.size()]);
    }

    private Image getIcon(boolean opened) {
        Image badge = ImageUtilities.loadImage((String)"org/netbeans/modules/maven/projectfiles-badge.png", (boolean)true);
        Image img = ImageUtilities.mergeImages((Image)NodeUtils.getTreeFolderIcon(opened), (Image)badge, (int)8, (int)8);
        return img;
    }

    @Override
    protected Image getIconImpl(int param) {
        return this.getIcon(false);
    }

    @Override
    protected Image getOpenedIconImpl(int param) {
        return this.getIcon(true);
    }

    private void setMyFiles() {
        FileObject fo2;
        HashSet<FileObject> fobs = new HashSet<FileObject>();
        FileObject fo = this.project.getProjectDirectory().getFileObject("pom.xml");
        if (fo != null) {
            fobs.add(fo);
        }
        if ((fo2 = this.project.getProjectDirectory().getFileObject("profiles.xml")) != null) {
            fobs.add(fo2);
        }
        this.setFiles(fobs);
    }

    private class AddSettingsXmlAction
    extends AbstractAction {
        AddSettingsXmlAction() {
            this.putValue("Name", NbBundle.getMessage(ProjectFilesNode.class, (String)"BTN_Create_settings_xml"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                File fil = MavenSettingsSingleton.getInstance().getM2UserDir();
                DataFolder folder = DataFolder.findFolder((FileObject)FileUtil.createFolder((File)fil));
                FileObject temp = FileUtil.getConfigFile((String)"Maven2Templates/settings.xml");
                DataObject dobj = DataObject.find((FileObject)temp);
                DataObject newOne = dobj.createFromTemplate(folder);
                EditCookie cook = (EditCookie)newOne.getCookie(EditCookie.class);
                if (cook != null) {
                    cook.edit();
                }
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private class AddProfileXmlAction
    extends AbstractAction {
        AddProfileXmlAction() {
            this.putValue("Name", NbBundle.getMessage(ProjectFilesNode.class, (String)"BTN_Create_profile_xml"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                DataFolder folder = DataFolder.findFolder((FileObject)ProjectFilesNode.this.project.getProjectDirectory());
                FileObject temp = FileUtil.getConfigFile((String)"Maven2Templates/profiles.xml");
                DataObject dobj = DataObject.find((FileObject)temp);
                DataObject newOne = dobj.createFromTemplate(folder);
                EditCookie cook = (EditCookie)newOne.getCookie(EditCookie.class);
                if (cook != null) {
                    cook.edit();
                }
            }
            catch (DataObjectNotFoundException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private static class ProjectFilesChildren
    extends Children.Keys<File>
    implements PropertyChangeListener {
        private NbMavenProjectImpl project;
        private FileChangeAdapter fileChangeListener;

        public ProjectFilesChildren(NbMavenProjectImpl proj) {
            this.project = proj;
            this.fileChangeListener = new FileChangeAdapter(){

                public void fileDataCreated(FileEvent fe) {
                    ProjectFilesChildren.this.regenerateKeys(true);
                }

                public void fileDeleted(FileEvent fe) {
                    ProjectFilesChildren.this.regenerateKeys(true);
                }
            };
        }

        protected Node[] createNodes(File fil) {
            FileObject fo = FileUtil.toFileObject((File)fil);
            if (fo != null) {
                try {
                    DataObject dobj = DataObject.find((FileObject)fo);
                    FilterNode node = new FilterNode(dobj.getNodeDelegate().cloneNode());
                    return new Node[]{node};
                }
                catch (DataObjectNotFoundException dataObjectNotFoundException) {
                    // empty catch block
                }
            }
            return new Node[0];
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if ("MavenProject".equals(evt.getPropertyName())) {
                this.regenerateKeys(true);
            }
        }

        protected void addNotify() {
            super.addNotify();
            NbMavenProject.addPropertyChangeListener(this.project, this);
            this.project.getProjectDirectory().addFileChangeListener((FileChangeListener)this.fileChangeListener);
            this.regenerateKeys(false);
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            NbMavenProject.removePropertyChangeListener(this.project, this);
            this.project.getProjectDirectory().removeFileChangeListener((FileChangeListener)this.fileChangeListener);
            super.removeNotify();
        }

        private void regenerateKeys(final boolean refresh) {
            if (ProjectManager.mutex().isReadAccess() || ProjectManager.mutex().isWriteAccess()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        ProjectFilesChildren.this.regenerateKeys(refresh);
                    }
                });
                return;
            }
            ArrayList<File> keys = new ArrayList<File>();
            keys.add(new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "pom.xml"));
            keys.add(new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), "profiles.xml"));
            keys.add(new File(MavenSettingsSingleton.getInstance().getM2UserDir(), "settings.xml"));
            this.setKeys(keys);
            ((ProjectFilesNode)this.getNode()).setMyFiles();
            if (refresh) {
                for (File key : keys) {
                    this.refreshKey(key);
                }
            }
        }
    }
}

