/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.portlet.mvc.annotation;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.ClientDataRequest;
import javax.portlet.Event;
import javax.portlet.EventRequest;
import javax.portlet.EventResponse;
import javax.portlet.MimeResponse;
import javax.portlet.PortalContext;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.portlet.UnavailableException;
import javax.portlet.WindowState;
import javax.servlet.http.Cookie;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.Ordered;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.style.StylerUtils;
import org.springframework.ui.ExtendedModelMap;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.validation.support.BindingAwareModelMap;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.annotation.support.HandlerMethodInvoker;
import org.springframework.web.bind.annotation.support.HandlerMethodResolver;
import org.springframework.web.bind.support.DefaultSessionAttributeStore;
import org.springframework.web.bind.support.SessionAttributeStore;
import org.springframework.web.bind.support.WebArgumentResolver;
import org.springframework.web.bind.support.WebBindingInitializer;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.RequestScope;
import org.springframework.web.portlet.HandlerAdapter;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.bind.MissingPortletRequestParameterException;
import org.springframework.web.portlet.bind.PortletRequestDataBinder;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.EventMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.bind.annotation.ResourceMapping;
import org.springframework.web.portlet.context.PortletWebRequest;
import org.springframework.web.portlet.handler.PortletContentGenerator;
import org.springframework.web.portlet.handler.PortletSessionRequiredException;
import org.springframework.web.portlet.mvc.annotation.PortletAnnotationMappingUtils;
import org.springframework.web.portlet.util.PortletUtils;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.mvc.annotation.ModelAndViewResolver;

public class AnnotationMethodHandlerAdapter
extends PortletContentGenerator
implements HandlerAdapter,
Ordered,
BeanFactoryAware {
    private static final String IMPLICIT_MODEL_ATTRIBUTE = "org.springframework.web.portlet.mvc.ImplicitModel";
    private WebBindingInitializer webBindingInitializer;
    private SessionAttributeStore sessionAttributeStore = new DefaultSessionAttributeStore();
    private int cacheSecondsForSessionAttributeHandlers = 0;
    private boolean synchronizeOnSession = false;
    private ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();
    private WebArgumentResolver[] customArgumentResolvers;
    private ModelAndViewResolver[] customModelAndViewResolvers;
    private int order = Integer.MAX_VALUE;
    private ConfigurableBeanFactory beanFactory;
    private BeanExpressionContext expressionContext;
    private final Map<Class<?>, PortletHandlerMethodResolver> methodResolverCache = new ConcurrentHashMap();

    public void setWebBindingInitializer(WebBindingInitializer webBindingInitializer) {
        this.webBindingInitializer = webBindingInitializer;
    }

    public void setSessionAttributeStore(SessionAttributeStore sessionAttributeStore) {
        Assert.notNull((Object)sessionAttributeStore, (String)"SessionAttributeStore must not be null");
        this.sessionAttributeStore = sessionAttributeStore;
    }

    public void setCacheSecondsForSessionAttributeHandlers(int cacheSecondsForSessionAttributeHandlers) {
        this.cacheSecondsForSessionAttributeHandlers = cacheSecondsForSessionAttributeHandlers;
    }

    public void setSynchronizeOnSession(boolean synchronizeOnSession) {
        this.synchronizeOnSession = synchronizeOnSession;
    }

    public void setParameterNameDiscoverer(ParameterNameDiscoverer parameterNameDiscoverer) {
        this.parameterNameDiscoverer = parameterNameDiscoverer;
    }

    public void setCustomArgumentResolver(WebArgumentResolver argumentResolver) {
        this.customArgumentResolvers = new WebArgumentResolver[]{argumentResolver};
    }

    public void setCustomArgumentResolvers(WebArgumentResolver[] argumentResolvers) {
        this.customArgumentResolvers = argumentResolvers;
    }

    public void setCustomModelAndViewResolver(ModelAndViewResolver customModelAndViewResolver) {
        this.customModelAndViewResolvers = new ModelAndViewResolver[]{customModelAndViewResolver};
    }

    public void setCustomModelAndViewResolvers(ModelAndViewResolver[] customModelAndViewResolvers) {
        this.customModelAndViewResolvers = customModelAndViewResolvers;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.beanFactory = (ConfigurableBeanFactory)beanFactory;
            this.expressionContext = new BeanExpressionContext(this.beanFactory, (Scope)new RequestScope());
        }
    }

    public boolean supports(Object handler) {
        return this.getMethodResolver(handler).hasHandlerMethods();
    }

    public void handleAction(ActionRequest request, ActionResponse response, Object handler) throws Exception {
        ModelAndView returnValue = this.doHandle((PortletRequest)request, (PortletResponse)response, handler);
        if (returnValue != null) {
            throw new IllegalStateException("Invalid action method return value: " + returnValue);
        }
    }

    public ModelAndView handleRender(RenderRequest request, RenderResponse response, Object handler) throws Exception {
        this.checkAndPrepare((PortletRequest)request, (MimeResponse)response);
        return this.doHandle((PortletRequest)request, (PortletResponse)response, handler);
    }

    public ModelAndView handleResource(ResourceRequest request, ResourceResponse response, Object handler) throws Exception {
        this.checkAndPrepare((PortletRequest)request, (MimeResponse)response);
        return this.doHandle((PortletRequest)request, (PortletResponse)response, handler);
    }

    public void handleEvent(EventRequest request, EventResponse response, Object handler) throws Exception {
        ModelAndView returnValue = this.doHandle((PortletRequest)request, (PortletResponse)response, handler);
        if (returnValue != null) {
            throw new IllegalStateException("Invalid action method return value: " + returnValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ModelAndView doHandle(PortletRequest request, PortletResponse response, Object handler) throws Exception {
        PortletSession session;
        BindingAwareModelMap implicitModel = null;
        if (response instanceof MimeResponse) {
            PortletSession session2;
            MimeResponse mimeResponse = (MimeResponse)response;
            if (request.getParameter(IMPLICIT_MODEL_ATTRIBUTE) != null && (session2 = request.getPortletSession(false)) != null) {
                implicitModel = (ExtendedModelMap)session2.getAttribute(IMPLICIT_MODEL_ATTRIBUTE);
            }
            if (handler.getClass().getAnnotation(SessionAttributes.class) != null) {
                this.checkAndPrepare(request, mimeResponse, this.cacheSecondsForSessionAttributeHandlers);
            } else {
                this.checkAndPrepare(request, mimeResponse);
            }
        }
        if (implicitModel == null) {
            implicitModel = new BindingAwareModelMap();
        }
        if (this.synchronizeOnSession && (session = request.getPortletSession(false)) != null) {
            Object mutex;
            Object object = mutex = PortletUtils.getSessionMutex(session);
            synchronized (object) {
                return this.invokeHandlerMethod(request, response, handler, (ExtendedModelMap)implicitModel);
            }
        }
        return this.invokeHandlerMethod(request, response, handler, (ExtendedModelMap)implicitModel);
    }

    private ModelAndView invokeHandlerMethod(PortletRequest request, PortletResponse response, Object handler, ExtendedModelMap implicitModel) throws Exception {
        PortletWebRequest webRequest = new PortletWebRequest(request, response);
        PortletHandlerMethodResolver methodResolver = this.getMethodResolver(handler);
        Method handlerMethod = methodResolver.resolveHandlerMethod(request);
        PortletHandlerMethodInvoker methodInvoker = new PortletHandlerMethodInvoker(methodResolver);
        Object result = methodInvoker.invokeHandlerMethod(handlerMethod, handler, webRequest, implicitModel);
        ModelAndView mav = methodInvoker.getModelAndView(handlerMethod, handler.getClass(), result, implicitModel, webRequest);
        methodInvoker.updateModelAttributes(handler, mav != null ? mav.getModel() : null, implicitModel, webRequest);
        if (response instanceof ActionResponse && !implicitModel.isEmpty()) {
            ActionResponse actionResponse = (ActionResponse)response;
            try {
                actionResponse.setRenderParameter(IMPLICIT_MODEL_ATTRIBUTE, Boolean.TRUE.toString());
                request.getPortletSession().setAttribute(IMPLICIT_MODEL_ATTRIBUTE, (Object)implicitModel);
            }
            catch (IllegalStateException illegalStateException) {}
        }
        return mav;
    }

    private PortletHandlerMethodResolver getMethodResolver(Object handler) {
        Class handlerClass = ClassUtils.getUserClass((Object)handler);
        PortletHandlerMethodResolver resolver = this.methodResolverCache.get(handlerClass);
        if (resolver == null) {
            resolver = new PortletHandlerMethodResolver(handlerClass);
            this.methodResolverCache.put(handlerClass, resolver);
        }
        return resolver;
    }

    protected PortletRequestDataBinder createBinder(PortletRequest request, Object target, String objectName) throws Exception {
        return new PortletRequestDataBinder(target, objectName);
    }

    private class PortletHandlerMethodInvoker
    extends HandlerMethodInvoker {
        public PortletHandlerMethodInvoker(HandlerMethodResolver resolver) {
            super(resolver, AnnotationMethodHandlerAdapter.this.webBindingInitializer, AnnotationMethodHandlerAdapter.this.sessionAttributeStore, AnnotationMethodHandlerAdapter.this.parameterNameDiscoverer, AnnotationMethodHandlerAdapter.this.customArgumentResolvers, null);
        }

        protected void raiseMissingParameterException(String paramName, Class paramType) throws Exception {
            throw new MissingPortletRequestParameterException(paramName, paramType.getSimpleName());
        }

        protected void raiseSessionRequiredException(String message) throws Exception {
            throw new PortletSessionRequiredException(message);
        }

        protected WebDataBinder createBinder(NativeWebRequest webRequest, Object target, String objectName) throws Exception {
            return AnnotationMethodHandlerAdapter.this.createBinder((PortletRequest)webRequest.getNativeRequest(PortletRequest.class), target, objectName);
        }

        protected void doBind(WebDataBinder binder, NativeWebRequest webRequest) throws Exception {
            PortletRequestDataBinder portletBinder = (PortletRequestDataBinder)binder;
            portletBinder.bind((PortletRequest)webRequest.getNativeRequest(PortletRequest.class));
        }

        protected Object resolveDefaultValue(String value) {
            if (AnnotationMethodHandlerAdapter.this.beanFactory == null) {
                return value;
            }
            String placeholdersResolved = AnnotationMethodHandlerAdapter.this.beanFactory.resolveEmbeddedValue(value);
            BeanExpressionResolver exprResolver = AnnotationMethodHandlerAdapter.this.beanFactory.getBeanExpressionResolver();
            if (exprResolver == null) {
                return value;
            }
            return exprResolver.evaluate(placeholdersResolved, AnnotationMethodHandlerAdapter.this.expressionContext);
        }

        protected Object resolveCookieValue(String cookieName, Class paramType, NativeWebRequest webRequest) throws Exception {
            PortletRequest portletRequest = (PortletRequest)webRequest.getNativeRequest(PortletRequest.class);
            Cookie cookieValue = PortletUtils.getCookie(portletRequest, cookieName);
            if (Cookie.class.isAssignableFrom(paramType)) {
                return cookieValue;
            }
            if (cookieValue != null) {
                return cookieValue.getValue();
            }
            return null;
        }

        protected Object resolveStandardArgument(Class parameterType, NativeWebRequest webRequest) throws Exception {
            PortletRequest request = (PortletRequest)webRequest.getNativeRequest(PortletRequest.class);
            PortletResponse response = (PortletResponse)webRequest.getNativeResponse(PortletResponse.class);
            if (PortletRequest.class.isAssignableFrom(parameterType)) {
                return request;
            }
            if (PortletResponse.class.isAssignableFrom(parameterType)) {
                return response;
            }
            if (PortletSession.class.isAssignableFrom(parameterType)) {
                return request.getPortletSession();
            }
            if (PortletPreferences.class.isAssignableFrom(parameterType)) {
                return request.getPreferences();
            }
            if (PortletMode.class.isAssignableFrom(parameterType)) {
                return request.getPortletMode();
            }
            if (WindowState.class.isAssignableFrom(parameterType)) {
                return request.getWindowState();
            }
            if (PortalContext.class.isAssignableFrom(parameterType)) {
                return request.getPortalContext();
            }
            if (Principal.class.isAssignableFrom(parameterType)) {
                return request.getUserPrincipal();
            }
            if (Locale.class.equals((Object)parameterType)) {
                return request.getLocale();
            }
            if (InputStream.class.isAssignableFrom(parameterType)) {
                if (!(request instanceof ClientDataRequest)) {
                    throw new IllegalStateException("InputStream can only get obtained for Action/ResourceRequest");
                }
                return ((ClientDataRequest)request).getPortletInputStream();
            }
            if (Reader.class.isAssignableFrom(parameterType)) {
                if (!(request instanceof ClientDataRequest)) {
                    throw new IllegalStateException("Reader can only get obtained for Action/ResourceRequest");
                }
                return ((ClientDataRequest)request).getReader();
            }
            if (OutputStream.class.isAssignableFrom(parameterType)) {
                if (!(response instanceof MimeResponse)) {
                    throw new IllegalStateException("OutputStream can only get obtained for Render/ResourceResponse");
                }
                return ((MimeResponse)response).getPortletOutputStream();
            }
            if (Writer.class.isAssignableFrom(parameterType)) {
                if (!(response instanceof MimeResponse)) {
                    throw new IllegalStateException("Writer can only get obtained for Render/ResourceResponse");
                }
                return ((MimeResponse)response).getWriter();
            }
            if (Event.class.equals((Object)parameterType)) {
                if (!(request instanceof EventRequest)) {
                    throw new IllegalStateException("Event can only get obtained from EventRequest");
                }
                return ((EventRequest)request).getEvent();
            }
            return super.resolveStandardArgument(parameterType, webRequest);
        }

        public ModelAndView getModelAndView(Method handlerMethod, Class handlerType, Object returnValue, ExtendedModelMap implicitModel, PortletWebRequest webRequest) {
            if (AnnotationMethodHandlerAdapter.this.customModelAndViewResolvers != null) {
                ModelAndViewResolver[] modelAndViewResolverArray = AnnotationMethodHandlerAdapter.this.customModelAndViewResolvers;
                int n = modelAndViewResolverArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ModelAndViewResolver mavResolver = modelAndViewResolverArray[n2];
                    org.springframework.web.servlet.ModelAndView smav = mavResolver.resolveModelAndView(handlerMethod, handlerType, returnValue, implicitModel, (NativeWebRequest)webRequest);
                    if (smav != ModelAndViewResolver.UNRESOLVED) {
                        return smav.isReference() ? new ModelAndView(smav.getViewName(), (Map<String, ?>)smav.getModelMap()) : new ModelAndView(smav.getView(), (Map<String, ?>)smav.getModelMap());
                    }
                    ++n2;
                }
            }
            if (returnValue instanceof ModelAndView) {
                ModelAndView mav = (ModelAndView)returnValue;
                mav.getModelMap().mergeAttributes((Map)implicitModel);
                return mav;
            }
            if (returnValue instanceof org.springframework.web.servlet.ModelAndView) {
                org.springframework.web.servlet.ModelAndView smav = (org.springframework.web.servlet.ModelAndView)returnValue;
                ModelAndView mav = smav.isReference() ? new ModelAndView(smav.getViewName(), (Map<String, ?>)smav.getModelMap()) : new ModelAndView(smav.getView(), (Map<String, ?>)smav.getModelMap());
                mav.getModelMap().mergeAttributes((Map)implicitModel);
                return mav;
            }
            if (returnValue instanceof Model) {
                return new ModelAndView().addAllObjects((Map<String, ?>)implicitModel).addAllObjects(((Model)returnValue).asMap());
            }
            if (returnValue instanceof View) {
                return new ModelAndView(returnValue).addAllObjects((Map<String, ?>)implicitModel);
            }
            if (handlerMethod.isAnnotationPresent(ModelAttribute.class)) {
                this.addReturnValueAsModelAttribute(handlerMethod, handlerType, returnValue, implicitModel);
                return new ModelAndView().addAllObjects((Map<String, ?>)implicitModel);
            }
            if (returnValue instanceof Map) {
                return new ModelAndView().addAllObjects((Map<String, ?>)implicitModel).addAllObjects((Map)returnValue);
            }
            if (returnValue instanceof String) {
                return new ModelAndView((String)returnValue).addAllObjects((Map<String, ?>)implicitModel);
            }
            if (returnValue == null) {
                return null;
            }
            if (!BeanUtils.isSimpleProperty(returnValue.getClass())) {
                this.addReturnValueAsModelAttribute(handlerMethod, handlerType, returnValue, implicitModel);
                return new ModelAndView().addAllObjects((Map<String, ?>)implicitModel);
            }
            throw new IllegalArgumentException("Invalid handler method return value: " + returnValue);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PortletHandlerMethodResolver
    extends HandlerMethodResolver {
        private final Map<Method, RequestMappingInfo> mappings = new HashMap<Method, RequestMappingInfo>();

        public PortletHandlerMethodResolver(Class<?> handlerType) {
            this.init(handlerType);
        }

        protected boolean isHandlerMethod(Method method) {
            RequestMappingInfo mappingInfo = new RequestMappingInfo();
            RequestMapping requestMapping = (RequestMapping)AnnotationUtils.findAnnotation((Method)method, RequestMapping.class);
            ActionMapping actionMapping = (ActionMapping)AnnotationUtils.findAnnotation((Method)method, ActionMapping.class);
            RenderMapping renderMapping = (RenderMapping)AnnotationUtils.findAnnotation((Method)method, RenderMapping.class);
            ResourceMapping resourceMapping = (ResourceMapping)AnnotationUtils.findAnnotation((Method)method, ResourceMapping.class);
            EventMapping eventMapping = (EventMapping)AnnotationUtils.findAnnotation((Method)method, EventMapping.class);
            if (actionMapping != null) {
                mappingInfo.initPhaseMapping("ACTION_PHASE", actionMapping.value(), actionMapping.params());
            }
            if (renderMapping != null) {
                mappingInfo.initPhaseMapping("RENDER_PHASE", renderMapping.value(), renderMapping.params());
            }
            if (resourceMapping != null) {
                mappingInfo.initPhaseMapping("RESOURCE_PHASE", resourceMapping.value(), new String[0]);
            }
            if (eventMapping != null) {
                mappingInfo.initPhaseMapping("EVENT_PHASE", eventMapping.value(), new String[0]);
            }
            if (requestMapping != null) {
                mappingInfo.initStandardMapping(requestMapping.value(), requestMapping.method(), requestMapping.params(), requestMapping.headers());
                if (mappingInfo.phase == null) {
                    mappingInfo.phase = this.determineDefaultPhase(method);
                }
            }
            this.mappings.put(method, mappingInfo);
            return mappingInfo.phase != null;
        }

        public Method resolveHandlerMethod(PortletRequest request) throws PortletException {
            LinkedHashMap<RequestMappingInfo, Method> targetHandlerMethods = new LinkedHashMap<RequestMappingInfo, Method>();
            for (Method handlerMethod : this.getHandlerMethods()) {
                Method oldMappedMethod;
                RequestMappingInfo mappingInfo = this.mappings.get(handlerMethod);
                if (!mappingInfo.match(request) || (oldMappedMethod = targetHandlerMethods.put(mappingInfo, handlerMethod)) == null || oldMappedMethod == handlerMethod) continue;
                throw new IllegalStateException("Ambiguous handler methods mapped for portlet mode '" + request.getPortletMode() + "': {" + oldMappedMethod + ", " + handlerMethod + "}. If you intend to handle the same mode in multiple methods, then factor " + "them out into a dedicated handler class with that mode mapped at the type level!");
            }
            if (!targetHandlerMethods.isEmpty()) {
                if (targetHandlerMethods.size() == 1) {
                    return (Method)targetHandlerMethods.values().iterator().next();
                }
                RequestMappingInfo bestMappingMatch = null;
                for (RequestMappingInfo mapping : targetHandlerMethods.keySet()) {
                    if (bestMappingMatch == null) {
                        bestMappingMatch = mapping;
                        continue;
                    }
                    if (!mapping.isBetterMatchThan(bestMappingMatch)) continue;
                    bestMappingMatch = mapping;
                }
                return (Method)targetHandlerMethods.get(bestMappingMatch);
            }
            throw new UnavailableException("No matching handler method found for portlet request: mode '" + request.getPortletMode() + "', phase '" + request.getAttribute("javax.portlet.lifecycle_phase") + "', parameters " + StylerUtils.style((Object)request.getParameterMap()));
        }

        private String determineDefaultPhase(Method handlerMethod) {
            if (!Void.TYPE.equals(handlerMethod.getReturnType())) {
                return "RENDER_PHASE";
            }
            Class<?>[] classArray = handlerMethod.getParameterTypes();
            int n = classArray.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> argType = classArray[n2];
                if (ActionRequest.class.isAssignableFrom(argType) || ActionResponse.class.isAssignableFrom(argType) || InputStream.class.isAssignableFrom(argType) || Reader.class.isAssignableFrom(argType)) {
                    return "ACTION_PHASE";
                }
                if (RenderRequest.class.isAssignableFrom(argType) || RenderResponse.class.isAssignableFrom(argType) || OutputStream.class.isAssignableFrom(argType) || Writer.class.isAssignableFrom(argType)) {
                    return "RENDER_PHASE";
                }
                if (ResourceRequest.class.isAssignableFrom(argType) || ResourceResponse.class.isAssignableFrom(argType)) {
                    return "RESOURCE_PHASE";
                }
                if (EventRequest.class.isAssignableFrom(argType) || EventResponse.class.isAssignableFrom(argType)) {
                    return "EVENT_PHASE";
                }
                ++n2;
            }
            return "";
        }
    }

    private static class RequestMappingInfo {
        public final Set<PortletMode> modes = new HashSet<PortletMode>();
        public String phase;
        public String value;
        public final Set<String> methods = new HashSet<String>();
        public String[] params = new String[0];
        public String[] headers = new String[0];

        private RequestMappingInfo() {
        }

        public void initStandardMapping(String[] modes, RequestMethod[] methods, String[] params, String[] headers) {
            String[] stringArray = modes;
            int n = modes.length;
            int n2 = 0;
            while (n2 < n) {
                String mode = stringArray[n2];
                this.modes.add(new PortletMode(mode));
                ++n2;
            }
            stringArray = methods;
            n = methods.length;
            n2 = 0;
            while (n2 < n) {
                String method = stringArray[n2];
                this.methods.add(method.name());
                ++n2;
            }
            this.params = StringUtils.mergeStringArrays((String[])this.params, (String[])params);
            this.headers = StringUtils.mergeStringArrays((String[])this.headers, (String[])headers);
        }

        public void initPhaseMapping(String phase, String value, String[] params) {
            if (this.phase != null) {
                throw new IllegalStateException("Invalid mapping - more than one phase specified: '" + this.phase + "', '" + phase + "'");
            }
            this.phase = phase;
            this.value = value;
            this.params = StringUtils.mergeStringArrays((String[])this.params, (String[])params);
        }

        public boolean match(PortletRequest request) {
            if (!this.modes.isEmpty() && !this.modes.contains(request.getPortletMode())) {
                return false;
            }
            if (StringUtils.hasLength((String)this.phase) && !this.phase.equals(request.getAttribute("javax.portlet.lifecycle_phase"))) {
                return false;
            }
            if (StringUtils.hasLength((String)this.value)) {
                Event event;
                if (this.phase.equals("ACTION_PHASE") && !this.value.equals(request.getParameter("javax.portlet.action"))) {
                    return false;
                }
                if (this.phase.equals("RENDER_PHASE") && !new WindowState(this.value).equals((Object)request.getWindowState())) {
                    return false;
                }
                if (this.phase.equals("RESOURCE_PHASE") && !this.value.equals(((ResourceRequest)request).getResourceID())) {
                    return false;
                }
                if (this.phase.equals("EVENT_PHASE") && !this.value.equals((event = ((EventRequest)request).getEvent()).getName()) && !this.value.equals(event.getQName().toString())) {
                    return false;
                }
            }
            return PortletAnnotationMappingUtils.checkRequestMethod(this.methods, request) && PortletAnnotationMappingUtils.checkParameters(this.params, request) && PortletAnnotationMappingUtils.checkHeaders(this.headers, request);
        }

        public boolean isBetterMatchThan(RequestMappingInfo other) {
            return !this.modes.isEmpty() && other.modes.isEmpty() || StringUtils.hasLength((String)this.phase) && !StringUtils.hasLength((String)other.phase) || StringUtils.hasLength((String)this.value) && !StringUtils.hasLength((String)other.value) || !this.methods.isEmpty() && other.methods.isEmpty() || this.params.length > other.params.length;
        }

        public boolean equals(Object obj) {
            RequestMappingInfo other = (RequestMappingInfo)obj;
            return this.modes.equals(other.modes) && ObjectUtils.nullSafeEquals((Object)this.phase, (Object)other.phase) && ObjectUtils.nullSafeEquals((Object)this.value, (Object)other.value) && this.methods.equals(other.methods) && Arrays.equals(this.params, other.params) && Arrays.equals(this.headers, other.headers);
        }

        public int hashCode() {
            return ObjectUtils.nullSafeHashCode(this.modes) * 29 + this.phase.hashCode();
        }
    }
}

