/*
 * Decompiled with CFR 0.152.
 */
package com.meterware.httpunit;

import com.meterware.httpunit.FormControl;
import com.meterware.httpunit.NodeUtils;
import com.meterware.httpunit.ParameterProcessor;
import com.meterware.httpunit.WebForm;
import com.meterware.httpunit.scripting.ScriptableDelegate;
import java.io.IOException;
import java.util.List;
import org.w3c.dom.Node;

abstract class BooleanFormControl
extends FormControl {
    private boolean _isChecked;
    private String[] _value = new String[1];
    private final boolean _isCheckedDefault;
    private String[] _displayedValue;

    protected ScriptableDelegate newScriptable() {
        return new Scriptable();
    }

    public BooleanFormControl(WebForm form, Node node) {
        super(form, node);
        this._displayedValue = new String[]{this.readDisplayedValue(node)};
        this._isChecked = this._isCheckedDefault = NodeUtils.isNodeAttributePresent(node, "checked");
    }

    private String readDisplayedValue(Node node) {
        Node nextSibling;
        for (nextSibling = node.getNextSibling(); nextSibling != null && nextSibling.getNodeType() != 3 && nextSibling.getNodeType() != 1; nextSibling = nextSibling.getNextSibling()) {
        }
        if (nextSibling == null || nextSibling.getNodeType() != 3) {
            return "";
        }
        return nextSibling.getNodeValue();
    }

    boolean isChecked() {
        return this._isChecked;
    }

    public void setChecked(boolean checked) {
        this._isChecked = checked;
    }

    void reset() {
        this._isChecked = this._isCheckedDefault;
    }

    public String[] getValues() {
        return this.isChecked() ? this.toArray(this.getQueryValue()) : NO_VALUE;
    }

    public String[] getOptionValues() {
        return this.isReadOnly() && !this.isChecked() ? NO_VALUE : this.toArray(this.getQueryValue());
    }

    String[] getDisplayedOptions() {
        return this._displayedValue;
    }

    void addValues(ParameterProcessor processor, String characterSet) throws IOException {
        if (this.isChecked() && !this.isDisabled()) {
            processor.addParameter(this.getName(), this.getQueryValue(), characterSet);
        }
    }

    void claimRequiredValues(List values) {
        if (this.isValueRequired()) {
            this.claimValueIsRequired(values, this.getQueryValue());
        }
    }

    protected boolean isValueRequired() {
        return this.isReadOnly() && this.isChecked();
    }

    abstract String getQueryValue();

    private String[] toArray(String value) {
        this._value[0] = value;
        return this._value;
    }

    class Scriptable
    extends FormControl.Scriptable {
        Scriptable() {
            super(BooleanFormControl.this);
        }

        public Object get(String propertyName) {
            if (propertyName.equalsIgnoreCase("value")) {
                return BooleanFormControl.this.getQueryValue();
            }
            if (propertyName.equalsIgnoreCase("checked")) {
                return BooleanFormControl.this.isChecked() ? Boolean.TRUE : Boolean.FALSE;
            }
            if (propertyName.equalsIgnoreCase("defaultchecked")) {
                return BooleanFormControl.this._isCheckedDefault ? Boolean.TRUE : Boolean.FALSE;
            }
            return super.get(propertyName);
        }

        public void set(String propertyName, Object value) {
            if (propertyName.equalsIgnoreCase("checked")) {
                BooleanFormControl.this.setChecked(value instanceof Boolean && (Boolean)value != false);
            } else {
                super.set(propertyName, value);
            }
        }
    }
}

