/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import org.jruby.Ruby;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.java.proxies.JavaProxy;
import org.jruby.javasupport.JavaArray;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

@JRubyModule(name={"JavaArrayUtilities"})
public class JavaArrayUtilities {
    public static RubyModule createJavaArrayUtilitiesModule(Ruby runtime2) {
        RubyModule javaArrayUtils = runtime2.defineModule("JavaArrayUtilities");
        javaArrayUtils.defineAnnotatedMethods(JavaArrayUtilities.class);
        return javaArrayUtils;
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject bytes_to_ruby_string(IRubyObject recv2, IRubyObject wrappedObject) {
        Ruby runtime2 = recv2.getRuntime();
        byte[] bytes2 = null;
        if (wrappedObject instanceof JavaProxy) {
            Object wrapped = ((JavaProxy)wrappedObject).getObject();
            if (wrapped instanceof byte[]) {
                bytes2 = (byte[])wrapped;
            }
        } else {
            JavaObject byteArray = (JavaObject)wrappedObject.dataGetStruct();
            if (byteArray instanceof JavaArray && ((JavaArray)byteArray).getValue() instanceof byte[]) {
                bytes2 = (byte[])((JavaArray)byteArray).getValue();
            }
        }
        if (bytes2 == null) {
            throw runtime2.newTypeError("wrong argument type " + wrappedObject.getMetaClass() + " (expected byte[])");
        }
        return runtime2.newString(new ByteList(bytes2, true));
    }

    @JRubyMethod(module=true, visibility=Visibility.PRIVATE)
    public static IRubyObject ruby_string_to_bytes(IRubyObject recv2, IRubyObject string2) {
        Ruby runtime2 = recv2.getRuntime();
        if (!(string2 instanceof RubyString)) {
            throw runtime2.newTypeError(string2, runtime2.getString());
        }
        return JavaUtil.convertJavaToUsableRubyObject(runtime2, ((RubyString)string2).getBytes());
    }
}

